/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.FileContentQueue;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesUploadingService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import com.jetbrains.plugins.webDeployment.ui.OverwriteRemoteWarningDialog;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteEditUploadFilesTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(RemoteEditUploadFilesTask.class);
    protected final ConnectionOwner myConnectionOwner;
    @NotNull
    private final FileContentQueue myQueue;
    private volatile boolean myProjectCloseRequested;
    private volatile boolean myFinished;

    public RemoteEditUploadFilesTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull @NlsContexts.ProgressTitle String title, @NotNull FileContentQueue queue) {
        if (connectionOwner == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(1);
        }
        if (queue == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(2);
        }
        super(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
        this.myConnectionOwner = connectionOwner;
        this.myQueue = queue;
    }

    public boolean isConditionalModal() {
        return true;
    }

    public void run(@NotNull ProgressIndicator pi) {
        if (pi == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(3);
        }
        this.doRun(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doRun(final @NotNull ProgressIndicator pi) {
        if (pi == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.myFinished);
        VetoableProjectManagerListener listener = null;
        if (this.myProject != null) {
            listener = new VetoableProjectManagerListener(){

                public boolean canClose(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project != RemoteEditUploadFilesTask.this.myProject) {
                        return true;
                    }
                    String title = WDBundle.message("warning.running.dialog.title", RemoteEditUploadFilesTask.this.getTitle());
                    String text = WDBundle.message("warning.running.on.project.close", RemoteEditUploadFilesTask.this.getTitle());
                    int result = Messages.showOkCancelDialog((Project)RemoteEditUploadFilesTask.this.myProject, (String)text, (String)title, (Icon)Messages.getQuestionIcon());
                    if (result != 0) {
                        return false;
                    }
                    RemoteEditUploadFilesTask.this.myProjectCloseRequested = true;
                    pi.cancel();
                    return RemoteEditUploadFilesTask.this.myFinished;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask$1", "canClose"));
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(listener);
        }
        try {
            Pair<RemoteVirtualFile, byte[]> next;
            while ((next = this.myQueue.getNextFile()) != null) {
                RemoteConnection connection = ((RemoteVirtualFile)((Object)next.getFirst())).getClonedConnection();
                try {
                    this.uploadFile(pi, next, connection);
                }
                finally {
                    if (connection == null) continue;
                    connection.release();
                }
            }
            return;
        }
        catch (ProcessCanceledException e) {
            LOG.debug("cancelled");
            return;
        }
        finally {
            this.myFinished = true;
            if (listener != null) {
                ProjectManager.getInstance().removeProjectManagerListener(listener);
            }
            if (this.myProjectCloseRequested && this.myProject != null) {
                ApplicationManager.getApplication().invokeLater(() -> ProjectManager.getInstance().closeAndDispose(this.myProject));
            }
        }
    }

    private void uploadFile(@NotNull ProgressIndicator pi, Pair<RemoteVirtualFile, byte[]> next, RemoteConnection connection) {
        if (pi == null) {
            RemoteEditUploadFilesTask.$$$reportNull$$$0(5);
        }
        RemoteVirtualFile file = (RemoteVirtualFile)((Object)next.getFirst());
        pi.setText(WDBundle.message("remote.edit.uploading.content.of", file.getPath()));
        Deployable serverConfig = file.getServerConfig();
        byte[] content = (byte[])next.getSecond();
        FileObject dest = file.getDestination();
        ExecutionContext context = this.myQueue.createContext(serverConfig, this.myProject, pi);
        pi.checkCanceled();
        Ref exceptionHolder = Ref.create();
        boolean triedToUpload = (Boolean)connection.executeServerOperationSilently(() -> {
            OutputStream out = null;
            try {
                DeploymentPathUtils.refreshRemoteFile(dest, context);
                if (this.handleChangedRemote(dest, file, pi)) {
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                out = dest.getContent().getOutputStream();
                FileTransferUtil.writeContent(content, out, context);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                exceptionHolder.set((Object)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            return Boolean.TRUE;
        }, pi);
        if (!triedToUpload) {
            return;
        }
        IOException exception = (IOException)exceptionHolder.get();
        if (exception == null) {
            file.updateLastSyncedContent(content);
        }
        RemoteEditEditorDecorator.updateDecorators(file);
        if (exception != null) {
            String message = WDBundle.message("remote.edit.failed.to.upload.content.of.remote.file.0.from.server.1.n.2", file.getPath(), file.getServerConfig().getName(), exception.getMessage());
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)RemoteEditUploadFilesTask.getMessagesTitle()));
        }
        pi.setText("");
    }

    private boolean handleChangedRemote(FileObject dest, RemoteVirtualFile file, ProgressIndicator pi) throws IOException {
        if (!dest.exists()) {
            return (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> 0 != Messages.showOkCancelDialog((Project)this.myProject, (String)WDBundle.message("remote.edit.file.0.was.deleted.on.1.server", file.getName(), file.getServerConfig().getName()), (String)RemoteEditUploadFilesTask.getMessagesTitle(), (String)WDBundle.message("remote.edit.upload", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()));
        }
        byte[] oldContent = FileTransferUtil.getContent(dest, pi);
        if (!file.isChanged(oldContent)) {
            return false;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.suggestToMerge(oldContent, file, dest));
        return true;
    }

    private void suggestToMerge(byte[] remoteContent, RemoteVirtualFile file, FileObject dest) {
        OverwriteRemoteWarningDialog dialog = OverwriteRemoteWarningDialog.createInstance(this.myConnectionOwner, dest, file.getServerConfig(), false);
        dialog.setTitle(RemoteEditUploadFilesTask.getMessagesTitle());
        dialog.setSkipActionTitle(CommonBundle.getCancelButtonText());
        dialog.showAndGet();
        OverwriteRemoteWarningDialog.OverwriteOption overwriteOption = dialog.getResult();
        switch (overwriteOption) {
            case OVERWRITE: {
                file.updateLastSyncedContent(remoteContent);
                RemoteEditedFilesUploadingService.getInstance(this.myProject).queueUpload(file);
                break;
            }
            case SKIP: {
                break;
            }
            case MERGE: {
                this.merge(remoteContent, file);
                break;
            }
            default: {
                LOG.error("Unexpected result: " + overwriteOption);
            }
        }
    }

    private void merge(byte[] remoteContent, RemoteVirtualFile file) {
        byte[] baseContent;
        try {
            baseContent = file.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String message = WDBundle.message("remote.edit.failed.to.upload", file.getPath(), file.getServerConfig().getName());
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)RemoteEditUploadFilesTask.getMessagesTitle()));
            return;
        }
        byte[] lastSyncedContent = file.getLastSyncedContent();
        String windowTitle = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
        List<String> titles = Arrays.asList(WDBundle.message("remote.edit.last.uploaded", new Object[0]), WDBundle.message("remote.edit.current.content", new Object[0]), WDBundle.message("remote.edit.remote.file.content", new Object[0]));
        List contents = Arrays.asList(lastSyncedContent, baseContent, remoteContent);
        Consumer callback = result -> {
            if (result != MergeResult.CANCEL) {
                Document document = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                file.updateLastSyncedContent(remoteContent);
                RemoteEditedFilesUploadingService.getInstance(this.myProject).queueUpload(file);
            }
        };
        try {
            TextMergeRequest request = DiffRequestFactory.getInstance().createTextMergeRequest(this.myProject, (VirtualFile)file, contents, windowTitle, titles, callback);
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, PublishUtils.getMergeResolveCaptions());
            DiffManager.getInstance().showMerge(this.myProject, (MergeRequest)request);
        }
        catch (InvalidDiffRequestException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @NlsContexts.DialogTitle
    private static String getMessagesTitle() {
        return WDBundle.message("remote.edit.remote.file.upload.messages.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

