/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.render.BookmarkIcon;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue RIGHT_PADDING = JBVG.value(4.0f);
    public static final JBValue LEFT_PADDING = JBVG.value(4.0f);
    public static final JBValue COMPACT_MIDDLE_PADDING = JBVG.value(2.0f);
    public static final JBValue MIDDLE_PADDING = JBVG.value(12.0f);
    public static final JBValue ICON_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private static final int MAX_LENGTH = 22;
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final LabelIconCache myIconCache;
    @NotNull
    private final UpdateScaleHelper myUpdateScaleHelper;
    @NotNull
    protected List<Pair<String, Icon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    protected Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myIsOpaque;
    private boolean myCompact;
    private boolean myLeftAligned;

    public LabelPainter(@NotNull JComponent component2, @NotNull LabelIconCache iconCache) {
        if (component2 == null) {
            LabelPainter.$$$reportNull$$$0(0);
        }
        if (iconCache == null) {
            LabelPainter.$$$reportNull$$$0(1);
        }
        this.myUpdateScaleHelper = new UpdateScaleHelper();
        this.myLabels = new ArrayList<Pair<String, Icon>>();
        this.myHeight = JBUIScale.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myIsOpaque = true;
        this.myComponent = component2;
        this.myIconCache = iconCache;
    }

    public void updateHeight() {
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
    }

    public void customizePainter(@NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth, @NotNull List<? extends RefGroup> refGroups) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(2);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(3);
        }
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(4);
        }
        this.customizePainter(background, foreground, isSelected, availableWidth, refGroups, Collections.emptyList());
    }

    public void customizePainter(@NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth, @NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(5);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(6);
        }
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(7);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(8);
        }
        this.myBackground = background;
        this.myForeground = foreground;
        this.updateHeight();
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myGreyBackground = ExperimentalUI.isNewUI() ? null : LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, Icon>>, Integer> presentation = this.calculatePresentation(refGroups, bookmarks, metrics, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private Pair<List<Pair<String, Icon>>, Integer> calculatePresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(9);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(10);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(11);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(12);
        }
        if (compact) {
            return this.calculateCompactPresentation(refGroups, bookmarks, fontMetrics, background, availableWidth);
        }
        return this.calculateLongPresentation(refGroups, bookmarks, fontMetrics, background, availableWidth);
    }

    @NotNull
    private Pair<List<Pair<String, Icon>>, Integer> calculateCompactPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(13);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(14);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(15);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(16);
        }
        ArrayList<Pair> labels = new ArrayList<Pair>();
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        int height = fontMetrics.getHeight();
        for (VcsBookmarkRef vcsBookmarkRef : bookmarks) {
            BookmarkIcon icon = new BookmarkIcon(this.myComponent, height, background, vcsBookmarkRef);
            boolean isLast = refGroups.isEmpty() && vcsBookmarkRef == ContainerUtil.getLastItem(bookmarks);
            int newWidth = width + icon.getIconWidth() + (isLast ? 0 : COMPACT_MIDDLE_PADDING.get());
            labels.add(Pair.create((Object)"", (Object)icon));
            width = newWidth += LabelPainter.getIconTextPadding();
        }
        for (RefGroup refGroup : refGroups) {
            List colors = refGroup.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            boolean isLast = refGroup == ContainerUtil.getLastItem(refGroups);
            int newWidth = width + labelIcon.getIconWidth() + (isLast ? 0 : COMPACT_MIDDLE_PADDING.get());
            String text = LabelPainter.shortenRefName(refGroup.getName(), fontMetrics, availableWidth - newWidth);
            newWidth += fontMetrics.stringWidth(text);
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth += LabelPainter.getIconTextPadding();
        }
        Pair pair = Pair.create(labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @NotNull
    private Pair<List<Pair<String, Icon>>, Integer> calculateLongPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(18);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(19);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(20);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(21);
        }
        ArrayList<Pair> labels = new ArrayList<Pair>();
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        int height = fontMetrics.getHeight();
        for (VcsBookmarkRef bookmark : bookmarks) {
            BookmarkIcon icon = new BookmarkIcon(this.myComponent, height, background, bookmark);
            boolean isLast = refGroups.isEmpty() && bookmark == ContainerUtil.getLastItem(bookmarks);
            int newWidth = width + icon.getIconWidth() + (isLast ? 0 : MIDDLE_PADDING.get());
            labels.add(Pair.create((Object)"", (Object)icon));
            width = newWidth;
        }
        for (int i = 0; i < refGroups.size(); ++i) {
            RefGroup group = refGroups.get(i);
            int doNotFitWidth = 0;
            if (i < refGroups.size() - 1) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            boolean isLast = i == refGroups.size() - 1;
            int newWidth = width + labelIcon.getIconWidth() + (isLast ? 0 : MIDDLE_PADDING.get());
            String text = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth);
            newWidth += fontMetrics.stringWidth(text);
            if (availableWidth - (newWidth += LabelPainter.getIconTextPadding()) - doNotFitWidth < 0) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name = labels.isEmpty() ? text : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth;
        }
        Pair pair = Pair.create(labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    private LabelIcon getIcon(int height, @NotNull Color background, @NotNull List<? extends Color> colors) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(23);
        }
        if (colors == null) {
            LabelPainter.$$$reportNull$$$0(24);
        }
        LabelIcon labelIcon = this.myIconCache.getIcon(this.myComponent, height, background, colors);
        if (labelIcon == null) {
            LabelPainter.$$$reportNull$$$0(25);
        }
        return labelIcon;
    }

    @NotNull
    private static List<Color> getColors(@NotNull Collection<? extends RefGroup> groups) {
        if (groups == null) {
            LabelPainter.$$$reportNull$$$0(26);
        }
        LinkedHashMap<Color, Integer> usedColors = new LinkedHashMap<Color, Integer>();
        for (RefGroup refGroup : groups) {
            List colors = refGroup.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList<Color> result2 = new ArrayList<Color>();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add((Color)entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add((Color)entry.getKey());
        }
        ArrayList<Color> arrayList = result2;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group == null) {
            LabelPainter.$$$reportNull$$$0(28);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(29);
        }
        if (!group.isExpanded()) {
            return LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
        }
        StringBuilder text = new StringBuilder();
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i = 0; i < group.getRefs().size(); ++i) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text.append(remainder);
                break;
            }
            text.append(firstRef ? "" : separator).append(refName);
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        String string = text.toString();
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<? extends RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(31);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(32);
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return CurrentBranchComponent.getBranchPresentationBackground((Color)background);
        }
        for (RefGroup refGroup : refGroups) {
            boolean paintGreyBackground;
            if (refGroup.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)refGroup.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !refGroup.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return CurrentBranchComponent.getBranchPresentationBackground((Color)background);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull @NlsSafe String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            LabelPainter.$$$reportNull$$$0(33);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(34);
        }
        if (fontMetrics.stringWidth((String)refName) > availableWidth && ((String)refName).length() > 22) {
            int separatorIndex = ((String)refName).indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + ((String)refName).substring(separatorIndex);
            }
            if (availableWidth > 0) {
                String string = VcsLogUiUtil.shortenTextToFit((String)refName, fontMetrics, availableWidth, 22, "\u2026");
                if (string == null) {
                    LabelPainter.$$$reportNull$$$0(35);
                }
                return string;
            }
            String string = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)"\u2026");
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = refName;
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(37);
        }
        return string;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            LabelPainter.$$$reportNull$$$0(38);
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.getFractionalMetricsValue()).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.getTextAntiAliasingValue());
        g2.setFont(LabelPainter.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        if (this.myIsOpaque) {
            g2.setColor(this.myBackground);
            g2.fillRect(x, y, this.myWidth, height);
        }
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get());
        }
        x += LEFT_PADDING.get();
        for (Pair<String, Icon> label : this.myLabels) {
            Icon icon = (Icon)label.second;
            String text = (String)label.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - MIDDLE_PADDING.get() / 3, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), icon.getIconWidth() + fontMetrics.stringWidth(text) + 2 * MIDDLE_PADDING.get() / 3, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get(), LABEL_ARC.get(), LABEL_ARC.get()));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            x += icon.getIconWidth();
            g2.setColor(this.myForeground);
            g2.drawString(text, x += LabelPainter.getIconTextPadding(), y + baseLine);
            x += fontMetrics.stringWidth(text) + (this.myCompact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get());
        }
        config.restore();
    }

    private static int getIconTextPadding() {
        return ExperimentalUI.isNewUI() ? ICON_TEXT_PADDING.get() : 0;
    }

    private Object getTextAntiAliasingValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING), AntialiasingType.getKeyForCurrentScope((boolean)false));
    }

    private Object getFractionalMetricsValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS), UISettings.Companion.getPreferredFractionalMetricsValue());
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        this.myUpdateScaleHelper.saveScaleAndRunIfChanged(this::updateHeight);
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return this.myLeftAligned;
    }

    public static Font getReferenceFont() {
        Font font = GraphCommitCellRenderer.getLabelFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }

    public void setLeftAligned(boolean leftAligned) {
        this.myLeftAligned = leftAligned;
    }

    public void setOpaque(boolean isOpaque) {
        this.myIsOpaque = isOpaque;
    }

    public void clear() {
        this.myLabels.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 22, 25, 27, 30, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconCache";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 16: 
            case 21: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarks";
                break;
            }
            case 11: 
            case 15: 
            case 20: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 17: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCompactPresentation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLongPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupText";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizePainter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentation";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateCompactPresentation";
                break;
            }
            case 17: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateLongPresentation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGroupText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calculateGreyBackground";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "shortenRefName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 22, 25, 27, 30, 35, 36, 37 -> new IllegalStateException(string);
        };
    }
}

