/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
abstract class CollapseOrExpandGraphAction
extends DumbAwareAction {
    private final Supplier<@NlsActions.ActionText String> myLinearBranchesAction;
    private final Supplier<@NlsActions.ActionDescription String> myLinearBranchesDescription;
    private final Supplier<@NlsActions.ActionText String> myMergesAction;
    private final Supplier<@NlsActions.ActionDescription String> myMergesDescription;

    protected CollapseOrExpandGraphAction(@NotNull Supplier<String> linearBranchesAction, @NotNull Supplier<String> linearBranchesDescription, @NotNull Supplier<String> mergesAction, @NotNull Supplier<String> mergesDescription) {
        if (linearBranchesAction == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(0);
        }
        if (linearBranchesDescription == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(1);
        }
        if (mergesAction == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(2);
        }
        if (mergesDescription == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(3);
        }
        super(linearBranchesAction, linearBranchesDescription);
        this.myLinearBranchesAction = linearBranchesAction;
        this.myLinearBranchesDescription = linearBranchesDescription;
        this.myMergesAction = mergesAction;
        this.myMergesDescription = mergesDescription;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(4);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        MainVcsLogUi ui2 = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        if (ui2 == null || !ui2.getDataPack().getVisibleGraph().getActionController().isActionSupported(this.getGraphAction())) {
            return;
        }
        this.executeAction(ui2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(5);
        }
        MainVcsLogUi ui2 = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        boolean visible = ui2 != null && ui2.getDataPack().getVisibleGraph().getActionController().isActionSupported(this.getGraphAction());
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !ui2.getDataPack().isEmpty());
        if (visible) {
            if (properties != null && properties.exists(MainVcsLogUiProperties.GRAPH_OPTIONS) && properties.get(MainVcsLogUiProperties.GRAPH_OPTIONS) == PermanentGraph.Options.LinearBek.INSTANCE) {
                e.getPresentation().setText(this.myMergesAction.get());
                e.getPresentation().setDescription(this.myMergesDescription.get());
            } else {
                e.getPresentation().setText(this.myLinearBranchesAction.get());
                e.getPresentation().setDescription(this.myLinearBranchesDescription.get());
            }
        }
    }

    protected abstract void executeAction(@NotNull MainVcsLogUi var1);

    @NotNull
    protected abstract GraphAction getGraphAction();

    protected void performLongAction(@NotNull MainVcsLogUi logUi2, @NotNull GraphAction graphAction, @NotNull @NlsContexts.ProgressTitle String title) {
        if (logUi2 == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(6);
        }
        if (graphAction == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(7);
        }
        if (title == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(8);
        }
        VisiblePack dataPack = logUi2.getDataPack();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ActionController actionController = dataPack.getVisibleGraph().getActionController();
            GraphAnswer answer = actionController.performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                assert (updater != null) : "Action:" + title + "\nController: " + actionController + "\nAnswer:" + answer;
                updater.run();
                logUi2.getTable().handleAnswer((GraphAnswer<Integer>)answer);
            });
        }, title, false, null, logUi2.getMainComponent());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CollapseOrExpandGraphAction.$$$reportNull$$$0(9);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearBranchesAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearBranchesDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergesAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergesDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performLongAction";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

