/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;
    private final ConcurrentCharSequenceMapBuilder<T> myConcurrentCharSequenceMapBuilder;
    private final Map<String, T> myHashBangMap;

    private FileTypeAssocTable(@NotNull Map<? extends CharSequence, ? extends T> extensionMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameAnyCaseMappings, @NotNull ConcurrentCharSequenceMapBuilder<T> concurrentCharSequenceMapBuilder, @NotNull Map<? extends String, ? extends T> hashBangMap, @NotNull List<? extends Pair<FileNameMatcher, T>> matchingMappings) {
        if (extensionMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(0);
        }
        if (exactFileNameMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(1);
        }
        if (exactFileNameAnyCaseMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(2);
        }
        if (concurrentCharSequenceMapBuilder == null) {
            FileTypeAssocTable.$$$reportNull$$$0(3);
        }
        if (hashBangMap == null) {
            FileTypeAssocTable.$$$reportNull$$$0(4);
        }
        if (matchingMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(5);
        }
        this.myExtensionMappings = concurrentCharSequenceMapBuilder.build(extensionMappings, false);
        this.myExactFileNameMappings = concurrentCharSequenceMapBuilder.build(exactFileNameMappings, true);
        this.myExactFileNameAnyCaseMappings = concurrentCharSequenceMapBuilder.build(exactFileNameAnyCaseMappings, false);
        this.myConcurrentCharSequenceMapBuilder = concurrentCharSequenceMapBuilder;
        this.myHashBangMap = new ConcurrentHashMap<String, T>(hashBangMap);
        this.myMatchingMappings = ContainerUtil.createLockFreeCopyOnWriteList(matchingMappings);
    }

    public FileTypeAssocTable(@NotNull ConcurrentCharSequenceMapBuilder<T> concurrentCharSequenceMapBuilder) {
        if (concurrentCharSequenceMapBuilder == null) {
            FileTypeAssocTable.$$$reportNull$$$0(6);
        }
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), concurrentCharSequenceMapBuilder, Collections.emptyMap(), Collections.emptyList());
    }

    public FileTypeAssocTable() {
        this(FileTypeAssocTable::createCharSequenceConcurrentMap);
    }

    boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(7);
        }
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(8);
        }
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return type.equals(this.findAssociatedFileType(matcher));
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || !type.equals(mapping.getSecond())) continue;
            return true;
        }
        return false;
    }

    public T addAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(9);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(10);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            return this.myExtensionMappings.put(extension, type);
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.put(exactFileNameMatcher.getFileName(), type);
        }
        int i = ContainerUtil.indexOf(this.myMatchingMappings, p -> ((FileNameMatcher)p.first).equals(matcher));
        if (i == -1) {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
            return null;
        }
        Pair<FileNameMatcher, T> old = this.myMatchingMappings.get(i);
        this.myMatchingMappings.set(i, Pair.create((Object)matcher, type));
        return (T)Pair.getSecond(old);
    }

    void addHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        if (hashBang == null) {
            FileTypeAssocTable.$$$reportNull$$$0(11);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(12);
        }
        this.myHashBangMap.put(hashBang, type);
    }

    void removeHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        if (hashBang == null) {
            FileTypeAssocTable.$$$reportNull$$$0(13);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(14);
        }
        this.myHashBangMap.remove(hashBang, type);
    }

    void removeAssociation(@NotNull FileNameMatcher matcher, @Nullable T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(15);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (type == null || type.equals(this.myExtensionMappings.get(extension))) {
                this.myExtensionMappings.remove(extension);
            }
            return;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> mapToUse;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map = mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (type == null || type.equals(mapToUse.get(fileName))) {
                mapToUse.remove(fileName);
            }
            return;
        }
        this.myMatchingMappings.removeIf(assoc -> matcher.equals(assoc.getFirst()) && (type == null || type.equals(assoc.getSecond())));
    }

    void removeAllAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(16);
        }
        this.removeAllAssociations(bean -> bean.equals(type));
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (fileName == null) {
            FileTypeAssocTable.$$$reportNull$$$0(17);
        }
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!((FileNameMatcher)mapping.getFirst()).acceptsCharSequence(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.findByExtension(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    T findAssociatedFileTypeByHashBang(@NotNull CharSequence content) {
        if (content == null) {
            FileTypeAssocTable.$$$reportNull$$$0(18);
        }
        for (Map.Entry<String, T> entry : this.myHashBangMap.entrySet()) {
            String hashBang = entry.getKey();
            if (!FileUtil.isHashBangLine((CharSequence)content, (String)hashBang)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(19);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.findByExtension(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    T findByExtension(@NotNull CharSequence extension) {
        if (extension == null) {
            FileTypeAssocTable.$$$reportNull$$$0(20);
        }
        return this.myExtensionMappings.get(extension);
    }

    String @NotNull [] getAssociatedExtensions(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(21);
        }
        ArrayList<String> extensions = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : this.myExtensionMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            extensions.add(entry.getKey().toString());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(extensions);
        if (stringArray == null) {
            FileTypeAssocTable.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        return new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myConcurrentCharSequenceMapBuilder, this.myHashBangMap, this.myMatchingMappings);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(23);
        }
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (!type.equals(pair.getSecond())) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), false));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            FileTypeAssocTable.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getHashBangPatterns(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(25);
        }
        List<String> list = this.myHashBangMap.entrySet().stream().filter(e -> e.getValue().equals(type)).map(e -> (String)e.getKey()).collect(Collectors.toList());
        if (list == null) {
            FileTypeAssocTable.$$$reportNull$$$0(26);
        }
        return list;
    }

    boolean hasAssociationsFor(@NotNull T fileType) {
        if (fileType == null) {
            FileTypeAssocTable.$$$reportNull$$$0(27);
        }
        if (this.myExtensionMappings.containsValue(fileType) || this.myExactFileNameMappings.containsValue(fileType) || this.myHashBangMap.containsValue(fileType) || this.myExactFileNameAnyCaseMappings.containsValue(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!fileType.equals(mapping.getSecond())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Map<FileNameMatcher, T> getRemovedMappings(@NotNull FileTypeAssocTable<T> newTable, @NotNull Collection<? extends T> keys) {
        if (newTable == null) {
            FileTypeAssocTable.$$$reportNull$$$0(28);
        }
        if (keys == null) {
            FileTypeAssocTable.$$$reportNull$$$0(29);
        }
        HashMap<FileNameMatcher, T> map = new HashMap<FileNameMatcher, T>();
        for (T key : keys) {
            List<FileNameMatcher> associations = this.getAssociations(key);
            associations.removeAll(newTable.getAssociations(key));
            for (FileNameMatcher matcher : associations) {
                map.put(matcher, key);
            }
        }
        HashMap<FileNameMatcher, T> hashMap = map;
        if (hashMap == null) {
            FileTypeAssocTable.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myHashBangMap.equals(that.myHashBangMap) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myHashBangMap.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }

    @NotNull
    Map<String, T> getInternalRawHashBangPatterns() {
        Map map = CollectionFactory.createSmallMemoryFootprintMap(this.myHashBangMap);
        if (map == null) {
            FileTypeAssocTable.$$$reportNull$$$0(31);
        }
        return map;
    }

    @NotNull
    private static <T> Map<CharSequence, T> createCharSequenceConcurrentMap(@NotNull Map<? extends CharSequence, ? extends T> source, boolean caseSensitive) {
        if (source == null) {
            FileTypeAssocTable.$$$reportNull$$$0(32);
        }
        Map map = CollectionFactory.createCharSequenceMap((boolean)caseSensitive, (int)source.size(), (float)0.5f);
        map.putAll(source);
        Map map2 = Collections.synchronizedMap(map);
        if (map2 == null) {
            FileTypeAssocTable.$$$reportNull$$$0(33);
        }
        return map2;
    }

    void removeAllAssociations(@NotNull Predicate<? super T> predicate) {
        if (predicate == null) {
            FileTypeAssocTable.$$$reportNull$$$0(34);
        }
        this.myExtensionMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myExactFileNameMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myExactFileNameAnyCaseMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myMatchingMappings.removeIf(entry -> predicate.test(entry.getSecond()));
        this.myHashBangMap.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
    }

    public String toString() {
        return "FileTypeAssocTable. myExtensionMappings=" + this.myExtensionMappings + ";\nmyExactFileNameMappings=" + this.myExactFileNameMappings + ";\nmyExactFileNameAnyCaseMappings=" + this.myExactFileNameAnyCaseMappings + ";\nmyMatchingMappings=" + this.myMatchingMappings + ";\nmyHashBangMap=" + this.myHashBangMap + ";";
    }

    @TestOnly
    public void clear() {
        this.myHashBangMap.clear();
        this.myMatchingMappings.clear();
        this.myExtensionMappings.clear();
        this.myExactFileNameMappings.clear();
        this.myExactFileNameAnyCaseMappings.clear();
    }

    void removeAssociationsForFile(@NotNull CharSequence fileName, @NotNull T association) {
        T t;
        if (fileName == null) {
            FileTypeAssocTable.$$$reportNull$$$0(35);
        }
        if (association == null) {
            FileTypeAssocTable.$$$reportNull$$$0(36);
        }
        if (association.equals(t = this.myExactFileNameMappings.get(fileName))) {
            this.myExactFileNameMappings.remove(fileName);
        }
        if (association.equals(t = this.myExactFileNameAnyCaseMappings.get(fileName))) {
            this.myExactFileNameAnyCaseMappings.remove(fileName);
        }
        this.myMatchingMappings.removeIf(pair -> association.equals(pair.second) && ((FileNameMatcher)pair.getFirst()).acceptsCharSequence(fileName));
        CharSequence extension = FileUtilRt.getExtension((CharSequence)fileName);
        t = this.myExtensionMappings.get(extension);
        if (association.equals(t)) {
            this.myExtensionMappings.remove(extension);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameMappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameAnyCaseMappings";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concurrentCharSequenceMapBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBangMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingMappings";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBang";
                break;
            }
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "association";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashBangPatterns";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappings";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalRawHashBangPatterns";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharSequenceConcurrentMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWith";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAssociation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addHashBangPattern";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeHashBangPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 16: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAssociations";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedFileType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedFileTypeByHashBang";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findByExtension";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHashBangPatterns";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasAssociationsFor";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRemovedMappings";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCharSequenceConcurrentMap";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociationsForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ConcurrentCharSequenceMapBuilder<T> {
        @NotNull
        public Map<CharSequence, T> build(@NotNull Map<? extends CharSequence, ? extends T> var1, boolean var2);
    }
}

