/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.PromiseEvaluationHandler;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.runtime.CallFunctionOnResult;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001 B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH&J>\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/wip/WipEvaluateContextBase;", "DATA", "", "Lorg/jetbrains/debugger/EvaluateContextBase;", "Lorg/jetbrains/wip/WipValueManager;", "valueManager", "(Lorg/jetbrains/wip/WipValueManager;)V", "createRequest", "Lorg/jetbrains/jsonProtocol/Request;", "expression", "", "awaitPromise", "", "evaluate", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/EvaluateResult;", "additionalContext", "", "enableBreak", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "data", "(Ljava/lang/Object;)Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "getWasThrown", "(Ljava/lang/Object;)Z", "processResponse", "(Ljava/lang/Object;Lorg/jetbrains/wip/WipValueManager;)Lorg/jetbrains/debugger/EvaluateResult;", "releaseObjects", "", "wrapObjectLiteral", "Companion", "intellij.javascript.wip.backend"})
public abstract class WipEvaluateContextBase<DATA>
extends EvaluateContextBase<WipValueManager> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Pattern OBJECT_LITERAL_PATTERN;

    public WipEvaluateContextBase(@NotNull WipValueManager valueManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        super((ValueManager)valueManager);
    }

    @NotNull
    public Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable Map<String, ? extends Object> additionalContext, boolean enableBreak, @Nullable Project project) {
        Map<String, ? extends Object> map;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (((WipValueManager)this.getValueManager()).isObsolete()) {
            return Promises.cancelledPromise();
        }
        Pair<String, Boolean> pair = PromiseEvaluationHandler.INSTANCE.handleAwait(expression, project);
        String processedExpression = (String)pair.component1();
        boolean wrappedInAsync = (Boolean)pair.component2();
        if (!wrappedInAsync) {
            processedExpression = this.wrapObjectLiteral(expression, project);
        }
        if (!((map = additionalContext) == null || map.isEmpty())) {
            Promise promise;
            Object thisParameter;
            Object object = thisParameter = additionalContext.size() == 1 ? additionalContext.get("this") : null;
            if (thisParameter instanceof SerializableValue) {
                WipCommandProcessor wipCommandProcessor = ((WipValueManager)this.getValueManager()).getCommandProcessor();
                CharSequence charSequence = "function() {return " + expression + ";}";
                String string = ((SerializableValue)thisParameter).getRefId();
                Intrinsics.checkNotNull((Object)string);
                Promise promise2 = wipCommandProcessor.send((Request)RuntimeKt.CallFunctionOn$default(charSequence, string, null, null, null, null, null, null, null, null, null, null, null, 8188, null)).then(arg_0 -> WipEvaluateContextBase.evaluate$lambda$0((Function1)new Function1<CallFunctionOnResult, EvaluateResult>(this){
                    final /* synthetic */ WipEvaluateContextBase<DATA> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final EvaluateResult invoke(CallFunctionOnResult it) {
                        Value value = ((WipValueManager)this.this$0.getValueManager()).createValue(it.result());
                        Intrinsics.checkNotNull((Object)value);
                        return new EvaluateResult(value, it.getExceptionDetails() != null);
                    }
                }, arg_0));
                Intrinsics.checkNotNull((Object)promise2);
                promise = promise2;
            } else {
                promise = ((WipValueManager)this.getValueManager()).getVm().getSuspendContextManager().getEvaluateHack$intellij_javascript_wip_backend().evaluate(expression, additionalContext, (WipValueManager)this.getValueManager(), this);
            }
            return promise;
        }
        Promise request = ((WipValueManager)this.getValueManager()).getCommandProcessor().send(this.createRequest(processedExpression, (WipValueManager)this.getValueManager(), wrappedInAsync));
        this.refreshOnDone(request);
        Promise promise = request.then(arg_0 -> WipEvaluateContextBase.evaluate$lambda$1((Function1)new Function1<DATA, EvaluateResult>(this){
            final /* synthetic */ WipEvaluateContextBase<DATA> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final EvaluateResult invoke(DATA it) {
                Intrinsics.checkNotNull(it);
                return this.this$0.processResponse(it, (WipValueManager)this.this$0.getValueManager());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final String wrapObjectLiteral(String expression, Project project) {
        if (project == null || !OBJECT_LITERAL_PATTERN.matcher(expression).matches()) {
            return expression;
        }
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = expression;
        ReadAction.run(() -> WipEvaluateContextBase.wrapObjectLiteral$lambda$3(project, expression, result));
        return (String)result.element;
    }

    @NotNull
    public final EvaluateResult processResponse(@NotNull DATA data, @NotNull WipValueManager valueManager) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        Value value = valueManager.createValue(this.getRemoteObjectValue(data));
        Intrinsics.checkNotNull((Object)value);
        return new EvaluateResult(value, this.getWasThrown(data));
    }

    public void releaseObjects() {
        ((WipValueManager)this.getValueManager()).clearCaches();
        ((WipValueManager)this.getValueManager()).releaseObjects();
    }

    @NotNull
    public abstract Request<DATA> createRequest(@NotNull String var1, @NotNull WipValueManager var2, boolean var3);

    @NotNull
    protected abstract RemoteObjectValue getRemoteObjectValue(@NotNull DATA var1);

    protected abstract boolean getWasThrown(@NotNull DATA var1);

    private static final EvaluateResult evaluate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EvaluateResult)$tmp0.invoke(p0);
    }

    private static final EvaluateResult evaluate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EvaluateResult)$tmp0.invoke(p0);
    }

    private static final void wrapObjectLiteral$lambda$3(Project $project, String $expression, Ref.ObjectRef $result) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
            Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
            ASTNode aSTNode = JSChangeUtil.tryCreateExpressionFromText((Project)$project, (String)$expression, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_6, (boolean)false);
            if (aSTNode == null) break block1;
            ASTNode psi = aSTNode;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)psi.getElementType(), (Object)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION)) {
                $result.element = "(" + $result.element + ")";
            }
        }
    }

    static {
        Pattern pattern = Pattern.compile("^\\s*\\{.*}\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        OBJECT_LITERAL_PATTERN = pattern;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/wip/WipEvaluateContextBase$Companion;", "", "()V", "OBJECT_LITERAL_PATTERN", "Ljava/util/regex/Pattern;", "getOBJECT_LITERAL_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.javascript.wip.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getOBJECT_LITERAL_PATTERN() {
            return OBJECT_LITERAL_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

