/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.documentation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.documentation.ClangDocumentationProviderKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.documentation.CidrDocumentationProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0017\u0010\b\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/documentation/ClangDocumentationProvider;", "Lcom/jetbrains/cidr/lang/documentation/CidrDocumentationProvider;", "()V", "formatHoverInfo", "", "Lorg/jetbrains/annotations/Nls;", "hoverInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClionHoverInfo;", "getEvaluatedExpressionInfo", "element", "Lcom/intellij/psi/PsiElement;", "intellij.c.clangdBridge"})
public final class ClangDocumentationProvider
extends CidrDocumentationProvider {
    @Nullable
    protected String getEvaluatedExpressionInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!ClangUtils.isClangdOn((Project)project2)) {
            return null;
        }
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref ref2 = ref;
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted((Project)project2);
        if (clangLanguageService != null) {
            clangLanguageService.getCLionHoverInfo(virtualFile2, element.getTextOffset(), arg_0 -> ClangDocumentationProvider.getEvaluatedExpressionInfo$lambda$0(ref2, arg_0));
        }
        ClionHoverInfo hoverInfo = (ClionHoverInfo)ref2.get();
        return this.formatHoverInfo(hoverInfo);
    }

    private final String formatHoverInfo(ClionHoverInfo hoverInfo) {
        StringBuilder stringBuilder;
        if (hoverInfo == null) {
            return null;
        }
        StringBuilder $this$formatHoverInfo_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (hoverInfo.getValue() != null) {
            String string = hoverInfo.getValue();
            Intrinsics.checkNotNull((Object)string);
            ClangDocumentationProviderKt.access$addValueFromHover($this$formatHoverInfo_u24lambda_u241, string);
        }
        ClangDocumentationProviderKt.access$addOffset($this$formatHoverInfo_u24lambda_u241, hoverInfo);
        ClangDocumentationProviderKt.access$addSizeAndPadding($this$formatHoverInfo_u24lambda_u241, hoverInfo);
        ClangDocumentationProviderKt.access$addMoveCopyability($this$formatHoverInfo_u24lambda_u241, hoverInfo);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void getEvaluatedExpressionInfo$lambda$0(Ref $ref, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)$ref, (String)"$ref");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $ref.set(it.waitForResult());
    }
}

