/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SnippetInsertHandler
extends TemplateInsertHandler {
    @NonNls
    private static final String NEW_WITH_SPACE = "new ";
    @NonNls
    private static final String CASE = "case";
    @NonNls
    private static final String USING_NAMESPACE_WITH_SPACE = "using namespace ";
    private final CLionCompletionItem myCompletion;
    private final String myInsertion;

    protected SnippetInsertHandler(String insertion, CLionCompletionItem completion) {
        super(insertion);
        this.myInsertion = insertion;
        this.myCompletion = completion;
    }

    private static String getText(Document document, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document.getImmutableCharSequence();
            return chars.subSequence(Math.min(chars.length() - 1, startOffset), Math.min(chars.length() - 1, endOffset)).toString();
        }
        return "";
    }

    private static boolean hasMatchingCharAfterInsertion(@NotNull String insertion, Document document, int endOffset, String character) {
        if (insertion == null) {
            SnippetInsertHandler.$$$reportNull$$$0(0);
        }
        return insertion.endsWith(character) && endOffset < document.getTextLength() && SnippetInsertHandler.getText(document, endOffset, endOffset + 1).equals(character);
    }

    protected void reformatAfterInsertion(@NotNull InsertionContext context, @NotNull String insertion, int caretOffset) {
        if (context == null) {
            SnippetInsertHandler.$$$reportNull$$$0(1);
        }
        if (insertion == null) {
            SnippetInsertHandler.$$$reportNull$$$0(2);
        }
        Document document = context.getDocument();
        int endOffset = context.getTailOffset();
        ClangdCompletionUtils.adjustCompletionInLiveTemplateIfNeeded((Project)context.getProject(), (Editor)context.getEditor(), (Document)document, (String)insertion, (int)endOffset);
        if (SnippetInsertHandler.hasMatchingCharAfterInsertion(insertion, document, endOffset, " ")) {
            document.replaceString(endOffset - 1, endOffset + 1, (CharSequence)" ");
            return;
        }
        if (context.getCompletionChar() == ';' && SnippetInsertHandler.getText(document, endOffset - 1, endOffset).equals(";")) {
            context.setAddCompletionChar(false);
        }
        if (this.myCompletion.getFilterText().startsWith("#") || insertion.startsWith(CASE) || insertion.startsWith(NEW_WITH_SPACE) || insertion.startsWith(USING_NAMESPACE_WITH_SPACE) || insertion.endsWith(":") || insertion.endsWith(" ") && context.getCompletionChar() != ';') {
            ClangdCompletionUtils.reindentCompletion((InsertionContext)context, (int)context.getStartOffset(), (int)(context.getStartOffset() + insertion.length()));
            return;
        }
        ClangdCompletionUtils.reformatCompletion((InsertionContext)context, (int)context.getStartOffset(), (int)(context.getStartOffset() + insertion.length()), (int)caretOffset);
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int completionStart;
        String text2;
        if (context == null) {
            SnippetInsertHandler.$$$reportNull$$$0(3);
        }
        if (item == null) {
            SnippetInsertHandler.$$$reportNull$$$0(4);
        }
        Document document = context.getDocument();
        boolean completionEndsWithSemicolon = this.myInsertion.endsWith(";");
        if (completionEndsWithSemicolon && (text2 = document.getText().substring(context.getTailOffset())).trim().startsWith(";")) {
            context.getOffsetMap().addOffset(InsertionContext.TAIL_OFFSET, context.getTailOffset() + text2.indexOf(";") + 1);
        }
        if ((completionStart = ClangLanguageServiceUtils.lspPos2Offset((Document)context.getDocument(), (Position)((TextEdit)this.myCompletion.getTextEdit().getLeft()).getRange().getStart())) != context.getStartOffset() && (context.getEditor().getCaretModel().getCaretCount() == 1 || document.getLineNumber(completionStart) == document.getLineNumber(context.getStartOffset()))) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, completionStart);
        }
        super.handleInsert(context, item);
        if (completionEndsWithSemicolon && !this.myInsertion.contains("<caret>")) {
            OCTypedHandlerDelegate.overTypeNextSemicolon();
        }
    }

    public static LookupElementBuilder snippetLookup(CLionCompletionItem completion) {
        String template = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
        String data = template.replaceAll("\\n|(<caret>)|(<#(.*)#>)", "").trim();
        return SnippetInsertHandler.snippetLookup(data, template, completion);
    }

    public static LookupElementBuilder snippetLookup(String userString, String template, CLionCompletionItem completion) {
        Object insertHandler;
        int caretIndex = template.indexOf("<caret>");
        if ((userString.endsWith("()") || userString.endsWith("();")) && caretIndex > template.indexOf(40)) {
            insertHandler = new SnippetParenthesesHandler(!template.endsWith("()"), userString.endsWith(");"), completion);
            userString = userString.substring(0, userString.lastIndexOf("("));
        } else {
            insertHandler = new SnippetInsertHandler(template, completion);
        }
        return LookupElementBuilder.create((Object)new TemplateInsertHandler.TemplateObject(userString), (String)ClangdCompletionUtils.trimKeywordLookup((String)completion.getFilterText())).withInsertHandler((InsertHandler)insertHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertion";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/completion/SnippetInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMatchingCharAfterInsertion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatAfterInsertion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SnippetParenthesesHandler
    implements InsertHandler<LookupElement> {
        final boolean myHasParameters;
        final boolean myHasSemicolon;
        private final CLionCompletionItem myCompletion;

        SnippetParenthesesHandler(boolean hasParameters, boolean hasSemicolon, CLionCompletionItem completion) {
            this.myHasParameters = hasParameters;
            this.myHasSemicolon = hasSemicolon;
            this.myCompletion = completion;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Editor editor;
            Document document;
            int completionStart;
            if (context == null) {
                SnippetParenthesesHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                SnippetParenthesesHandler.$$$reportNull$$$0(1);
            }
            if ((completionStart = ClangLanguageServiceUtils.lspPos2Offset((Document)(document = (editor = context.getEditor()).getDocument()), (Position)((TextEdit)this.myCompletion.getTextEdit().getLeft()).getRange().getStart())) != context.getStartOffset()) {
                String template = ((TextEdit)this.myCompletion.getTextEdit().getLeft()).getNewText();
                String insertion = template.replaceAll("\\n|(<caret>)|(<#(.*)#>)", "").trim();
                insertion = insertion.substring(0, insertion.indexOf(40));
                document.replaceString(completionStart, context.getTailOffset(), (CharSequence)insertion);
                context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, completionStart);
            }
            String text2 = document.getText();
            boolean hasLParen = context.getTailOffset() < text2.length() && text2.substring(context.getTailOffset()).trim().startsWith("(");
            int offsetBeforeLParen = context.getTailOffset();
            if (context.getTailOffset() > 0 && context.getTailOffset() < text2.length() && text2.substring(context.getTailOffset() - 1, context.getTailOffset() + 1).equals("  ")) {
                document.replaceString(context.getTailOffset(), context.getTailOffset() + 1, (CharSequence)"");
            }
            ParenthesesInsertHandler.getInstance((boolean)this.myHasParameters, (boolean)false, (boolean)false, (!hasLParen ? 1 : 0) != 0, (boolean)false).handleInsert(context, item);
            if (!hasLParen && this.myHasSemicolon) {
                document.insertString(context.getTailOffset(), (CharSequence)";");
            }
            @NotNull Caret caret = editor.getCaretModel().getCurrentCaret();
            if (hasLParen && this.myHasParameters) {
                text2 = document.getText();
                int lParenOffset = offsetBeforeLParen < text2.length() ? text2.indexOf("(", offsetBeforeLParen) : context.getTailOffset();
                caret.moveToOffset(lParenOffset + 1);
            }
            ClangdCompletionUtils.reformatCompletion((InsertionContext)context, (int)context.getStartOffset(), (int)context.getTailOffset(), (int)caret.getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/completion/SnippetInsertHandler$SnippetParenthesesHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

