/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.tracker;

import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.session.SessionFactorsUtils;
import com.intellij.completion.ml.personalization.session.SessionPrefixTracker;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.tracker.CompletionFactorsInitializer;
import com.intellij.completion.ml.tracker.LookupCompletedTracker;
import com.intellij.completion.ml.tracker.LookupSelectionTracker;
import com.intellij.completion.ml.tracker.LookupStartedTracker;
import com.intellij.completion.ml.tracker.LookupTracker;
import com.intellij.completion.ml.tracker.TimeBetweenTypingTracker;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ml/tracker/CompletionFactorsInitializer;", "Lcom/intellij/completion/ml/tracker/LookupTracker;", "()V", "lookupCreated", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "processSessionFactors", "lookupStorage", "processUserFactors", "shouldUseSessionFactors", "", "shouldUseUserFactors", "language", "Lcom/intellij/lang/Language;", "Companion", "intellij.completionMlRanking"})
public final class CompletionFactorsInitializer
extends LookupTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean isEnabledInTests;

    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (ApplicationManager.getApplication().isUnitTestMode() && !isEnabledInTests) {
            return;
        }
        this.processUserFactors(lookup);
        this.processSessionFactors(lookup, storage);
    }

    private final boolean shouldUseUserFactors(Language language) {
        return ApplicationManager.getApplication().isEAP() || Intrinsics.areEqual((Object)ApplicationInfo.getInstance().getVersionName(), (Object)"PyCharm") && (language == null || language.isKindOf("Python")) && PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)"org.jetbrains.completion.full.line"));
    }

    private final boolean shouldUseSessionFactors() {
        return SessionFactorsUtils.INSTANCE.shouldUseSessionFactors();
    }

    private final void processUserFactors(LookupImpl lookup) {
        if (!this.shouldUseUserFactors(LookupExtensionsKt.language(lookup))) {
            return;
        }
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_USAGE(), processUserFactors.1.INSTANCE);
        Project project2 = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        lookup.setPrefixChangeListener((PrefixChangeListener)new TimeBetweenTypingTracker(project2));
        lookup.addLookupListener((LookupListener)new LookupCompletedTracker());
        lookup.addLookupListener((LookupListener)new LookupStartedTracker());
    }

    private final void processSessionFactors(LookupImpl lookup, MutableLookupStorage lookupStorage) {
        if (!this.shouldUseSessionFactors()) {
            return;
        }
        lookup.setPrefixChangeListener((PrefixChangeListener)new SessionPrefixTracker(lookupStorage.getSessionFactors()));
        lookup.addLookupListener((LookupListener)new LookupSelectionTracker(lookupStorage));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/tracker/CompletionFactorsInitializer$Companion;", "", "()V", "isEnabledInTests", "", "()Z", "setEnabledInTests", "(Z)V", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabledInTests() {
            return isEnabledInTests;
        }

        public final void setEnabledInTests(boolean bl) {
            isEnabledInTests = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

