/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.renderers;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.rd.ide.model.CodeStyleBoolOption;
import com.jetbrains.rd.ide.model.CodeStyleEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleFlaggedEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleNumericOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.CodeStyleOrderedCollectionOption;
import com.jetbrains.rd.ide.model.CodeStyleStringOption;
import com.jetbrains.rider.model.EnumWithValue;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.RendererDecorator;
import com.jetbrains.rider.settings.tree.renderers.BoolRenderer;
import com.jetbrains.rider.settings.tree.renderers.CodeStyleOrderedCollectionRenderer;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.settings.tree.renderers.EnumRenderer;
import com.jetbrains.rider.settings.tree.renderers.FlaggedEnumRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J<\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/settings/tree/renderers/NodeValueRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "myBoolPresenter", "Lcom/jetbrains/rider/settings/tree/renderers/BoolRenderer;", "myEmptyLabel", "Ljavax/swing/JPanel;", "myEnumPresenter", "Lcom/jetbrains/rider/settings/tree/renderers/EnumRenderer;", "myFlaggedEnumRenderer", "Lcom/jetbrains/rider/settings/tree/renderers/FlaggedEnumRenderer;", "myNumericLabel", "Ljavax/swing/JLabel;", "myOrderedCollectionRenderer", "Lcom/jetbrains/rider/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "myStringLabel", "getRendererWithoutBackground", "Ljava/awt/Component;", "option", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "value", "", "isEnabled", "", "isHighlighted", "tooltip", "", "getTableCellRendererComponent", "table", "Ljavax/swing/JTable;", "isSelected", "hasFocus", "row", "", "column", "intellij.rider.rdclient.dotnet"})
public final class NodeValueRenderer
implements TableCellRenderer {
    @NotNull
    private final BoolRenderer myBoolPresenter = new BoolRenderer();
    @NotNull
    private final EnumRenderer myEnumPresenter = new EnumRenderer();
    @NotNull
    private final FlaggedEnumRenderer myFlaggedEnumRenderer = new FlaggedEnumRenderer();
    @NotNull
    private final JLabel myNumericLabel = new JLabel();
    @NotNull
    private final JLabel myStringLabel = new JLabel();
    @NotNull
    private final CodeStyleOrderedCollectionRenderer myOrderedCollectionRenderer = new CodeStyleOrderedCollectionRenderer();
    @NotNull
    private final JPanel myEmptyLabel = new JPanel();

    public NodeValueRenderer() {
        RendererDecorator decorator2 = new RendererDecorator();
        decorator2.decorate(this.myNumericLabel);
        this.myNumericLabel.setOpaque(true);
        decorator2.decorate(this.myStringLabel);
        this.myStringLabel.setOpaque(true);
        decorator2.decorate(this.myEmptyLabel);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@Nullable JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isEnabled = true;
        boolean isHighlighted = false;
        String tooltip2 = null;
        Intrinsics.checkNotNull((Object)table2, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.treetable.TreeTable");
        Object object = ((TreeTable)table2).getTree().getPathForRow(row).getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        CodeStyleOptionBase option = null;
        if (node instanceof CodeStyleTreeNode) {
            isEnabled = ((CodeStyleTreeNode)node).isEnabled();
            option = ((CodeStyleTreeNode)node).getModel();
            isHighlighted = ((CodeStyleTreeNode)node).isHighlighted();
            tooltip2 = ((CodeStyleTreeNode)node).tooltip();
        }
        if (!((TreeTable)table2).isEnabled()) {
            isEnabled = false;
        }
        Component res2 = this.getRendererWithoutBackground(option, value2, isEnabled, isHighlighted, tooltip2);
        if (!isHighlighted) {
            res2.setBackground(((TreeTable)table2).getBackground());
        }
        return res2;
    }

    private final Component getRendererWithoutBackground(CodeStyleOptionBase option, Object value2, boolean isEnabled, boolean isHighlighted, @NlsContexts.Tooltip String tooltip2) {
        if (option instanceof CodeStyleBoolOption) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.myBoolPresenter.reset((Boolean)value2, isEnabled, isHighlighted, tooltip2);
            return (Component)((Object)this.myBoolPresenter);
        }
        if (option instanceof CodeStyleEnumOption) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.EnumWithValue");
            this.myEnumPresenter.reset(((EnumWithValue)value2).getPresentation(), isEnabled, isHighlighted, tooltip2);
            return (Component)((Object)this.myEnumPresenter);
        }
        if (option instanceof CodeStyleFlaggedEnumOption) {
            this.myFlaggedEnumRenderer.reset((CodeStyleFlaggedEnumOption)option, isEnabled, isHighlighted, tooltip2);
            return (Component)((Object)this.myFlaggedEnumRenderer);
        }
        if (option instanceof CodeStyleNumericOption) {
            this.myNumericLabel.setText(String.valueOf(value2));
            this.myNumericLabel.setEnabled(isEnabled);
            if (isHighlighted) {
                this.myNumericLabel.setBackground(Common.Resources.getHighlightedBackgroundColor());
                if (tooltip2 != null) {
                    this.myNumericLabel.setToolTipText(tooltip2);
                }
            }
            return this.myNumericLabel;
        }
        if (option instanceof CodeStyleStringOption) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.String");
            this.myStringLabel.setText((String)value2);
            this.myStringLabel.setEnabled(isEnabled);
            if (isHighlighted) {
                this.myStringLabel.setBackground(Common.Resources.getHighlightedBackgroundColor());
                if (tooltip2 != null) {
                    this.myNumericLabel.setToolTipText(tooltip2);
                }
            }
            return this.myStringLabel;
        }
        if (option instanceof CodeStyleOrderedCollectionOption) {
            this.myOrderedCollectionRenderer.reset((CodeStyleOrderedCollectionOption)option, isEnabled, isHighlighted, tooltip2);
            return (Component)((Object)this.myOrderedCollectionRenderer);
        }
        if (option instanceof CodeStyleGroupOption) {
            return this.myEmptyLabel;
        }
        return this.myEmptyLabel;
    }
}

