/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingStyleKindsConverter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;", "Ljavax/swing/JPanel;", "namingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "(Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;)V", "converter", "Lcom/jetbrains/rider/settings/naming/NamingStyleKindsConverter;", "currentRule", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "prefix", "Ljavax/swing/JTextField;", "style", "Ljavax/swing/JComboBox;", "", "suffix", "fillFromRule", "", "rule", "handleDataChanged", "setIsEnabled", "value", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingRuleEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingRuleEditor.kt\ncom/jetbrains/rider/settings/naming/NamingRuleEditor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n13309#2,2:116\n37#3,2:118\n*S KotlinDebug\n*F\n+ 1 NamingRuleEditor.kt\ncom/jetbrains/rider/settings/naming/NamingRuleEditor\n*L\n52#1:116,2\n53#1:118,2\n*E\n"})
public final class NamingRuleEditor
extends JPanel {
    @NotNull
    private final NamingChangeTracker namingChangeTracker;
    @NotNull
    private final JTextField prefix;
    @NotNull
    private JTextField suffix;
    @NotNull
    private JComboBox<String> style;
    @Nullable
    private MutableNamingRule currentRule;
    @NotNull
    private final NamingStyleKindsConverter converter;

    public NamingRuleEditor(@NotNull NamingChangeTracker namingChangeTracker) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints gridBagConstraints2;
        Intrinsics.checkNotNullParameter((Object)namingChangeTracker, (String)"namingChangeTracker");
        this.namingChangeTracker = namingChangeTracker;
        this.prefix = new JTextField(RiderSettingsBundle.Companion.message("NamingRuleEditor.text.select.a.rule.to.edit", new Object[0]));
        this.suffix = new JTextField(RiderSettingsBundle.Companion.message("NamingRuleEditor.text.select.a.rule.to.edit", new Object[0]));
        this.converter = new NamingStyleKindsConverter();
        this.setLayout(new GridBagLayout());
        this.setAlignmentX(0.0f);
        GridBagConstraints $this$_init__u24lambda_u240 = gridBagConstraints2 = new GridBagConstraints();
        boolean bl = false;
        $this$_init__u24lambda_u240.gridx = 0;
        $this$_init__u24lambda_u240.gridy = 0;
        $this$_init__u24lambda_u240.weightx = 0.0;
        $this$_init__u24lambda_u240.weighty = 0.0;
        $this$_init__u24lambda_u240.anchor = 13;
        $this$_init__u24lambda_u240.fill = 0;
        GridBagConstraints constraints = gridBagConstraints2;
        JLabel prefixDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.prefix", new Object[0]) + " ");
        JLabel suffixDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.suffix", new Object[0]) + " ");
        JLabel styleDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.style", new Object[0]) + " ");
        this.add((Component)prefixDescriptionLabel, constraints);
        int n = constraints.gridy;
        constraints.gridy = n + 1;
        this.add((Component)suffixDescriptionLabel, constraints);
        n = constraints.gridy;
        constraints.gridy = n + 1;
        this.add((Component)styleDescriptionLabel, constraints);
        ArrayList<String> allKinds = new ArrayList<String>();
        NamingStyleKinds[] $this$forEach$iv = NamingStyleKinds.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            NamingStyleKinds element$iv;
            NamingStyleKinds it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            allKinds.add(this.converter.convert(it));
        }
        Collection $this$toTypedArray$iv = allKinds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.style = (JComboBox)new ComboBox((Object[])thisCollection$iv.toArray(new String[0]));
        this.setBorder((Border)JBUI.Borders.empty());
        GridBagConstraints $this$_init__u24lambda_u242 = gridBagConstraints = constraints;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.gridy = 0;
        $this$_init__u24lambda_u242.gridx = 1;
        $this$_init__u24lambda_u242.weightx = 1.0;
        $this$_init__u24lambda_u242.fill = 2;
        this.add((Component)this.prefix, constraints);
        int n3 = constraints.gridy;
        constraints.gridy = n3 + 1;
        this.add((Component)this.suffix, constraints);
        n3 = constraints.gridy;
        constraints.gridy = n3 + 1;
        this.add((Component)this.style, constraints);
        this.prefix.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleDataChanged();
            }
        });
        this.suffix.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleDataChanged();
            }
        });
        this.style.addActionListener(arg_0 -> NamingRuleEditor._init_$lambda$3(this, arg_0));
        this.setIsEnabled(false);
    }

    public final void fillFromRule(@NotNull MutableNamingRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.setIsEnabled(true);
        this.currentRule = rule;
        this.prefix.setText(rule.getPrefix());
        this.suffix.setText(rule.getSuffix());
        this.style.setSelectedItem(this.converter.convert(rule.getKind()));
    }

    private final void handleDataChanged() {
        boolean bl;
        if (!this.namingChangeTracker.getShouldTrackChanged()) {
            return;
        }
        boolean bl2 = bl = this.currentRule != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        MutableNamingRule mutableNamingRule = this.currentRule;
        Intrinsics.checkNotNull((Object)mutableNamingRule);
        MutableNamingRule rule = mutableNamingRule;
        String string = this.prefix.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        rule.setPrefix(string);
        String string2 = this.suffix.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        rule.setSuffix(string2);
        NamingStyleKinds kind = this.converter.convertBack(this.style.getSelectedItem().toString());
        rule.setKind(kind);
        this.namingChangeTracker.handleDataChanged();
    }

    private final void setIsEnabled(boolean value2) {
        this.prefix.setEnabled(value2);
        this.suffix.setEnabled(value2);
        this.style.setEnabled(value2);
    }

    private static final void _init_$lambda$3(NamingRuleEditor this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleDataChanged();
    }
}

