/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.ide.model.CategoryGroup;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.ConfigureFormattingRdModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.codeStyle.ConfigureFormattingDialog;
import com.jetbrains.rider.settings.codeStyle.DialogPositionProvider;
import com.jetbrains.rider.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNodeSection;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.settings.util.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001e\u0018\u0000 12\u00020\u0001:\u000212B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\r\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001cH\u0014J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0014JD\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-H\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u001cH\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "getModel", "()Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "beforeSave", "", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createSaveAsCommentsAction", "com/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1", "()Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1;", "createTitlePane", "doCancelAction", "doOKAction", "fillTree", "", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeNode;", "options", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "refresher", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory$Refresher;", "filter", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getInitialSize", "Ljava/awt/Dimension;", "getPreferredFocusedComponent", "Companion", "SaveAction", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1549#2:311\n1620#2,2:312\n1855#2,2:314\n1622#2:316\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n*L\n116#1:311\n116#1:312,2\n126#1:314,2\n116#1:316\n*E\n"})
public final class ConfigureFormattingDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigureFormattingRdModel model;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private final Editor editor;
    @NlsSafe
    @NotNull
    private static final String ClangFormatFileName = ".clang-format";
    @NlsSafe
    @NotNull
    private static final String EditorConfigFileName = ".editorconfig";

    public ConfigureFormattingDialog(@NotNull ConfigureFormattingRdModel model, @NotNull Lifetime lifetime2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, DialogWrapper.IdeModalityType.IDE);
        this.model = model;
        this.lifetime = lifetime2;
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fill, ins 0", "[fill]", "[fill]"));
        TextControlId textControlId = this.model.getTextControl();
        this.editor = textControlId != null ? TextControlUtilsKt.tryGetEditor(textControlId, FrontendTextControlHost.Companion.getInstance(project2)) : null;
        this.myOKAction = new SaveAction();
        this.setTitle(this.model.getTitle());
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        CodeStyleTreeFactory treeFactory = new CodeStyleTreeFactory(disposable);
        final CodeStyleTreeTable treeTable2 = treeFactory.createTree((Function2<? super DefaultMutableTreeNode, ? super CodeStyleTreeFactory.Refresher, Boolean>)((Function2)treeTable.1.INSTANCE));
        treeTable2.setTableHeader(null);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setMinimumSize(new Dimension(JBUIScale.scale((int)10), JBUIScale.scale((int)100)));
        scrollPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)50), JBUIScale.scale((int)500)));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        this.mainPanel.add((Component)scrollPanel);
        this.model.getFilteredEntries().advise(this.lifetime, (Function1)new Function1<List<? extends Integer>, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<Integer> it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
                List list = (List)this.getModel().getFilteredEntries().getValueOrNull();
                if (list == null) {
                    return;
                }
                List filteredEntries = list;
                HashSet filter2 = CollectionsKt.toHashSet((Iterable)filteredEntries);
                CodeStyleTreeFactory.Refresher refresher = new CodeStyleTreeFactory.Refresher();
                refresher.setTreeTable(treeTable2);
                Iterable iterable = this.getModel().getSettings();
                ConfigureFormattingDialog configureFormattingDialog = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CategoryGroup group = (CategoryGroup)((Object)element$iv);
                    boolean bl = false;
                    List children = configureFormattingDialog.fillTree(group.getOptions(), configureFormattingDialog.getLifetime(), refresher, filter2);
                    if (!CollectionsKt.any((Iterable)children)) continue;
                    CodeStyleTreeNodeSection newNode = new CodeStyleTreeNodeSection(group);
                    Iterable $this$forEach$iv2 = children;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CodeStyleTreeNode it2 = (CodeStyleTreeNode)element$iv2;
                        boolean bl2 = false;
                        newNode.add(it2);
                    }
                    rootNode.add(newNode);
                }
                TreeTableModel treeTableModel = treeTable2.getTableModel();
                Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.treetable.ListTreeTableModel");
                ListTreeTableModel listTreeTableModel = (ListTreeTableModel)treeTableModel;
                listTreeTableModel.setRoot((TreeNode)rootNode);
                TreeUtil.INSTANCE.fitColumnWidthPercent(0, treeTable2, (int)(1.2 * (double)(100 / treeTable2.getColumnCount())), true);
                TreeTableTree treeTableTree = treeTable2.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
                TreeUtil.INSTANCE.expandTree((JTree)treeTableTree);
            }
        });
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.close(1);
            }
        });
        RdTextRange selectedRange = this.model.getSelectedRange();
        if (this.editor != null && selectedRange != null) {
            this.setInitialLocationCallback(() -> ConfigureFormattingDialog._init_$lambda$0(this, selectedRange));
        }
        this.init();
    }

    @NotNull
    public final ConfigureFormattingRdModel getModel() {
        return this.model;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public Dimension getInitialSize() {
        int width = SwingUtilities.getRootPane(this.getWindow().getParent()).getWidth() / 5;
        int minWidth = JBUIScale.scale((int)540);
        int maxWidth = JBUIScale.scale((int)1000);
        if (width < minWidth) {
            width = minWidth;
        } else if (width > maxWidth) {
            width = maxWidth;
        }
        return new Dimension(width, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CodeStyleTreeNode> fillTree(List<? extends CodeStyleOptionBase> options, Lifetime lifetime2, CodeStyleTreeFactory.Refresher refresher, HashSet<Integer> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CodeStyleTreeNode codeStyleTreeNode;
            void option;
            List<CodeStyleTreeNode> children;
            CodeStyleOptionBase codeStyleOptionBase = (CodeStyleOptionBase)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<CodeStyleTreeNode> list = children = option instanceof CodeStyleGroupOption ? this.fillTree(((CodeStyleGroupOption)option).getChildren(), lifetime2, refresher, filter2) : CollectionsKt.emptyList();
            if (filter2.contains(option.getId()) || CollectionsKt.any((Iterable)children)) {
                CodeStyleTreeNode newNode = new CodeStyleTreeNode((CodeStyleOptionBase)option);
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CodeStyleTreeNode it = (CodeStyleTreeNode)element$iv;
                    boolean bl2 = false;
                    newNode.add(it);
                }
                codeStyleTreeNode = newNode;
            } else {
                codeStyleTreeNode = null;
            }
            collection.add(codeStyleTreeNode);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    public void doCancelAction() {
        InterfacesKt.fire(this.model.getCancel());
        this.close(1);
    }

    @NotNull
    protected JComponent createTitlePane() {
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0", "", "[min!]"));
        if (this.model.getShouldShowEditorConfigWarning()) {
            JBLabel editorConfigNotificationPanel = new JBLabel("");
            editorConfigNotificationPanel.setBackground(Common.Resources.getHighlightedBackgroundColor());
            editorConfigNotificationPanel.setOpaque(true);
            JPanel panelWithEditorConfigNotification = new JPanel();
            panelWithEditorConfigNotification.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)0));
            panelWithEditorConfigNotification.setLayout((LayoutManager)new MigLayout("insets 3 5 3 5", "[]"));
            panelWithEditorConfigNotification.setBackground(Common.Resources.getHighlightedBackgroundColor());
            panelWithEditorConfigNotification.setOpaque(true);
            panelWithEditorConfigNotification.add((Component)editorConfigNotificationPanel, "grow");
            String saveText = this.model.getShouldShowEditorConfigSaveSuggestion() ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.to.save.them.select.saveto.editorconfig", new Object[0]) : RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.all.changes.to.them.would.be.lost", new Object[0]);
            Object[] objectArray = new Object[]{this.model.getConfigFileName()};
            editorConfigNotificationPanel.setText(new HtmlBuilder().append(HtmlChunk.text((String)RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.overrides.some.code.style.settings", objectArray))).br().append(HtmlChunk.text((String)saveText)).wrapWith(HtmlChunk.body()).style("white-space:normal").wrapWith(HtmlChunk.html()).toString());
            editorConfigNotificationPanel.setBackground(Common.Resources.getHighlightedBackgroundColor());
            panelWithEditorConfigNotification.setVisible(true);
            panel2.add((Component)panelWithEditorConfigNotification, "dock north");
        }
        if (this.model.getShowCheckBoxes()) {
            JCheckBox previewFormattingCheckBox = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.preview.formatting", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getPreviewFormatting()))));
            previewFormattingCheckBox.addChangeListener(arg_0 -> ConfigureFormattingDialog.createTitlePane$lambda$3(this, previewFormattingCheckBox, arg_0));
            panel2.add(previewFormattingCheckBox);
            JCheckBox onlyShowChangedCheckBox = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.only.show.changed.values", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getOnlyShowChanged()))));
            onlyShowChangedCheckBox.addChangeListener(arg_0 -> ConfigureFormattingDialog.createTitlePane$lambda$4(this, onlyShowChangedCheckBox, arg_0));
            panel2.add(onlyShowChangedCheckBox);
        }
        return panel2;
    }

    public final void beforeSave() {
        TableCellEditor editor2;
        Container parent;
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            ((JFormattedTextField)focusOwner).commitEdit();
        }
        Component component = focusOwner;
        Container container = parent = component != null ? component.getParent() : null;
        if (parent instanceof JTable && (editor2 = ((JTable)parent).getCellEditor()) != null && !editor2.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
    }

    private final createSaveAsCommentsAction.1 createSaveAsCommentsAction() {
        String string = RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.as.comments", new Object[0]);
        return new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ ConfigureFormattingDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
                this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)$receiver.getModel().getSaveEnabled())));
                $receiver.getModel().getSaveEnabled().advise($receiver.getLifetime(), (Function1)new Function1<Boolean, Unit>(this, $receiver){
                    final /* synthetic */ createSaveAsCommentsAction.1 this$0;
                    final /* synthetic */ ConfigureFormattingDialog this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        this.this$0.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$1.getModel().getSaveEnabled())));
                    }
                });
            }

            protected void doAction(@Nullable ActionEvent e) {
                this.this$0.beforeSave();
                InterfacesKt.fire(this.this$0.getModel().getSaveToComments());
                this.this$0.close(1);
            }
        };
    }

    @NotNull
    protected Action[] createActions() {
        if (this.model.getCanSaveAsComments() && !this.model.getPresentSaveAsCommentAsLayer()) {
            Action[] actionArray = new Action[3];
            Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
            actionArray[1] = this.createSaveAsCommentsAction();
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
            return actionArray;
        }
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    protected void doOKAction() {
        this.beforeSave();
        InterfacesKt.fire(this.model.getSave());
        this.close(1);
    }

    private static final Point _init_$lambda$0(ConfigureFormattingDialog this$0, RdTextRange $selectedRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Editor editor2 = this$0.editor;
        Dimension dimension = this$0.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        int n = $selectedRange.getStartOffset();
        int n2 = $selectedRange.getEndOffset();
        JRootPane jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getParent());
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return new DialogPositionProvider(editor2, dimension, document, n, n2, jRootPane).calculateLocation();
    }

    private static final void createTitlePane$lambda$3(ConfigureFormattingDialog this$0, JCheckBox $previewFormattingCheckBox, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$previewFormattingCheckBox, (String)"$previewFormattingCheckBox");
        this$0.model.getPreviewFormatting().set((Object)$previewFormattingCheckBox.isSelected());
    }

    private static final void createTitlePane$lambda$4(ConfigureFormattingDialog this$0, JCheckBox $onlyShowChangedCheckBox, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onlyShowChangedCheckBox, (String)"$onlyShowChangedCheckBox");
        this$0.model.getOnlyShowChanged().set((Object)$onlyShowChangedCheckBox.isSelected());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$Companion;", "", "()V", "ClangFormatFileName", "", "EditorConfigFileName", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction;", "Ljavax/swing/AbstractAction;", "Lcom/intellij/openapi/ui/OptionAction;", "(Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;)V", "myOptions", "", "Ljavax/swing/Action;", "[Ljavax/swing/Action;", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "getOptions", "()[Ljavax/swing/Action;", "setEnabled", "value", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,310:1\n766#2:311\n857#2,2:312\n1549#2:314\n1620#2,3:315\n37#3,2:318\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n*L\n272#1:311\n272#1:312,2\n281#1:314\n281#1:315,3\n302#1:318,2\n*E\n"})
    private final class SaveAction
    extends AbstractAction
    implements OptionAction {
        @NotNull
        private final Action[] myOptions;

        /*
         * WARNING - void declaration
         */
        public SaveAction() {
            List list;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2;
            Object object;
            ConfigureFormattingDialog $this$filterTo$iv$iv;
            super(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
            this.putValue("DefaultAction", true);
            List backendLayers = ConfigureFormattingDialog.this.getModel().getSettingsLayerCollection().getLayers();
            if (OptionsUtilsHost.Companion.getLayer() != null) {
                Iterable $this$filter$iv = backendLayers;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    SettingsLayer it = (SettingsLayer)element$iv$iv;
                    boolean bl = false;
                    object = it.getDisplayName();
                    if (!((Intrinsics.areEqual((Object)object, (Object)ConfigureFormattingDialog.ClangFormatFileName) ? true : Intrinsics.areEqual((Object)object, (Object)ConfigureFormattingDialog.EditorConfigFileName)) | Intrinsics.areEqual((Object)it, (Object)OptionsUtilsHost.Companion.getLayer()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = backendLayers;
            }
            List layers = list2;
            Iterable $i$f$filter = layers;
            $this$filterTo$iv$iv = ConfigureFormattingDialog.this;
            boolean $i$f$map = false;
            void $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (SettingsLayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String displayName2 = Intrinsics.areEqual((Object)it, (Object)OptionsUtilsHost.Companion.getLowPriorityIdeaSettingsLayer()) ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.to.lowPriorityIdeaLayer", new Object[0]) : it.getDisplayName();
                collection.add(new AbstractAction(displayName2, $this$filterTo$iv$iv, (SettingsLayer)it){
                    final /* synthetic */ ConfigureFormattingDialog this$0;
                    final /* synthetic */ SettingsLayer $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super($displayName);
                    }

                    public void actionPerformed(@Nullable ActionEvent e) {
                        this.this$0.beforeSave();
                        this.this$0.getModel().getSaveTo().fire((Object)this.$it);
                        this.this$0.close(1);
                    }
                });
            }
            List saveToLayerActions2 = (List)destination$iv$iv;
            if (ConfigureFormattingDialog.this.getModel().getCanSaveAsComments() && ConfigureFormattingDialog.this.getModel().getPresentSaveAsCommentAsLayer()) {
                createSaveAsCommentsAction.1 action2 = ConfigureFormattingDialog.this.createSaveAsCommentsAction();
                list = CollectionsKt.listOf((Object)((Object)action2));
            } else {
                list = CollectionsKt.emptyList();
            }
            List saveAsCommentsAction = list;
            Collection $this$toTypedArray$iv = CollectionsKt.union((Iterable)saveToLayerActions2, (Iterable)saveAsCommentsAction);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.myOptions = thisCollection$iv.toArray(new Action[0]);
            this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)ConfigureFormattingDialog.this.getModel().getSaveEnabled())));
            ConfigureFormattingDialog.this.getModel().getSaveEnabled().advise(ConfigureFormattingDialog.this.getLifetime(), (Function1)new Function1<Boolean, Unit>(){

                public final void invoke(boolean it) {
                    this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)ConfigureFormattingDialog.this.getModel().getSaveEnabled())));
                }
            });
        }

        @Override
        public void setEnabled(boolean value2) {
            super.setEnabled(value2);
            for (Action option : this.myOptions) {
                option.setEnabled(value2);
            }
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ConfigureFormattingDialog.this.doOKAction();
        }

        @NotNull
        public Action[] getOptions() {
            return this.myOptions;
        }
    }
}

