/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.settings.RiderSettingsDialog;
import com.jetbrains.rider.settings.RiderSettingsDialogFactory;
import com.jetbrains.rider.settings.RiderSettingsDialogFactoryCookie;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J2\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J&\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0018J:\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/settings/RiderSettingsDialogFactory;", "Lcom/intellij/openapi/options/newEditor/SettingsDialogFactory;", "()V", "create", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "filter", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/options/ConfigurableGroup;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;)Lcom/intellij/openapi/ui/DialogWrapper;", "", "key", "showApplyButton", "", "showResetButton", "parent", "Ljava/awt/Component;", "source", "leafFilter", "Lkotlin/Function1;", "filterConfigurableGroup", "shouldFilter", "getOrCreateGroup", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderSettingsDialogFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderSettingsDialogFactory.kt\ncom/jetbrains/rider/settings/RiderSettingsDialogFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,150:1\n1#2:151\n1855#3,2:152\n13309#4,2:154\n*S KotlinDebug\n*F\n+ 1 RiderSettingsDialogFactory.kt\ncom/jetbrains/rider/settings/RiderSettingsDialogFactory\n*L\n70#1:152,2\n90#1:154,2\n*E\n"})
public final class RiderSettingsDialogFactory
extends SettingsDialogFactory {
    @NotNull
    public DialogWrapper create(@Nullable Project project2, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Project project3 = project2;
        if (project3 == null) {
            Project project4 = ProjectManager.getInstance().getDefaultProject();
            project3 = project4;
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getDefaultProject(...)");
        }
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project3);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(project2, key, configurable, showApplyButton, showResetButton, host);
        return (DialogWrapper)dialog2;
    }

    @NotNull
    public DialogWrapper create(@NotNull Project project2, @NotNull ConfigurableGroup[] groups, @Nullable Configurable configurable, @Nullable String filter2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        List<ConfigurableGroup> list = Arrays.asList(Arrays.copyOf(groups, groups.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
        return this.create(project2, list, configurable, filter2);
    }

    @NotNull
    public DialogWrapper create(@NotNull Project project2, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        SettingsLayer settingsLayer = host.getLayer();
        List<ConfigurableGroup> filteredGroups2 = this.filterConfigurableGroup(host.getLayer() != null, groups, (Function1<? super Configurable, ? extends Configurable>)(Intrinsics.areEqual((Object)(settingsLayer != null ? settingsLayer.getDisplayName() : null), (Object)".editorconfig") ? (Function1)create.filteredGroups.1.INSTANCE : (Function1)create.filteredGroups.2.INSTANCE));
        RiderSettingsDialogFactoryCookie.Companion.setProject(project2);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(project2, filteredGroups2, configurable, filter2, host);
        RiderSettingsDialogFactoryCookie.Companion.setProject(null);
        return (DialogWrapper)dialog2;
    }

    @NotNull
    public DialogWrapper create(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Project parentProject;
        Project project2;
        Object object;
        Window parentWindow;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        if (!showApplyButton) {
            return super.create(parent, key, configurable, showApplyButton, showResetButton);
        }
        Container container = SwingUtilities.getAncestorOfClass(Window.class, parent);
        Window window = parentWindow = container instanceof Window ? (Window)container : null;
        if (window != null) {
            Window it = window;
            boolean bl = false;
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(it);
            object = projectFrameHelper != null ? projectFrameHelper.getProject() : null;
        } else {
            object = null;
        }
        if ((project2 = (parentProject = object)) == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(parent, key, configurable, showApplyButton, showResetButton, host);
        return (DialogWrapper)dialog2;
    }

    private final List<ConfigurableGroup> filterConfigurableGroup(boolean shouldFilter, List<? extends ConfigurableGroup> groups, Function1<? super Configurable, ? extends Configurable> leafFilter) {
        if (!shouldFilter) {
            return groups;
        }
        List filteredGroups2 = new ArrayList();
        Iterable $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configurable group;
            ConfigurableGroup it = (ConfigurableGroup)element$iv;
            boolean bl = false;
            if (!(it instanceof Configurable) || (group = this.filter((Configurable)it, leafFilter)) == null) continue;
            ConfigurableGroup wrappedGrouped2 = this.getOrCreateGroup(group);
            filteredGroups2.add(wrappedGrouped2);
        }
        return filteredGroups2;
    }

    @Nullable
    public final Configurable filter(@NotNull Configurable source, @NotNull Function1<? super Configurable, ? extends Configurable> leafFilter) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(leafFilter, (String)"leafFilter");
        if (source instanceof Configurable.Composite) {
            List filteredChildren = new ArrayList();
            Configurable[] configurableArray = ((Configurable.Composite)source).getConfigurables();
            Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
            Object[] $this$forEach$iv = configurableArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Configurable it = (Configurable)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Configurable child = this.filter(it, leafFilter);
                if (child == null) continue;
                filteredChildren.add(child);
            }
            if (CollectionsKt.any((Iterable)filteredChildren)) {
                ConfigurableGroup stub2 = new ConfigurableGroup(leafFilter, source, filteredChildren){
                    final /* synthetic */ Function1<Configurable, Configurable> $leafFilter;
                    final /* synthetic */ Configurable $source;
                    final /* synthetic */ List<Configurable> $filteredChildren;
                    {
                        this.$leafFilter = $leafFilter;
                        this.$source = $source;
                        this.$filteredChildren = $filteredChildren;
                    }

                    @Nullable
                    public JComponent createComponent() {
                        return this.$leafFilter.invoke((Object)this.$source) != null ? this.$source.createComponent() : null;
                    }

                    public boolean isModified() {
                        return false;
                    }

                    public void apply() {
                    }

                    @NotNull
                    public String getDisplayName() {
                        String string = this.$source.getDisplayName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                        return string;
                    }

                    @NotNull
                    public Configurable[] getConfigurables() {
                        Collection $this$toTypedArray$iv = this.$filteredChildren;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new Configurable[0]);
                    }
                };
                return (Configurable)stub2;
            }
        }
        return (Configurable)leafFilter.invoke((Object)source);
    }

    @NotNull
    public final ConfigurableGroup getOrCreateGroup(@NotNull Configurable source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof ConfigurableGroup) {
            return (ConfigurableGroup)source;
        }
        ConfigurableGroup wrappedGrouped2 = new ConfigurableGroup(source){
            final /* synthetic */ Configurable $source;
            {
                this.$source = $source;
            }

            @NotNull
            public String getDisplayName() {
                String string = this.$source.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                return string;
            }

            @NotNull
            public Configurable[] getConfigurables() {
                Configurable[] configurableArray = new Configurable[]{this.$source};
                return configurableArray;
            }
        };
        return wrappedGrouped2;
    }
}

