/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.rider.model.IndentSettings;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.settings.RiderPrefetchedIndentOptions;
import com.jetbrains.rider.settings.RiderSmartTabsBackendSynchronizer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/settings/RiderFileIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFileIndentOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n65#2,4:122\n65#2,4:126\n65#2,4:130\n65#2,4:134\n*S KotlinDebug\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n*L\n28#1:122,4\n44#1:126,4\n64#1:130,4\n107#1:134,4\n*E\n"})
public final class RiderFileIndentOptionsProvider
extends FileIndentOptionsProvider {
    @NotNull
    private final Logger logger;

    public RiderFileIndentOptionsProvider() {
        Logger logger = Logger.getInstance(RiderFileIndentOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        EditorSynchronizer editorSynchronizer;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ApplicationKt.getApplication().assertReadAccessAllowed();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "` start");
        }
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language);
        if (frontendTypedHandler == null) {
            return null;
        }
        FrontendTypedHandler frontendTypedHandler2 = frontendTypedHandler;
        if (!frontendTypedHandler2.isAvailable(psiFile)) {
            return null;
        }
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        if (project3.isDisposed()) {
            return null;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project3);
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Object object = settings.getIndentOptions(psiFile.getFileType()).clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document2, project3);
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Editor editor2 = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
        Object object2 = editorSynchronizer = editor2 != null ? DocumentExKt.getEditorSynchronizer(editor2) : null;
        if (editorSynchronizer != null) {
            boolean newSmartTabs;
            boolean bl;
            Integer n = EditorSynchronizerKt.getTabSize((EditorSynchronizer)editorSynchronizer);
            int newTabSize = n != null ? n : indentOptions.TAB_SIZE;
            Logger $this$trace$iv2 = this.logger;
            boolean $i$f$trace22 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl2 = false;
                logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`. Tab size is `" + newTabSize + "`.");
            }
            boolean bl3 = $this$trace$iv2 = newTabSize >= 0;
            if (_Assertions.ENABLED && !$this$trace$iv2) {
                String $i$f$trace22 = "Assertion failed";
                throw new AssertionError((Object)$i$f$trace22);
            }
            Integer n2 = EditorSynchronizerKt.getIndentSize((EditorSynchronizer)editorSynchronizer);
            int newIndentSize = n2 != null ? n2 : indentOptions.INDENT_SIZE;
            boolean bl4 = $i$f$trace22 = newIndentSize >= 0;
            if (_Assertions.ENABLED && !$i$f$trace22) {
                String bl2 = "Assertion failed";
                throw new AssertionError((Object)bl2);
            }
            Boolean bl5 = EditorSynchronizerKt.getUseTab((EditorSynchronizer)editorSynchronizer);
            boolean newUseTab = bl5 != null ? bl5 : indentOptions.USE_TAB_CHARACTER;
            Integer n3 = EditorSynchronizerKt.getContinuousIndentSize((EditorSynchronizer)editorSynchronizer);
            int newContinuationIndentSize = n3 != null ? n3 : indentOptions.CONTINUATION_INDENT_SIZE;
            boolean bl6 = bl = newContinuationIndentSize >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean shouldSynchronizeSmartTabs = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (shouldSynchronizeSmartTabs) {
                Boolean bl7 = EditorSynchronizerKt.getSmartTabs((EditorSynchronizer)editorSynchronizer);
                v16 = bl7 != null ? bl7 : indentOptions.SMART_TABS;
            } else {
                v16 = newSmartTabs = indentOptions.SMART_TABS;
            }
            if (indentOptions.TAB_SIZE != newTabSize || newIndentSize != indentOptions.INDENT_SIZE || newUseTab != indentOptions.USE_TAB_CHARACTER || newContinuationIndentSize != indentOptions.CONTINUATION_INDENT_SIZE || newSmartTabs != indentOptions.SMART_TABS || !indentOptions.isOverrideLanguageOptions()) {
                Logger $this$trace$iv3 = this.logger;
                boolean $i$f$trace3 = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    logger = $this$trace$iv3;
                    boolean bl8 = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = newTabSize;
                indentOptions.INDENT_SIZE = newIndentSize;
                indentOptions.USE_TAB_CHARACTER = newUseTab;
                indentOptions.CONTINUATION_INDENT_SIZE = newContinuationIndentSize;
                if (shouldSynchronizeSmartTabs) {
                    indentOptions.SMART_TABS = newSmartTabs;
                }
                return indentOptions;
            }
        } else {
            VirtualFile originalFile;
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            VirtualFile virtualFile3 = originalFile = virtualFile2 instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile2).getOriginalFile() : virtualFile2;
            if (originalFile == null) {
                return null;
            }
            if (!PatchEngineRegistryKt.isPatchEngineEnabled() && TextBufferDocumentSynchronizer.Companion.isBackendUpdateInProgress(document2, FrontendSessionsUtilKt.getFrontendProjectSession(project3).getAppSession())) {
                return null;
            }
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project3);
            if (workspaceModel == null) {
                return null;
            }
            WorkspaceModel workspaceModel2 = workspaceModel;
            int entityId = com.jetbrains.rider.document.DocumentExKt.findBestProjectModelIdForDocument(WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel2, originalFile, project3), project3);
            if (entityId == 0) {
                return null;
            }
            RiderPrefetchedIndentOptions prefetchedIndentOptions = RiderPrefetchedIndentOptions.Companion.getInstance(project3);
            IndentSettings result2 = prefetchedIndentOptions.getIndentSettings(entityId);
            if (result2 == null) {
                return null;
            }
            boolean shouldSynchronizeSmartTabs = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (indentOptions.TAB_SIZE != result2.getTabSize() || result2.getIndentSize() != indentOptions.INDENT_SIZE || result2.getUseTabs() != indentOptions.USE_TAB_CHARACTER || result2.getContinuationIndentSize() != indentOptions.CONTINUATION_INDENT_SIZE || result2.getSmartTabs() != indentOptions.SMART_TABS && shouldSynchronizeSmartTabs || !indentOptions.isOverrideLanguageOptions()) {
                Logger $this$trace$iv4 = this.logger;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv4.isTraceEnabled()) {
                    logger = $this$trace$iv4;
                    boolean bl = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = result2.getTabSize();
                indentOptions.INDENT_SIZE = result2.getIndentSize();
                indentOptions.USE_TAB_CHARACTER = result2.getUseTabs();
                indentOptions.CONTINUATION_INDENT_SIZE = result2.getContinuationIndentSize();
                if (shouldSynchronizeSmartTabs) {
                    indentOptions.SMART_TABS = result2.getSmartTabs();
                }
                return indentOptions;
            }
        }
        return null;
    }
}

