/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.popups.ProtoViewModel;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.ui.bindable.ViewRegistry;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.BeSimpleOptionsPageContent;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.settings.IRiderViewModelConfigurableKt;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCodeStyleContentPageConverter;
import com.jetbrains.rider.settings.RiderCodeStyleMainPanel;
import com.jetbrains.rider.settings.RiderCodeStyleSettings;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeStyle.RiderCodeStyleTabPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel;", "Lcom/intellij/application/options/TabbedLanguageCodeStylePanel;", "language", "Lcom/intellij/lang/Language;", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settings", "(Lcom/intellij/lang/Language;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "mySchemeRefresher", "Lkotlin/Function0;", "", "getMySchemeRefresher", "()Lkotlin/jvm/functions/Function0;", "setMySchemeRefresher", "(Lkotlin/jvm/functions/Function0;)V", "mySettings", "", "Lcom/jetbrains/rd/ide/model/KeyPathComponents;", "Lcom/jetbrains/rd/ide/model/PredefinedValue;", "addAutodetectButton", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "apply", "initSchemeSupport", "host", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "initTabs", "isModified", "", "resetImpl", "updateProtocolStorage", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleMainPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,287:1\n215#2,2:288\n1855#3,2:290\n1855#3,2:292\n13#4:294\n13#5:295\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n*L\n85#1:288,2\n186#1:290,2\n223#1:292,2\n68#1:294\n68#1:295\n*E\n"})
public final class RiderCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<KeyPathComponents, PredefinedValue> mySettings;
    @Nullable
    private Function0<Unit> mySchemeRefresher;
    @NotNull
    private static final Logger LOG;

    public RiderCodeStyleMainPanel(@Nullable Language language, @NotNull CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentSettings, (String)"currentSettings");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(language, currentSettings, settings);
        this.mySettings = new LinkedHashMap();
    }

    @Nullable
    public final Function0<Unit> getMySchemeRefresher() {
        return this.mySchemeRefresher;
    }

    public final void setMySchemeRefresher(@Nullable Function0<Unit> function0) {
        this.mySchemeRefresher = function0;
    }

    protected void initTabs(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null);
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        permittedModalitiesImpl.allowPumpProtocolForComponent(jComponent, (Disposable)this);
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getCurrentInstance();
        if (host != null) {
            Map<String, String> pages = settings instanceof RiderCodeStyleSettings ? ((RiderCodeStyleSettings)settings).getPages() : ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getPages();
            this.mySchemeRefresher = this.initSchemeSupport(host);
            Ref.BooleanRef autodetectButtonAdded = new Ref.BooleanRef();
            Map<String, String> $this$forEach$iv = pages;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator2.next();
                boolean bl = false;
                Language language = this.getDefaultLanguage();
                FileType fileType = UnknownFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"INSTANCE");
                RiderCodeStyleTabPanel myCodeStyleAbstractPanel = new RiderCodeStyleTabPanel(language, fileType, it.getValue(), host.getCurrentDialogLifetime(), settings);
                host.requestFullPage(it.getKey(), (Function1<? super OptionsPageInfo, Unit>)((Function1)new Function1<OptionsPageInfo, Unit>(myCodeStyleAbstractPanel, autodetectButtonAdded, this, host){
                    final /* synthetic */ RiderCodeStyleTabPanel $myCodeStyleAbstractPanel;
                    final /* synthetic */ Ref.BooleanRef $autodetectButtonAdded;
                    final /* synthetic */ RiderCodeStyleMainPanel this$0;
                    final /* synthetic */ SettingsViewModelHost $host;
                    {
                        this.$myCodeStyleAbstractPanel = $myCodeStyleAbstractPanel;
                        this.$autodetectButtonAdded = $autodetectButtonAdded;
                        this.this$0 = $receiver;
                        this.$host = $host;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionsPageInfo page) {
                        Intrinsics.checkNotNullParameter((Object)((Object)page), (String)"page");
                        OptionsPageContentBase content = page.getContent();
                        this.$myCodeStyleAbstractPanel.setSearchableKeywords(IRiderViewModelConfigurableKt.getAllKeywords(page.getSearchableKeywords()));
                        OptionsPageContentBase optionsPageContentBase = content;
                        if (optionsPageContentBase instanceof CodeStylePageContent) {
                            if (((CodeStylePageContent)content).getShowAutoDetectButton() && !this.$autodetectButtonAdded.element) {
                                this.$autodetectButtonAdded.element = true;
                                JPanel panelWithRunAutodetection = RiderCodeStyleMainPanel.access$addAutodetectButton(this.this$0, (CodeStylePageContent)content);
                                JComponent jComponent = this.this$0.getPanel();
                                Intrinsics.checkNotNull((Object)jComponent);
                                jComponent.add((Component)panelWithRunAutodetection, "North");
                            }
                            this.$myCodeStyleAbstractPanel.setContent((CodeStylePageContent)content);
                        } else if (optionsPageContentBase instanceof NamingPageContentBase) {
                            this.$myCodeStyleAbstractPanel.setContent((NamingPageContentBase)content);
                        } else if (optionsPageContentBase instanceof BeSimpleOptionsPageContent) {
                            JComponent view = ViewRegistry.Companion.getInstance().getView((ProtoViewModel)((BeSimpleOptionsPageContent)content).getAutomation(), this.$host.getCurrentDialogLifetime());
                            this.$myCodeStyleAbstractPanel.setContent(view);
                        } else {
                            JComponent component = RiderCodeStyleContentPageConverter.Companion.createComponent(content, this.$myCodeStyleAbstractPanel.getLifetime());
                            if (component != null) {
                                this.$myCodeStyleAbstractPanel.setContent(component);
                            } else {
                                RiderCodeStyleMainPanel.access$getLOG$cp().error("Unexpected page content " + content);
                            }
                        }
                    }
                }));
                this.addTab(myCodeStyleAbstractPanel);
            }
            Object[] objectArray = Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
            for (CodeStyleSettingsProvider provider2 : (CodeStyleSettingsProvider[])objectArray) {
                if (!Intrinsics.areEqual((Object)provider2.getLanguage(), (Object)this.getDefaultLanguage()) || provider2.hasSettingsPage()) continue;
                this.createTab(provider2);
            }
        } else if (ApplicationKt.getApplication().isHeadlessEnvironment()) {
            CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
            this.addTab(new CodeStyleAbstractPanel(codeStyleSettings){

                protected void resetImpl(@NotNull CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                @NotNull
                protected String getPreviewText() {
                    return "";
                }

                public boolean isModified(@Nullable CodeStyleSettings settings) {
                    return false;
                }

                @NotNull
                public JComponent getPanel() {
                    return new JPanel();
                }

                protected int getRightMargin() {
                    return 0;
                }

                public void apply(@NotNull CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                @NotNull
                protected FileType getFileType() {
                    Language language = this.getDefaultLanguage();
                    Object object = language != null ? language.getAssociatedFileType() : null;
                    Intrinsics.checkNotNull((Object)object);
                    return (FileType)object;
                }

                @NotNull
                protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
                    Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                    return (EditorHighlighter)new EmptyEditorHighlighter(TextAttributes.ERASE_MARKER);
                }
            });
        }
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            this.mySettings.clear();
            this.mySettings.putAll(((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData());
            Function0<Unit> refresher = this.mySchemeRefresher;
            if (refresher != null) {
                refresher.invoke();
            }
        }
        super.resetImpl(settings);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            Map<KeyPathComponents, PredefinedValue> data2 = ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData();
            data2.clear();
            data2.putAll(this.mySettings);
        }
        super.apply(settings);
    }

    public boolean isModified(@Nullable CodeStyleSettings settings) {
        if (settings != null && OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            Map<KeyPathComponents, PredefinedValue> data2 = ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData();
            Iterable $this$forEach$iv = this.mySettings.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KeyPathComponents it = (KeyPathComponents)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)data2.get(it), (Object)this.mySettings.get(it))) continue;
                return true;
            }
        }
        return super.isModified(settings);
    }

    private final Function0<Unit> initSchemeSupport(SettingsViewModelHost host) {
        if (!OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            return initSchemeSupport.1.INSTANCE;
        }
        SequentialLifetimes lifetimes = new SequentialLifetimes(host.getLifetimeDef().getLifetime());
        Function0 schemeRefresher2 = (Function0)new Function0<Unit>(this, lifetimes, host){
            final /* synthetic */ RiderCodeStyleMainPanel this$0;
            final /* synthetic */ SequentialLifetimes $lifetimes;
            final /* synthetic */ SettingsViewModelHost $host;
            {
                this.this$0 = $receiver;
                this.$lifetimes = $lifetimes;
                this.$host = $host;
                super(0);
            }

            public final void invoke() {
                RiderCodeStyleMainPanel.access$updateProtocolStorage(this.this$0, this.$lifetimes, this.$host);
            }
        };
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        jComponent.addHierarchyListener(arg_0 -> RiderCodeStyleMainPanel.initSchemeSupport$lambda$2(schemeRefresher2, arg_0));
        return schemeRefresher2;
    }

    private final void updateProtocolStorage(SequentialLifetimes lifetimes, SettingsViewModelHost host) {
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        if (jComponent.isShowing()) {
            IMutableViewableMap<KeyPathComponents, PredefinedValue> storage;
            OptionsDialog currentDialog;
            LifetimeDefinition lifetime2 = lifetimes.next();
            OptionsDialog optionsDialog = currentDialog = (OptionsDialog)((Object)host.getCurrentDialog().getValueOrNull());
            Object object = storage = optionsDialog != null ? optionsDialog.getTransactionStorage() : null;
            if (storage != null) {
                Map<KeyPathComponents, PredefinedValue> customSettings = this.mySettings;
                LifetimeDefinition handshake = lifetime2.createNested();
                SourceExKt.adviseOnce((ISource)((ISource)currentDialog.getTransactionStorageChanged()), (Lifetime)((Lifetime)handshake), (Function1)((Function1)new Function1<Unit, Unit>(handshake){
                    final /* synthetic */ LifetimeDefinition $handshake;
                    {
                        this.$handshake = $handshake;
                        super(1);
                    }

                    public final void invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LifetimeDefinition.terminate$default((LifetimeDefinition)this.$handshake, (boolean)false, (int)1, null);
                    }
                }));
                boolean needSynchronization = false;
                Iterable $this$forEach$iv = CollectionsKt.union((Iterable)storage.keySet(), (Iterable)customSettings.keySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KeyPathComponents key = (KeyPathComponents)element$iv;
                    boolean bl = false;
                    PredefinedValue dest = customSettings.getOrDefault(key, null);
                    if (Intrinsics.areEqual((Object)storage.get((Object)key), (Object)dest)) continue;
                    if (dest == null) {
                        storage.remove((Object)key);
                    } else {
                        ((Map)storage).put(key, dest);
                    }
                    needSynchronization = true;
                }
                if (!needSynchronization) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)handshake, (boolean)false, (int)1, null);
                } else {
                    IProtocol protocol = ApplicationProtocolKt.getProtocolOrFirstExistentForDefault(host.getProject());
                    IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)IRdDispatcherKt.getAsRdDispatcher((IScheduler)protocol.getScheduler()), (Lifetime)handshake.getLifetime());
                }
                storage.getChange().advise((Lifetime)lifetime2, (Function1)new Function1<IViewableMap.Event<KeyPathComponents, ? extends PredefinedValue>, Unit>(customSettings, this){
                    final /* synthetic */ Map<KeyPathComponents, PredefinedValue> $customSettings;
                    final /* synthetic */ RiderCodeStyleMainPanel this$0;
                    {
                        this.$customSettings = $customSettings;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull IViewableMap.Event<KeyPathComponents, ? extends PredefinedValue> event) {
                        Intrinsics.checkNotNullParameter(event, (String)"event");
                        IViewableMap.Event<KeyPathComponents, ? extends PredefinedValue> event2 = event;
                        if (event2 instanceof IViewableMap.Event.Add) {
                            this.$customSettings.put((KeyPathComponents)event.getKey(), (PredefinedValue)((IViewableMap.Event.Add)event).getNewValue());
                        } else if (event2 instanceof IViewableMap.Event.Update) {
                            this.$customSettings.put((KeyPathComponents)event.getKey(), (PredefinedValue)((IViewableMap.Event.Update)event).getNewValue());
                        } else if (event2 instanceof IViewableMap.Event.Remove) {
                            this.$customSettings.remove(event.getKey());
                        }
                        RiderCodeStyleMainPanel.access$applySettingsToModel(this.this$0);
                    }
                });
            }
        } else {
            lifetimes.next();
        }
    }

    private final JPanel addAutodetectButton(CodeStylePageContent content) {
        JLabel descriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.label.based.on.the.existing.code.of.the.entire.solution", new Object[0]));
        descriptionLabel.setOpaque(true);
        descriptionLabel.setForeground(UIUtil.getMenuItemDisabledForeground());
        JButton runDetectionButton = new JButton(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.button.auto.detect.formatting.rules", new Object[0]));
        JPanel panelWithRunAutodetection = new JPanel();
        panelWithRunAutodetection.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)0));
        panelWithRunAutodetection.setLayout((LayoutManager)new MigLayout("insets 3 5 10 5"));
        panelWithRunAutodetection.setOpaque(true);
        panelWithRunAutodetection.add(runDetectionButton);
        panelWithRunAutodetection.add(descriptionLabel);
        panelWithRunAutodetection.setVisible(true);
        runDetectionButton.addActionListener(arg_0 -> RiderCodeStyleMainPanel.addAutodetectButton$lambda$4(descriptionLabel, content, arg_0));
        return panelWithRunAutodetection;
    }

    private static final void initSchemeSupport$lambda$2(Function0 $schemeRefresher, HierarchyEvent it) {
        Intrinsics.checkNotNullParameter((Object)$schemeRefresher, (String)"$schemeRefresher");
        if ((it.getChangeFlags() & 4L) != 0L) {
            $schemeRefresher.invoke();
        }
    }

    private static final void addAutodetectButton$lambda$4(JLabel $descriptionLabel, CodeStylePageContent $content, ActionEvent it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$descriptionLabel, (String)"$descriptionLabel");
            Intrinsics.checkNotNullParameter((Object)((Object)$content), (String)"$content");
            if (!((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.title.run.detection.in.background", new Object[0]), RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.message.run.detection", new Object[0])).icon(Messages.getQuestionIcon())).ask((Component)$descriptionLabel)) break block1;
            InterfacesKt.fire($content.getRunAutodetection());
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost != null) {
                settingsViewModelHost.cancel();
            }
        }
    }

    public static final /* synthetic */ void access$updateProtocolStorage(RiderCodeStyleMainPanel $this, SequentialLifetimes lifetimes, SettingsViewModelHost host) {
        $this.updateProtocolStorage(lifetimes, host);
    }

    public static final /* synthetic */ void access$applySettingsToModel(RiderCodeStyleMainPanel $this) {
        $this.applySettingsToModel();
    }

    public static final /* synthetic */ JPanel access$addAutodetectButton(RiderCodeStyleMainPanel $this, CodeStylePageContent content) {
        return $this.addAutodetectButton(content);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderCodeStyleMainPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

