/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCodeStyleOptionPageProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B6\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleConfigurableWrapper;", "Lcom/intellij/application/options/CodeStyleConfigurableWrapper;", "Lcom/jetbrains/rider/settings/IRiderViewModelConfigurable;", "provider", "Lcom/jetbrains/rider/settings/RiderCodeStyleOptionPageProvider;", "owner", "Lcom/intellij/application/options/CodeStyleSchemesConfigurable;", "codeStyleSchemesModel", "Lcom/intellij/application/options/codeStyle/CodeStyleSchemesModel;", "pages", "", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "(Lcom/jetbrains/rider/settings/RiderCodeStyleOptionPageProvider;Lcom/intellij/application/options/CodeStyleSchemesConfigurable;Lcom/intellij/application/options/codeStyle/CodeStyleSchemesModel;Ljava/util/Map;)V", "filterTags", "", "getFilterTags", "()Ljava/lang/Iterable;", "reSharperPagesId", "getReSharperPagesId", "reSharperPagesMap", "getReSharperPagesMap", "()Ljava/util/Map;", "canBeShared", "", "filter", "Lcom/intellij/openapi/options/Configurable;", "filterTag", "intellij.rider.rdclient.dotnet"})
public class RiderCodeStyleConfigurableWrapper
extends CodeStyleConfigurableWrapper
implements IRiderViewModelConfigurable {
    @NotNull
    private final RiderCodeStyleOptionPageProvider provider;
    @NotNull
    private final CodeStyleSchemesConfigurable owner;
    @NotNull
    private final CodeStyleSchemesModel codeStyleSchemesModel;
    @NotNull
    private final Map<String, String> pages;

    public RiderCodeStyleConfigurableWrapper(final @NotNull RiderCodeStyleOptionPageProvider provider2, @NotNull CodeStyleSchemesConfigurable owner, final @NotNull CodeStyleSchemesModel codeStyleSchemesModel, final @NotNull Map<String, String> pages) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)codeStyleSchemesModel, (String)"codeStyleSchemesModel");
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        super((CodeStyleSettingsProvider)provider2, new CodeStyleSettingsPanelFactory(){

            @NotNull
            public NewCodeStyleSettingsPanel createPanel(@NotNull CodeStyleScheme scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                CodeStyleSettings codeStyleSettings = scheme.getCodeStyleSettings();
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
                CodeStyleSettings codeStyleSettings2 = codeStyleSchemesModel.getCloneSettings(scheme);
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings2, (String)"getCloneSettings(...)");
                Language language = ((CodeStyleSettingsProvider)provider2).getLanguage();
                String string = ((CodeStyleSettingsProvider)provider2).getConfigurableDisplayName();
                Intrinsics.checkNotNull((Object)string);
                return new NewCodeStyleSettingsPanel((Configurable)provider2.createRiderConfigurable(codeStyleSettings, codeStyleSettings2, language, string, pages), codeStyleSchemesModel);
            }
        }, owner);
        this.provider = provider2;
        this.owner = owner;
        this.codeStyleSchemesModel = codeStyleSchemesModel;
        this.pages = pages;
    }

    @Override
    @NotNull
    public Iterable<String> getReSharperPagesId() {
        return this.pages.keySet();
    }

    @NotNull
    public final Map<String, String> getReSharperPagesMap() {
        return this.pages;
    }

    @Override
    @NotNull
    public Iterable<String> getFilterTags() {
        return this.provider.getFilterTags();
    }

    @Override
    @NotNull
    public Configurable filter(@NotNull String filterTag) {
        Intrinsics.checkNotNullParameter((Object)filterTag, (String)"filterTag");
        return (Configurable)new RiderCodeStyleConfigurableWrapper(this.provider, this.owner, this.codeStyleSchemesModel, this.provider.filterPages(filterTag));
    }

    protected boolean canBeShared() {
        return OptionsUtilsHost.Companion.getAllowSchemeSupport();
    }
}

