/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.EditorAnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import com.jetbrains.rider.ui.SwingScheduler;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.time.Duration;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect;", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentOffset", "", "delegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;ILkotlin/jvm/functions/Function1;)V", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "rectangle", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getRectangle", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "calculateRectangle", "Companion", "intellij.rider.rdclient.dotnet"})
public final class EditorAnchoringRect
implements AnchoringRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    private final int documentOffset;
    @NotNull
    private final Function1<Rectangle, Rectangle> delegate;
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final IProperty<Rectangle> rectangle;

    public EditorAnchoringRect(@NotNull Lifetime lifetime2, @NotNull Editor editor2, int documentOffset, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate) {
        EditorImpl outerLifetime;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.editor = editor2;
        this.documentOffset = documentOffset;
        this.delegate = delegate;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(this.documentOffset, this.documentOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        this.rangeMarker = rangeMarker;
        this.rectangle = (IProperty)new Property((Object)this.calculateRectangle());
        ScrollingModel scrollingModel = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        ISource<VisibleAreaEvent> visibleAreaChanged2 = RdSwingKt.visibleAreaChanged(scrollingModel);
        Editor editor3 = this.editor;
        Object object = editor3 instanceof EditorImpl ? (EditorImpl)editor3 : null;
        if (object == null || (object = object.getDisposable()) == null || (object = LifetimeDisposableExKt.createLifetime((Disposable)object)) == null) {
            Project project2 = this.editor.getProject();
            object = project2 != null ? ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project2)) : null;
        }
        Lifetime lt = (outerLifetime = object) != null ? RLifetimeKt.intersect((Lifetime)lifetime2, (Lifetime)outerLifetime) : lifetime2;
        Duration duration = Duration.ofMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        AdditionalApiKt.throttleLast(visibleAreaChanged2, (Duration)duration, (IScheduler)SwingScheduler.INSTANCE).advise(lt, (Function1)new Function1<VisibleAreaEvent, Unit>(){

            public final void invoke(@NotNull VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getRectangle().set((Object)this.calculateRectangle());
            }
        });
    }

    public /* synthetic */ EditorAnchoringRect(Lifetime lifetime2, Editor editor2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(lifetime2, editor2, n, (Function1<? super Rectangle, ? extends Rectangle>)function1);
    }

    @NotNull
    public IProperty<Rectangle> getRectangle() {
        return this.rectangle;
    }

    private final Rectangle calculateRectangle() {
        Rectangle rectangle;
        Point point;
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!(!this.editor.isDisposed())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.rangeMarker.isValid()) {
            return null;
        }
        TextRange range2 = new TextRange(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset());
        if (range2.isEmpty()) {
            Point point2 = this.editor.offsetToXY(range2.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
            point = point2;
            rectangle = new Rectangle(point, new Dimension(JBUI.scale((int)1), this.editor.getLineHeight() + JBUI.scale((int)1)));
        } else {
            Point point3 = this.editor.offsetToXY(range2.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"offsetToXY(...)");
            Point start2 = point3;
            Point point4 = this.editor.offsetToXY(range2.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point4, (String)"offsetToXY(...)");
            Point end = point4;
            rectangle = RectangleUtilsKt.rectangleFromLTRBNonNegative(start2.x, start2.y - this.editor.getLineHeight(), end.x, end.y);
        }
        Rectangle rect = rectangle;
        Rectangle rectangle2 = RectangleUtilsKt.map(rect, (Function1<? super Rectangle, ? extends Rectangle>)((Function1)new Function1<Rectangle, Rectangle>(this){
            final /* synthetic */ EditorAnchoringRect this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Rectangle invoke(@NotNull Rectangle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RectangleUtilsKt.map(it, (Function1<? super Rectangle, ? extends Rectangle>)EditorAnchoringRect.access$getDelegate$p(this.this$0));
            }
        }));
        if (rectangle2 == null) {
            return null;
        }
        rect = rectangle2;
        point = rect.getLocation();
        SwingUtilities.convertPointToScreen(point, this.editor.getContentComponent());
        return new Rectangle(point, new Dimension(rect.width, rect.height));
    }

    public static final /* synthetic */ Function1 access$getDelegate$p(EditorAnchoringRect $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect$Companion;", "", "()V", "create", "Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "offset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "delegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "createHorizontalSmartClipRect", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "createSmartClipRect", "horizontalSmartClipDelegate", "smartClipDelegate", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Rectangle, Rectangle> horizontalSmartClipDelegate(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (Function1)new Function1<Rectangle, Rectangle>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @Nullable
                public final Rectangle invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Rectangle rectangle = this.$editor.getScrollingModel().getVisibleArea();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
                    Rectangle visibleArea = rectangle;
                    return visibleArea.y >= it.y + this.$editor.getLineHeight() || visibleArea.y + visibleArea.height <= it.y - this.$editor.getLineHeight() / 2 ? null : RectangleUtilsKt.horizontalSmartClip(it, visibleArea);
                }
            };
        }

        @NotNull
        public final Function1<Rectangle, Rectangle> smartClipDelegate(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (Function1)new Function1<Rectangle, Rectangle>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Rectangle invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Rectangle rectangle = this.$editor.getScrollingModel().getVisibleArea();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
                    Rectangle visibleArea = rectangle;
                    return RectangleUtilsKt.smartClip(it, visibleArea);
                }
            };
        }

        @NotNull
        public final EditorAnchoringRect create(@NotNull Lifetime lifetime2, int offset, @NotNull Editor editor2, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            return new EditorAnchoringRect(lifetime2, editor2, offset, delegate);
        }

        public static /* synthetic */ EditorAnchoringRect create$default(Companion companion, Lifetime lifetime2, int n, Editor editor2, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                function1 = create.1.INSTANCE;
            }
            return companion.create(lifetime2, n, editor2, (Function1<? super Rectangle, ? extends Rectangle>)function1);
        }

        @NotNull
        public final AnchoringRect createSmartClipRect(@NotNull Lifetime lifetime2, int offset, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.create(lifetime2, offset, editor2, this.smartClipDelegate(editor2));
        }

        @NotNull
        public final AnchoringRect createHorizontalSmartClipRect(@NotNull Lifetime lifetime2, int offset, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.create(lifetime2, offset, editor2, this.horizontalSmartClipDelegate(editor2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

