/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.projectView.ProjectModelViewUpdaterAsync;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "index", "", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "", "manager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "addToIndex", "", "url", "shouldUpdate", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDirectoryUrl", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "inIndex", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeFromIndex", "updateIndex", "action", "Lkotlin/Function0;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class WorkspaceModelDirectoryIndex
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFileUrl, Integer> index;
    @NotNull
    private final VirtualFileUrlManager manager;
    @NotNull
    private final ExecutorService executor;

    public WorkspaceModelDirectoryIndex(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.index = new LinkedHashMap();
        this.manager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"WorkspaceModelDirectoryIndex", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        final List entities2 = new ArrayList();
        CollectionsKt.addAll((Collection)entities2, (Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ProjectModelEntity.class));
        CollectionsKt.addAll((Collection)entities2, (Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ContentRootEntity.class));
        this.updateIndex((Function0<Boolean>)((Function0)new Function0<Boolean>(){

            @NotNull
            public final Boolean invoke() {
                for (WorkspaceEntity entity2 : entities2) {
                    this.addToIndex(this.getDirectoryUrl(entity2), new AtomicBoolean());
                }
                return false;
            }
        }));
        WorkspaceModelChangeListener listener2 = new WorkspaceModelChangeListener(this){
            final /* synthetic */ WorkspaceModelDirectoryIndex this$0;
            {
                this.this$0 = $receiver;
            }

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Sequence changes2 = ((VersionedStorageChangeInternal)event).getAllChanges();
                if (SequencesKt.none((Sequence)changes2)) {
                    return;
                }
                WorkspaceModelDirectoryIndex.access$updateIndex(this.this$0, (Function0)new Function0<Boolean>(changes2, this.this$0){
                    final /* synthetic */ Sequence<EntityChange<?>> $changes;
                    final /* synthetic */ WorkspaceModelDirectoryIndex this$0;
                    {
                        this.$changes = $changes;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        AtomicBoolean shouldUpdate = new AtomicBoolean(false);
                        for (EntityChange change : this.$changes) {
                            VirtualFileUrl newUrl;
                            VirtualFileUrl oldUrl;
                            if (change instanceof EntityChange.Added) {
                                WorkspaceModelDirectoryIndex.access$addToIndex(this.this$0, WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Added)change).getNewEntity()), shouldUpdate);
                            }
                            if (change instanceof EntityChange.Removed) {
                                WorkspaceModelDirectoryIndex.access$removeFromIndex(this.this$0, WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Removed)change).getOldEntity()), shouldUpdate);
                            }
                            if (!(change instanceof EntityChange.Replaced) || Intrinsics.areEqual((Object)(oldUrl = WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Replaced)change).getOldEntity())), (Object)(newUrl = WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Replaced)change).getNewEntity())))) continue;
                            WorkspaceModelDirectoryIndex.access$removeFromIndex(this.this$0, oldUrl, shouldUpdate);
                            WorkspaceModelDirectoryIndex.access$addToIndex(this.this$0, newUrl, shouldUpdate);
                        }
                        return shouldUpdate.get();
                    }
                });
            }
        };
        this.project.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)listener2);
    }

    private final VirtualFileUrl getDirectoryUrl(WorkspaceEntity entity2) {
        WorkspaceEntity workspaceEntity = entity2;
        VirtualFileUrl virtualFileUrl = workspaceEntity instanceof ProjectModelEntity ? ProjectModelEntityExtensionsKt.getContentRootUrl((ProjectModelEntity)entity2, this.manager) : (workspaceEntity instanceof ContentRootEntity ? ((ContentRootEntity)entity2).getUrl() : null);
        if (virtualFileUrl == null) {
            return null;
        }
        VirtualFileUrl url2 = virtualFileUrl;
        return url2.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean inIndex(@NotNull VirtualFile virtualFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Map<VirtualFileUrl, Integer> map = this.index;
        synchronized (map) {
            boolean bl2 = false;
            Integer count = this.index.get(VirtualFileUrls.toVirtualFileUrl((VirtualFile)virtualFile2, (VirtualFileUrlManager)this.manager));
            bl = count != null && count > 0;
        }
        return bl;
    }

    private final void updateIndex(Function0<Boolean> action2) {
        this.executor.submit(() -> WorkspaceModelDirectoryIndex.updateIndex$lambda$2(this, action2));
    }

    private final void addToIndex(VirtualFileUrl url2, AtomicBoolean shouldUpdate) {
        int count;
        if (url2 == null) {
            return;
        }
        Integer n = this.index.get(url2);
        int n2 = count = n != null ? n : 0;
        if (count == 0) {
            this.index.put(url2, 1);
            shouldUpdate.set(true);
        } else {
            this.index.put(url2, count + 1);
        }
        this.addToIndex(url2.getParent(), shouldUpdate);
    }

    private final void removeFromIndex(VirtualFileUrl url2, AtomicBoolean shouldUpdate) {
        if (url2 == null) {
            return;
        }
        Integer n = this.index.get(url2);
        int count = n != null ? n : 0;
        switch (count) {
            case 0: {
                break;
            }
            case 1: {
                this.index.remove(url2);
                shouldUpdate.set(true);
                break;
            }
            default: {
                this.index.put(url2, count - 1);
            }
        }
        this.removeFromIndex(url2.getParent(), shouldUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateIndex$lambda$2(WorkspaceModelDirectoryIndex this$0, Function0 $action) {
        boolean skipRefresh;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Map<VirtualFileUrl, Integer> map = this$0.index;
        synchronized (map) {
            boolean bl2 = false;
            bl = (Boolean)$action.invoke();
        }
        boolean shouldUpdate = bl;
        boolean bl3 = skipRefresh = !shouldUpdate || (Boolean)((WorkspaceModelUpdater)((Object)this$0.project.getService(WorkspaceModelUpdater.class))).isLiveMode().getValue() == false;
        if (skipRefresh) {
            return;
        }
        ProjectModelViewUpdaterAsync.Companion.getInstance(this$0.project).requestUpdatePresentation();
    }

    public static final /* synthetic */ void access$updateIndex(WorkspaceModelDirectoryIndex $this, Function0 action2) {
        $this.updateIndex((Function0<Boolean>)action2);
    }

    public static final /* synthetic */ void access$removeFromIndex(WorkspaceModelDirectoryIndex $this, VirtualFileUrl url2, AtomicBoolean shouldUpdate) {
        $this.removeFromIndex(url2, shouldUpdate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nWorkspaceModelDirectoryIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelDirectoryIndex.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,130:1\n17#2,2:131\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelDirectoryIndex.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion\n*L\n26#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceModelDirectoryIndex getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project2;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(WorkspaceModelDirectoryIndex.class);
            if (object == null) {
                throw new IllegalStateException("Service " + WorkspaceModelDirectoryIndex.class + " not found in container " + $this$getService$iv);
            }
            return (WorkspaceModelDirectoryIndex)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

