/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.solutionStructure.definitions;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.util.text.CharSequenceReader;
import com.jetbrains.rider.projectView.solutionStructure.definitions.DefinitionItem;
import com.jetbrains.rider.projectView.solutionStructure.definitions.GlobalDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.LineDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.PropertyDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.RegularProjectDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinitionType;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SolutionFolderDefinition;
import com.jetbrains.rider.utils.UUIDUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J2\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/solutionStructure/definitions/SolutionDefinitionReader;", "", "location", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "globalMatcher", "Lkotlin/text/Regex;", "headerMatcher", "items", "", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/DefinitionItem;", "getItems", "()Ljava/util/List;", "lineForRollback", "", "projectMatcher", "propertyMatcher", "sectionMatcher", "fetchNextLine", "reader", "Ljava/io/BufferedReader;", "parseSection", "", "name", "parseSectionOwner", "owner", "nextOwner", "read", "rollbackFetch", "line", "skipHeaderLine", "intellij.rider.rdclient.dotnet"})
public final class SolutionDefinitionReader {
    @NotNull
    private final Path location;
    @NotNull
    private final Regex headerMatcher;
    @NotNull
    private final Regex projectMatcher;
    @NotNull
    private final Regex globalMatcher;
    @NotNull
    private final Regex sectionMatcher;
    @NotNull
    private final Regex propertyMatcher;
    @Nullable
    private String lineForRollback;
    @NotNull
    private final List<DefinitionItem> items;

    public SolutionDefinitionReader(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
        this.headerMatcher = new Regex("Microsoft Visual Studio Solution File, Format Version (?<formatVersion>\\d+\\.\\d+)");
        this.projectMatcher = new Regex("Project\\(\"(?<package>\\{.*?\\})\".*?\"(?<name>.*?)\".*?\"(?<project>.*?)\".*?\"(?<guid>.*?)\"");
        this.globalMatcher = new Regex("Global");
        this.sectionMatcher = new Regex("(?<type>Project|Global)Section\\((?<name>[^)]*)\\)\\s*=\\s*(?<value>.*)");
        this.propertyMatcher = new Regex("^(?<name>[^=]+?)\\s*=\\s*(?<value>.*)$");
        this.items = new ArrayList();
    }

    @NotNull
    public final List<DefinitionItem> getItems() {
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void read() {
        this.items.clear();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.location, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(this.location, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return;
        }
        byte[] bytes = Files.readAllBytes(this.location);
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextByBinaryPresentation(...)");
        CharSequence text = charSequence;
        Closeable closeable = new BufferedReader((Reader)new CharSequenceReader(text));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            this.skipHeaderLine(reader, this.items);
            while (true) {
                String string;
                if (this.fetchNextLine(reader, this.items) == null) {
                    return;
                }
                String line = string;
                MatchResult projectMatch = this.projectMatcher.matchEntire((CharSequence)line);
                if (projectMatch != null) {
                    List projectItems = new ArrayList();
                    this.parseSectionOwner(reader, projectItems, "Project", "Global");
                    MatchResult.Destructured destructured = projectMatch.getDestructured();
                    String projectTypeGuidValue = (String)destructured.getMatch().getGroupValues().get(1);
                    String projectName = (String)destructured.getMatch().getGroupValues().get(2);
                    String projectPath = (String)destructured.getMatch().getGroupValues().get(3);
                    String projectGuidValue = (String)destructured.getMatch().getGroupValues().get(4);
                    UUID projectGuid = UUIDUtils.INSTANCE.parseCurlyBracketsValue(projectGuidValue);
                    UUID projectTypeGuid = UUIDUtils.INSTANCE.parseCurlyBracketsValue(projectTypeGuidValue);
                    if (Intrinsics.areEqual((Object)projectTypeGuid, (Object)SolutionFolderDefinition.Companion.getTypeGuid())) {
                        this.items.add(new SolutionFolderDefinition(projectName, projectPath, projectGuid, projectItems));
                        continue;
                    }
                    this.items.add(new RegularProjectDefinition(projectName, projectPath, projectGuid, projectTypeGuid, projectItems));
                    continue;
                }
                MatchResult globalMatch = this.globalMatcher.matchEntire((CharSequence)line);
                if (globalMatch != null) {
                    List globalItems = new ArrayList();
                    SolutionDefinitionReader.parseSectionOwner$default(this, reader, globalItems, "Global", null, 8, null);
                    this.items.add(new GlobalDefinition(globalItems));
                    continue;
                }
                MatchResult propertyMatch = this.propertyMatcher.matchEntire((CharSequence)line);
                if (propertyMatch != null) {
                    this.items.add(new LineDefinition(line));
                }
                this.items.add(new LineDefinition(line));
                continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void parseSectionOwner(BufferedReader reader, List<DefinitionItem> items2, String owner, String nextOwner) {
        while (this.fetchNextLine(reader, items2) != null) {
            String line;
            String ownerEnd = "End" + owner;
            if (StringsKt.equals((String)line, (String)ownerEnd, (boolean)true)) {
                return;
            }
            MatchResult match = this.sectionMatcher.matchEntire((CharSequence)line);
            if (match != null) {
                List sectionItems = new ArrayList();
                MatchResult.Destructured destructured = match.getDestructured();
                String type = (String)destructured.getMatch().getGroupValues().get(1);
                String name = (String)destructured.getMatch().getGroupValues().get(2);
                String value2 = (String)destructured.getMatch().getGroupValues().get(3);
                this.parseSection(reader, sectionItems, type);
                SectionDefinitionType sectionType = SectionDefinitionType.valueOf(type);
                items2.add(new SectionDefinition(name, value2, sectionType, sectionItems));
                continue;
            }
            if (StringsKt.startsWith((String)line, (String)ownerEnd, (boolean)true)) {
                this.rollbackFetch(StringsKt.removePrefix((String)line, (CharSequence)ownerEnd));
                return;
            }
            if (StringsKt.startsWith((String)line, (String)owner, (boolean)true) || nextOwner != null && StringsKt.startsWith((String)line, (String)nextOwner, (boolean)true)) {
                this.rollbackFetch(line);
                return;
            }
            items2.add(new LineDefinition(line));
        }
        return;
    }

    static /* synthetic */ void parseSectionOwner$default(SolutionDefinitionReader solutionDefinitionReader, BufferedReader bufferedReader, List list, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        solutionDefinitionReader.parseSectionOwner(bufferedReader, list, string, string2);
    }

    private final void parseSection(BufferedReader reader, List<DefinitionItem> items2, String name) {
        String sectionName = name + "Section";
        String sectionEndName = "End" + sectionName;
        String ownerEndName = "End" + name;
        while (this.fetchNextLine(reader, items2) != null) {
            String line;
            if (StringsKt.equals((String)line, (String)sectionEndName, (boolean)true)) {
                return;
            }
            MatchResult propertyMatch = this.propertyMatcher.matchEntire((CharSequence)line);
            if (propertyMatch != null) {
                MatchResult.Destructured destructured = propertyMatch.getDestructured();
                String propertyName = (String)destructured.getMatch().getGroupValues().get(1);
                String propertyValue = (String)destructured.getMatch().getGroupValues().get(2);
                items2.add(new PropertyDefinition(propertyName, propertyValue));
                continue;
            }
            if (StringsKt.startsWith((String)line, (String)sectionEndName, (boolean)true)) {
                this.rollbackFetch(StringsKt.removePrefix((String)line, (CharSequence)sectionEndName));
                return;
            }
            if (StringsKt.startsWith((String)line, (String)sectionName, (boolean)true) || StringsKt.startsWith((String)line, (String)ownerEndName, (boolean)true)) {
                this.rollbackFetch(line);
                return;
            }
            items2.add(new LineDefinition(line));
        }
        return;
    }

    private final void skipHeaderLine(BufferedReader reader, List<DefinitionItem> items2) {
        String string = this.fetchNextLine(reader, items2);
        if (string == null) {
            return;
        }
        String line = string;
        MatchResult match = this.headerMatcher.matchEntire((CharSequence)line);
        if (match != null) {
            items2.add(new LineDefinition(line));
            return;
        }
        this.rollbackFetch(line);
    }

    private final String fetchNextLine(BufferedReader reader, List<DefinitionItem> items2) {
        String lineTrimmed;
        String rollback = this.lineForRollback;
        if (rollback != null) {
            this.lineForRollback = null;
            return rollback;
        }
        while (true) {
            String string;
            if ((string = reader.readLine()) == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                return null;
            }
            lineTrimmed = string;
            if (!(((CharSequence)lineTrimmed).length() == 0) && !StringsKt.startsWith$default((String)lineTrimmed, (String)"#", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)lineTrimmed, (String)">>>>>>>", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)lineTrimmed, (String)"<<<<<<<", (boolean)false, (int)2, null)) break;
            items2.add(new LineDefinition(lineTrimmed));
        }
        return lineTrimmed;
    }

    private final void rollbackFetch(String line) {
        this.lineForRollback = line;
    }
}

