/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.rider.model.RdAddItemData;
import com.jetbrains.rider.model.RdAddItemsCommand;
import com.jetbrains.rider.model.RdExcludeItemsCommand;
import com.jetbrains.rider.model.RdProjectModelCommand;
import com.jetbrains.rider.model.RdRenameItemData;
import com.jetbrains.rider.model.RdRenameItemsCommand;
import com.jetbrains.rider.projectView.ProjectModelEventsService;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/projectView/VfsToProjectModelEvents;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectModelEventsService", "Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "getProjectModelEventsService", "()Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "getWorkspaceModel", "()Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "onFileAdd", "Lcom/jetbrains/rider/model/RdProjectModelCommand;", "path", "", "onFileRemove", "onFileRename", "newName", "translateEvent", "", "event", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsToProjectModelEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsToProjectModelEvents.kt\ncom/jetbrains/rider/projectView/VfsToProjectModelEvents\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n1#2:135\n1#2:171\n1#2:187\n661#3,11:136\n661#3,11:147\n766#3:158\n857#3,2:159\n1603#3,9:161\n1855#3:170\n1856#3:172\n1612#3:173\n766#3:174\n857#3,2:175\n1603#3,9:177\n1855#3:186\n1856#3:188\n1612#3:189\n59#4:190\n13#5:191\n13#6:192\n*S KotlinDebug\n*F\n+ 1 VfsToProjectModelEvents.kt\ncom/jetbrains/rider/projectView/VfsToProjectModelEvents\n*L\n101#1:171\n111#1:187\n89#1:136,11\n90#1:147,11\n100#1:158\n100#1:159,2\n101#1:161,9\n101#1:170\n101#1:172\n101#1:173\n110#1:174\n110#1:175,2\n111#1:177,9\n111#1:186\n111#1:188\n111#1:189\n126#1:190\n34#1:191\n34#1:192\n*E\n"})
public final class VfsToProjectModelEvents
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public VfsToProjectModelEvents(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    private final WorkspaceModel getWorkspaceModel() {
        return WorkspaceModel.Companion.getInstance(this.project);
    }

    private final ProjectModelEventsService getProjectModelEventsService() {
        return ProjectModelEventsService.Companion.getInstance(this.project);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            List commands;
            block13: {
                if (!this.translateEvent(vFileEvent)) continue;
                commands = new ArrayList();
                try {
                    RdProjectModelCommand it;
                    VFileEvent vFileEvent2 = vFileEvent;
                    if (vFileEvent2 instanceof VFileCreateEvent) {
                        String string = ((VFileCreateEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (this.onFileAdd(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileDeleteEvent) {
                        String string = ((VFileDeleteEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (this.onFileRemove(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileCopyEvent) {
                        String newPath = ((VFileCopyEvent)vFileEvent).getNewParent().getPath() + File.pathSeparator + ((VFileCopyEvent)vFileEvent).getNewChildName();
                        if (this.onFileAdd(newPath) != null) {
                            RdProjectModelCommand it2;
                            boolean bl = false;
                            commands.add(it2);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileMoveEvent) {
                        String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                        if (this.onFileRemove(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        String string2 = ((VFileMoveEvent)vFileEvent).getNewPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNewPath(...)");
                        if (this.onFileAdd(string2) == null) break block13;
                        boolean bl = false;
                        commands.add(it);
                        break block13;
                    }
                    if (!(vFileEvent2 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename()) break block13;
                    String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                    Object object = ((VFilePropertyChangeEvent)vFileEvent).getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    if (this.onFileRename(string, (String)object) == null) break block13;
                    boolean bl = false;
                    commands.add(it);
                }
                catch (Throwable t) {
                    logger.error(t);
                    continue;
                }
            }
            this.getProjectModelEventsService().addCommands(commands);
            logger.info("Translate " + vFileEvent + " to backend...");
            try {
                this.getProjectModelEventsService().flush();
            }
            catch (RdFault ex) {
                logger.warn((Throwable)ex);
            }
        }
    }

    private final RdProjectModelCommand onFileAdd(String path) {
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (file2.isDirectory() || file2.getFileType() instanceof UnknownFileType) {
            return null;
        }
        List<ProjectModelEntity> entities2 = WorkspaceModelExtensionsKt.getProjectModelEntities(this.getWorkspaceModel(), file2, this.project);
        if (CollectionsKt.any((Iterable)entities2)) {
            return null;
        }
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        VirtualFile virtualFile3 = file2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
        List<ProjectModelEntity> parentEntities = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile3, this.project);
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull(parentEntities);
        if (projectModelEntity == null) {
            Object v4;
            block11: {
                Iterable $this$singleOrNull$iv = parentEntities;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)element$iv;
                    boolean bl = false;
                    if (!ProjectModelEntityExtensionsKt.isFromSharedProject(it)) continue;
                    if (found$iv) {
                        v4 = null;
                        break block11;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            if ((projectModelEntity = (ProjectModelEntity)v4) == null) {
                Object v5;
                block12: {
                    Iterable $this$singleOrNull$iv = parentEntities;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ProjectModelEntity it = (ProjectModelEntity)element$iv;
                        boolean bl = false;
                        if (!ProjectModelEntityExtensionsKt.isProject(it)) continue;
                        if (found$iv) {
                            v5 = null;
                            break block12;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v5 = !found$iv ? null : single$iv;
                }
                if ((projectModelEntity = (ProjectModelEntity)v5) == null) {
                    return null;
                }
            }
        }
        ProjectModelEntity parentEntity = projectModelEntity;
        Integer n = ProjectModelEntityExtensionsKt.getId(parentEntity, this.project);
        if (n == null) {
            return null;
        }
        int parentEntityId = n;
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new RdAddItemsCommand(CollectionsKt.listOf((Object)new RdAddItemData(string, parentEntityId, null, true)));
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectModelCommand onFileRemove(String path) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Iterable $this$filter$iv = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, path2, this.project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl = false;
            if (!ProjectModelEntityExtensionsKt.isProjectFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId(it, this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entityIds = (List)destination$iv$iv;
        if (entityIds.isEmpty()) {
            return null;
        }
        return new RdExcludeItemsCommand(entityIds);
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectModelCommand onFileRename(String path, String newName) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, path2, this.project);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl = false;
            if (!ProjectModelEntityExtensionsKt.isProjectFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId(it, this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entityIds = (List)destination$iv$iv;
        if (entityIds.isEmpty()) {
            return null;
        }
        List renameData = new ArrayList();
        Iterator iterator3 = entityIds.iterator();
        while (iterator3.hasNext()) {
            int entityId = ((Number)iterator3.next()).intValue();
            renameData.add(new RdRenameItemData(entityId, newName));
        }
        return new RdRenameItemsCommand(renameData);
    }

    private final boolean translateEvent(VFileEvent event) {
        if (event.isFromRefresh()) {
            return false;
        }
        if (event.getRequestor() == null || event.getRequestor() instanceof VfsBackendRequester) {
            return false;
        }
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.project;
        boolean $i$f$serviceIfCreated = false;
        UndoManager it = (UndoManager)$this$serviceIfCreated$iv.getServiceIfCreated(UndoManager.class);
        boolean bl = false;
        boolean bl2 = it == null || it.isUndoOrRedoInProgress();
        if (bl2) {
            return false;
        }
        return CommandProcessor.getInstance().getCurrentCommand() != null;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsToProjectModelEvents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsToProjectModelEvents.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/projectView/VfsToProjectModelEvents$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

