/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inTests;

import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.inTests.BulbItemsTestInfo;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.model.BulbTestState;
import com.jetbrains.rider.model.CleanupData;
import com.jetbrains.rider.model.NotReadyTestState;
import com.jetbrains.rider.model.RdTestSettingsEntry;
import com.jetbrains.rider.model.ReadyTestState;
import com.jetbrains.rider.model.RiderTestModel;
import com.jetbrains.rider.model.RiderTestModel_PregeneratedKt;
import com.jetbrains.rider.model.SymLinkArg;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.ProtocolManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u0006\u0010%\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\u0013R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/inTests/TestHost;", "Lcom/jetbrains/rider/protocol/ProtocolComponent;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "(Lcom/jetbrains/rider/protocol/IProtocolHost;)V", "currentSolutionBuildToolPath", "", "getCurrentSolutionBuildToolPath", "()Ljava/lang/String;", "frameworkLogger", "Lorg/apache/commons/logging/Log;", "isReady", "", "()Z", "model", "Lcom/jetbrains/rider/model/RiderTestModel;", "getModel", "()Lcom/jetbrains/rider/model/RiderTestModel;", "backendWaitForCaches", "", "reason", "cleanupBetweenTests", "filesToInvalidateCaches", "", "Ljava/io/File;", "commitPsiFile", "editor", "Lcom/jetbrains/rd/ide/model/TextControlId;", "createSymLinkDir", "source", "link", "flushQueueFromTests", "getBulbItemsDiagnosticInformation", "Lcom/jetbrains/rider/inTests/BulbItemsTestInfo;", "setEnvVar", "key", "value", "waitForExternalChangeProcessor", "waitForWebFormsAvailabilityCache", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTestHostFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost\n*L\n71#1:125\n71#1:126,3\n*E\n"})
public final class TestHost
extends ProtocolComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Log frameworkLogger;
    @NotNull
    private final RiderTestModel model;

    public TestHost(@NotNull IProtocolHost protocolHost) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        super(protocolHost);
        Log log = LogFactory.getLog((String)"com.jetbrains.rider.test.framework");
        Intrinsics.checkNotNull((Object)log);
        this.frameworkLogger = log;
        this.model = RiderTestModel_PregeneratedKt.getRiderTestModel(this.getProtocol());
        boolean bl2 = bl = ApplicationKt.getApplication().isUnitTestMode() || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "This component must be instantiated only in some test mode";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final RiderTestModel getModel() {
        return this.model;
    }

    @Nullable
    public final String getCurrentSolutionBuildToolPath() {
        return (String)this.model.getActiveToolsetPath().getValue();
    }

    public final boolean isReady() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.model.getReady()));
    }

    public final void setEnvVar(@NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        ExtensionsKt.callSynchronously$default((IRdCall)this.model.getSetEnvVariable(), new RdTestSettingsEntry(key, value2), this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)("Setup env var " + key + " = '" + value2 + "'"));
    }

    @NotNull
    public final BulbItemsTestInfo getBulbItemsDiagnosticInformation() {
        String string;
        BulbTestState value2 = (BulbTestState)this.model.getBulbTestStateInfo().getValueOrNull();
        BulbTestState bulbTestState = value2;
        if (bulbTestState instanceof ReadyTestState) {
            if (((ReadyTestState)value2).getCreatedWithHighlighterUnderCaret()) {
                return new BulbItemsTestInfo(false, "BulbItems was created by Highlighter Under caret.");
            }
            if (((ReadyTestState)value2).getUponInvalidatedDaemon()) {
                return new BulbItemsTestInfo(false, "The Daemon was invalidated (QF's isn't collected).");
            }
            return new BulbItemsTestInfo(true, "");
        }
        if (bulbTestState instanceof NotReadyTestState) {
            return new BulbItemsTestInfo(false, "BulbItems isn't in ready state.");
        }
        Object object = value2;
        if ((object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : (string = null)) == null) {
            string = "NULL";
        }
        throw new IllegalArgumentException("Unexpected type: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupBetweenTests(@NotNull String reason, @NotNull List<? extends File> filesToInvalidateCaches) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(filesToInvalidateCaches, (String)"filesToInvalidateCaches");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Iterable iterable = filesToInvalidateCaches;
        String string = reason;
        IRdCall iRdCall = (IRdCall)this.model.getCleanupDocuments();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalPath());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string2 = string;
        ExtensionsKt.callSynchronously$default(iRdCall, new CleanupData(string2, list), this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)"Cleaned up documents between tests.");
    }

    public static /* synthetic */ void cleanupBetweenTests$default(TestHost testHost, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        testHost.cleanupBetweenTests(string, list);
    }

    public final void backendWaitForCaches(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Integer result2 = (Integer)ExtensionsKt.callSynchronously$default((IRdCall)this.model.getWaitForCaches(), reason, this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)("Complete waiting for backend document caches. waitForIdle state performed for " + result2 + " milliseconds"));
    }

    public final void waitForExternalChangeProcessor() {
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        this.frameworkLogger.info((Object)"Start syncExternalChangeProcessor()");
        ExtensionsKt.callSynchronously$default((IRdCall)this.model.getSyncExternalChangeProcessor(), Unit.INSTANCE, this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)"Finished syncExternalChangeProcessor()");
    }

    public final void waitForWebFormsAvailabilityCache() {
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        this.frameworkLogger.info((Object)"Start waitForWebFormsAvailabilityCache()");
        ExtensionsKt.callSynchronously$default((IRdCall)this.model.getWaitForWebFormsAvailabilityCache(), Unit.INSTANCE, this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)"Finished waitForWebFormsAvailabilityCache()");
    }

    public final void commitPsiFile(@NotNull TextControlId editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Integer result2 = (Integer)ExtensionsKt.callSynchronously$default((IRdCall)this.model.getCommitPsiFile(), editor2, this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)("Complete waiting for backend commit psi file. Commit performed for " + result2 + " milliseconds"));
    }

    public final void flushQueueFromTests(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.frameworkLogger.info((Object)"flushing the backend queue from tests....");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        ExtensionsKt.callSynchronously$default((IRdCall)this.model.getFlushQueueFromTests(), reason, this.getProtocol(), this.getLifetime(), null, null, 24, null);
        this.frameworkLogger.info((Object)"Processed frontend queues on the backend");
    }

    @NotNull
    public final File createSymLinkDir(@NotNull File source, @NotNull File link) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.frameworkLogger.info((Object)"Call createSymLink");
        IRdCall iRdCall = (IRdCall)this.model.getCreateSymLink();
        String string = source.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String string2 = link.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        ExtensionsKt.callSynchronously$default(iRdCall, new SymLinkArg(string, string2), this.getProtocol(), this.getLifetime(), null, null, 24, null);
        return link;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/inTests/TestHost$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/inTests/TestHost;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nTestHostFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost$Companion\n+ 2 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n24#2:125\n800#3,11:126\n*S KotlinDebug\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost$Companion\n*L\n27#1:125\n27#1:126,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestHost getInstance(@NotNull IProtocolHost protocolHost) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
            IProtocolHost $this$getComponent$iv = protocolHost;
            boolean $i$f$getComponent = false;
            Iterable $this$filterIsInstance$iv$iv = $this$getComponent$iv.getComponents();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof TestHost)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            return (TestHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

