/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "solutionDirectory", "Ljava/io/File;", "tempDirectory", "shouldWatch", "", "rootFile", "intellij.rider.rdclient.dotnet"})
public final class VfsWatchRootFilter {
    @NotNull
    private final File solutionDirectory;
    @NotNull
    private final File tempDirectory;

    public VfsWatchRootFilter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.solutionDirectory = SolutionHostExtensionsKt.getSolutionDirectory(project2);
        this.tempDirectory = new File(FileUtil.getTempDirectory());
    }

    public final boolean shouldWatch(@NotNull File rootFile) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        if (rootFile.getParentFile() == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile) || Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile.getParentFile())) {
            return false;
        }
        return !VfsUtil.isAncestor((File)this.solutionDirectory, (File)rootFile, (boolean)false);
    }
}

