/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.CachingPainter;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ObjectUtils;
import com.jetbrains.rdclient.daemon.util.StringUtilKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J,\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "indentWidthInSpaces", "", "vfiAlignmentBaseOffset", "vfiEndOffset", "dots", "(Lcom/intellij/openapi/editor/Editor;IIII)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "editorFontMetrics", "Ljava/awt/FontMetrics;", "getEditorFontMetrics", "()Ljava/awt/FontMetrics;", "editorFontMetrics$delegate", "Lkotlin/Lazy;", "getIndentWidthInSpaces", "()I", "myDotCacheKey", "", "Lorg/jetbrains/annotations/NotNull;", "calcHeightInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "roundToPixelCenter", "", "value", "", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderVirtualFormatterSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderVirtualFormatterSupport.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1747#3,3:200\n*S KotlinDebug\n*F\n+ 1 RiderVirtualFormatterSupport.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer\n*L\n84#1:200,3\n*E\n"})
public final class RiderVirtualWhitespaceRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    private final int indentWidthInSpaces;
    private final int vfiAlignmentBaseOffset;
    private final int vfiEndOffset;
    private final int dots;
    @NotNull
    private final Object myDotCacheKey;
    @NotNull
    private final Lazy editorFontMetrics$delegate;

    public RiderVirtualWhitespaceRenderer(@NotNull Editor editor2, int indentWidthInSpaces, int vfiAlignmentBaseOffset, int vfiEndOffset, int dots) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.indentWidthInSpaces = indentWidthInSpaces;
        this.vfiAlignmentBaseOffset = vfiAlignmentBaseOffset;
        this.vfiEndOffset = vfiEndOffset;
        this.dots = dots;
        Object object = ObjectUtils.sentinel((String)"inlay space symbol");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.myDotCacheKey = object;
        this.editorFontMetrics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FontMetrics>(this){
            final /* synthetic */ RiderVirtualWhitespaceRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FontMetrics invoke() {
                Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                Font font2 = font;
                FontMetrics fontMetrics = this.this$0.getEditor().getContentComponent().getFontMetrics(font2);
                if (fontMetrics == null) {
                    String string = font2.getFontName();
                    Document document = this.this$0.getEditor().getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    throw new IllegalArgumentException("Font metrics of the font " + string + " on the editor " + StringUtilKt.presentableName(document) + " are null!");
                }
                return fontMetrics;
            }
        }));
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getIndentWidthInSpaces() {
        return this.indentWidthInSpaces;
    }

    private final FontMetrics getEditorFontMetrics() {
        Lazy lazy = this.editorFontMetrics$delegate;
        return (FontMetrics)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        StringBuilder stringBuilder;
        Serializable baseOffsetPoint;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        int finalBaseXOffsetDp = 0;
        if (this.vfiAlignmentBaseOffset > 0) {
            InlayModel inlayModel = this.editor.getInlayModel();
            Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
            InlayModel im = inlayModel;
            Point point = this.editor.offsetToXY(this.vfiAlignmentBaseOffset, true, false);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            baseOffsetPoint = point;
            int baseXOffsetDp = ((Point)baseOffsetPoint).x;
            List list = im.getInlineElementsInRange(this.vfiEndOffset - 1, this.vfiEndOffset);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
            Iterable iterable = list;
            int n = 0;
            for (Object t : iterable) {
                void it;
                Inlay inlay2 = (Inlay)t;
                int n2 = n;
                boolean bl = false;
                Rectangle rectangle = it.getBounds();
                int n3 = rectangle != null ? rectangle.width : 0;
                n = n2 + n3;
            }
            int existentInlaysWidth = n;
            finalBaseXOffsetDp = baseXOffsetDp - existentInlaysWidth;
        }
        baseOffsetPoint = stringBuilder = new StringBuilder();
        FontMetrics fontMetrics = this.getEditorFontMetrics();
        boolean bl = false;
        int n = this.indentWidthInSpaces;
        int n4 = 0;
        while (n4 < n) {
            void $this$calcWidthInPixels_u24lambda_u242;
            int it = n4++;
            boolean bl2 = false;
            $this$calcWidthInPixels_u24lambda_u242.append(' ');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return fontMetrics.stringWidth(string) + finalBaseXOffsetDp;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.getEditorFontMetrics().getHeight();
    }

    private final float roundToPixelCenter(double value2, ScaleContext scaleContext) {
        double devPixel = 1.0 / PaintUtil.devValue((double)1.0, (ScaleContext)scaleContext);
        return (float)(PaintUtil.alignToInt((double)value2, (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null) + devPixel / (double)2);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        boolean shouldPaintInlayDots;
        block5: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            int docLine = this.editor.getDocument().getLineNumber(inlay.getOffset() + 1);
            List list = this.editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Caret it = (Caret)element$iv;
                    boolean bl = false;
                    if (!(this.editor.getDocument().getLineNumber(it.getOffset()) == docLine)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = shouldPaintInlayDots = false;
            }
        }
        if (shouldPaintInlayDots) {
            ScaleContext scaleContext = ScaleContext.Companion.create();
            Color whitespacesColor = this.editor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR);
            float fontSizeDotScale = (float)this.editor.getColorsScheme().getEditorFontSize() / (float)FontPreferences.DEFAULT_FONT_SIZE;
            double dotCellWidthdp = targetRegion.getWidth() / (double)this.dots;
            int n = this.dots;
            for (int dot = 0; dot < n; ++dot) {
                double startXdp = targetRegion.getX() + (double)dot * dotCellWidthdp;
                double endXdp = targetRegion.getX() + (double)(dot + 1) * dotCellWidthdp;
                float dotXpx = this.roundToPixelCenter((startXdp + endXdp) / 2.0, scaleContext) - fontSizeDotScale / (float)2;
                float dotYpx = this.roundToPixelCenter(targetRegion.getY() + targetRegion.getHeight() / 2.0, scaleContext) - fontSizeDotScale / (float)2;
                Object[] objectArray = new Object[]{whitespacesColor};
                CachingPainter.paint((Graphics2D)g, (float)dotXpx, (float)dotYpx, (float)fontSizeDotScale, (float)fontSizeDotScale, arg_0 -> RiderVirtualWhitespaceRenderer.paint$lambda$4((Function1)new Function1<Graphics2D, Unit>(targetRegion, whitespacesColor, fontSizeDotScale){
                    final /* synthetic */ Rectangle2D $targetRegion;
                    final /* synthetic */ Color $whitespacesColor;
                    final /* synthetic */ float $fontSizeDotScale;
                    {
                        this.$targetRegion = $targetRegion;
                        this.$whitespacesColor = $whitespacesColor;
                        this.$fontSizeDotScale = $fontSizeDotScale;
                        super(1);
                    }

                    public final void invoke(Graphics2D it) {
                        it.setColor(new Color(0, 0, 0, 0));
                        it.fill(this.$targetRegion);
                        it.setColor(this.$whitespacesColor);
                        it.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        it.fill(new Ellipse2D.Float(0.0f, 0.0f, this.$fontSizeDotScale, this.$fontSizeDotScale));
                    }
                }, arg_0), (Object)this.myDotCacheKey, (Object[])objectArray);
            }
        }
    }

    private static final void paint$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

