/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.rider.editors.virtualFormat.FoldingArgs;
import com.jetbrains.rider.editors.virtualFormat.InlayArgs;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatterListenerAggregatorKt;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatterSupportKt;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatting;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualWhitespaceRenderer;
import com.jetbrains.rider.editors.virtualFormat.VirtualFormattingApplicationStrategy;
import com.jetbrains.rider.editors.virtualFormat.VirtualFormattingInfo;
import com.jetbrains.rider.editors.virtualFormat.VirtualFormattingRegion;
import com.jetbrains.rider.editors.virtualFormat.VirtualWhitespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001aJ\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0003\u001a\"\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0007\"-\u0010\u0000\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"?\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002*\u00020\b2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00028F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"EDITOR_VIRTUAL_WHITESPACE_COLLECTION", "Lcom/intellij/openapi/util/Key;", "", "Lcom/jetbrains/rider/editors/virtualFormat/VirtualWhitespace;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "virtualWhitespaces", "Lcom/intellij/openapi/editor/Editor;", "getVirtualWhitespaces", "(Lcom/intellij/openapi/editor/Editor;)Ljava/util/List;", "setVirtualWhitespaces", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "virtualWhitespaces$delegate", "Lkotlin/properties/ReadWriteProperty;", "applyVirtualFormattingToEditor", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "strategy", "Lcom/jetbrains/rider/editors/virtualFormat/VirtualFormattingApplicationStrategy;", "calculateVirtualFormattingRegions", "collectVirtualWhitespaceCreationData", "vfi", "Lcom/jetbrains/rider/editors/virtualFormat/VirtualFormattingInfo;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "foldingCreationArgs", "", "Lcom/jetbrains/rider/editors/virtualFormat/FoldingArgs;", "inlayCreationArgs", "Lcom/jetbrains/rider/editors/virtualFormat/InlayArgs;", "highlightersWithCreation", "createRenderer", "Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer;", "offsetDelta", "", "dropAllVirtualFormatting", "intellij.rider.rdclient.dotnet"})
@JvmName(name="RiderVirtualFormatting")
@SourceDebugExtension(value={"SMAP\nriderVirtualFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 riderVirtualFormattingService.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormatting\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n3792#2:186\n4307#2,2:187\n1603#3,9:189\n1855#3:198\n1856#3:200\n1612#3:201\n1855#3,2:202\n1855#3,2:204\n1855#3,2:207\n1855#3,2:209\n1855#3,2:211\n1#4:199\n1#4:206\n*S KotlinDebug\n*F\n+ 1 riderVirtualFormattingService.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormatting\n*L\n91#1:186\n91#1:187,2\n92#1:189,9\n92#1:198\n92#1:200\n92#1:201\n100#1:202,2\n139#1:204,2\n169#1:207,2\n131#1:209,2\n178#1:211,2\n92#1:199\n*E\n"})
public final class RiderVirtualFormatting {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Key<List<VirtualWhitespace>> EDITOR_VIRTUAL_WHITESPACE_COLLECTION;
    @NotNull
    private static final ReadWriteProperty virtualWhitespaces$delegate;

    @Nullable
    public static final List<VirtualWhitespace> getVirtualWhitespaces(@NotNull Editor $this$virtualWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualWhitespaces, (String)"<this>");
        return (List)virtualWhitespaces$delegate.getValue((Object)$this$virtualWhitespaces, $$delegatedProperties[0]);
    }

    public static final void setVirtualWhitespaces(@NotNull Editor $this$virtualWhitespaces, @Nullable List<VirtualWhitespace> list) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualWhitespaces, (String)"<this>");
        virtualWhitespaces$delegate.setValue((Object)$this$virtualWhitespaces, $$delegatedProperties[0], list);
    }

    private static final RiderVirtualWhitespaceRenderer createRenderer(Editor editor2, VirtualFormattingInfo vfi, int offsetDelta) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        RiderVirtualFormatterListenerAggregatorKt.getLOG().trace("creating renderer of line " + doc.getLineNumber(vfi.getEndOffset()));
        if (vfi.getAlignmentBaseOffset() != null) {
            return null;
        }
        return new RiderVirtualWhitespaceRenderer(editor2, vfi.getRelativeSpaces(), 0, 0, offsetDelta);
    }

    @RequiresReadLock
    private static final void collectVirtualWhitespaceCreationData(EditorImpl editor2, VirtualFormattingInfo vfi, RangeHighlighter highlighter2, Collection<FoldingArgs> foldingCreationArgs, Collection<InlayArgs> inlayCreationArgs, Collection<RangeHighlighter> highlightersWithCreation) {
        if (vfi.getRelativeSpaces() == 0 && vfi.getAlignmentBaseOffset() == null) {
            return;
        }
        if (vfi.getEndOffset() > editor2.getDocument().getTextLength()) {
            return;
        }
        RiderVirtualWhitespaceRenderer renderer = RiderVirtualFormatting.createRenderer((Editor)editor2, vfi, highlighter2.getEndOffset() - highlighter2.getStartOffset());
        if (renderer == null) {
            return;
        }
        highlightersWithCreation.add(highlighter2);
        foldingCreationArgs.add(new FoldingArgs(highlighter2.getStartOffset(), highlighter2.getEndOffset()));
        inlayCreationArgs.add(new InlayArgs(highlighter2.getEndOffset(), renderer));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public static final VirtualFormattingApplicationStrategy calculateVirtualFormattingRegions(@NotNull EditorImpl editor2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.getProject() == null) {
            throw new IllegalArgumentException("Cannot calculate virtual formatting for a non-project editor!");
        }
        List foldingCreationData = new ArrayList();
        List inlayCreationData = new ArrayList();
        List highlightersWithCreation = new ArrayList();
        RangeHighlighter[] rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)((Document)editor2.getDocument()), (Project)editor2.getProject(), (boolean)false).getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] objectArray = rangeHighlighterArray;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!RiderVirtualFormatterSupportKt.isBackendVirtualFormattingElement(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            VirtualFormattingRegion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            VirtualFormattingInfo vfi = RiderVirtualFormatterSupportKt.getVirtualFormattingInfo(it);
            if ((vfi != null ? new VirtualFormattingRegion(it, vfi) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List vfis = (List)destination$iv$iv;
        Iterable $this$forEach$iv = vfis;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFormattingRegion reg = (VirtualFormattingRegion)element$iv;
            boolean bl = false;
            RiderVirtualFormatting.collectVirtualWhitespaceCreationData(editor2, reg.getVfi(), reg.getHighlighter(), foldingCreationData, inlayCreationData, highlightersWithCreation);
        }
        return new VirtualFormattingApplicationStrategy(highlightersWithCreation, foldingCreationData, inlayCreationData);
    }

    @RequiresEdt
    public static final void applyVirtualFormattingToEditor(@NotNull EditorImpl editor2, @NotNull VirtualFormattingApplicationStrategy strategy2) {
        List list;
        List virtualWhitespaces;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)strategy2, (String)"strategy");
        if (editor2.getProject() == null) {
            throw new IllegalArgumentException("Cannot calculate virtual formatting for a non-project editor!");
        }
        if (ClientSessionsManager.Companion.getAppSessions(ClientKind.ALL).size() > 2) {
            return;
        }
        RiderVirtualFormatting.dropAllVirtualFormatting((Editor)editor2);
        List list2 = RiderVirtualFormatting.getVirtualWhitespaces((Editor)editor2);
        if (list2 == null) {
            list2 = virtualWhitespaces = (List)new ArrayList();
        }
        if (RiderVirtualFormatting.getVirtualWhitespaces((Editor)editor2) == null) {
            RiderVirtualFormatting.setVirtualWhitespaces((Editor)editor2, virtualWhitespaces);
        }
        List materialisedInlays = new ArrayList();
        List materialisedFoldings = new ArrayList();
        editor2.getFoldingModel().runBatchFoldingOperation(() -> RiderVirtualFormatting.applyVirtualFormattingToEditor$lambda$5(strategy2, editor2, materialisedFoldings));
        Iterable $this$forEach$iv = strategy2.getInlayCreationArgs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlayArgs it = (InlayArgs)element$iv;
            boolean bl = false;
            Inlay inlay = editor2.getInlayModel().addInlineElement(it.getPosition(), true, 10000, (EditorCustomElementRenderer)it.getRenderer());
            materialisedInlays.add(inlay);
        }
        boolean bl = $this$forEach$iv = materialisedInlays.size() == materialisedFoldings.size() && materialisedFoldings.size() == strategy2.getHighlighters().size();
        if (_Assertions.ENABLED && !$this$forEach$iv) {
            boolean bl2 = false;
            String string = "Inlays, foldings, and highlighters are zipable";
            throw new AssertionError((Object)string);
        }
        int commonSize = materialisedInlays.size();
        List it = list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Triple<? extends Inlay<RiderVirtualWhitespaceRenderer>, ? extends FoldRegion, ? extends RangeHighlighter>>, Continuation<? super Unit>, Object>(commonSize, (List<Inlay<RiderVirtualWhitespaceRenderer>>)materialisedInlays, (List<FoldRegion>)materialisedFoldings, strategy2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $commonSize;
            final /* synthetic */ List<Inlay<RiderVirtualWhitespaceRenderer>> $materialisedInlays;
            final /* synthetic */ List<FoldRegion> $materialisedFoldings;
            final /* synthetic */ VirtualFormattingApplicationStrategy $strategy;
            {
                this.$commonSize = $commonSize;
                this.$materialisedInlays = $materialisedInlays;
                this.$materialisedFoldings = $materialisedFoldings;
                this.$strategy = $strategy;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = this.$commonSize;
                        var4_5 = this.$materialisedInlays;
                        var5_6 = this.$materialisedFoldings;
                        var6_7 = this.$strategy;
                        var7_8 = 0;
lbl11:
                        // 2 sources

                        while (var7_8 < var3_4) {
                            i = var7_8;
                            $i$a$-repeat-RiderVirtualFormatting$applyVirtualFormattingToEditor$4$1 = false;
                            this.L$0 = $this$sequence;
                            this.L$1 = var4_5;
                            this.L$2 = var5_6;
                            this.L$3 = var6_7;
                            this.I$0 = var3_4;
                            this.I$1 = var7_8;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)new Triple(var4_5.get(i), var5_6.get(i), (Object)var6_7.getHighlighters().get(i)), (Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl36
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-repeat-RiderVirtualFormatting$applyVirtualFormattingToEditor$4$1 = false;
                        var7_8 = this.I$1;
                        var3_4 = this.I$0;
                        var6_7 = (VirtualFormattingApplicationStrategy)this.L$3;
                        var5_6 = (List)this.L$2;
                        var4_5 = (List)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        ++var7_8;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Triple<? extends Inlay<RiderVirtualWhitespaceRenderer>, ? extends FoldRegion, ? extends RangeHighlighter>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function1)applyVirtualFormattingToEditor.5.INSTANCE));
        boolean bl3 = false;
        virtualWhitespaces.addAll(it);
    }

    @RequiresEdt
    public static final void dropAllVirtualFormatting(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.getProject() == null) {
            throw new IllegalArgumentException("Cannot calculate virtual formatting for a non-project editor!");
        }
        List<VirtualWhitespace> virtualWhitespaces = RiderVirtualFormatting.getVirtualWhitespaces(editor2);
        Collection collection = virtualWhitespaces;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        List toRemove = new ArrayList();
        Iterable $this$forEach$iv = virtualWhitespaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay<RiderVirtualWhitespaceRenderer> it;
            VirtualWhitespace vws = (VirtualWhitespace)element$iv;
            boolean bl = false;
            if (vws.getPaddingInlay() == null) continue;
            boolean bl2 = false;
            Disposer.dispose((Disposable)((Disposable)it));
            toRemove.add(vws);
        }
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel fm = foldingModel;
        fm.runBatchFoldingOperation(() -> RiderVirtualFormatting.dropAllVirtualFormatting$lambda$13(toRemove, fm));
        virtualWhitespaces.removeAll(toRemove);
    }

    private static final void applyVirtualFormattingToEditor$lambda$5(VirtualFormattingApplicationStrategy $strategy, EditorImpl $editor, List $materialisedFoldings) {
        Intrinsics.checkNotNullParameter((Object)$strategy, (String)"$strategy");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$materialisedFoldings, (String)"$materialisedFoldings");
        Iterable $this$forEach$iv = $strategy.getFoldingCreationArgs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion foldRegion;
            FoldingArgs it = (FoldingArgs)element$iv;
            boolean bl = false;
            if ($editor.getFoldingModel().createFoldRegion(it.getStart(), it.getEnd(), "", null, true) != null) {
                FoldRegion foldRegion2;
                FoldRegion $this$applyVirtualFormattingToEditor_u24lambda_u245_u24lambda_u244_u24lambda_u243 = foldRegion2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$this$applyVirtualFormattingToEditor_u24lambda_u245_u24lambda_u244_u24lambda_u243);
                RiderVirtualFormatterListenerAggregatorKt.setVirtualWhitespaceFolding($this$applyVirtualFormattingToEditor_u24lambda_u245_u24lambda_u244_u24lambda_u243, true);
                foldRegion = foldRegion2;
            } else {
                foldRegion = null;
            }
            FoldRegion foldRegion3 = foldRegion;
            $materialisedFoldings.add(foldRegion3);
        }
    }

    private static final void dropAllVirtualFormatting$lambda$13(List $toRemove, FoldingModel $fm) {
        Intrinsics.checkNotNullParameter((Object)$toRemove, (String)"$toRemove");
        Intrinsics.checkNotNullParameter((Object)$fm, (String)"$fm");
        Iterable $this$forEach$iv = $toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it;
            VirtualWhitespace vws = (VirtualWhitespace)element$iv;
            boolean bl = false;
            if (vws.getObscuringFoldRegion() == null) continue;
            boolean bl2 = false;
            $fm.removeFoldRegion(it);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(RiderVirtualFormatting.class, "virtualWhitespaces", "getVirtualWhitespaces(Lcom/intellij/openapi/editor/Editor;)Ljava/util/List;", 1)))};
        $$delegatedProperties = kPropertyArray;
        Key key = Key.create((String)"rider.editor.vws");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDITOR_VIRTUAL_WHITESPACE_COLLECTION = key;
        virtualWhitespaces$delegate = UserDataHolderKt.userData(EDITOR_VIRTUAL_WHITESPACE_COLLECTION);
    }
}

