/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rd.ide.Suppressor;
import com.jetbrains.rd.ide.model.Operation;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TypedKey;
import com.jetbrains.rd.ide.model.TypingSessionState;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.CommitResult;
import com.jetbrains.rider.editorActions.FairMergeStrategy;
import com.jetbrains.rider.editorActions.RangePair;
import com.jetbrains.rider.editorActions.RangePairKt;
import com.jetbrains.rider.editorActions.TextModificationMap;
import com.jetbrains.rider.editorActions.TextModificationMapsDiff;
import com.jetbrains.rider.editorActions.TypingSessionMediator;
import com.jetbrains.rider.editors.EditorSynchronizerWithTypingSession;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001cB=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020GH\u0016J\u0006\u0010H\u001a\u00020DJ\u0010\u0010I\u001a\u00020D2\u0006\u0010F\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020D2\u0006\u0010F\u001a\u00020JH\u0016J\u0010\u0010L\u001a\u00020D2\u0006\u0010F\u001a\u00020JH\u0016J\u000e\u0010M\u001a\u00020D2\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020DH\u0002J\b\u0010Q\u001a\u00020DH\u0002J\u0006\u0010R\u001a\u00020DJ\u0006\u0010S\u001a\u00020DJ\u0006\u0010T\u001a\u00020%J\u0010\u0010U\u001a\u00020D2\u0006\u0010V\u001a\u00020%H\u0002J\u0010\u0010W\u001a\u00020D2\u0006\u0010X\u001a\u00020YH\u0016J\u000e\u0010Z\u001a\u00020D2\u0006\u0010[\u001a\u000207J\u000e\u0010\\\u001a\u00020D2\u0006\u0010]\u001a\u00020^J\u0006\u0010_\u001a\u00020DJ\u0019\u0010`\u001a\u00020D2\u000e\b\u0004\u0010a\u001a\b\u0012\u0004\u0012\u00020D0bH\u0082\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u00070)\u00a2\u0006\u0002\b*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessionMediator;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sessionState", "Lcom/jetbrains/rd/ide/model/TypingSessionState;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorSynchronizer", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;", "documentSynchronizer", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "suppressor", "Lcom/jetbrains/rd/ide/Suppressor;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rd/ide/model/TypingSessionState;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;Lcom/jetbrains/rd/ide/Suppressor;Lcom/intellij/openapi/client/ClientAppSession;)V", "documentTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "editorTypingSession", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "expectedChange", "", "fairMergeStrategy", "Lcom/jetbrains/rider/editorActions/FairMergeStrategy;", "fairMergeStrategyDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<set-?>", "hasWritableTypingAssist", "getHasWritableTypingAssist", "()Z", "id", "", "getId", "()I", "initialText", "Lcom/intellij/util/text/ImmutableCharSequence;", "Lorg/jetbrains/annotations/NotNull;", "isSingleOperation", "lastLocalSelection", "lastRemoteSelection", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "localComposedChanges", "Lcom/jetbrains/rider/editorActions/TextModificationMap;", "operationNumber", "queuedOperations", "", "Lcom/jetbrains/rd/ide/model/Operation;", "remoteComposedChanges", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "sessionFinishedSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/jetbrains/rider/editorActions/CommitResult;", "getSessionFinishedSignal$intellij_rider_rdclient_dotnet", "()Lcom/jetbrains/rd/util/reactive/Signal;", "sessionLifetimeDefinition", "allowModifications", "Lcom/intellij/openapi/Disposable;", "assertEmptyQueue", "", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "beforeWritableOperation", "caretAdded", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "caretRemoved", "close", "reason", "", "commitLocalVersion", "commitRemoteVersion", "endAllowModifications", "flushQueuedOperations", "getNextOperationTimestamp", "receiveOperationAck", "remoteTimestamp", "selectionChanged", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "sendOperation", "operation", "sendReadonlyTypedKey", "typedKey", "Lcom/jetbrains/rd/ide/model/TypedKey;", "startAllowModifications", "withEditorRepairing", "block", "Lkotlin/Function0;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTypingSessionMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingSessionMediator.kt\ncom/jetbrains/rider/editorActions/TypingSessionMediator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n180#1,9:309\n189#1,6:320\n195#1,10:328\n65#2,4:305\n65#2,4:355\n65#2,4:359\n65#2,4:363\n65#2,4:367\n65#2,4:371\n22#3,2:318\n26#3,2:326\n22#3,2:339\n22#3,6:341\n26#3,2:347\n22#3,6:349\n1#4:338\n*S KotlinDebug\n*F\n+ 1 TypingSessionMediator.kt\ncom/jetbrains/rider/editorActions/TypingSessionMediator\n*L\n99#1:309,9\n99#1:320,6\n99#1:328,10\n90#1:305,4\n218#1:355,4\n273#1:359,4\n277#1:363,4\n287#1:367,4\n292#1:371,4\n99#1:318,2\n99#1:326,2\n137#1:339,2\n138#1:341,6\n137#1:347,2\n188#1:349,6\n*E\n"})
public final class TypingSessionMediator
implements DocumentListener,
CaretListener,
SelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final TypingSessionState sessionState;
    @NotNull
    private final Editor editor;
    @NotNull
    private final EditorSynchronizerWithTypingSession editorSynchronizer;
    @NotNull
    private final TextBufferDocumentSynchronizer documentSynchronizer;
    @NotNull
    private final Suppressor suppressor;
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final LifetimeDefinition sessionLifetimeDefinition;
    @NotNull
    private final ITypingSession<SelectionRange> editorTypingSession;
    @NotNull
    private final ITypingSession<RdTextChange> documentTypingSession;
    @NotNull
    private final TextModificationMap remoteComposedChanges;
    @NotNull
    private final TextModificationMap localComposedChanges;
    private int operationNumber;
    private boolean isSingleOperation;
    @NotNull
    private final LifetimeDefinition fairMergeStrategyDef;
    @NotNull
    private final FairMergeStrategy fairMergeStrategy;
    @NotNull
    private final ImmutableCharSequence initialText;
    @Nullable
    private SelectionRange lastRemoteSelection;
    @Nullable
    private SelectionRange lastLocalSelection;
    private boolean expectedChange;
    @NotNull
    private final List<Operation> queuedOperations;
    @NotNull
    private final Signal<CommitResult> sessionFinishedSignal;
    private boolean hasWritableTypingAssist;
    private static int timestamp;

    public TypingSessionMediator(@NotNull Logger logger, @NotNull TypingSessionState sessionState, @NotNull Editor editor2, @NotNull EditorSynchronizerWithTypingSession editorSynchronizer, @NotNull TextBufferDocumentSynchronizer documentSynchronizer2, @NotNull Suppressor suppressor2, @NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)editorSynchronizer), (String)"editorSynchronizer");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer2, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)suppressor2, (String)"suppressor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.logger = logger;
        this.sessionState = sessionState;
        this.editor = editor2;
        this.editorSynchronizer = editorSynchronizer;
        this.documentSynchronizer = documentSynchronizer2;
        this.suppressor = suppressor2;
        this.session = session2;
        this.sessionLifetimeDefinition = this.editorSynchronizer.getTextControlLifetime().createNested();
        this.editorTypingSession = this.editorSynchronizer.startTypingSession(this.getLifetime());
        this.documentTypingSession = this.documentSynchronizer.startTypingSession(this.getLifetime());
        this.remoteComposedChanges = new TextModificationMap();
        this.localComposedChanges = new TextModificationMap();
        this.isSingleOperation = true;
        this.fairMergeStrategyDef = this.getLifetime().createNested();
        this.fairMergeStrategy = new FairMergeStrategy((Lifetime)this.fairMergeStrategyDef, this.editor, this.session, this.documentTypingSession, this.editorTypingSession);
        ImmutableCharSequence immutableCharSequence = CharArrayUtil.createImmutableCharSequence((CharSequence)this.editor.getDocument().getImmutableCharSequence());
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"createImmutableCharSequence(...)");
        this.initialText = immutableCharSequence;
        this.queuedOperations = new ArrayList();
        this.sessionFinishedSignal = new Signal();
        this.documentTypingSession.getOnRemoteChange().advise(this.getLifetime(), (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(@NotNull RdTextChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                remoteComposedChanges.add(RangePairKt.toTextChange(it));
            }
        });
        this.documentTypingSession.getOnLocalChange().advise(this.getLifetime(), (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(@NotNull RdTextChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                localComposedChanges.add(RangePairKt.toTextChange(it));
            }
        });
        this.editorTypingSession.getOnRemoteChange().advise(this.getLifetime(), (Function1)new Function1<SelectionRange, Unit>(){

            public final void invoke(@NotNull SelectionRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                lastRemoteSelection = it;
            }
        });
        this.editorTypingSession.getOnLocalChange().advise(this.getLifetime(), (Function1)new Function1<SelectionRange, Unit>(){

            public final void invoke(@NotNull SelectionRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                lastLocalSelection = it;
            }
        });
        this.sessionState.getAck().advise(this.getLifetime(), (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                ((TypingSessionMediator)this.receiver).receiveOperationAck(p0);
            }
        });
        this.sessionState.getClose().advise(this.getLifetime(), (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.close("backend error");
            }
        });
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    public final Signal<CommitResult> getSessionFinishedSignal$intellij_rider_rdclient_dotnet() {
        return this.sessionFinishedSignal;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.sessionLifetimeDefinition.getLifetime();
    }

    public final boolean getHasWritableTypingAssist() {
        return this.hasWritableTypingAssist;
    }

    public final int getId() {
        return this.sessionState.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void receiveOperationAck(int remoteTimestamp) {
        block11: {
            int localTimestamp = timestamp;
            if (localTimestamp != remoteTimestamp) {
                Logger $this$trace$iv = this.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("localTimestamp (" + localTimestamp + ") != remoteTimestamp (" + remoteTimestamp + ")");
                }
                return;
            }
            this.assertEmptyQueue();
            this.documentSynchronizer.assertEmptyChangesQueue();
            this.editorSynchronizer.assertEmptyChangesQueue();
            TypingSessionMediator this_$iv = this;
            boolean $i$f$withEditorRepairing = false;
            CharSequence charSequence = this_$iv.editor.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence textToRepair$iv = charSequence;
            int caretOffsetToRepair$iv = this_$iv.editor.getCaretModel().getPrimaryCaret().getOffset();
            try {
                boolean bl = false;
                this.commitRemoteVersion();
            }
            catch (Throwable t$iv) {
                TextControlId textControlId;
                this_$iv.logger.error("Repairing the document state... Please submit exception.", t$iv);
                Disposable $this$use$iv$iv = this_$iv.allowModifications();
                boolean $i$f$use = false;
                try {
                    Disposable it$iv = $this$use$iv$iv;
                    boolean bl = false;
                    ApplicationManager.getApplication().runWriteAction(new Runnable(this_$iv, textToRepair$iv){
                        final /* synthetic */ TypingSessionMediator this$0;
                        final /* synthetic */ CharSequence $textToRepair;
                        {
                            this.this$0 = $receiver;
                            this.$textToRepair = $textToRepair;
                        }

                        public final void run() {
                            this.this$0.getEditor().getDocument().setText(this.$textToRepair);
                        }
                    });
                    if (!this_$iv.editor.isDisposed()) {
                        this_$iv.editor.getCaretModel().moveToOffset(caretOffsetToRepair$iv);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if ($this$use$iv$iv != null) {
                        Disposer.dispose((Disposable)$this$use$iv$iv);
                    }
                }
                if (RLifetimeKt.isAlive((Lifetime)((Lifetime)this_$iv.sessionLifetimeDefinition))) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this_$iv.sessionLifetimeDefinition, (boolean)false, (int)1, null);
                }
                if (this_$iv.editor.isDisposed() || (textControlId = DocumentExKt.getTextControlId(this_$iv.editor)) == null || (textControlId = textControlId.getDocumentId()) == null) break block11;
                TextControlId documentId$iv = textControlId;
                EditorSynchronizerWithTypingSession.Companion.recoverEditorsSynchronization((RdDocumentId)documentId$iv, this_$iv.session);
            }
        }
    }

    private final void assertEmptyQueue() {
        this.logger.assertTrue(this.queuedOperations.isEmpty(), (Object)"queuedOperations.isEmpty()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitRemoteVersion() {
        this.logger.trace("Committing remote version.");
        if (!(!this.editor.isDisposed())) {
            boolean $i$a$-require-TypingSessionMediator$commitRemoteVersion$22 = false;
            String $i$a$-require-TypingSessionMediator$commitRemoteVersion$22 = "editor is disposed";
            throw new IllegalArgumentException($i$a$-require-TypingSessionMediator$commitRemoteVersion$22.toString());
        }
        TextBufferDocumentSynchronizer.AccumulatedRecoverRequests recoveringCookie = this.documentSynchronizer.accumulateRecoverRequests();
        Disposable $this$use$iv = recoveringCookie;
        boolean $i$f$use = false;
        try {
            TextBufferDocumentSynchronizer.AccumulatedRecoverRequests it = (TextBufferDocumentSynchronizer.AccumulatedRecoverRequests)$this$use$iv;
            boolean bl = false;
            Disposable $this$use$iv2 = this.allowModifications();
            boolean $i$f$use2 = false;
            try {
                Disposable it2 = $this$use$iv2;
                boolean bl2 = false;
                List<RangePair> diff = TextModificationMapsDiff.Companion.build(this.remoteComposedChanges, this.localComposedChanges, this.initialText);
                this.documentTypingSession.startCommitRemoteVersion();
                this.editorTypingSession.startCommitRemoteVersion();
                if (!((Collection)diff).isEmpty() || this.lastRemoteSelection != null && !Intrinsics.areEqual((Object)this.lastLocalSelection, (Object)this.lastRemoteSelection)) {
                    if (!((Collection)diff).isEmpty()) {
                        if (this.isSingleOperation) {
                            this.fairMergeStrategy.merge();
                        } else {
                            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(diff, this){
                                final /* synthetic */ List<RangePair> $diff;
                                final /* synthetic */ TypingSessionMediator this$0;
                                {
                                    this.$diff = $diff;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    CommandProcessor.getInstance().runUndoTransparentAction(() -> commitRemoteVersion.2.1.1.invoke$lambda$0(this.$diff, this.this$0));
                                }

                                private static final void invoke$lambda$0(List $diff, TypingSessionMediator this$0) {
                                    Intrinsics.checkNotNullParameter((Object)$diff, (String)"$diff");
                                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                    TypingSessionMediator.access$commitRemoteVersion$applyDiff(this$0, $diff);
                                    TypingSessionMediator.access$commitRemoteVersion$applySelection(this$0);
                                }
                            }));
                        }
                    } else {
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> TypingSessionMediator.commitRemoteVersion$lambda$5$lambda$4$lambda$3(this));
                    }
                }
                this.documentTypingSession.finishCommitRemoteVersion();
                this.editorTypingSession.finishCommitRemoteVersion();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv2 != null) {
                    Disposer.dispose((Disposable)$this$use$iv2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        if (recoveringCookie.getHasRequests()) {
            this.sessionFinishedSignal.fire((Object)CommitResult.Rolledback);
            throw new IllegalStateException("corrupted document state");
        }
        this.sessionFinishedSignal.fire((Object)CommitResult.Commited);
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.sessionLifetimeDefinition, (boolean)false, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withEditorRepairing(Function0<Unit> block) {
        boolean $i$f$withEditorRepairing = false;
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence textToRepair = charSequence;
        int caretOffsetToRepair = this.editor.getCaretModel().getPrimaryCaret().getOffset();
        try {
            block.invoke();
        }
        catch (Throwable t) {
            this.logger.error("Repairing the document state... Please submit exception.", t);
            Disposable $this$use$iv = this.allowModifications();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl = false;
                ApplicationManager.getApplication().runWriteAction(new /* invalid duplicate definition of identical inner class */);
                if (!this.editor.isDisposed()) {
                    this.editor.getCaretModel().moveToOffset(caretOffsetToRepair);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
                InlineMarker.finallyEnd((int)1);
            }
            if (RLifetimeKt.isAlive((Lifetime)((Lifetime)this.sessionLifetimeDefinition))) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.sessionLifetimeDefinition, (boolean)false, (int)1, null);
            }
            if (this.editor.isDisposed()) {
                return;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(this.editor);
            if (textControlId == null || (textControlId = textControlId.getDocumentId()) == null) {
                return;
            }
            TextControlId documentId = textControlId;
            EditorSynchronizerWithTypingSession.Companion.recoverEditorsSynchronization((RdDocumentId)documentId, this.session);
        }
    }

    private final void commitLocalVersion() {
        this.logger.trace("Committing local version.");
        InterfacesKt.fire((ISignal)this.sessionState.getRollback());
        this.documentTypingSession.rollbackRemoteVersion();
        this.editorTypingSession.rollbackRemoteVersion();
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.sessionLifetimeDefinition, (boolean)false, (int)1, null);
        this.sessionFinishedSignal.fire((Object)CommitResult.Rolledback);
    }

    public final void close(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!RLifetimeKt.isAlive((Lifetime)this.getLifetime())) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Closing typing session... |" + reason + "|");
        }
        this.commitLocalVersion();
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.expectedChange) {
            return;
        }
        this.close("caretPositionChanged event");
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.expectedChange) {
            return;
        }
        this.close("caretAdded event");
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.expectedChange) {
            return;
        }
        this.close("caretRemoved event");
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.expectedChange) {
            return;
        }
        this.close("selectionChanged event");
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.expectedChange) {
            return;
        }
        this.close("beforeDocumentChange event");
    }

    public final void startAllowModifications() {
        if (!(!this.expectedChange)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.expectedChange = true;
    }

    public final void endAllowModifications() {
        if (!this.expectedChange) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.expectedChange = false;
    }

    @NotNull
    public final Disposable allowModifications() {
        this.startAllowModifications();
        return () -> TypingSessionMediator.allowModifications$lambda$8(this);
    }

    public final int getNextOperationTimestamp() {
        int n = this.operationNumber;
        this.operationNumber = n + 1;
        if (this.operationNumber == 2) {
            this.isSingleOperation = false;
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.fairMergeStrategyDef, (boolean)false, (int)1, null);
        }
        return Companion.nextTimestamp();
    }

    public final void sendOperation(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (this.suppressor.shouldSuppress()) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Queueing operation: " + IPrintableKt.printToString((Object)operation) + " for " + this.sessionState.getTextControlId() + ".");
            }
            this.queuedOperations.add(operation);
        } else {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Sending operation: " + IPrintableKt.printToString((Object)operation) + " for " + this.sessionState.getTextControlId() + ".");
            }
            this.sessionState.getExecute().fire((Object)operation);
        }
    }

    public final void beforeWritableOperation() {
        this.hasWritableTypingAssist = true;
    }

    public final void sendReadonlyTypedKey(@NotNull TypedKey typedKey) {
        Intrinsics.checkNotNullParameter((Object)typedKey, (String)"typedKey");
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Sending readonly typed key: " + IPrintableKt.printToString((Object)typedKey) + ".");
        }
        this.sessionState.getExecuteReadonlyTypeAssist().fire((Object)typedKey);
    }

    public final void flushQueuedOperations() {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Flushing queued operations (" + this.queuedOperations.size() + ")...");
        }
        for (Operation op : this.queuedOperations) {
            this.sessionState.getExecute().fire((Object)op);
        }
        this.queuedOperations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void commitRemoteVersion$applyDiff(TypingSessionMediator this$0, List<RangePair> diff) {
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        try {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
            for (RangePair change : diff) {
                RangePairKt.applyChange(change, document2);
            }
        }
        finally {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
        }
    }

    private static final void commitRemoteVersion$applySelection(TypingSessionMediator this$0) {
        SelectionRange remoteSelection = this$0.lastRemoteSelection;
        if (remoteSelection != null) {
            PlatformTextControlUtilsKt.applyTo(remoteSelection, this$0.editor);
        }
        EditorModificationUtil.scrollToCaret((Editor)this$0.editor);
    }

    private static final void commitRemoteVersion$lambda$5$lambda$4$lambda$3(TypingSessionMediator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TypingSessionMediator.commitRemoteVersion$applySelection(this$0);
    }

    private static final void allowModifications$lambda$8(TypingSessionMediator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.endAllowModifications();
    }

    public static final /* synthetic */ void access$commitRemoteVersion$applyDiff(TypingSessionMediator this$0, List diff) {
        TypingSessionMediator.commitRemoteVersion$applyDiff(this$0, diff);
    }

    public static final /* synthetic */ void access$commitRemoteVersion$applySelection(TypingSessionMediator this$0) {
        TypingSessionMediator.commitRemoteVersion$applySelection(this$0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessionMediator$Companion;", "", "()V", "timestamp", "", "nextTimestamp", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final int nextTimestamp() {
            timestamp = timestamp + 1;
            return timestamp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

