/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ea;

import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.jetbrains.rider.ea.LogPacker;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tJ0\u0010\u0014\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J \u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/ea/LogPacker;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "collectTroubleshootingInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "copyFileSafely", "", "logFile", "Ljava/io/File;", "logFileCopy", "getFileTooHugeMessageBytes", "", "maxSizeToCopy", "", "packLogs", "packLogsImpl", "logsDirectory", "checkForInterrupt", "Lkotlin/Function0;", "", "writeBytesToTar", "raf", "Ljava/io/RandomAccessFile;", "bytesToWrite", "tar", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "writeToTar", "position", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nLogPacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogPacker.kt\ncom/jetbrains/rider/ea/LogPacker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n1313#2:181\n1314#2:186\n1#3:182\n1747#4,3:183\n13#5:187\n13#6:188\n*S KotlinDebug\n*F\n+ 1 LogPacker.kt\ncom/jetbrains/rider/ea/LogPacker\n*L\n51#1:181\n51#1:186\n59#1:183,3\n26#1:187\n26#1:188\n*E\n"})
public final class LogPacker {
    @NotNull
    public static final LogPacker INSTANCE = new LogPacker();
    @NotNull
    private static final Logger logger;

    private LogPacker() {
    }

    private final byte[] getFileTooHugeMessageBytes(long maxSizeToCopy) {
        String string = "\n-----------------------------------------------------------------------\nLog file is truncated, showing only first and last " + maxSizeToCopy / (long)2 / (long)1024 / (long)1024 + " megabytes.\nIn order to access full log please use 'Collect Logs' action and attach it manually.\n-----------------------------------------------------------------------\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public final File packLogsImpl(@Nullable Project project2, @NotNull File logsDirectory, long maxSizeToCopy, @NotNull Function0<Unit> checkForInterrupt) {
        Intrinsics.checkNotNullParameter((Object)logsDirectory, (String)"logsDirectory");
        Intrinsics.checkNotNullParameter(checkForInterrupt, (String)"checkForInterrupt");
        long currentTimeMillis = System.currentTimeMillis();
        File file2 = FileUtil.createTempFile((String)"rider-logs-attachment", (String)".tar.xz", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File logsFile2 = file2;
        logsFile2.deleteOnExit();
        byte[] fileTooHugeMessageBytes = this.getFileTooHugeMessageBytes(maxSizeToCopy);
        Closeable closeable = new FileOutputStream(logsFile2);
        int n = 153600;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream stream = (BufferedOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveOutputStream((OutputStream)new XZOutputStream((OutputStream)stream, (FilterOptions)new LZMA2Options(2)));
            Throwable throwable2 = null;
            try {
                TarArchiveOutputStream tar = (TarArchiveOutputStream)closeable2;
                boolean bl2 = false;
                tar.setLongFileMode(3);
                Object[] objectArray = new String[]{".txt", ".log", ".err", ".out", ".tdump"};
                List logExtensions = CollectionsKt.listOf((Object[])objectArray);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)logsDirectory, null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File logFileCopy;
                    Duration fileAge;
                    boolean bl3;
                    File logFile;
                    block29: {
                        File resolvedLogFile;
                        Object $this$packLogsImpl_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u240;
                        logFile = (File)element$iv;
                        boolean bl4 = false;
                        checkForInterrupt.invoke();
                        Logger logger = LogPacker.logger;
                        try {
                            $this$packLogsImpl_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u240 = logger;
                            boolean bl5 = false;
                            $this$packLogsImpl_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)logFile.toPath().toRealPath(new LinkOption[0]).toFile());
                        }
                        catch (Throwable bl5) {
                            $this$packLogsImpl_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                        }
                        if ((File)(Result.isFailure-impl((Object)(logger = $this$packLogsImpl_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u240)) ? null : logger) == null || !FileUtil.isAncestor((File)logsDirectory, (File)resolvedLogFile, (boolean)true) || !logFile.isFile()) continue;
                        Iterable $this$any$iv = logExtensions;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String it = (String)element$iv2;
                                boolean bl6 = false;
                                String string = logFile.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                if (!StringsKt.endsWith((String)string, (String)it, (boolean)true)) continue;
                                bl3 = true;
                                break block29;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3 || (fileAge = Duration.ofMillis(currentTimeMillis - logFile.lastModified())).compareTo(Duration.ofDays(1L)) > 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.createTempFile((String)logFile.getName(), (String)".tmp"), (String)"createTempFile(...)");
                    try {
                        if (!INSTANCE.copyFileSafely(logFile, logFileCopy)) {
                            continue;
                        }
                        TarArchiveEntry entry2 = new TarArchiveEntry(FilesKt.toRelativeString((File)logFile, (File)logsDirectory));
                        entry2.setModTime(logFile.lastModified() / (long)1000);
                        entry2.setSize(logFileCopy.length() <= maxSizeToCopy ? logFileCopy.length() : maxSizeToCopy + (long)fileTooHugeMessageBytes.length);
                        tar.putArchiveEntry(entry2);
                        Closeable closeable3 = new RandomAccessFile(logFileCopy, "r");
                        Throwable throwable3 = null;
                        try {
                            RandomAccessFile raf = (RandomAccessFile)closeable3;
                            boolean bl7 = false;
                            if (raf.length() <= maxSizeToCopy) {
                                INSTANCE.writeToTar(raf, 0L, tar);
                            } else {
                                long headSize = maxSizeToCopy / (long)2;
                                long tailSize = maxSizeToCopy - headSize;
                                INSTANCE.writeBytesToTar(raf, headSize, tar);
                                tar.write(fileTooHugeMessageBytes, 0, fileTooHugeMessageBytes.length);
                                long tailStartOffset = Math.max(0L, raf.length() - tailSize);
                                INSTANCE.writeToTar(raf, tailStartOffset, tar);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        tar.closeArchiveEntry();
                    }
                    finally {
                        logFileCopy.delete();
                    }
                }
                StringBuilder troubleshooting = INSTANCE.collectTroubleshootingInfo(project2);
                if (troubleshooting != null) {
                    String string = troubleshooting.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] troubleshootingBytes = byArray;
                    TarArchiveEntry entry3 = new TarArchiveEntry("troubleshooting.txt");
                    entry3.setModTime(new Date(System.currentTimeMillis()));
                    entry3.setSize((long)troubleshootingBytes.length);
                    tar.putArchiveEntry(entry3);
                    tar.write(troubleshootingBytes);
                    tar.closeArchiveEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return logsFile2;
    }

    private final boolean copyFileSafely(File logFile, File logFileCopy) {
        boolean bl;
        try {
            FileUtil.copyFileOrDir((File)logFile, (File)logFileCopy, (boolean)false);
            bl = true;
        }
        catch (Throwable t) {
            logger.warn(t);
            bl = false;
        }
        return bl;
    }

    private final void writeBytesToTar(RandomAccessFile raf, long bytesToWrite, TarArchiveOutputStream tar) {
        byte[] buffer = new byte[524288];
        int bytes = raf.read(buffer);
        long recorded = 0L;
        while (bytes >= 0 && recorded + (long)bytes < bytesToWrite) {
            tar.write(buffer, 0, bytes);
            recorded += (long)bytes;
            bytes = raf.read(buffer);
        }
        int toWrite = (int)Math.min((long)bytes, bytesToWrite - recorded);
        if (toWrite > 0) {
            tar.write(buffer, 0, toWrite);
        }
    }

    private final void writeToTar(RandomAccessFile raf, long position, TarArchiveOutputStream tar) {
        raf.seek(position);
        byte[] buffer = new byte[524288];
        int bytes = raf.read(buffer);
        while (bytes >= 0) {
            tar.write(buffer, 0, bytes);
            bytes = raf.read(buffer);
        }
    }

    private final StringBuilder collectTroubleshootingInfo(Project project2) {
        StringBuilder settings = null;
        if (project2 != null) {
            settings = new StringBuilder();
            settings.append(new CompositeGeneralTroubleInfoCollector().collectInfo(project2));
            for (TroubleInfoCollector troubleInfoCollector : (TroubleInfoCollector[])TroubleInfoCollector.EP_SETTINGS.getExtensions()) {
                settings.append(troubleInfoCollector.collectInfo(project2)).append('\n');
            }
        }
        return settings;
    }

    @NotNull
    public final File packLogs(@Nullable Project project2) {
        return this.packLogsImpl(project2, new File(PathManager.getLogPath()), 0x2800000L, (Function0<Unit>)((Function0)packLogs.1.INSTANCE));
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LogPacker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogPacker.logger = logger;
    }
}

