/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CommandModel;
import com.jetbrains.rd.ide.model.RdBackendCommand;
import com.jetbrains.rd.ide.model.RdCommandGroupId;
import com.jetbrains.rd.ide.model.RdCommandItem;
import com.jetbrains.rd.ide.model.RdDeleteGroupId;
import com.jetbrains.rd.ide.model.RdDocumentGroupId;
import com.jetbrains.rd.ide.model.RdEditGroupId;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorFinish;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorStart;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorUpdate;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RdTransparentGroupId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendTypeKeyRequest;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/document/RdCommandService;", "", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "commandFromBackend", "Lcom/jetbrains/rider/document/RdCommandService$Command;", "session", "Lcom/jetbrains/rider/document/RdCommandService$Session;", "finishCommand", "", "finish", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorFinish;", "getCommand", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "startCommand", "start", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorStart;", "startSession", "Lcom/intellij/openapi/application/AccessToken;", "startSessionIfThereIsCommandFromBackend", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "updateCommand", "update", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorUpdate;", "Command", "Companion", "MyCommandModelListener", "Session", "intellij.rider.rdclient.dotnet"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,293:1\n13#2:294\n*S KotlinDebug\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService\n*L\n39#1:294\n*E\n"})
public final class RdCommandService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession appSession;
    @Nullable
    private Command commandFromBackend;
    @Nullable
    private Session session;
    @NotNull
    private static final Logger logger;

    public RdCommandService(@NotNull ClientAppSession appSession) {
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        this.appSession = appSession;
    }

    @NotNull
    public final AccessToken startSession(@NotNull FrontendRdPatchHandlerContext context2) {
        Session session2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Session session3 = this.session;
        boolean bl = session3 != null ? session3.isAlive() : false;
        if (bl) {
            logger.error("An attempt to start a new session, but previous session: " + this.session + " is still alive");
            Session session4 = this.session;
            Intrinsics.checkNotNull((Object)((Object)session4));
            session4.finish();
        }
        if (context2.getOperation() instanceof PatchItemOperationType.Rollback || context2.getOperation() instanceof PatchItemOperationType.Merge) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        if (CollectionsKt.singleOrNull((List)context2.getPatch().getChanges()) instanceof RdCommandItem) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        Session $this$startSession_u24lambda_u240 = session2 = new Session(this.appSession);
        boolean bl2 = false;
        $this$startSession_u24lambda_u240.getLifetime().onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ RdCommandService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RdCommandService.access$setSession$p(this.this$0, null);
            }
        });
        Command command = this.getCommand(context2);
        if (command != null) {
            $this$startSession_u24lambda_u240.startNewCommand(command);
        }
        this.session = $this$startSession_u24lambda_u240;
        return session2;
    }

    @NotNull
    public final AccessToken startSessionIfThereIsCommandFromBackend() {
        Session session2;
        Session session3 = this.session;
        boolean bl = session3 != null ? session3.isAlive() : false;
        if (bl) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        Command command = this.commandFromBackend;
        if (command == null) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        Session $this$startSessionIfThereIsCommandFromBackend_u24lambda_u241 = session2 = new Session(this.appSession);
        boolean bl2 = false;
        $this$startSessionIfThereIsCommandFromBackend_u24lambda_u241.getLifetime().onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ RdCommandService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RdCommandService.access$setSession$p(this.this$0, null);
            }
        });
        $this$startSessionIfThereIsCommandFromBackend_u24lambda_u241.startNewCommand(command);
        this.session = $this$startSessionIfThereIsCommandFromBackend_u24lambda_u241;
        return session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T startSessionIfThereIsCommandFromBackend(@NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        AutoCloseable autoCloseable = (AutoCloseable)this.startSessionIfThereIsCommandFromBackend();
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            Object object = action2.invoke();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Command getCommand(FrontendRdPatchHandlerContext context) {
        block7: {
            block9: {
                block8: {
                    v0 = this.commandFromBackend;
                    if (v0 != null) break block7;
                    $this$getCommand_u24lambda_u243 = this;
                    $i$a$-run-RdCommandService$getCommand$1 = false;
                    request = context.getRequest();
                    if (!(request instanceof FrontendAsyncRequestWithImmediateResult)) {
                        return null;
                    }
                    var5_5 = (FrontendAsyncRequestWithImmediateResult)request;
                    if (!(var5_5 instanceof FrontendTypeKeyRequest)) break block8;
                    v0 = new Command("Typing", ((FrontendTypeKeyRequest)request).getEditorId().getProjectId(), (RdCommandGroupId)new RdDocumentGroupId(((FrontendTypeKeyRequest)request).getEditorId().getDocumentId()), false);
                    break block7;
                }
                if (!(var5_5 instanceof FrontendCallEditorActionRequest)) break block9;
                var6_6 = ((FrontendCallEditorActionRequest)request).getFrontendActionId();
                switch (var6_6.hashCode()) {
                    case 152646344: {
                        if (var6_6.equals("EditorTab")) break;
                        ** break;
                    }
                    case -1337106024: {
                        if (!var6_6.equals("EditorDelete")) {
                            ** break;
                        }
                        ** GOTO lbl25
                    }
                    case -516098734: {
                        if (!var6_6.equals("EditorBackSpace")) ** break;
lbl25:
                        // 2 sources

                        v0 = new Command(((FrontendCallEditorActionRequest)request).getFrontendActionId(), ((FrontendCallEditorActionRequest)request).getEditorId().getProjectId(), (RdCommandGroupId)new RdDeleteGroupId(), false);
                        break block7;
                    }
                }
                v0 = new Command(((FrontendCallEditorActionRequest)request).getFrontendActionId(), ((FrontendCallEditorActionRequest)request).getEditorId().getProjectId(), (RdCommandGroupId)new RdEditGroupId(), false);
                break block7;
lbl29:
                // 4 sources

                v0 = null;
                break block7;
            }
            v0 = null;
        }
        return v0;
    }

    public final void startCommand(@NotNull RdPatchCommandDescriptorStart start2) {
        block0: {
            Command command;
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            this.commandFromBackend = command = new Command(start2.getName(), start2.getProjectId(), start2.getGroupId(), start2.isNavigatable());
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.startNewCommand(command);
        }
    }

    public final void updateCommand(@NotNull RdPatchCommandDescriptorUpdate update2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Command command = this.commandFromBackend;
            logger.assertTrue(command != null, (Object)"commandFromBackend must not be null");
            Command command2 = command;
            Intrinsics.checkNotNull((Object)command2);
            this.commandFromBackend = Command.copy$default(command2, update2.getName(), null, update2.getGroupId(), false, 10, null);
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.updateCurrentCommand(update2);
        }
    }

    public final void finishCommand(@NotNull RdPatchCommandDescriptorFinish finish) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)finish, (String)"finish");
            this.commandFromBackend = null;
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.finishCurrentCommand();
        }
    }

    public static final /* synthetic */ void access$setCommandFromBackend$p(RdCommandService $this, Command command) {
        $this.commandFromBackend = command;
    }

    public static final /* synthetic */ Command access$getCommandFromBackend$p(RdCommandService $this) {
        return $this.commandFromBackend;
    }

    public static final /* synthetic */ void access$setSession$p(RdCommandService $this, Session session2) {
        $this.session = session2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdCommandService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RdCommandService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Command;", "", "name", "", "projectId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "groupId", "Lcom/jetbrains/rd/ide/model/RdCommandGroupId;", "isNavigation", "", "(Ljava/lang/String;Lcom/jetbrains/rd/ide/model/RdProjectId;Lcom/jetbrains/rd/ide/model/RdCommandGroupId;Z)V", "getGroupId", "()Lcom/jetbrains/rd/ide/model/RdCommandGroupId;", "()Z", "setNavigation", "(Z)V", "isTransparent", "getName", "()Ljava/lang/String;", "getProjectId", "()Lcom/jetbrains/rd/ide/model/RdProjectId;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
    private static final class Command {
        @NotNull
        private final String name;
        @Nullable
        private final RdProjectId projectId;
        @Nullable
        private final RdCommandGroupId groupId;
        private boolean isNavigation;

        public Command(@NotNull String name, @Nullable RdProjectId projectId, @Nullable RdCommandGroupId groupId, boolean isNavigation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.projectId = projectId;
            this.groupId = groupId;
            this.isNavigation = isNavigation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final RdProjectId getProjectId() {
            return this.projectId;
        }

        @Nullable
        public final RdCommandGroupId getGroupId() {
            return this.groupId;
        }

        public final boolean isNavigation() {
            return this.isNavigation;
        }

        public final void setNavigation(boolean bl) {
            this.isNavigation = bl;
        }

        public final boolean isTransparent() {
            return this.groupId instanceof RdTransparentGroupId;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final RdProjectId component2() {
            return this.projectId;
        }

        @Nullable
        public final RdCommandGroupId component3() {
            return this.groupId;
        }

        public final boolean component4() {
            return this.isNavigation;
        }

        @NotNull
        public final Command copy(@NotNull String name, @Nullable RdProjectId projectId, @Nullable RdCommandGroupId groupId, boolean isNavigation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Command(name, projectId, groupId, isNavigation);
        }

        public static /* synthetic */ Command copy$default(Command command, String string, RdProjectId rdProjectId, RdCommandGroupId rdCommandGroupId, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = command.name;
            }
            if ((n & 2) != 0) {
                rdProjectId = command.projectId;
            }
            if ((n & 4) != 0) {
                rdCommandGroupId = command.groupId;
            }
            if ((n & 8) != 0) {
                bl = command.isNavigation;
            }
            return command.copy(string, rdProjectId, rdCommandGroupId, bl);
        }

        @NotNull
        public String toString() {
            return "Command(name=" + this.name + ", projectId=" + this.projectId + ", groupId=" + this.groupId + ", isNavigation=" + this.isNavigation + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.projectId == null ? 0 : this.projectId.hashCode());
            result2 = result2 * 31 + (this.groupId == null ? 0 : this.groupId.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isNavigation);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Command)) {
                return false;
            }
            Command command = (Command)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)command.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectId, (Object)command.projectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)command.groupId)) {
                return false;
            }
            return this.isNavigation == command.isNavigation;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Companion;", "", "()V", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "getCommandProcessor", "()Lcom/intellij/openapi/command/CommandProcessorEx;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/document/RdCommandService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "toGroupId", "Lcom/jetbrains/rd/ide/model/RdCommandGroupId;", "appSession", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,293:1\n23#2:294\n*S KotlinDebug\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Companion\n*L\n42#1:294\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CommandProcessorEx getCommandProcessor() {
            CommandProcessor commandProcessor2 = CommandProcessor.getInstance();
            Intrinsics.checkNotNull((Object)commandProcessor2, (String)"null cannot be cast to non-null type com.intellij.openapi.command.CommandProcessorEx");
            return (CommandProcessorEx)commandProcessor2;
        }

        @NotNull
        public final RdCommandService getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(RdCommandService.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (RdCommandService)object;
        }

        private final Object toGroupId(RdCommandGroupId $this$toGroupId, ClientAppSession appSession) {
            Object object;
            RdCommandGroupId rdCommandGroupId = $this$toGroupId;
            if (rdCommandGroupId instanceof RdBackendCommand) {
                object = ((RdBackendCommand)$this$toGroupId).getId();
            } else if (rdCommandGroupId instanceof RdDeleteGroupId) {
                object = EditorActionUtil.DELETE_COMMAND_GROUP;
            } else if (rdCommandGroupId instanceof RdEditGroupId) {
                object = EditorActionUtil.EDIT_COMMAND_GROUP;
            } else if (rdCommandGroupId instanceof RdDocumentGroupId) {
                DocumentSynchronizer documentSynchronizer2 = FrontendDocumentHost.Companion.getInstance(appSession).getSynchronizer(((RdDocumentGroupId)$this$toGroupId).getDocumentId());
                object = documentSynchronizer2 != null ? documentSynchronizer2.getDocument() : null;
            } else {
                if (rdCommandGroupId instanceof RdTransparentGroupId) {
                    logger.error("RdTransparentGroupId cannot be used as a group id");
                    return null;
                }
                logger.error("Unknown group id: " + $this$toGroupId);
                return null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$MyCommandModelListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/CommandModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class MyCommandModelListener
    implements RootExtListener<CommandModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientAppSession session2, @NotNull CommandModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Property property = new Property(null);
            InterfacesKt.viewNotNull((IViewable)((IViewable)property), (Lifetime)lifetime2, (Function2)((Function2)new Function2<Lifetime, RdPatchCommandDescriptorStart, Unit>(session2){
                final /* synthetic */ ClientAppSession $session;
                {
                    this.$session = $session;
                    super(2);
                }

                public final void invoke(@NotNull Lifetime commandLifetime, @NotNull RdPatchCommandDescriptorStart start2) {
                    Intrinsics.checkNotNullParameter((Object)commandLifetime, (String)"commandLifetime");
                    Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
                    RdCommandService instance2 = RdCommandService.Companion.getInstance(this.$session);
                    Command command = new Command(start2.getName(), start2.getProjectId(), start2.getGroupId(), start2.isNavigatable());
                    commandLifetime.bracketOrThrow((Function0)new Function0<Unit>(instance2, command){
                        final /* synthetic */ RdCommandService $instance;
                        final /* synthetic */ Command $command;
                        {
                            this.$instance = $instance;
                            this.$command = $command;
                            super(0);
                        }

                        public final void invoke() {
                            RdCommandService.access$setCommandFromBackend$p(this.$instance, this.$command);
                        }
                    }, (Function0)new Function0<Unit>(instance2, command){
                        final /* synthetic */ RdCommandService $instance;
                        final /* synthetic */ Command $command;
                        {
                            this.$instance = $instance;
                            this.$command = $command;
                            super(0);
                        }

                        public final void invoke() {
                            if (RdCommandService.access$getCommandFromBackend$p(this.$instance) == this.$command) {
                                RdCommandService.access$setCommandFromBackend$p(this.$instance, null);
                            }
                        }
                    });
                }
            }));
            model.getOverrideCommandFromBackend().advise(lifetime2, (Function1)new Function1<RdPatchCommandDescriptorStart, Unit>((Property<RdPatchCommandDescriptorStart>)property){
                final /* synthetic */ Property<RdPatchCommandDescriptorStart> $property;
                {
                    this.$property = $property;
                    super(1);
                }

                public final void invoke(@Nullable RdPatchCommandDescriptorStart it) {
                    this.$property.set((Object)it);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Session;", "Lcom/intellij/openapi/application/AccessToken;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "def", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "isAlive", "", "()Z", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "finish", "", "finishCurrentCommand", "startCommandAndGetClosable", "Ljava/lang/AutoCloseable;", "command", "Lcom/jetbrains/rider/document/RdCommandService$Command;", "startNewCommand", "updateCurrentCommand", "update", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorUpdate;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
    private static final class Session
    extends AccessToken {
        @NotNull
        private final ClientAppSession appSession;
        @NotNull
        private final LifetimeDefinition def;
        @NotNull
        private final SequentialLifetimes lifetimes;

        public Session(@NotNull ClientAppSession appSession) {
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            this.appSession = appSession;
            this.def = new LifetimeDefinition();
            this.lifetimes = new SequentialLifetimes(this.def.getLifetime());
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.def.getLifetime();
        }

        public final boolean isAlive() {
            return RLifetimeKt.isAlive((Lifetime)this.def.getLifetime());
        }

        public final void startNewCommand(@NotNull Command command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            LifetimeDefinition lifetime2 = this.lifetimes.next();
            AutoCloseable token = this.startCommandAndGetClosable(command);
            if (token != null) {
                lifetime2.onTermination((Function0)new Function0<Unit>(token){
                    final /* synthetic */ AutoCloseable $token;
                    {
                        this.$token = $token;
                        super(0);
                    }

                    public final void invoke() {
                        this.$token.close();
                    }
                });
            }
        }

        private final AutoCloseable startCommandAndGetClosable(Command command) {
            FileEditor fileEditor;
            Project project2;
            if (command.isTransparent()) {
                return Companion.getCommandProcessor().withUndoTransparentAction();
            }
            RdProjectId rdProjectId = command.getProjectId();
            Project project3 = project2 = rdProjectId != null ? ProjectUtilKt.toProjectOrNull((RdProjectId)rdProjectId) : null;
            if (project3 != null) {
                Project it = project3;
                boolean bl = false;
                fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
            } else {
                fileEditor = null;
            }
            FileEditor selectedEditorBeforeCommand = fileEditor;
            RdCommandGroupId rdCommandGroupId = command.getGroupId();
            Object groupId = rdCommandGroupId != null ? Companion.toGroupId(rdCommandGroupId, this.appSession) : null;
            CommandToken commandToken = Companion.getCommandProcessor().startCommand(project2, command.getName(), groupId, UndoConfirmationPolicy.DEFAULT);
            if (commandToken == null) {
                return null;
            }
            CommandToken token = commandToken;
            AccessToken allowMergeGlobalCommandsToken = Companion.getCommandProcessor().allowMergeGlobalCommands();
            return () -> Session.startCommandAndGetClosable$lambda$1(command, project2, selectedEditorBeforeCommand, token, allowMergeGlobalCommandsToken);
        }

        public final void finishCurrentCommand() {
            this.lifetimes.terminateCurrent();
        }

        public void finish() {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.def, (boolean)false, (int)1, null);
        }

        public final void updateCurrentCommand(@NotNull RdPatchCommandDescriptorUpdate update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Companion.getCommandProcessor().setCurrentCommandName(update2.getName());
            Companion.getCommandProcessor().setCurrentCommandGroupId((Object)update2.getGroupId());
        }

        private static final void startCommandAndGetClosable$lambda$1(Command $command, Project $project, FileEditor $selectedEditorBeforeCommand, CommandToken $token, AccessToken $allowMergeGlobalCommandsToken) {
            Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
            Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
            if ($command.isNavigation() && $project != null) {
                FileEditor selectedEditor = FileEditorManager.getInstance((Project)$project).getSelectedEditor();
                if (!Intrinsics.areEqual((Object)selectedEditor, (Object)$selectedEditorBeforeCommand)) {
                    IdeDocumentHistory.getInstance((Project)$project).setCurrentCommandHasMoves();
                }
                IdeDocumentHistory.getInstance((Project)$project).includeCurrentCommandAsNavigation();
            }
            Companion.getCommandProcessor().finishCommand($token, null);
            $allowMergeGlobalCommandsToken.finish();
        }
    }
}

