/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.CommandDescriptor;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.document.FrontendCommandsHost;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0016\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013J\u0012\u0010$\u001a\u0004\u0018\u00010\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020\"H\u0002J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "getCommandProcessor", "()Lcom/intellij/openapi/command/CommandProcessorEx;", "commandProcessor$delegate", "Lkotlin/Lazy;", "guard", "", "ignoredCommands", "", "", "policy", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "suppressionReqs", "", "bind", "", "commandProcessorModel", "Lcom/jetbrains/rd/ide/model/RdCommandProcessor;", "finishCommand", "command", "Lcom/intellij/openapi/command/CommandToken;", "commandName", "setCustomUndoConfirmationPolicy", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "customPolicy", "startCommand", "cmdDescriptor", "Lcom/jetbrains/rd/ide/model/CommandDescriptor;", "startFrontendCommand", "lt", "suppress", "Companion", "ProtocolListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendCommandsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost\n+ 2 Logger.kt\ncom/jetbrains/rdclient/util/idea/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n6#2:137\n13#3:138\n13#4:139\n*S KotlinDebug\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost\n*L\n31#1:137\n31#1:138\n31#1:139\n*E\n"})
public final class FrontendCommandsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Logger LOG;
    @NotNull
    private UndoConfirmationPolicy policy;
    private boolean guard;
    private int suppressionReqs;
    @NotNull
    private final Lazy commandProcessor$delegate;
    @NotNull
    private final Set<String> ignoredCommands;

    public FrontendCommandsHost(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        boolean $i$f$getLogger = false;
        boolean $i$f$getLogger2 = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendCommandsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.policy = UndoConfirmationPolicy.DEFAULT;
        this.commandProcessor$delegate = LazyKt.lazy((Function0)commandProcessor.2.INSTANCE);
        Object[] objectArray = new String[]{"Go to next hotspot", "Go to previous hotspot", "Hostpot.Update"};
        this.ignoredCommands = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    private final CommandProcessorEx getCommandProcessor() {
        Lazy lazy = this.commandProcessor$delegate;
        return (CommandProcessorEx)lazy.getValue();
    }

    private final void bind(RdCommandProcessor commandProcessorModel) {
        InterfacesKt.viewNotNull((IViewable)((IViewable)commandProcessorModel.getCurrentCommand()), (Lifetime)this.getServiceLifetime(), (Function2)((Function2)new Function2<Lifetime, CommandDescriptor, Unit>(this){
            final /* synthetic */ FrontendCommandsHost this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull CommandDescriptor cmdDescriptor) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)cmdDescriptor, (String)"cmdDescriptor");
                if (FrontendCommandsHost.access$getSuppressionReqs$p(this.this$0) > 0) {
                    Logger $this$trace$iv = FrontendCommandsHost.access$getLOG$p(this.this$0);
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Command execution is suppressed, skipping command with name " + cmdDescriptor.getName() + ".");
                    }
                    return;
                }
                if (PatchEngineRegistryKt.isPatchEngineEnabled() && FrontendCommandsHost.access$getIgnoredCommands$p(this.this$0).contains(cmdDescriptor.getName())) {
                    Logger $this$trace$iv = FrontendCommandsHost.access$getLOG$p(this.this$0);
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Ignore command " + cmdDescriptor.getName());
                    }
                    return;
                }
                FrontendCommandsHost.access$startFrontendCommand(this.this$0, cmdDescriptor, lt);
            }
        }));
    }

    public final void suppress(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        ApplicationManager.getApplication().assertIsDispatchThread();
        lifetime2.bracket((Function0)new Function0<Integer>(this){
            final /* synthetic */ FrontendCommandsHost this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                boolean bl;
                boolean bl2 = bl = FrontendCommandsHost.access$getSuppressionReqs$p(this.this$0) >= 0;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                FrontendCommandsHost frontendCommandsHost = this.this$0;
                int n = FrontendCommandsHost.access$getSuppressionReqs$p(frontendCommandsHost);
                FrontendCommandsHost.access$setSuppressionReqs$p(frontendCommandsHost, n + 1);
                return n;
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendCommandsHost this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean bl2 = bl = FrontendCommandsHost.access$getSuppressionReqs$p(this.this$0) >= 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                FrontendCommandsHost frontendCommandsHost = this.this$0;
                int n = FrontendCommandsHost.access$getSuppressionReqs$p(frontendCommandsHost);
                FrontendCommandsHost.access$setSuppressionReqs$p(frontendCommandsHost, n + -1);
            }
        });
    }

    private final void startFrontendCommand(CommandDescriptor cmdDescriptor, Lifetime lt) {
        CommandToken commandToken = this.startCommand(cmdDescriptor);
        if (commandToken == null) {
            return;
        }
        CommandToken command = commandToken;
        lt.onTermination((Function0)new Function0<Unit>(this, command, cmdDescriptor){
            final /* synthetic */ FrontendCommandsHost this$0;
            final /* synthetic */ CommandToken $command;
            final /* synthetic */ CommandDescriptor $cmdDescriptor;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                this.$cmdDescriptor = $cmdDescriptor;
                super(0);
            }

            public final void invoke() {
                FrontendCommandsHost.access$finishCommand(this.this$0, this.$command, this.$cmdDescriptor.getName());
            }
        });
    }

    private final void finishCommand(CommandToken command, String commandName) {
        if (this.getCommandProcessor().getCurrentCommand() != null) {
            this.getCommandProcessor().finishCommand(command, null);
        } else {
            this.LOG.error("The command '" + commandName + "' has already been interrupted by frontend.");
        }
        this.LOG.debug("<<< End command " + commandName);
    }

    private final CommandToken startCommand(CommandDescriptor cmdDescriptor) {
        String commandName = cmdDescriptor.component1();
        boolean isNavigation = cmdDescriptor.component2();
        boolean isTypingPostProcessor = cmdDescriptor.component3();
        if (this.getCommandProcessor().getCurrentCommand() != null && isTypingPostProcessor) {
            this.LOG.debug("isTypingPostProcessor received. Tearing apart outer command");
            TypedAction typedAction = TypedAction.getInstance();
            Intrinsics.checkNotNull((Object)typedAction, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.TypedActionImpl");
            DefaultRawTypedHandler handler2 = ((TypedActionImpl)typedAction).getDefaultRawTypedHandler();
            handler2.beginUndoablePostProcessing();
            return null;
        }
        ClientProjectSession projectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)this.session.getProjectSessions());
        this.LOG.debug(">>> Start command " + commandName);
        ClientProjectSession clientProjectSession = projectSession;
        CommandToken command = this.getCommandProcessor().startCommand((Project)(clientProjectSession != null ? clientProjectSession.getProject() : null), commandName, null, this.policy);
        if (isNavigation) {
            if (projectSession == null) {
                this.LOG.error("There is not project session for command: " + commandName);
            } else {
                IdeDocumentHistory.getInstance((Project)projectSession.getProject()).includeCurrentCommandAsNavigation();
            }
        }
        if (command == null) {
            this.LOG.debug("<<< End command " + commandName + ": (The command is nested into " + this.getCommandProcessor().getCurrentCommandName() + ". Do nothing)");
            return null;
        }
        return command;
    }

    public final void setCustomUndoConfirmationPolicy(@NotNull Lifetime lifetime2, @NotNull UndoConfirmationPolicy customPolicy) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)customPolicy, (String)"customPolicy");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.LOG.assertTrue(!this.guard);
        this.guard = true;
        UndoConfirmationPolicy oldPolicy = this.policy;
        this.policy = customPolicy;
        lifetime2.onTermination((Function0)new Function0<Unit>(this, oldPolicy){
            final /* synthetic */ FrontendCommandsHost this$0;
            final /* synthetic */ UndoConfirmationPolicy $oldPolicy;
            {
                this.this$0 = $receiver;
                this.$oldPolicy = $oldPolicy;
                super(0);
            }

            public final void invoke() {
                FrontendCommandsHost.access$setPolicy$p(this.this$0, this.$oldPolicy);
                FrontendCommandsHost.access$setGuard$p(this.this$0, false);
            }
        });
    }

    public static final /* synthetic */ int access$getSuppressionReqs$p(FrontendCommandsHost $this) {
        return $this.suppressionReqs;
    }

    public static final /* synthetic */ Logger access$getLOG$p(FrontendCommandsHost $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ Set access$getIgnoredCommands$p(FrontendCommandsHost $this) {
        return $this.ignoredCommands;
    }

    public static final /* synthetic */ void access$startFrontendCommand(FrontendCommandsHost $this, CommandDescriptor cmdDescriptor, Lifetime lt) {
        $this.startFrontendCommand(cmdDescriptor, lt);
    }

    public static final /* synthetic */ void access$setSuppressionReqs$p(FrontendCommandsHost $this, int n) {
        $this.suppressionReqs = n;
    }

    public static final /* synthetic */ void access$finishCommand(FrontendCommandsHost $this, CommandToken command, String commandName) {
        $this.finishCommand(command, commandName);
    }

    public static final /* synthetic */ void access$setPolicy$p(FrontendCommandsHost $this, UndoConfirmationPolicy undoConfirmationPolicy) {
        $this.policy = undoConfirmationPolicy;
    }

    public static final /* synthetic */ void access$setGuard$p(FrontendCommandsHost $this, boolean bl) {
        $this.guard = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/document/FrontendCommandsHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFrontendCommandsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,136:1\n23#2:137\n*S KotlinDebug\n*F\n+ 1 FrontendCommandsHost.kt\ncom/jetbrains/rider/document/FrontendCommandsHost$Companion\n*L\n28#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendCommandsHost getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project2).getAppSession());
        }

        @NotNull
        public final FrontendCommandsHost getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(FrontendCommandsHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (FrontendCommandsHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/FrontendCommandsHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientAppSession session2, @NotNull DocumentsOperationModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            RdCommandProcessor commandProcessorModel = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)model);
            Companion.getInstance(session2).bind(commandProcessorModel);
        }
    }
}

