/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.document.DocumentHostHelper;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.editors.EditorSynchronizerWithTypingSession;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "documentsToRecover", "Ljava/util/HashSet;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lkotlin/collections/HashSet;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "operationModel", "Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "getOperationModel", "()Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "recoveringQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "bindModel", "", "processBeforeSaving", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "saveDocument", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "saveDocumentForceUndo", "BeforeDocumentSavedListener", "Companion", "ProtocolListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDocumentHostHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,201:1\n13#2:202\n13#3:203\n65#3,4:204\n*S KotlinDebug\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper\n*L\n51#1:202\n51#1:203\n170#1:204,4\n*E\n"})
public final class DocumentHostHelper
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final Disposable disposable;
    private final MergingUpdateQueue recoveringQueue;
    @NotNull
    private final HashSet<RdDocumentId> documentsToRecover;
    @NotNull
    private final Logger logger;

    public DocumentHostHelper(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null);
        this.recoveringQueue = new MergingUpdateQueue("recoverQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, true).setRestartTimerOnAdd(true);
        this.documentsToRecover = new HashSet();
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DocumentHostHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    private final RiderProjectDocumentOperationModel getOperationModel() {
        return RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this.session));
    }

    private final void bindModel() {
        this.getOperationModel().getDoNotStripFiles().view(this.getServiceLifetime(), (Function3)bindModel.1.INSTANCE);
        this.getOperationModel().getNeedRecover().advise(this.getServiceLifetime(), (Function1)new Function1<RdDocumentId, Unit>(this){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdDocumentId documentId) {
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger $this$trace$iv = DocumentHostHelper.access$getLogger$p(this.this$0);
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Received needRecover command for " + DocumentExKt.toDebugString((RdDocumentId)documentId) + " document...");
                }
                DocumentHostHelper.access$getDocumentsToRecover$p(this.this$0).add(documentId);
                String string = "queue recover " + DocumentExKt.toDebugString((RdDocumentId)documentId);
                DocumentHostHelper.access$getRecoveringQueue$p(this.this$0).queue(new Update(this.this$0, string){
                    final /* synthetic */ DocumentHostHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super((Object)$super_call_param$1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public void run() {
                        try {
                            void $this$forEach$iv;
                            ApplicationKt.getApplication().assertIsDispatchThread();
                            Iterable iterable = DocumentHostHelper.access$getDocumentsToRecover$p(this.this$0);
                            DocumentHostHelper documentHostHelper = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                RdDocumentId entityId = (RdDocumentId)element$iv;
                                boolean bl = false;
                                TypingSessions.Companion.getInstance(DocumentHostHelper.access$getSession$p(documentHostHelper)).forceCloseActiveSession("recovering");
                                EditorSynchronizerWithTypingSession.Companion.recoverEditorsSynchronization(entityId, DocumentHostHelper.access$getSession$p(documentHostHelper).getAppSession());
                            }
                        }
                        catch (Throwable t) {
                            DocumentHostHelper.access$getLogger$p(this.this$0).warn("Exception while recovering document:\n", t);
                        }
                        finally {
                            DocumentHostHelper.access$getDocumentsToRecover$p(this.this$0).clear();
                        }
                    }
                });
            }
        });
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveAll()), null, null, (Function2)((Function2)new Function2<Lifetime, Boolean, RdTask<Boolean>>(this){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final RdTask<Boolean> invoke(@NotNull Lifetime lifetime2, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"<anonymous parameter 0>");
                DocumentHostHelper.access$getLogger$p(this.this$0).info("saveAll command received...");
                ApplicationKt.getApplication().saveAll();
                DocumentHostHelper.access$getLogger$p(this.this$0).info("saveAll command has finished");
                RdTask result2 = new RdTask();
                result2.set((Object)true);
                return result2;
            }
        }), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveAllEditorsAfterBackendSync()), null, null, (Function2)((Function2)new Function2<Lifetime, Boolean, RdTask<Boolean>>(this){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final RdTask<Boolean> invoke(@NotNull Lifetime lifetime2, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"<anonymous parameter 0>");
                if (!(CommandProcessor.getInstance().getCurrentCommand() == null)) {
                    boolean bl2 = false;
                    String string = "Cannot call 'save all files' inside " + CommandProcessor.getInstance().getCurrentCommandName() + " command. This can potentially break the undo stack.";
                    throw new IllegalArgumentException(string.toString());
                }
                RdTask task = new RdTask();
                RiderBackendInteractionHelper.Companion.getInstance(DocumentHostHelper.access$getSession$p(this.this$0).getAppSession()).onSyncFromBackendFinished(DocumentHostHelper.access$getServiceLifetime(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>((RdTask<Boolean>)task){
                    final /* synthetic */ RdTask<Boolean> $task;
                    {
                        this.$task = $task;
                        super(0);
                    }

                    public final void invoke() {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        this.$task.set((Object)true);
                    }
                }));
                return task;
            }
        }), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveFileAfterBackendSync()), null, null, (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String filePath) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                try {
                    Logger $this$trace$iv = DocumentHostHelper.access$getLogger$p(this.this$0);
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Got saveFileAfterBackendSync command for the file " + filePath + "...");
                    }
                    VirtualFile virtualFile2 = DocumentUtilKt.toVirtualFile(filePath, true);
                    if (virtualFile2 == null) {
                        return false;
                    }
                    VirtualFile virtualFile3 = virtualFile2;
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile3);
                    if (document == null) {
                        return false;
                    }
                    Document document2 = document;
                    RiderBackendInteractionHelper.Companion.getInstance(DocumentHostHelper.access$getSession$p(this.this$0).getAppSession()).onSyncFromBackendFinished(DocumentHostHelper.access$getServiceLifetime(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, virtualFile3, document2){
                        final /* synthetic */ DocumentHostHelper this$0;
                        final /* synthetic */ VirtualFile $virtualFile;
                        final /* synthetic */ Document $document;
                        {
                            this.this$0 = $receiver;
                            this.$virtualFile = $virtualFile;
                            this.$document = $document;
                            super(0);
                        }

                        public final void invoke() {
                            DocumentHostHelper.access$saveDocument(this.this$0, this.$virtualFile, this.$document);
                        }
                    }));
                    return true;
                }
                catch (Throwable t) {
                    DocumentHostHelper.access$getLogger$p(this.this$0).error(t);
                    return false;
                }
            }
        }), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveFiles()), null, null, (Function1)((Function1)new Function1<List<? extends String>, Boolean>(this){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull List<String> filePaths) {
                Logger logger;
                Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
                boolean result2 = true;
                Logger $this$trace$iv = DocumentHostHelper.access$getLogger$p(this.this$0);
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Got saveFiles command for " + ((Collection)filePaths).size() + " files");
                }
                for (String filePath : filePaths) {
                    try {
                        Logger $this$trace$iv2 = DocumentHostHelper.access$getLogger$p(this.this$0);
                        boolean $i$f$trace2 = false;
                        if ($this$trace$iv2.isTraceEnabled()) {
                            logger = $this$trace$iv2;
                            boolean bl = false;
                            logger.trace("Saving file " + filePath + " right away...");
                        }
                        VirtualFile virtualFile2 = DocumentUtilKt.toVirtualFile(filePath, true);
                        if (virtualFile2 == null) {
                            DocumentHostHelper.access$getLogger$p(this.this$0).trace("Couldn't find vf by path " + filePath);
                            continue;
                        }
                        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
                        if (document == null) {
                            DocumentHostHelper.access$getLogger$p(this.this$0).trace("Couldn't find document for vf " + virtualFile2);
                            continue;
                        }
                        DocumentHostHelper.access$saveDocument(this.this$0, virtualFile2, document);
                    }
                    catch (Throwable t) {
                        DocumentHostHelper.access$getLogger$p(this.this$0).error("error while saving document " + filePath + ". Exception:\n" + t);
                        result2 = false;
                    }
                }
                return result2;
            }
        }), (int)3, null);
    }

    private final void saveDocument(VirtualFile virtualFile2, Document document) {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Syncing from backend is finished, no editors found for this document -> do save file " + virtualFile2.getPath());
        }
        this.saveDocumentForceUndo(document, virtualFile2);
    }

    private final void saveDocumentForceUndo(Document document, VirtualFile virtualFile2) {
        UndoUtil.forceUndoIn((VirtualFile)virtualFile2, () -> DocumentHostHelper.saveDocumentForceUndo$lambda$1(document));
    }

    private final void processBeforeSaving(Project project2, Document document) {
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        ApplicationKt.getApplication().invokeLater(() -> DocumentHostHelper.processBeforeSaving$lambda$2(project2, document, this, file2));
    }

    private static final void saveDocumentForceUndo$lambda$1(Document $document) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        FileDocumentManager.getInstance().saveDocumentAsIs($document);
    }

    private static final void processBeforeSaving$lambda$2(Project $project, Document $document, DocumentHostHelper this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        if ($project.isDisposed()) {
            return;
        }
        if (LookupManagerImpl.getInstance((Project)$project).getActiveLookup() == null) {
            Editor[] editorArray = EditorFactory.getInstance().getEditors($document, $project);
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
            for (Editor openedEditor : editorArray) {
                PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance($project);
                Intrinsics.checkNotNull((Object)openedEditor);
                preemptiveCompletionHost.terminateCurrentCompletion(openedEditor, "Save document on disk");
            }
        }
        ISignal<String> iSignal = this$0.getOperationModel().getAfterDocumentInEditorSaved();
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        iSignal.fire((Object)string);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DocumentHostHelper $this) {
        return $this.logger;
    }

    public static final /* synthetic */ HashSet access$getDocumentsToRecover$p(DocumentHostHelper $this) {
        return $this.documentsToRecover;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getRecoveringQueue$p(DocumentHostHelper $this) {
        return $this.recoveringQueue;
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(DocumentHostHelper $this) {
        return $this.session;
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(DocumentHostHelper $this) {
        return $this.getServiceLifetime();
    }

    public static final /* synthetic */ void access$saveDocument(DocumentHostHelper $this, VirtualFile virtualFile2, Document document) {
        $this.saveDocument(virtualFile2, document);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$BeforeDocumentSavedListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "beforeDocumentSaving", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rider.rdclient.dotnet"})
    public static final class BeforeDocumentSavedListener
    implements FileDocumentManagerListener {
        @NotNull
        private final Project project;

        public BeforeDocumentSavedListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void beforeDocumentSaving(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Companion.getInstance(this.project).processBeforeSaving(this.project, document);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/document/DocumentHostHelper;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nDocumentHostHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,201:1\n23#2:202\n*S KotlinDebug\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper$Companion\n*L\n42#1:202\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentHostHelper getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project2));
        }

        @NotNull
        public final DocumentHostHelper getInstance(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(DocumentHostHelper.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (DocumentHostHelper)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements SolutionExtListener<RiderProjectDocumentOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session2, @NotNull RiderProjectDocumentOperationModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Companion.getInstance(session2).bindModel();
        }
    }
}

