/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001e\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/diagnostics/SpecialPathEntry;", "", "name", "", "originalPath", "kind", "Lcom/jetbrains/rider/diagnostics/SpecialPathEntry$Kind;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/rider/diagnostics/SpecialPathEntry$Kind;)V", "getKind", "()Lcom/jetbrains/rider/diagnostics/SpecialPathEntry$Kind;", "getName", "()Ljava/lang/String;", "path", "getPath", "component1", "component2", "component3", "copy", "equals", "", "other", "getContextActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "closeAction", "Lkotlin/Function0;", "", "hashCode", "", "open", "openDirectory", "openInEditor", "toString", "Kind", "intellij.rider.rdclient.dotnet"})
public final class SpecialPathEntry {
    @NotNull
    private final String name;
    @NotNull
    private final String originalPath;
    @NotNull
    private final Kind kind;
    @NotNull
    private final String path;

    public SpecialPathEntry(@NotNull String name, @NotNull String originalPath, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.name = name;
        this.originalPath = originalPath;
        this.kind = kind;
        String string = FileUtilRt.toSystemDependentName((String)this.originalPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        this.path = string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void openDirectory() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                RevealFileAction.openDirectory((File)new File(this.path));
                break;
            }
            case 2: {
                RevealFileAction.openFile((File)new File(this.path));
            }
        }
    }

    public final void openInEditor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (this.kind == Kind.Folder) {
            throw new Exception("It's impossible to open folder in editor");
        }
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(this.path), (boolean)true);
        if (file2 == null) {
            Object[] objectArray = new Object[]{this.path};
            Notifications.Bus.notify((Notification)new Notification("System Messages", ExecutionBundle.message((String)"error.common.title", (Object[])new Object[0]), RdClientDotnetBundle.INSTANCE.message("notification.content.there.no.such.file", objectArray), NotificationType.ERROR), (Project)project2);
        } else {
            FileEditorManager.getInstance((Project)project2).openFile(file2, true, true);
        }
    }

    public final void open(@Nullable Project project2) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                this.openDirectory();
                break;
            }
            case 2: {
                if (project2 != null) {
                    this.openInEditor(project2);
                    break;
                }
                this.openDirectory();
            }
        }
    }

    @NotNull
    public final DefaultActionGroup getContextActionGroup(@Nullable Project project2, @NotNull Function0<Unit> closeAction) {
        Object object;
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
        DefaultActionGroup $this$getContextActionGroup_u24lambda_u244 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                object = RdClientDotnetBundle.INSTANCE.messagePointer("action.open.folder.text", new Object[0]);
                Object object2 = new Object[]{this.path};
                Supplier<String> supplier = RdClientDotnetBundle.INSTANCE.messagePointer("action.open.folder.description", object2);
                object2 = SpecialPathEntry::getContextActionGroup$lambda$4$lambda$0;
                $this$getContextActionGroup_u24lambda_u244.add(new AnAction(this, closeAction, (Supplier<String>)object, supplier, (Supplier<Icon>)object2){
                    final /* synthetic */ SpecialPathEntry this$0;
                    final /* synthetic */ Function0<Unit> $closeAction;
                    {
                        this.this$0 = $receiver;
                        this.$closeAction = $closeAction;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.openDirectory();
                        this.$closeAction.invoke();
                    }
                });
                break;
            }
            case 2: {
                Supplier<String> supplier;
                Object object3;
                if (project2 != null) {
                    object = RdClientDotnetBundle.INSTANCE.messagePointer("action.open.in.editor.text", new Object[0]);
                    object3 = new Object[]{this.path};
                    supplier = RdClientDotnetBundle.INSTANCE.messagePointer("action.open.in.editor.description", object3);
                    object3 = SpecialPathEntry::getContextActionGroup$lambda$4$lambda$1;
                    $this$getContextActionGroup_u24lambda_u244.add(new AnAction(this, project2, closeAction, (Supplier<String>)object, supplier, (Supplier<Icon>)object3){
                        final /* synthetic */ SpecialPathEntry this$0;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Function0<Unit> $closeAction;
                        {
                            this.this$0 = $receiver;
                            this.$project = $project;
                            this.$closeAction = $closeAction;
                            super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.this$0.openInEditor(this.$project);
                            this.$closeAction.invoke();
                        }
                    });
                }
                object = RdClientDotnetBundle.INSTANCE.messagePointer("action.show.in.folder.text", new Object[0]);
                object3 = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)new File(this.path).getParent(), (String)"getParent(...)");
                supplier = RdClientDotnetBundle.INSTANCE.messagePointer("action.show.in.folder.description", object3);
                object3 = SpecialPathEntry::getContextActionGroup$lambda$4$lambda$2;
                $this$getContextActionGroup_u24lambda_u244.add(new AnAction(this, closeAction, (Supplier<String>)object, supplier, (Supplier<Icon>)object3){
                    final /* synthetic */ SpecialPathEntry this$0;
                    final /* synthetic */ Function0<Unit> $closeAction;
                    {
                        this.this$0 = $receiver;
                        this.$closeAction = $closeAction;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.openDirectory();
                        this.$closeAction.invoke();
                    }
                });
            }
        }
        Supplier<String> supplier = RdClientDotnetBundle.INSTANCE.messagePointer("action.copy.path.text", new Object[0]);
        object = new Object[]{this.path};
        Supplier<String> supplier2 = RdClientDotnetBundle.INSTANCE.messagePointer("action.copy.path.description", object);
        object = SpecialPathEntry::getContextActionGroup$lambda$4$lambda$3;
        $this$getContextActionGroup_u24lambda_u244.add(new AnAction(this, supplier, supplier2, (Supplier<Icon>)object){
            final /* synthetic */ SpecialPathEntry this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.this$0.getPath()));
            }
        });
        return defaultActionGroup;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final String component2() {
        return this.originalPath;
    }

    @NotNull
    public final Kind component3() {
        return this.kind;
    }

    @NotNull
    public final SpecialPathEntry copy(@NotNull String name, @NotNull String originalPath, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return new SpecialPathEntry(name, originalPath, kind);
    }

    public static /* synthetic */ SpecialPathEntry copy$default(SpecialPathEntry specialPathEntry, String string, String string2, Kind kind, int n, Object object) {
        if ((n & 1) != 0) {
            string = specialPathEntry.name;
        }
        if ((n & 2) != 0) {
            string2 = specialPathEntry.originalPath;
        }
        if ((n & 4) != 0) {
            kind = specialPathEntry.kind;
        }
        return specialPathEntry.copy(string, string2, kind);
    }

    @NotNull
    public String toString() {
        return "SpecialPathEntry(name=" + this.name + ", originalPath=" + this.originalPath + ", kind=" + this.kind + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.originalPath.hashCode();
        result2 = result2 * 31 + this.kind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpecialPathEntry)) {
            return false;
        }
        SpecialPathEntry specialPathEntry = (SpecialPathEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)specialPathEntry.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalPath, (Object)specialPathEntry.originalPath)) {
            return false;
        }
        return this.kind == specialPathEntry.kind;
    }

    private static final Icon getContextActionGroup$lambda$4$lambda$0() {
        return null;
    }

    private static final Icon getContextActionGroup$lambda$4$lambda$1() {
        return null;
    }

    private static final Icon getContextActionGroup$lambda$4$lambda$2() {
        return null;
    }

    private static final Icon getContextActionGroup$lambda$4$lambda$3() {
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/diagnostics/SpecialPathEntry$Kind;", "", "(Ljava/lang/String;I)V", "File", "Folder", "intellij.rider.rdclient.dotnet"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind File = new Kind();
        public static final /* enum */ Kind Folder = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.File, Kind.Folder};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Kind.values().length];
            try {
                nArray[Kind.Folder.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.File.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

