/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.completion.RiderCodeCompletionExtraSettings;
import com.jetbrains.rider.cpp.completion.CppCompletionHelperBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/completion/CppCharFilterBase;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "()V", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "isApplicable", "", "language", "Lcom/intellij/lang/Language;", "intellij.rider.cpp.core"})
public abstract class CppCharFilterBase
extends CharFilter {
    public abstract boolean isApplicable(@NotNull Language var1);

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (this.isApplicable(language)) {
            if (c == '(' || c == ':') {
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (c == ' ') {
                if (RiderCodeCompletionExtraSettings.Companion.getInstance().getAllowToCompleteWithWhitespace()) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (c == '.') {
                PsiFile psiFile3 = lookup.getPsiFile();
                Document document = psiFile3 != null && (psiFile3 = psiFile3.getViewProvider()) != null ? psiFile3.getDocument() : null;
                if (document == null) {
                    return null;
                }
                Document document2 = document;
                if (CppCompletionHelperBase.Companion.isInFileNameContext(document2, lookup.getLookupStart())) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
            } else if (c == '=' && 8 == prefixLength) {
                FileViewProvider fileViewProvider = psiFile2.getViewProvider();
                Object object = fileViewProvider != null ? fileViewProvider.getDocument() : null;
                if (object == null) {
                    return null;
                }
                Document document = object;
                CharSequence prefix = document.getCharsSequence().subSequence(lookup.getLookupStart(), lookup.getLookupStart() + prefixLength);
                if ("operator".contentEquals(prefix)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
            }
            return null;
        }
        return null;
    }
}

