/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.documentation.ide.impl.DocumentationManagementHelper;
import com.intellij.lang.documentation.ide.impl.DocumentationManagerKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.QuickDocElementInfo;
import com.jetbrains.rd.ide.model.QuickDocHostModel;
import com.jetbrains.rd.ide.model.QuickDocHostModel_GeneratedKt;
import com.jetbrains.rd.ide.model.QuickDocSession;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.quickDoc.FrontendDocumentationFullSessionData;
import com.jetbrains.rdclient.quickDoc.FrontendDocumentationSessionWrapper;
import com.jetbrains.rdclient.quickDoc.FrontendDocumentationTarget;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.quickDoc.FrontendQuickDocHost;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/completion/QuickDocLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/codeInsight/lookup/impl/LookupImpl;)V", "alarm", "Lcom/intellij/util/Alarm;", "alarmDelay", "", "currentLookupElementToNotifyAbout", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isAlarmSet", "", "currentItemChanged", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "lookupShown", "onAlarmGoesOff", "onChangedElementToNotifyAbout", "setAlarm", "tryUpdateQuickDoc", "lookupElement", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nQuickDocLookupListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickDocLookupListener.kt\ncom/jetbrains/rider/completion/QuickDocLookupListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n13#2:123\n13#3:124\n*S KotlinDebug\n*F\n+ 1 QuickDocLookupListener.kt\ncom/jetbrains/rider/completion/QuickDocLookupListener\n*L\n36#1:123\n36#1:124\n*E\n"})
public final class QuickDocLookupListener
implements LookupListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final LookupImpl lookup;
    private final int alarmDelay;
    @NotNull
    private final Alarm alarm;
    private boolean isAlarmSet;
    @Nullable
    private LookupElement currentLookupElementToNotifyAbout;
    @NotNull
    private static final Logger LOG;

    public QuickDocLookupListener(@NotNull Lifetime lifetime2, @NotNull LookupImpl lookup) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.lifetime = lifetime2;
        this.lookup = lookup;
        this.alarmDelay = 200;
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
    }

    public void lookupShown(@NotNull LookupEvent event) {
        CompletionProgressIndicator indicator;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LOG.trace("lookup shown");
        CompletionProgressIndicator completionProgressIndicator = indicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        boolean bl = completionProgressIndicator != null ? completionProgressIndicator.isAutopopupCompletion() : false;
        if (bl) {
            int offset = this.lookup.getEditor().getCaretModel().getOffset();
            TextRange textRange = TextRange.from((int)offset, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
            Editor editor2 = this.lookup.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            HighlightersUtilKt.vanishHighlighters(this.lifetime, textRange, editor2);
        }
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LookupElement currentLookupElement = event.getItem();
        if (currentLookupElement instanceof PrioritizedLookupElement) {
            currentLookupElement = ((PrioritizedLookupElement)currentLookupElement).getDelegate();
        }
        if (!Intrinsics.areEqual((Object)currentLookupElement, (Object)this.currentLookupElementToNotifyAbout)) {
            this.currentLookupElementToNotifyAbout = currentLookupElement;
            this.onChangedElementToNotifyAbout();
        }
    }

    private final void onChangedElementToNotifyAbout() {
        if (this.alarm.isDisposed()) {
            return;
        }
        if (!this.isAlarmSet) {
            this.tryUpdateQuickDoc(this.currentLookupElementToNotifyAbout);
            this.setAlarm();
        }
    }

    private final void onAlarmGoesOff() {
        this.isAlarmSet = false;
        if (this.currentLookupElementToNotifyAbout != null) {
            this.tryUpdateQuickDoc(this.currentLookupElementToNotifyAbout);
            this.currentLookupElementToNotifyAbout = null;
            this.setAlarm();
        }
    }

    private final void setAlarm() {
        this.alarm.addRequest(() -> QuickDocLookupListener.setAlarm$lambda$0(this), this.alarmDelay);
        this.isAlarmSet = true;
    }

    private final void tryUpdateQuickDoc(LookupElement lookupElement) {
        if (lookupElement instanceof ProtocolLookupItemBase) {
            CompletionItem currentCompletionItem = ((ProtocolLookupItemBase)lookupElement).getCompletionItem();
            Project project2 = this.lookup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(project3);
            Editor editor2 = this.lookup.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            frontendCompletionHost.fireCurrentLookupItemChanged(currentCompletionItem, editor2);
            if (DocumentationManagerKt.isDocumentationPopupVisible((Project)project3)) {
                QuickDocHostModel quickDocHostModel = QuickDocHostModel_GeneratedKt.getQuickDocHostModel((Solution)FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(project3)));
                Integer n = FrontendQuickDocHost.Companion.getInstance(project3).getQuickDocSessionIdForLookup();
                if (n == null) {
                    return;
                }
                int quickDocSessionId = n;
                QuickDocSession quickDocSession = (QuickDocSession)quickDocHostModel.getQuickDocSessions().get((Object)quickDocSessionId);
                if (quickDocSession == null) {
                    return;
                }
                QuickDocSession quickDocSession2 = quickDocSession;
                LOG.debug("Request a quick doc for current completion item again: item=" + currentCompletionItem.getShortText());
                quickDocSession2.getFetchQuickDocAgain().start(this.lifetime, (Object)Unit.INSTANCE).getResult().advise(this.lifetime, (Function1)new Function1<RdTaskResult<? extends QuickDocElementInfo>, Unit>(project3, this, quickDocSessionId, quickDocSession2, quickDocHostModel){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ QuickDocLookupListener this$0;
                    final /* synthetic */ int $quickDocSessionId;
                    final /* synthetic */ QuickDocSession $quickDocSession;
                    final /* synthetic */ QuickDocHostModel $quickDocHostModel;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$quickDocSessionId = $quickDocSessionId;
                        this.$quickDocSession = $quickDocSession;
                        this.$quickDocHostModel = $quickDocHostModel;
                        super(1);
                    }

                    public final void invoke(@NotNull RdTaskResult<QuickDocElementInfo> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        QuickDocLookupListener.Companion.getLOG().debug("Got a quick doc for current completion item");
                        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.$project);
                        PsiFile psiFile = psiDocumentManager.getPsiFile(QuickDocLookupListener.access$getLookup$p(this.this$0).getEditor().getDocument());
                        if (psiFile == null) {
                            return;
                        }
                        PsiFile psiFile2 = psiFile;
                        QuickDocLookupListener.Companion.getLOG().debug("Showing the quick doc for current completion item");
                        DocumentationManagementHelper helper = DocumentationManagementHelper.Companion.getInstance(this.$project);
                        FrontendDocumentationFullSessionData data2 = new FrontendDocumentationFullSessionData(this.$project, this.$quickDocSessionId, this.$quickDocSession);
                        FrontendDocumentationSessionWrapper wrapper = new FrontendDocumentationSessionWrapper(data2, null, null, 6, null);
                        FrontendDocumentationTarget target = new FrontendDocumentationTarget(wrapper, this.$project, psiFile2);
                        Editor editor2 = QuickDocLookupListener.access$getLookup$p(this.this$0).getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        helper.showQuickDoc(editor2, (DocumentationTarget)target, (Function0)new Function0<Unit>(this.$quickDocHostModel, this.$quickDocSessionId){
                            final /* synthetic */ QuickDocHostModel $quickDocHostModel;
                            final /* synthetic */ int $quickDocSessionId;
                            {
                                this.$quickDocHostModel = $quickDocHostModel;
                                this.$quickDocSessionId = $quickDocSessionId;
                                super(0);
                            }

                            public final void invoke() {
                                this.$quickDocHostModel.getQuickDocSessions().remove((Object)this.$quickDocSessionId);
                            }
                        });
                    }
                });
            }
        }
    }

    private static final void setAlarm$lambda$0(QuickDocLookupListener this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onAlarmGoesOff();
    }

    public static final /* synthetic */ LookupImpl access$getLookup$p(QuickDocLookupListener $this) {
        return $this.lookup;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(QuickDocLookupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/completion/QuickDocLookupListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

