/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.Weigher;
import com.intellij.util.ProcessingContext;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CompletionItemType;
import com.jetbrains.rd.ide.model.ScoringHint;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.ProtocolCompletionContributor;
import com.jetbrains.rider.completion.ProtocolCompletionContributorKt;
import com.jetbrains.rider.completion.ProtocolCompletionProvider;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J8\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J>\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001aJ,\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001a0(H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/completion/ProtocolCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "owner", "Lcom/jetbrains/rider/completion/ProtocolCompletionContributor;", "(Lcom/jetbrains/rider/completion/ProtocolCompletionContributor;)V", "forceMiddleMatch", "Ljava/lang/Object;", "mlCompletionWeigher", "Lcom/intellij/psi/Weigher;", "", "getMlCompletionWeigher", "()Lcom/intellij/psi/Weigher;", "mlCompletionWeigher$delegate", "Lkotlin/Lazy;", "addCompletions", "", "params", "context", "Lcom/intellij/util/ProcessingContext;", "initialResultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "createCompletionConsumer", "prefix", "", "allSmallLetters", "", "onlyFirstLetterIsCapital", "casingIsDescendant", "groupByPrefixAndHints", "", "degree", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "processItem", "lookupElement", "customFilter", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProtocolCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolCompletionProvider.kt\ncom/jetbrains/rider/completion/ProtocolCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,332:1\n65#2,4:333\n*S KotlinDebug\n*F\n+ 1 ProtocolCompletionProvider.kt\ncom/jetbrains/rider/completion/ProtocolCompletionProvider\n*L\n46#1:333,4\n*E\n"})
public class ProtocolCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtocolCompletionContributor owner;
    @NotNull
    private final Lazy mlCompletionWeigher$delegate;
    @NotNull
    private final Object forceMiddleMatch;
    @NotNull
    private static final Key<Integer> CachedScore = new Key("CachedItemScore");
    @NotNull
    private static final String MlCompletionWeigherId = "ml_weigh";
    @NotNull
    private static final Key<Boolean> LookupStringEqualsPrefixKey = new Key("ML_feature_lookupStringEqualsPrefix");
    @NotNull
    private static final Key<Boolean> LookupStringStartsWithPrefixKey = new Key("ML_feature_lookupStringStartsWithPrefixKey");

    public ProtocolCompletionProvider(@NotNull ProtocolCompletionContributor owner) {
        Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
        this.owner = owner;
        this.mlCompletionWeigher$delegate = LazyKt.lazy((Function0)mlCompletionWeigher.2.INSTANCE);
        this.forceMiddleMatch = new Object();
    }

    private final Weigher<Object, Object> getMlCompletionWeigher() {
        Lazy lazy = this.mlCompletionWeigher$delegate;
        return (Weigher)lazy.getValue();
    }

    protected void addCompletions(@NotNull CompletionParameters params2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet initialResultSet) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initialResultSet, (String)"initialResultSet");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        Logger $this$trace$iv = this.owner.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("start contributor #" + this.owner.getCompletionId().incrementAndGet() + " for editor " + params2.getEditor());
        }
        Project project2 = params2.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.tryGetInstance(project3);
        if (frontendCompletionHost == null) {
            return;
        }
        FrontendCompletionHost completionHost = frontendCompletionHost;
        PsiFile psiFile = params2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
        CompletionProcessEx completionProcessEx = completionProcess instanceof CompletionProcessEx ? (CompletionProcessEx)completionProcess : null;
        if (completionProcessEx == null) {
            return;
        }
        CompletionProcessEx currentCompletion = completionProcessEx;
        Disposable disposable = Disposer.newDisposable((String)"Protocol completion contributor");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        currentCompletion.registerChildDisposable(() -> ProtocolCompletionProvider.addCompletions$lambda$1(disposable2));
        if (Disposer.isDisposed((Disposable)disposable2)) {
            return;
        }
        LifetimeDisposableExKt.doIfAlive((Disposable)disposable2, (Function1)((Function1)new Function1<Lifetime, Unit>(disposable2, params2, psiFile2, this, initialResultSet, completionHost){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ CompletionParameters $params;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ ProtocolCompletionProvider this$0;
            final /* synthetic */ CompletionResultSet $initialResultSet;
            final /* synthetic */ FrontendCompletionHost $completionHost;
            {
                this.$disposable = $disposable;
                this.$params = $params;
                this.$psiFile = $psiFile;
                this.this$0 = $receiver;
                this.$initialResultSet = $initialResultSet;
                this.$completionHost = $completionHost;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Logger logger;
                Function1 function1;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Lifetime popupLifetime = LifetimeDisposableExKt.createLifetime((Disposable)this.$disposable);
                int prefixOffset = this.$params.getOffset();
                Editor editor2 = this.$params.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                if (EditorUtilKt.hasMultipleEditPoints(editor2) || this.$params.getEditor().getSelectionModel().hasSelection()) {
                    Editor editor3 = this.$params.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                    prefixOffset = PlatformTextControlUtilsKt.getStartOffset(editor3);
                }
                if ((function1 = (Function1)this.$params.getEditor().getUserData(ProtocolCompletionContributor.Companion.getPassesCustomFilter())) == null) {
                    function1 = addCompletions.customFilter.1.INSTANCE;
                }
                Function1 function12 = function1;
                Intrinsics.checkNotNull((Object)function12);
                Function1 customFilter2 = function12;
                boolean mayTrustLookup = this.$params.getInvocationCount() == 0;
                Project project2 = this.$psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(project2);
                Document document = this.$params.getEditor().getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Editor editor4 = this.$params.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"getEditor(...)");
                String prefix = frontendCompletionHost.getCompletionPrefix(prefixOffset, document, this.$psiFile, ModelUtilKt.getCurrentOffsetSafe(DocumentExKt.getTextControlModel(editor4)), this.$params.getEditor(), mayTrustLookup);
                if (ProtocolCompletionProvider.access$getOwner$p(this.this$0).shouldStopOnPrefix(prefix, this.$params.isAutoPopup())) {
                    return;
                }
                boolean allSmallLetters = true;
                boolean onlyFirstLetterIsCapital = false;
                boolean hasSmallLetters = false;
                boolean casingIsDescendant = false;
                int n = prefix.length();
                for (int i = 0; i < n; ++i) {
                    char c = prefix.charAt(i);
                    if (Character.isUpperCase(c)) {
                        allSmallLetters = false;
                        boolean bl = onlyFirstLetterIsCapital = i == 0;
                        if (i == 0) {
                            casingIsDescendant = true;
                            continue;
                        }
                        if (!hasSmallLetters) continue;
                        casingIsDescendant = false;
                        continue;
                    }
                    hasSmallLetters = true;
                }
                casingIsDescendant = casingIsDescendant && hasSmallLetters;
                Logger $this$trace$iv = ProtocolCompletionProvider.access$getOwner$p(this.this$0).getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("prefix is '" + prefix + "'");
                }
                CompletionResultSet consumer2 = this.this$0.createCompletionConsumer(this.$initialResultSet, prefix, allSmallLetters, onlyFirstLetterIsCapital, casingIsDescendant, this.$params);
                CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
                if (completionProcess == null) {
                    return;
                }
                CompletionProcess indicator = completionProcess;
                LookupEx lookupEx = LookupManagerImpl.getActiveLookup((Editor)this.$params.getEditor());
                LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
                Logger $this$trace$iv2 = ProtocolCompletionProvider.access$getOwner$p(this.this$0).getLogger();
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl = false;
                    LookupImpl lookupImpl = lookup;
                    logger.trace("isAutopopupCompletion: " + indicator.isAutopopupCompletion() + ". lookup: " + (lookupImpl != null ? lookupImpl.hashCode() : 0));
                }
                Ref cursor = new Ref((Object)0);
                while (true) {
                    Editor editor5 = this.$params.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor5, (String)"getEditor(...)");
                    boolean itemsConsumed2 = this.$completionHost.consumeItems(editor5, consumer2, popupLifetime, (Ref<Integer>)cursor, (Function1<? super LookupElement, Boolean>)((Function1)new Function1<LookupElement, Boolean>(this.this$0, prefix, (Function1<? super ProtocolLookupItemBase, Boolean>)customFilter2){
                        final /* synthetic */ ProtocolCompletionProvider this$0;
                        final /* synthetic */ String $prefix;
                        final /* synthetic */ Function1<ProtocolLookupItemBase, Boolean> $customFilter;
                        {
                            this.this$0 = $receiver;
                            this.$prefix = $prefix;
                            this.$customFilter = $customFilter;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull LookupElement lookupElement) {
                            Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
                            return this.this$0.processItem(lookupElement, this.$prefix, this.$customFilter);
                        }
                    }));
                    if (!itemsConsumed2) break;
                    ProtocolCompletionProvider.access$getOwner$p(this.this$0).getLogger().trace("Items have passed to lookup engine.");
                }
                if (((CharSequence)prefix).length() == 0) {
                    this.$initialResultSet.restartCompletionOnAnyPrefixChange();
                }
                Logger $this$trace$iv3 = ProtocolCompletionProvider.access$getOwner$p(this.this$0).getLogger();
                boolean $i$f$trace3 = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    logger = $this$trace$iv3;
                    boolean bl = false;
                    logger.trace("contributor has finished its job. " + consumer2);
                }
            }
        }));
    }

    @NotNull
    protected CompletionResultSet createCompletionConsumer(@NotNull CompletionResultSet initialResultSet, @NotNull String prefix, boolean allSmallLetters, boolean onlyFirstLetterIsCapital, boolean casingIsDescendant, @NotNull CompletionParameters params2) {
        CompletionSorter completionSorter;
        Intrinsics.checkNotNullParameter((Object)initialResultSet, (String)"initialResultSet");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        LookupElementWeigher[] lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                double d;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PrioritizedLookupElement) {
                    d = -((PrioritizedLookupElement)element).getPriority();
                } else if (element instanceof LookupElementDecorator && ((LookupElementDecorator)element).getDelegate() instanceof PrioritizedLookupElement) {
                    LookupElement lookupElement = ((LookupElementDecorator)element).getDelegate();
                    Intrinsics.checkNotNull((Object)lookupElement, (String)"null cannot be cast to non-null type com.intellij.codeInsight.completion.PrioritizedLookupElement<*>");
                    d = -((PrioritizedLookupElement)lookupElement).getPriority();
                } else {
                    d = -0.0;
                }
                return d;
            }
        }};
        CompletionSorter completionSorter2 = CompletionSorter.emptySorter().weigh(new LookupElementWeigher(this, allSmallLetters, onlyFirstLetterIsCapital, casingIsDescendant){
            final /* synthetic */ ProtocolCompletionProvider this$0;
            final /* synthetic */ boolean $allSmallLetters;
            final /* synthetic */ boolean $onlyFirstLetterIsCapital;
            final /* synthetic */ boolean $casingIsDescendant;
            {
                this.this$0 = $receiver;
                this.$allSmallLetters = $allSmallLetters;
                this.$onlyFirstLetterIsCapital = $onlyFirstLetterIsCapital;
                this.$casingIsDescendant = $casingIsDescendant;
                super("mostRelevantItems");
            }

            @NotNull
            public Double weigh(@NotNull LookupElement element, @NotNull WeighingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(element);
                if (protocolLookupItemBase == null || (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) == null) {
                    return -1.0;
                }
                ProtocolLookupItemBase completionItem = protocolLookupItemBase;
                String string = context2.itemPattern(element);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
                String itemPattern = string;
                PrefixMatcher prefixMatcher = context2.itemMatcher(element).cloneWithPrefix(itemPattern);
                Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
                PrefixMatcher itemMatcher = prefixMatcher;
                int degree = ProtocolCompletionContributorKt.getBestMatchingDegree(element, itemMatcher, (CompletionItem)completionItem);
                element.putUserData(ProtocolCompletionProvider.access$getCachedScore$cp(), (Object)degree);
                return this.this$0.groupByPrefixAndHints(degree, element, this.$allSmallLetters, this.$onlyFirstLetterIsCapital, itemPattern, (CompletionItem)completionItem, this.$casingIsDescendant);
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weighAfter("mostRelevantItems", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            @NotNull
            public Integer weigh(@NotNull LookupElement element, @NotNull WeighingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Integer cachedDegree = (Integer)element.getUserData(ProtocolCompletionProvider.access$getCachedScore$cp());
                if (cachedDegree != null) {
                    return cachedDegree;
                }
                ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(element);
                if (protocolLookupItemBase == null || (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) == null) {
                    return -1;
                }
                ProtocolLookupItemBase completionItem = protocolLookupItemBase;
                PrefixMatcher prefixMatcher = context2.itemMatcher(element).cloneWithPrefix(context2.itemPattern(element));
                Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
                PrefixMatcher itemMatcher = prefixMatcher;
                return ProtocolCompletionContributorKt.getBestMatchingDegree(element, itemMatcher, (CompletionItem)completionItem);
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }};
        CompletionSorter completionSorter3 = completionSorter2.weighAfter("backendPriority", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            @NotNull
            public Integer weigh(@NotNull LookupElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                CharSequence $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!Character.isUpperCase(c)) continue;
                    ++count$iv;
                }
                return count$iv;
            }

            public boolean isPrefixDependent() {
                return false;
            }
        }};
        CompletionSorter completionSorter4 = completionSorter3.weighAfter("matcherPriority", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            @NotNull
            public Integer weigh(@NotNull LookupElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                if (StringsKt.startsWith$default((String)string, (String)"(", (boolean)false, (int)2, null)) {
                    return 0;
                }
                return -1;
            }

            public boolean isPrefixDependent() {
                return false;
            }
        }};
        CompletionSorter completionSorter5 = completionSorter4.weighAfter("lessHumpsPriority", lookupElementWeigherArray);
        CompletionResultSet completionResultSet = initialResultSet.withPrefixMatcher(prefix);
        boolean bl = false;
        Weigher<Object, Object> mlWeigher = this.getMlCompletionWeigher();
        if (mlWeigher != null) {
            LookupElementWeigher[] lookupElementWeigherArray2 = new LookupElementWeigher[]{new LookupElementWeigher(params2, mlWeigher){
                final /* synthetic */ CompletionParameters $params;
                final /* synthetic */ Weigher<Object, Object> $mlWeigher;
                {
                    this.$params = $params;
                    this.$mlWeigher = $mlWeigher;
                    super("ml_weigh");
                }

                @Nullable
                public Comparable<Object> weigh(@NotNull LookupElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    CompletionLocation location = new CompletionLocation(this.$params);
                    return this.$mlWeigher.weigh((Object)element, (Object)location);
                }
            }};
            completionSorter = sorter.weighAfter("shorterLambdas", lookupElementWeigherArray2);
        } else {
            completionSorter = sorter;
        }
        CompletionResultSet completionResultSet2 = completionResultSet.withRelevanceSorter(completionSorter);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet2, (String)"withRelevanceSorter(...)");
        CompletionResultSet consumer2 = completionResultSet2;
        return consumer2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean processItem(@NotNull LookupElement lookupElement, @NotNull String prefix, @NotNull Function1<? super ProtocolLookupItemBase, Boolean> customFilter2) {
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(customFilter2, (String)"customFilter");
        lookupElement.putUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH, this.forceMiddleMatch);
        ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(lookupElement);
        if (protocolLookupItemBase == null) {
            return true;
        }
        ProtocolLookupItemBase protocolItem = protocolLookupItemBase;
        if (!((Boolean)customFilter2.invoke((Object)protocolItem)).booleanValue()) {
            return false;
        }
        boolean isTemplateItem = protocolItem.getCompletionItem().getItemType() == CompletionItemType.TemplateItem;
        if (((CharSequence)prefix).length() == 0) {
            String string = lookupElement.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'#', (boolean)false, (int)2, null)) return false;
            if (isTemplateItem) {
                return false;
            }
        }
        if (!isTemplateItem) return true;
        String string = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        if (StringsKt.startsWith((String)string, (String)prefix, (boolean)true)) return true;
        return false;
    }

    public final double groupByPrefixAndHints(int degree, @NotNull LookupElement element, boolean allSmallLetters, boolean onlyFirstLetterIsCapital, @NotNull String prefix, @NotNull CompletionItem completionItem, boolean casingIsDescendant) {
        boolean typingHint;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        boolean lookupStringEqualsPrefixIgnoreCase = StringsKt.equals((String)element.getLookupString(), (String)prefix, (boolean)true);
        element.putUserData(LookupStringEqualsPrefixKey, (Object)lookupStringEqualsPrefixIgnoreCase);
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        boolean lookupStartsWithPrefixIgnoreCase = StringsKt.startsWith((String)string, (String)prefix, (boolean)true);
        element.putUserData(LookupStringStartsWithPrefixKey, (Object)lookupStartsWithPrefixIgnoreCase);
        String string2 = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        boolean lookupStartsWithPrefix = StringsKt.startsWith((String)string2, (String)prefix, (boolean)false);
        List scoringHints = completionItem.getScoringHints();
        if (scoringHints.contains(ScoringHint.Obsolete)) {
            return -0.2;
        }
        if (degree <= -1052 && scoringHints.contains(ScoringHint.FieldsParamsLocals)) {
            return -5.0 + (double)(degree + 1052) / 100.0;
        }
        if (degree <= -1000 && scoringHints.contains(ScoringHint.Blessed)) {
            return -5.0;
        }
        if ((degree <= -1150 || lookupStartsWithPrefixIgnoreCase && degree <= -1000) && completionItem.getStatsScore() > 0) {
            return -4.0 - (double)((float)completionItem.getStatsScore() / (float)50);
        }
        if (degree < -1001 && lookupStringEqualsPrefixIgnoreCase) {
            return -3.5;
        }
        if (degree <= -1100 && lookupStartsWithPrefixIgnoreCase && casingIsDescendant) {
            return -3.3;
        }
        if (degree <= -1100 && scoringHints.contains(ScoringHint.LightItem) && lookupStartsWithPrefix && prefix.length() >= 3) {
            return -3.2;
        }
        if (degree <= -1100 && scoringHints.contains(ScoringHint.LightItem)) {
            String string3 = element.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
            if (!StringsKt.contains$default((CharSequence)string3, (char)' ', (boolean)false, (int)2, null)) {
                return -3.0;
            }
        }
        if (degree <= -1000 && scoringHints.contains(ScoringHint.FieldsParamsLocals) && allSmallLetters) {
            return -2.5;
        }
        if (degree <= -1000 && lookupStartsWithPrefixIgnoreCase && allSmallLetters && scoringHints.contains(ScoringHint.LightItem)) {
            return -2.0;
        }
        boolean bl = typingHint = lookupStartsWithPrefix && onlyFirstLetterIsCapital;
        if (degree <= -1000 && typingHint) {
            return -2.0;
        }
        if (completionItem.getItemType() == CompletionItemType.PostfixTemplate && ((CharSequence)prefix).length() == 0) {
            return -0.5;
        }
        return -1.0;
    }

    private static final Disposable addCompletions$lambda$1(Disposable $disposable) {
        Intrinsics.checkNotNullParameter((Object)$disposable, (String)"$disposable");
        return $disposable;
    }

    public static final /* synthetic */ ProtocolCompletionContributor access$getOwner$p(ProtocolCompletionProvider $this) {
        return $this.owner;
    }

    public static final /* synthetic */ Key access$getCachedScore$cp() {
        return CachedScore;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/completion/ProtocolCompletionProvider$Companion;", "", "()V", "CachedScore", "Lcom/intellij/openapi/util/Key;", "", "LookupStringEqualsPrefixKey", "", "getLookupStringEqualsPrefixKey", "()Lcom/intellij/openapi/util/Key;", "LookupStringStartsWithPrefixKey", "getLookupStringStartsWithPrefixKey", "MlCompletionWeigherId", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getLookupStringEqualsPrefixKey() {
            return LookupStringEqualsPrefixKey;
        }

        @NotNull
        public final Key<Boolean> getLookupStringStartsWithPrefixKey() {
            return LookupStringStartsWithPrefixKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

