/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/completion/MyEditorTypingListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "beforeEditorTyping", "", "c", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/MyEditorTypingListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,406:1\n13#2:407\n13#3:408\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/MyEditorTypingListener\n*L\n50#1:407\n50#1:408\n*E\n"})
final class MyEditorTypingListener
implements AnActionListener {
    @NotNull
    private final Logger logger;

    public MyEditorTypingListener() {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MyEditorTypingListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project prj = project2;
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(prj);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return;
        }
        RiderDefaultBackend backend = riderDefaultBackend;
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        FrontendTypedHandler frontendTypedHandler = backend.getTypedHandler(editor3, editor3.getCaretModel().getOffset());
        if (frontendTypedHandler == null) {
            return;
        }
        FrontendTypedHandler typedHandler = frontendTypedHandler;
        boolean isCompletionTerminator = typedHandler.isCompletionTerminator(editor3, c);
        this.logger.trace("checking beforeEditorTyping heuristics to start completion session right away...");
        CompletionStateData completionStateData2 = FrontendCompletionHostKt.getCompletionStateData(editor3);
        if (!isCompletionTerminator && !completionStateData2.getHasSession()) {
            FrontendCompletionHost.ensureCompletionIsRunning$default(PreemptiveCompletionHost.Companion.getInstance(prj), editor3, CompletionType.BASIC, 0, null, null, 24, null);
        }
    }
}

