/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.lang.Language;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.rd.ide.model.AutoPopupResult;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.editors.TextControlUtilsKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.completion.AutoPopupBackendSupportPolicy;
import com.jetbrains.rider.completion.AutoPopupHost;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.completion.FrontendAutoPopupHost;
import com.jetbrains.rider.editorActions.FrontendTypedHandlerManager;
import com.jetbrains.rider.editorActions.IFrontendTypingListener;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import com.jetbrains.rider.template.FrontendLiveTemplateMacroExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0003\u0018\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/completion/FrontendAutoPopupHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rider/completion/AutoPopupHost;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cancelLookup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasMultipleEditSegments", "", "initBeforeTypingListener", "focusedTextControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "isUpToDateAutopopup", "result", "Lcom/jetbrains/rd/ide/model/AutoPopupResult;", "onAutoPopupRequested", "autoPopupLifetime", "shouldTrustBackend", "tryScheduleAutoPopup", "AutoPopupState", "Companion", "MyListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendAutoPopupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n65#2,4:219\n65#2,4:223\n65#2,4:227\n65#2,4:233\n13#2:237\n288#3,2:231\n*S KotlinDebug\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost\n*L\n138#1:219,4\n142#1:223,4\n158#1:227,4\n210#1:233,4\n41#1:237\n186#1:231,2\n*E\n"})
public class FrontendAutoPopupHost
extends LifetimedService
implements AutoPopupHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, AutoPopupState> autoPopupState$delegate;

    public FrontendAutoPopupHost(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected void initBeforeTypingListener(@NotNull Editor editor2, @NotNull Lifetime focusedTextControlLifetime) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)focusedTextControlLifetime, (String)"focusedTextControlLifetime");
        MessageBusConnection connection = this.project.getMessageBus().connect();
        focusedTextControlLifetime.onTermination((Function0)new Function0<Unit>(connection){
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.$connection = $connection;
                super(0);
            }

            public final void invoke() {
                this.$connection.disconnect();
            }
        });
        connection.subscribe(FrontendTypedHandlerManager.Companion.getBEFORE_TYPING_SENT(), (Object)new IFrontendTypingListener(){

            public void beforeSendType(@NotNull Editor editor2, int timestamp, boolean isCompletionTerminator) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                AutoPopupState autoPopupState = FrontendAutoPopupHost.Companion.getAutoPopupState(editor2);
                if (autoPopupState == null) {
                    Logger $this$trace$iv = FrontendAutoPopupHost.Companion.getLOG();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("There is no AutoPopupState attached to " + editor2);
                    }
                    return;
                }
                autoPopupState.setNextLookupSoft(false);
                Logger $this$trace$iv = FrontendAutoPopupHost.Companion.getLOG();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("updating latest id to " + timestamp);
                }
                autoPopupState.setLatestTypingTimestamp(timestamp);
            }
        });
    }

    protected boolean isUpToDateAutopopup(@NotNull Editor editor2, @NotNull AutoPopupResult result2) {
        boolean isUpToDate;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        AutoPopupState autoPopupState = Companion.getAutoPopupState(editor2);
        if (autoPopupState == null) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("There is no AutoPopupState attached to " + editor2);
            }
            return false;
        }
        Integer n = result2.getTypingTimeStamp();
        Intrinsics.checkNotNull((Object)n);
        boolean bl = isUpToDate = n >= autoPopupState.getLatestTypingTimestamp();
        if (!isUpToDate) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace(result2 + " rejected, because current id " + result2.getTypingTimeStamp() + " < " + autoPopupState.getLatestTypingTimestamp());
            }
        }
        return isUpToDate;
    }

    private final void tryScheduleAutoPopup(Editor editor2, AutoPopupResult result2) {
        block7: {
            block6: {
                if (!this.isUpToDateAutopopup(editor2, result2)) {
                    return;
                }
                LookupEx currentLookup = LookupManagerImpl.getActiveLookup((Editor)editor2);
                if (currentLookup != null) break block6;
                Class[] classArray = new Class[]{CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class};
                if (!CompletionServiceImpl.Companion.isPhase(classArray)) break block7;
            }
            LOG.trace("skipping scheduling backend autoPopup, cause we already have an active one.");
            return;
        }
        AutoPopupState autoPopupState = Companion.getAutoPopupState(editor2);
        if (autoPopupState == null) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("There is no AutoPopupState attached to editor " + editor2);
            }
            return;
        }
        LOG.trace("tryScheduleAutoPopup request. Waiting for the synced document state...");
        autoPopupState.getScheduleAutoPopupSeq().defineNext((Function2)new Function2<LifetimeDefinition, Lifetime, Unit>(this, editor2, result2){
            final /* synthetic */ FrontendAutoPopupHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ AutoPopupResult $result;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$result = $result;
                super(2);
            }

            public final void invoke(@NotNull LifetimeDefinition lifetimeDefinition, @NotNull Lifetime lifetime2) {
                Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
                this.this$0.onAutoPopupRequested(lifetime2, this.$editor, this.$result);
                TypingSessions.Companion.getInstance(this.this$0.getProject()).adviseBackendTypingsSynced("FrontendAutoPopupHost", lifetime2, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$editor, this.$result){
                    final /* synthetic */ FrontendAutoPopupHost this$0;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ AutoPopupResult $result;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        this.$result = $result;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.this$0.isUpToDateAutopopup(this.$editor, this.$result)) {
                            return;
                        }
                        FrontendAutoPopupHost.Companion.getLOG().trace("scheduling auto popup...");
                        CompletionType completionType = switch (tryScheduleAutoPopup.WhenMappings.$EnumSwitchMapping$0[this.$result.getMode().ordinal()]) {
                            case 1 -> CompletionType.CLASS_NAME;
                            case 2 -> CompletionType.SMART;
                            case 3 -> CompletionType.BASIC;
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        AutoPopupController.getInstance((Project)this.this$0.getProject()).scheduleAutoPopup(this.$editor, completionType, null);
                    }
                }));
            }
        });
    }

    protected void onAutoPopupRequested(@NotNull Lifetime autoPopupLifetime, @NotNull Editor editor2, @NotNull AutoPopupResult result2) {
        Intrinsics.checkNotNullParameter((Object)autoPopupLifetime, (String)"autoPopupLifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    private final boolean hasMultipleEditSegments(Editor editor2) {
        Object v3;
        block5: {
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor2);
            if (templateState == null) {
                return false;
            }
            TemplateState templateState2 = templateState;
            if (templateState2.getSegmentsCount() == 1) {
                return false;
            }
            String string = templateState2.getTemplate().getVariableNameAt(templateState2.getCurrentVariableNumber());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVariableNameAt(...)");
            String currentVariableName = string;
            ArrayList arrayList = templateState2.getTemplate().getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getVariables(...)");
            Iterable $this$firstOrNull$iv = arrayList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Variable it = (Variable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)currentVariableName)) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        Variable variable = v3;
        if (variable == null) {
            return false;
        }
        Variable currentVariable = variable;
        Expression expression = currentVariable.getExpression();
        FrontendLiveTemplateMacroExpression frontendLiveTemplateMacroExpression = expression instanceof FrontendLiveTemplateMacroExpression ? (FrontendLiveTemplateMacroExpression)expression : null;
        if (frontendLiveTemplateMacroExpression == null) {
            return false;
        }
        FrontendLiveTemplateMacroExpression frontendLiveTemplateMacroExpression2 = frontendLiveTemplateMacroExpression;
        return frontendLiveTemplateMacroExpression2.getVariable().getRanges().size() > 1;
    }

    private final boolean shouldTrustBackend(Editor editor2) {
        Language language = DocumentUtilKt.getLanguage(editor2);
        if (language == null) {
            return false;
        }
        Language language2 = language;
        IdeBackend ideBackend = IdeBackend.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)((Object)ideBackend), (String)"null cannot be cast to non-null type com.jetbrains.rider.services.RiderDefaultBackend");
        RiderDefaultBackend backend = (RiderDefaultBackend)ideBackend;
        return backend.getAutoPopupBackendSupportPolicy(language2) == AutoPopupBackendSupportPolicy.TRUST_BACKEND;
    }

    private final void cancelLookup(Editor editor2) {
        LOG.trace("cancelling completion activity");
        LookupEx lookupEx = LookupManagerImpl.getActiveLookup((Editor)editor2);
        LookupImpl lookupImpl = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        CompletionProcess currentCompletion = CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null && !currentCompletion.isAutopopupCompletion()) {
            return;
        }
        if (currentCompletion != null && !currentCompletion.isAutopopupCompletion()) {
            LOG.trace("current completion was started manually, do not cancel it by backend response");
            return;
        }
        if (lookupImpl == null) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("we've got active completion progress in " + CompletionServiceImpl.Companion.getCompletionService().getClass().getCanonicalName() + " phase and 'DoNotShow' response from backend. Stopping completion progress.");
            }
            CompletionProgressIndicator.cleanupForNextTest();
        }
    }

    public static final /* synthetic */ boolean access$hasMultipleEditSegments(FrontendAutoPopupHost $this, Editor editor2) {
        return $this.hasMultipleEditSegments(editor2);
    }

    public static final /* synthetic */ void access$tryScheduleAutoPopup(FrontendAutoPopupHost $this, Editor editor2, AutoPopupResult result2) {
        $this.tryScheduleAutoPopup(editor2, result2);
    }

    public static final /* synthetic */ void access$cancelLookup(FrontendAutoPopupHost $this, Editor editor2) {
        $this.cancelLookup(editor2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendAutoPopupHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        autoPopupState$delegate = UserDataHolderKt.userData$default(null, (int)1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$AutoPopupState;", "", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "isNextLookupSoft", "", "()Z", "setNextLookupSoft", "(Z)V", "latestTypingTimestamp", "", "getLatestTypingTimestamp", "()I", "setLatestTypingTimestamp", "(I)V", "scheduleAutoPopupSeq", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getScheduleAutoPopupSeq", "()Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "intellij.rider.rdclient.dotnet"})
    public static final class AutoPopupState {
        private boolean isNextLookupSoft;
        private int latestTypingTimestamp;
        @NotNull
        private final SequentialLifetimes scheduleAutoPopupSeq;

        public AutoPopupState(@NotNull Lifetime editorLifetime) {
            Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
            this.scheduleAutoPopupSeq = new SequentialLifetimes(editorLifetime);
        }

        public final boolean isNextLookupSoft() {
            return this.isNextLookupSoft;
        }

        public final void setNextLookupSoft(boolean bl) {
            this.isNextLookupSoft = bl;
        }

        public final int getLatestTypingTimestamp() {
            return this.latestTypingTimestamp;
        }

        public final void setLatestTypingTimestamp(int n) {
            this.latestTypingTimestamp = n;
        }

        @NotNull
        public final SequentialLifetimes getScheduleAutoPopupSeq() {
            return this.scheduleAutoPopupSeq;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\b*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R9\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@BX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "<set-?>", "Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$AutoPopupState;", "autoPopupState", "Lcom/intellij/openapi/editor/Editor;", "getAutoPopupState$annotations", "(Lcom/intellij/openapi/editor/Editor;)V", "getAutoPopupState", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$AutoPopupState;", "setAutoPopupState", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$AutoPopupState;)V", "autoPopupState$delegate", "Lkotlin/properties/ReadWriteProperty;", "getInstance", "Lcom/jetbrains/rider/completion/FrontendAutoPopupHost;", "project", "Lcom/intellij/openapi/project/Project;", "pushInitialAutoPopupState", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFrontendAutoPopupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,218:1\n31#2,2:219\n*S KotlinDebug\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost$Companion\n*L\n42#1:219,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final FrontendAutoPopupHost getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AutoPopupHost> serviceClass$iv = AutoPopupHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.completion.FrontendAutoPopupHost");
            return (FrontendAutoPopupHost)object;
        }

        @Nullable
        public final AutoPopupState getAutoPopupState(@NotNull Editor $this$autoPopupState) {
            Intrinsics.checkNotNullParameter((Object)$this$autoPopupState, (String)"<this>");
            return (AutoPopupState)autoPopupState$delegate.getValue((Object)$this$autoPopupState, $$delegatedProperties[0]);
        }

        private final void setAutoPopupState(Editor $this$autoPopupState, AutoPopupState autoPopupState) {
            autoPopupState$delegate.setValue((Object)$this$autoPopupState, $$delegatedProperties[0], (Object)autoPopupState);
        }

        public static /* synthetic */ void getAutoPopupState$annotations(Editor editor2) {
        }

        private final AutoPopupState pushInitialAutoPopupState(Editor $this$pushInitialAutoPopupState, Lifetime lifetime2) {
            AutoPopupState autoPopupState = new AutoPopupState(lifetime2);
            this.setAutoPopupState($this$pushInitialAutoPopupState, autoPopupState);
            return autoPopupState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "autoPopupState", "getAutoPopupState(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$AutoPopupState;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/completion/FrontendAutoPopupHost$MyListener;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldExpectFrontendCompletion", "", "language", "Lcom/intellij/lang/Language;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFrontendAutoPopupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost$MyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1747#2,3:219\n*S KotlinDebug\n*F\n+ 1 FrontendAutoPopupHost.kt\ncom/jetbrains/rider/completion/FrontendAutoPopupHost$MyListener\n*L\n111#1:219,3\n*E\n"})
    public static final class MyListener
    implements FrontendTextControlHostListener {
        @Override
        public void editorBound(@NotNull Lifetime lifetime2, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Project project2 = editor2.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            FrontendAutoPopupHost host = Companion.getInstance(project3);
            if (!host.shouldTrustBackend(editor2)) {
                return;
            }
            TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
            if (textControlModel == null) {
                return;
            }
            TextControlModel textControlModel2 = textControlModel;
            AutoPopupState autoPopupState = Companion.pushInitialAutoPopupState(editor2, lifetime2);
            autoPopupState.setLatestTypingTimestamp(0);
            CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getAutoPopupResult().advise(lifetime2, (Function1)new Function1<AutoPopupResult, Unit>(host, editor2, autoPopupState, this){
                final /* synthetic */ FrontendAutoPopupHost $host;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ AutoPopupState $autoPopupState;
                final /* synthetic */ MyListener this$0;
                {
                    this.$host = $host;
                    this.$editor = $editor;
                    this.$autoPopupState = $autoPopupState;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull AutoPopupResult result2) {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    Logger $this$trace$iv = FrontendAutoPopupHost.Companion.getLOG();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("getting auto popup request from backend... " + result2);
                    }
                    if (!this.$host.isUpToDateAutopopup(this.$editor, result2)) {
                        return;
                    }
                    if (FrontendAutoPopupHost.access$hasMultipleEditSegments(this.$host, this.$editor)) {
                        return;
                    }
                    try {
                        if (result2.getShouldBeShown()) {
                            Boolean forceSoft = result2.getForceSoft();
                            if (forceSoft != null) {
                                this.$autoPopupState.setNextLookupSoft(forceSoft);
                            }
                            FrontendAutoPopupHost.access$tryScheduleAutoPopup(this.$host, this.$editor, result2);
                        } else {
                            Language language;
                            int offset = this.$editor.getCaretModel().getOffset();
                            PsiFile psiFile = TextControlUtilsKt.getPsiFile(this.$editor);
                            Language language2 = psiFile != null && (psiFile = psiFile.findElementAt(offset)) != null ? psiFile.getLanguage() : (language = null);
                            if (!MyListener.access$shouldExpectFrontendCompletion(this.this$0, language)) {
                                FrontendAutoPopupHost.access$cancelLookup(this.$host, this.$editor);
                            }
                        }
                    }
                    catch (Throwable t) {
                        FrontendAutoPopupHost.Companion.getLOG().error(t);
                    }
                }
            });
            host.initBeforeTypingListener(editor2, lifetime2);
        }

        private final boolean shouldExpectFrontendCompletion(Language language) {
            boolean bl;
            block5: {
                if (language == null) {
                    return true;
                }
                List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(language);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
                List strategies = list;
                if (strategies.isEmpty()) {
                    return true;
                }
                Iterable $this$any$iv = strategies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompletionSessionStrategy it = (CompletionSessionStrategy)element$iv;
                        boolean bl2 = false;
                        if (!it.shouldExpectFrontendCompletion()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$shouldExpectFrontendCompletion(MyListener $this, Language language) {
            return $this.shouldExpectFrontendCompletion(language);
        }
    }
}

