/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.ui;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.ToolWindowComponentId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.ui.ComponentIdOwner;
import com.jetbrains.rd.ui.ComponentIdProvider;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/actions/ui/ToolWindowComponentIdProvider;", "Lcom/jetbrains/rd/ui/ComponentIdProvider;", "Lcom/jetbrains/rd/ide/model/ToolWindowComponentId;", "Lcom/jetbrains/rd/ui/ComponentIdOwner;", "()V", "createComponentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "tryGetComponent", "Ljava/awt/Component;", "componentId", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parentComponent", "intellij.rider.rdclient.dotnet"})
public final class ToolWindowComponentIdProvider
implements ComponentIdProvider<ToolWindowComponentId>,
ComponentIdOwner {
    @Nullable
    public ComponentId createComponentId(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        ToolWindow toolWindow = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(dataContext2);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Project project2 = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RdProjectId rdProjectId = ProjectUtilKt.getRdProjectId((Project)project2);
        String string = toolWindow2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (ComponentId)new ToolWindowComponentId(rdProjectId, string);
    }

    @Nullable
    public Component tryGetComponent(@NotNull ComponentId componentId, @NotNull ClientAppSession session2, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!(componentId instanceof ToolWindowComponentId)) {
            return null;
        }
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)session2, (RdProjectId)((ToolWindowComponentId)componentId).getProjectId());
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getProject()) == null) {
            return null;
        }
        ClientProjectSession project2 = clientProjectSession;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance((Project)project2).getToolWindow(((ToolWindowComponentId)componentId).getId());
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Object object = toolWindow2.getContentManager().getSelectedContent();
        return object != null && (object = object.getComponent()) != null ? (Component)object : (Component)toolWindow2.getComponent();
    }
}

