/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ide.bootstrap.StartupErrorReporter;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.RiderApplicationLoadListener;
import com.jetbrains.rider.RiderApplicationPreloadListener;
import com.jetbrains.rider.protocol.EarlyBackendStarter;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/RiderApplicationLoadListener;", "Lcom/intellij/ide/ApplicationLoadListener;", "()V", "isLaunched", "Lcom/jetbrains/rd/util/reactive/Property;", "", "()Lcom/jetbrains/rd/util/reactive/Property;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "configPath", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/application/Application;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "args", "", "", "(Lcom/intellij/openapi/application/Application;Ljava/nio/file/Path;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderApplicationLoadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderApplicationLoadListener.kt\ncom/jetbrains/rider/RiderApplicationLoadListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,117:1\n13#2:118\n13#3:119\n*S KotlinDebug\n*F\n+ 1 RiderApplicationLoadListener.kt\ncom/jetbrains/rider/RiderApplicationLoadListener\n*L\n47#1:118\n47#1:119\n*E\n"})
public class RiderApplicationLoadListener
implements ApplicationLoadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Property<Boolean> isLaunched;
    @NotNull
    public static final String WAIT_FOR_BACKEND_SHUTDOWN_PROPERTY = "waitForBackendShutdown";
    private static volatile boolean isDisabled;

    public RiderApplicationLoadListener() {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderApplicationLoadListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isLaunched = new Property((Object)false);
    }

    @NotNull
    public final Property<Boolean> isLaunched() {
        return this.isLaunched;
    }

    @Nullable
    public Object beforeApplicationLoaded(@NotNull Application application, @NotNull Path configPath, @NotNull List<String> args, @NotNull Continuation<? super Unit> $completion) {
        return RiderApplicationLoadListener.beforeApplicationLoaded$suspendImpl(this, application, configPath, args, $completion);
    }

    static /* synthetic */ Object beforeApplicationLoaded$suspendImpl(RiderApplicationLoadListener $this, Application application, Path configPath, List<String> args, Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(args), (Object)"update")) {
            isDisabled = true;
            $this.logger.info("Rider started in plugin update mode, will not start the backend.");
            return Unit.INSTANCE;
        }
        Object object = $this.beforeApplicationLoaded(application, configPath, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object beforeApplicationLoaded(@NotNull Application application, @NotNull Path configPath, @NotNull Continuation<? super Unit> $completion) {
        return RiderApplicationLoadListener.beforeApplicationLoaded$suspendImpl(this, application, configPath, $completion);
    }

    static /* synthetic */ Object beforeApplicationLoaded$suspendImpl(RiderApplicationLoadListener $this, Application application, Path configPath, Continuation<? super Unit> $completion) {
        if (!EarlyBackendStarter.Companion.isEnabled()) {
            RiderApplicationPreloadListener.Companion.beforeRiderLoaded(application, configPath);
        }
        if (CpuArch.is32Bit()) {
            $this.logger.warn("Attempt to run Rider in 32-bit Java Runtime");
            String riderSupports32BitEnvVarName = "RIDER_32_BIT";
            String envVarValue = System.getenv(riderSupports32BitEnvVarName);
            $this.logger.info("Environment variable " + riderSupports32BitEnvVarName + "=" + envVarValue);
            Intrinsics.checkNotNull((Object)envVarValue);
            String string = envVarValue.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"true")) {
                StartupErrorReporter.showError((String)RdClientDotnetBundle.INSTANCE.message("unsupported.java.runtime.title", new Object[0]), (String)RdClientDotnetBundle.INSTANCE.message("unsupported.java.runtime.message", new Object[0]));
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        System.out.println((Object)("Installation home directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath())));
        System.out.println((Object)("System directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getSystemPath())));
        System.out.println((Object)("Config directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getConfigPath())));
        System.out.println((Object)("Log directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getLogPath())));
        Lifetime applicationLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)application));
        ProtocolManager protocolManager = new ProtocolManager(application, applicationLifetime);
        application.putUserData(ProtocolKeys.Companion.getProtocolManagerKey(), (Object)protocolManager);
        $this.isLaunched.set((Object)Boxing.boxBoolean((boolean)true));
        MessageBusConnection connection = application.getMessageBus().connect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(applicationLifetime, protocolManager, $this){
            final /* synthetic */ Lifetime $applicationLifetime;
            final /* synthetic */ ProtocolManager $protocolManager;
            final /* synthetic */ RiderApplicationLoadListener this$0;
            {
                this.$applicationLifetime = $applicationLifetime;
                this.$protocolManager = $protocolManager;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void appWillBeClosed(boolean isRestart) {
                void $this$forEach$iv;
                RLifetimeKt.assertAlive((Lifetime)this.$applicationLifetime);
                Iterable iterable = (Iterable)this.$protocolManager.getProtocolHosts();
                ProtocolManager protocolManager = this.$protocolManager;
                RiderApplicationLoadListener riderApplicationLoadListener = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                    boolean bl = false;
                    protocolManager.requestShutdown(it);
                    if (!SystemProperties.getBooleanProperty((String)"waitForBackendShutdown", (boolean)false)) continue;
                    RiderApplicationLoadListener.access$getLogger$p(riderApplicationLoadListener).info("Waiting for backend shutdown in Playback tests");
                    ReSharperProcessBase reSharperProcessBase = it.getResharperProcess();
                    if (reSharperProcessBase != null) {
                        reSharperProcessBase.waitFor(false, (Function0<Unit>)((Function0)beforeApplicationLoaded.appWillBeClosed.1.1.INSTANCE));
                    }
                    RiderApplicationLoadListener.access$getLogger$p(riderApplicationLoadListener).info("Backend process shutdown complete");
                }
            }
        });
        application.addApplicationListener(new ApplicationListener(protocolManager){
            final /* synthetic */ ProtocolManager $protocolManager;
            {
                this.$protocolManager = $protocolManager;
            }

            public void applicationExiting() {
                this.$protocolManager.forceShutdown();
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)applicationLifetime, null, (int)1, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RiderApplicationLoadListener $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/RiderApplicationLoadListener$Companion;", "", "()V", "WAIT_FOR_BACKEND_SHUTDOWN_PROPERTY", "", "isDisabled", "", "()Z", "setDisabled", "(Z)V", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDisabled() {
            return isDisabled;
        }

        public final void setDisabled(boolean bl) {
            isDisabled = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

