/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rider.util.StartUpUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\u0013\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/PerformanceOutput;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "reportApplicationLoaded", "", "delta", "", "reportAssertion", "message", "", "reportBackendLoaded", "reportBackendSolutionLoaded", "reportCommandReject", "reportMemoryFootprint", "usedMem", "reportSolutionBenchmark", "benchmarkId", "logMeasuredSize", "key", "bytes", "intellij.rider.plugins.rdclient.performance"})
@SourceDebugExtension(value={"SMAP\nPerformanceOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceOutput.kt\ncom/jetbrains/rider/PerformanceOutput\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n13#3:46\n*S KotlinDebug\n*F\n+ 1 PerformanceOutput.kt\ncom/jetbrains/rider/PerformanceOutput\n*L\n10#1:45\n10#1:46\n*E\n"})
public final class PerformanceOutput {
    @NotNull
    public static final PerformanceOutput INSTANCE = new PerformanceOutput();
    @NotNull
    private static final Logger logger;

    private PerformanceOutput() {
    }

    public final void reportApplicationLoaded(long delta) {
        StructuredLoggingKt.logMeasuredTime$default((Logger)logger, (String)"ApplicationLoad", (long)delta, null, (int)4, null);
    }

    public final void reportBackendLoaded(long delta) {
        StructuredLoggingKt.logMeasuredTime$default((Logger)logger, (String)"BackendShellLoad", (long)delta, null, (int)4, null);
    }

    public final void reportBackendSolutionLoaded(long delta) {
        StructuredLoggingKt.logMeasuredTime$default((Logger)logger, (String)"BackendSolutionLoad", (long)delta, null, (int)4, null);
        StartUpUtilKt.logMeasuredStartupTime(logger, "startup.full");
    }

    public final void reportSolutionBenchmark(@NotNull String benchmarkId, long delta) {
        Intrinsics.checkNotNullParameter((Object)benchmarkId, (String)"benchmarkId");
        StructuredLoggingKt.logMeasuredTime$default((Logger)logger, (String)benchmarkId, (long)delta, null, (int)4, null);
    }

    public final void reportAssertion(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StructuredLoggingKt.logStructuredError((Logger)logger, (String)message2);
    }

    public final void reportCommandReject(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StructuredLoggingKt.logStructuredError((Logger)logger, (String)message2);
    }

    public final void reportMemoryFootprint(long usedMem) {
        PerformanceOutput.logMeasuredSize$default(this, logger, "memory.footprint", usedMem, null, 4, null);
    }

    private final void logMeasuredSize(Logger $this$logMeasuredSize, String key, long bytes, String message2) {
        String string = message2;
        if (string == null) {
            string = "";
        }
        StructuredLoggingKt.sendStructuredLog((Logger)$this$logMeasuredSize, (String)("<Measured> \"" + key + "\" " + string + " value=" + bytes + "b\u200b\u200c\u200b"));
    }

    static /* synthetic */ void logMeasuredSize$default(PerformanceOutput performanceOutput, Logger logger, String string, long l, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        performanceOutput.logMeasuredSize(logger, string, l, string2);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerformanceOutput.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PerformanceOutput.logger = logger;
    }
}

