/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.io.DigestUtil;
import com.jetbrains.rider.CrossgenRunUtil;
import com.jetbrains.rider.ProtectedRiderBackendExecutable;
import com.jetbrains.rider.RiderEnvironment;
import java.io.File;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/CrossgenRunUtil;", "", "()V", "BinCopiedMarkerFileName", "", "CrossgenVersionFileName", "MarkerFileName", "MaxHashLength", "", "UseR2RImagesName", "allowUseR2RImages", "Lkotlin/Lazy;", "", "getAllowUseR2RImages", "()Lkotlin/Lazy;", "buildVersion", "getBuildVersion", "()Ljava/lang/String;", "r2rDirWithBuildVersion", "Ljava/io/File;", "getR2rDirWithBuildVersion", "()Ljava/io/File;", "tryGetHashForVersionFile", "versionFileCanonical", "version", "tryGetProtectedRiderBackendExecutable", "Lcom/jetbrains/rider/ProtectedRiderBackendExecutable;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/CrossgenRunUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,796:1\n23#2:797\n23#2:798\n23#2:799\n23#2:800\n23#2:801\n23#2:802\n23#2:803\n23#2:804\n23#2:805\n23#2:806\n23#2:807\n23#2:808\n*S KotlinDebug\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/CrossgenRunUtil\n*L\n666#1:797\n673#1:798\n768#1:799\n704#1:800\n710#1:801\n716#1:802\n723#1:803\n730#1:804\n764#1:805\n741#1:806\n747#1:807\n753#1:808\n*E\n"})
public final class CrossgenRunUtil {
    @NotNull
    public static final CrossgenRunUtil INSTANCE = new CrossgenRunUtil();
    @NotNull
    private static final String CrossgenVersionFileName = "Rider.Backend.Crossgen.Version.txt";
    @NotNull
    private static final String MarkerFileName = "CrossgenMarker.txt";
    @NotNull
    private static final String BinCopiedMarkerFileName = "BinCopiedMarker.txt";
    private static final int MaxHashLength = 31;
    @NotNull
    public static final String UseR2RImagesName = "rider.backend.use.r2r.images";
    @NotNull
    private static final Lazy<Boolean> allowUseR2RImages = LazyKt.lazy((Function0)allowUseR2RImages.1.INSTANCE);

    private CrossgenRunUtil() {
    }

    @NotNull
    public final Lazy<Boolean> getAllowUseR2RImages() {
        return allowUseR2RImages;
    }

    @Nullable
    public final File getR2rDirWithBuildVersion() {
        if (!SystemInfo.isWindows) {
            return null;
        }
        return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getenv("PROGRAMFILES")), (String)"JetBrains"), (String)"Rider"), (String)"r2r"), (String)this.getBuildVersion());
    }

    private final String getBuildVersion() {
        ApplicationInfoEx info2;
        block9: {
            block8: {
                ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
                info2 = applicationInfoEx;
                String string = info2.getMicroVersion();
                if (string == null) {
                    string = "0";
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"0")) break block8;
                String string2 = info2.getPatchVersion();
                if (string2 == null) {
                    string2 = "0";
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"0")) break block9;
            }
            CrossgenRunUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Odd product version detected: " + info2.getMajorVersion() + "." + info2.getMinorVersion() + "." + info2.getMicroVersion() + "." + info2.getPatchVersion() + ". Ignoring micro and patch parts.");
        }
        String string = info2.getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        String versionString = string;
        Version version = Version.parseVersion((String)versionString);
        if (version == null) {
            Object object;
            CrossgenRunUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot parse version from string " + versionString + ". Falling back to the legacy algorithm.");
            String string3 = info2.getMajorVersion();
            String string4 = info2.getMinorVersion();
            Object object2 = info2.getMicroVersion();
            if (object2 == null) {
                object2 = 0;
            }
            if ((object = info2.getPatchVersion()) == null) {
                object = 0;
            }
            return string3 + "." + string4 + "." + object2 + "." + object + (info2.isEAP() ? "EAP" : "R");
        }
        return version.major + "." + version.minor + "." + version.bugfix + (info2.isEAP() ? "EAP" : "R");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ProtectedRiderBackendExecutable tryGetProtectedRiderBackendExecutable() {
        if (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer()) {
            return null;
        }
        long start2 = System.nanoTime();
        try {
            boolean $i$f$thisLogger;
            CrossgenRunUtil $this$thisLogger$iv;
            File file2;
            String string;
            File versionFile = RiderEnvironment.getBundledFile$default(RiderEnvironment.INSTANCE, CrossgenVersionFileName, false, null, false, 14, null);
            String versionFileCanonical = versionFile.getCanonicalPath();
            String version = FilesKt.readText$default((File)versionFile, null, (int)1, null);
            Intrinsics.checkNotNull((Object)versionFileCanonical);
            if (this.tryGetHashForVersionFile(versionFileCanonical, version) == null) {
                ProtectedRiderBackendExecutable protectedRiderBackendExecutable = null;
                return protectedRiderBackendExecutable;
            }
            String hash = string;
            if (this.getR2rDirWithBuildVersion() == null) {
                ProtectedRiderBackendExecutable $this$thisLogger$iv2 = null;
                return $this$thisLogger$iv2;
            }
            File r2rDirWithBuildVersion = file2;
            CrossgenRunUtil $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("r2rDirWithBuildVersion: " + r2rDirWithBuildVersion);
            File r2rBinDir = FilesKt.resolve((File)r2rDirWithBuildVersion, (String)hash);
            File markerFile = FilesKt.resolve((File)r2rBinDir, (String)MarkerFileName);
            Ref.BooleanRef crossgenIsReady = new Ref.BooleanRef();
            crossgenIsReady.element = true;
            if (!markerFile.exists()) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(CrossgenRunUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("CrossgenMarker.txt marker file doesn't exist (\"" + markerFile + "\"). Falling back to BinCopiedMarker.txt");
                crossgenIsReady.element = false;
                markerFile = FilesKt.resolve((File)r2rBinDir, (String)BinCopiedMarkerFileName);
            }
            if (!markerFile.exists()) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger3 = Logger.getInstance(CrossgenRunUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.warn("BinCopiedMarker.txt marker file doesn't exist (\"" + markerFile + "\").");
                $this$thisLogger$iv = null;
                return $this$thisLogger$iv;
            }
            String r2rOriginVersionFilePath = FilesKt.readText$default((File)markerFile, null, (int)1, null);
            String r2rOriginVersionFileCanonical = new File(r2rOriginVersionFilePath).getCanonicalPath();
            if (!StringsKt.equals((String)r2rOriginVersionFileCanonical, (String)versionFileCanonical, (boolean)true)) {
                CrossgenRunUtil $this$thisLogger$iv4 = this;
                boolean $i$f$thisLogger3 = false;
                Logger logger4 = Logger.getInstance(CrossgenRunUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
                logger4.warn("expected version file path: " + versionFile + " is not equal to r2r version file path: " + versionFileCanonical);
                $this$thisLogger$iv4 = null;
                return $this$thisLogger$iv4;
            }
            File r2rVersionFile = FilesKt.resolve((File)r2rBinDir, (String)CrossgenVersionFileName);
            String r2rVersion = FilesKt.readText$default((File)r2rVersionFile, null, (int)1, null);
            if (!Intrinsics.areEqual((Object)r2rVersion, (Object)version)) {
                CrossgenRunUtil $this$thisLogger$iv5 = this;
                boolean $i$f$thisLogger4 = false;
                Logger logger5 = Logger.getInstance(CrossgenRunUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getInstance(...)");
                logger5.warn("r2rVersion: " + r2rVersion + " is not equal to current: " + version);
                $this$thisLogger$iv5 = null;
                return $this$thisLogger$iv5;
            }
            File file3 = FilesKt.resolve((File)r2rBinDir, (String)RiderEnvironment.INSTANCE.getRiderBackendExecutableName());
            File niFile = CrossgenRunUtil.tryGetProtectedRiderBackendExecutable$tryGetNi(crossgenIsReady, file3);
            boolean bl = niFile != null;
            File file4 = niFile;
            if (file4 == null) {
                file4 = file3;
            }
            ProtectedRiderBackendExecutable protectedRiderBackendExecutable = new ProtectedRiderBackendExecutable(bl, file4);
            return protectedRiderBackendExecutable;
        }
        catch (Throwable e) {
            CrossgenRunUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get ni file", e);
            $this$thisLogger$iv = null;
            return $this$thisLogger$iv;
        }
        finally {
            CrossgenRunUtil $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("tryGetNiFile took " + (System.nanoTime() - start2) / (long)1000000 + "ms");
        }
    }

    private final String tryGetHashForVersionFile(String versionFileCanonical, String version) {
        String string = StringsKt.replace$default((String)versionFileCanonical, (char)'\\', (char)'/', (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String invariantPath = string;
        String hashSource = invariantPath + version;
        byte[] byArray = EncryptionUtil.getUTF8Bytes((String)hashSource);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUTF8Bytes(...)");
        String hexString = DigestUtil.sha1Hex((byte[])byArray);
        String string2 = hexString.substring(0, Math.min(hexString.length(), 31));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string3;
    }

    private static final File tryGetProtectedRiderBackendExecutable$tryGetNi(Ref.BooleanRef crossgenIsReady, File file2) {
        if (!crossgenIsReady.element) {
            return null;
        }
        if (!((Boolean)allowUseR2RImages.getValue()).booleanValue()) {
            CrossgenRunUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("rider.backend.use.r2r.images is false. Don't use r2r images.");
            return null;
        }
        File niFile = new File(file2.getParentFile(), FilesKt.getNameWithoutExtension((File)file2) + ".ni." + FilesKt.getExtension((File)file2));
        if (!niFile.exists()) {
            CrossgenRunUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(niFile + " doesn't exist");
            return null;
        }
        File niDepsJson = new File(file2.getParentFile(), FilesKt.getNameWithoutExtension((File)file2) + ".ni.deps.json");
        if (!niDepsJson.exists()) {
            CrossgenRunUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CrossgenRunUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(niDepsJson + " doesn't exist");
            return null;
        }
        return niFile;
    }
}

