/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.quickDoc;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.quickDoc.DocV2FakeElement;
import com.jetbrains.rdclient.quickDoc.FrontendDocumentationSessionWrapper;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\u001b\u0010\u0018\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00000\u00000\u0019\u00a2\u0006\u0002\b\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "data", "Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "getData", "()Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;", "getFile", "()Lcom/intellij/psi/PsiFile;", "navigatable", "Lcom/jetbrains/rdclient/quickDoc/DocV2FakeElement;", "getNavigatable", "()Lcom/jetbrains/rdclient/quickDoc/DocV2FakeElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult$Documentation;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "Lorg/jetbrains/annotations/NotNull;", "createPointer", "Lcom/intellij/model/Pointer;", "kotlin.jvm.PlatformType", "intellij.rd.client"})
public final class FrontendDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final FrontendDocumentationSessionWrapper data;
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final DocV2FakeElement navigatable;

    public FrontendDocumentationTarget(@NotNull FrontendDocumentationSessionWrapper data2, @NotNull Project project2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.data = data2;
        this.project = project2;
        this.file = file2;
        this.navigatable = new DocV2FakeElement(this.file, this.data);
    }

    @NotNull
    public final FrontendDocumentationSessionWrapper getData() {
        return this.data;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public DocV2FakeElement getNavigatable() {
        return this.navigatable;
    }

    @NotNull
    public Pointer<FrontendDocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        String string = this.data.getInitialInfo().getPresentableName();
        if (string == null) {
            string = "Documentation";
        }
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public DocumentationResult.Documentation computeDocumentation() {
        return DocumentationResult.Companion.documentation(RichTextHtmlUtils.INSTANCE.highlightAttributedParts(this.data.getInitialInfo().getDescriptionHtml()));
    }
}

