/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.actions.base.ActionContinuation;
import com.jetbrains.rdclient.actions.base.ActionContinuationHolder;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListener;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListenerKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.cwm.FrontendAsyncActionHost;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandlerKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0004\u001a\u001b\u001c\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J*\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "backendDeclaredStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;)V", "getBackendDeclaredStrategy", "()Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "backendIsEnabled", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "strategy", "doExecuteByStrategy", "tryFrontend", "getCallStrategy", "isEnabledForCaret", "CallEditorActionRequestFactory", "Companion", "LocalCallEditorActionRequestFactory", "RemoteCallEditorActionRequestFactory", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,290:1\n107#2:291\n98#2,4:292\n103#2:296\n98#2,4:297\n106#2:304\n98#2,4:305\n42#3,3:301\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n*L\n114#1:291\n114#1:292,4\n118#1:296\n118#1:297,4\n171#1:304\n171#1:305,4\n146#1:301,3\n*E\n"})
public final class FrontendAsyncEditorActionHandler
extends EditorActionHandler
implements FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private final ActionCallStrategyKind backendDeclaredStrategy;
    @NotNull
    private static final Set<String> PASTE_ACTIONS_IDS;
    @NotNull
    private static final Set<String> COPY_ACTIONS_IDS;
    @NotNull
    private static final Set<String> TRAVERSAL_ACTIONS_IDS;
    private static boolean isExecuting;

    public FrontendAsyncEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler, @NotNull ActionCallStrategyKind backendDeclaredStrategy) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        Intrinsics.checkNotNullParameter((Object)backendDeclaredStrategy, (String)"backendDeclaredStrategy");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
        this.backendDeclaredStrategy = backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getBackendDeclaredStrategy() {
        return this.backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getCallStrategy(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        ActionCallStrategyKind actionCallStrategyKind = (ActionCallStrategyKind)FrontendEditorActionHandlerStrategyCustomizer.Companion.getEP().computeSafeIfAny(arg_0 -> FrontendAsyncEditorActionHandler.getCallStrategy$lambda$0(this, editor2, caret, dataContext2, arg_0));
        if (actionCallStrategyKind == null) {
            actionCallStrategyKind = this.backendDeclaredStrategy;
        }
        return actionCallStrategyKind;
    }

    private final boolean backendIsEnabled(Editor editor2, DataContext dataContext2) {
        return DocumentExKt.getTextControlId(editor2) != null && FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext2, null, "unknown", null);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return this.baseHandler.isEnabled(editor2, caret, dataContext2);
        }
        if (DocumentExKt.getTextControlId(editor2) == null) {
            return this.baseHandler.isEnabled(editor2, caret, dataContext2);
        }
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor2, caret, dataContext2);
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: {
                return this.baseHandler.isEnabled(editor2, caret, dataContext2);
            }
            case 2: {
                return this.baseHandler.isEnabled(editor2, caret, dataContext2) && this.backendIsEnabled(editor2, dataContext2);
            }
            case 3: {
                return this.backendIsEnabled(editor2, dataContext2) || this.baseHandler.isEnabled(editor2, caret, dataContext2);
            }
            case 4: {
                Boolean actionAvailableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint((Editor)editor2, (int)editor2.getCaretModel().getOffset(), (String)this.frontendId);
                return Intrinsics.areEqual((Object)actionAvailableByHint, (Object)true);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            this.baseHandler.execute(editor2, caret, dataContext2);
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor2, caret, dataContext2);
        if (isExecuting) {
            void $this$log$iv$iv;
            if (strategy2 == ActionCallStrategyKind.FrontendOnly || strategy2 == ActionCallStrategyKind.FrontendFirst) {
                if (this.baseHandler.isEnabled(editor2, caret, dataContext2)) {
                    this.baseHandler.execute(editor2, caret, dataContext2);
                }
                return;
            }
            Logger $this$error$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_18 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Nested action '" + this.frontendId + "' call: FrontendAsyncEditorActionHandler.doExecute";
                var11_18.log(logLevel, (Object)string, null);
            }
            return;
        }
        Logger $this$trace$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        Logger $this$log$iv$iv = $this$trace$iv;
        LogLevel level$iv$iv = LogLevel.Trace;
        boolean $i$f$log = false;
        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
            LogLevel logLevel = level$iv$iv;
            Logger logger = $this$log$iv$iv;
            boolean bl = false;
            String string = "For action " + this.frontendId + " selected strategy is " + strategy2;
            logger.log(logLevel, (Object)string, null);
        }
        try {
            isExecuting = true;
            this.doExecute(editor2, caret, dataContext2, strategy2);
        }
        finally {
            isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doExecute(Editor editor2, Caret caret, DataContext dataContext2, ActionCallStrategyKind strategy2) {
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: {
                RdPatch rdPatch;
                void $this$recordChanges$iv;
                ClientAppSession session2 = DataContextKt.getFrontendAppSession((DataContext)dataContext2);
                if (session2 == null) {
                    FrontendAsyncEditorActionHandler.doExecute$executeFrontend(this, editor2, caret, dataContext2);
                    return;
                }
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor2);
                PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(session2);
                String description$iv = "Action handler " + this.frontendId;
                boolean $i$f$recordChanges = false;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
                Throwable throwable = null;
                try {
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl = false;
                    ChangeScope $this$doExecute_u24lambda_u243 = it$iv.getSession().getChangeScope();
                    boolean bl2 = false;
                    FrontendAsyncEditorActionHandler.doExecute$executeFrontend(this, editor2, caret, dataContext2);
                    rdPatch = it$iv.getSession().getPatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                RdPatch patch = rdPatch;
                if (patch != null) {
                    FrontendAsyncRequestExecutor.Companion.getInstance(session2).submitRequest(new FrontendApplyPatchRequest(patch, session2, resetUndoHistoryToken));
                }
                return;
            }
            case 2: {
                this.doExecuteByStrategy(editor2, caret, dataContext2, true);
                return;
            }
            case 3: {
                this.doExecuteByStrategy(editor2, caret, dataContext2, false);
                break;
            }
            case 4: {
                void $this$log$iv$iv;
                Boolean availableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint((Editor)editor2, (int)editor2.getCaretModel().getOffset(), (String)this.frontendId);
                if (Intrinsics.areEqual((Object)availableByHint, (Object)true)) {
                    this.doExecuteByStrategy(editor2, caret, dataContext2, false);
                    break;
                }
                Logger $this$warn$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
                boolean $i$f$warn = false;
                Logger $this$recordChanges$iv = $this$warn$iv;
                LogLevel level$iv$iv = LogLevel.Warn;
                boolean $i$f$log = false;
                if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                LogLevel logLevel = level$iv$iv;
                void var18_28 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Action '" + this.frontendId + "' is not available by availability hint but still was called for execution. Skipping.";
                var18_28.log(logLevel, (Object)string, null);
            }
        }
    }

    private final void doExecuteByStrategy(Editor editor2, Caret caret, DataContext dataContext2, boolean tryFrontend) {
        ClientAppSession clientAppSession = DataContextKt.getFrontendAppSession((DataContext)dataContext2);
        if (clientAppSession == null) {
            this.baseHandler.execute(editor2, caret, dataContext2);
            return;
        }
        ClientAppSession session2 = clientAppSession;
        TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
        if (textControlId == null) {
            this.baseHandler.execute(editor2, caret, dataContext2);
            return;
        }
        TextControlId editorId = textControlId;
        if (!((Boolean)FrontendSessionsUtilKt.isConnected(session2).getValue()).booleanValue() || FrontendPatchEngineKt.getEngine(session2).getHasActivePatch()) {
            this.baseHandler.execute(editor2, caret, dataContext2);
            return;
        }
        Object object = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendActionExecutionListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        FrontendActionExecutionListenerKt.beforeActionExecutedOnBackend((FrontendActionExecutionListener)object, this.frontendId);
        if (tryFrontend) {
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            Disposable disposable = ((EditorImpl)editor2).getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            Lifetime lifetime2 = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)lifetime2, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor2, dataContext2, session2, editorId, caret, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FrontendAsyncEditorActionHandler this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ DataContext $dataContext;
                final /* synthetic */ ClientAppSession $session;
                final /* synthetic */ TextControlId $editorId;
                final /* synthetic */ Caret $caret;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$dataContext = $dataContext;
                    this.$session = $session;
                    this.$editorId = $editorId;
                    this.$caret = $caret;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launchOnUi = (CoroutineScope)this.L$0;
                            if (FrontendAsyncEditorActionHandler.access$getTRAVERSAL_ACTIONS_IDS$cp().contains(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0))) {
                                v0 = DocumentExKt.getTextControlModel(this.$editor);
                                v1 = v0 != null && (v0 = TextControlModelExKt.getHasTemplateTraversalPolicyExtension((TextControlModel)v0)) != null ? v0.getHasTemplateTraversalPolicy() : false;
                                if (v1) {
                                    v2 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)this.$dataContext);
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"createFromDataContext(...)");
                                    event = v2;
                                    FrontendAsyncActionHost.Companion.getInstance(this.$session).execute(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), event);
                                    return Unit.INSTANCE;
                                }
                            }
                            deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                            v3 = (ActionContinuationHolder)BackendActionDelegationKt.getBACKEND_ACTION_CONTINUATION_KEY().getData(this.$dataContext);
                            if (v3 != null) {
                                v3.setContinuation(new ActionContinuation((CompletableDeferred<Unit>)deferred){
                                    final /* synthetic */ CompletableDeferred<Unit> $deferred;
                                    {
                                        this.$deferred = $deferred;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object await(@NotNull Continuation<? super Unit> var1_1) {
                                        if (!(var1_1 instanceof doExecuteByStrategy.await.1)) ** GOTO lbl-1000
                                        var3_2 = var1_1;
                                        if ((var3_2.label & -2147483648) != 0) {
                                            var3_2.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, var1_1){
                                                /* synthetic */ Object result;
                                                final /* synthetic */ doExecuteByStrategy.1 this$0;
                                                int label;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.await((Continuation<? super Unit>)((Continuation)this));
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                $continuation.label = 1;
                                                v0 = this.$deferred.await((Continuation)$continuation);
                                                if (v0 == var4_4) {
                                                    return var4_4;
                                                }
                                                ** GOTO lbl20
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl20:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                });
                            }
                            $this$service$iv = (ComponentManager)this.$session;
                            $i$f$service = false;
                            serviceClass$iv = CallEditorActionRequestFactory.class;
                            v4 = $this$service$iv.getService(serviceClass$iv);
                            if (v4 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            editorActionRequestFactory = (CallEditorActionRequestFactory)v4;
                            this.L$0 = $this$launchOnUi;
                            this.L$1 = deferred;
                            this.label = 1;
                            v5 = editorActionRequestFactory.createRequest(this.$editor, this.$editorId, FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), this.$caret, FrontendAsyncEditorActionHandler.access$getBaseHandler$p(this.this$0), this.$dataContext, (Continuation<? super FrontendAsyncRequest>)((Continuation)this));
                            if (v5 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl38
                        }
                        case 1: {
                            deferred = (CompletableDeferred)this.L$1;
                            $this$launchOnUi = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl38:
                            // 2 sources

                            v6 = (FrontendAsyncRequest)v5;
                            if (v6 == null) {
                                $i$a$-run-FrontendAsyncEditorActionHandler$doExecuteByStrategy$1$request$1 = false;
                                deferred.complete((Object)Unit.INSTANCE);
                                return Unit.INSTANCE;
                            }
                            request = v6;
                            this.L$0 = deferred;
                            this.L$1 = null;
                            this.label = 2;
                            v7 = FrontendAsyncRequestExecutor.Companion.getInstance(this.$session).executeRequest(request, (Continuation<? super Unit>)((Continuation)this));
                            ** if (v7 != var9_2) goto lbl54
lbl53:
                            // 1 sources

                            return var9_2;
lbl54:
                            // 1 sources

                            ** GOTO lbl65
                        }
                        case 2: {
                            deferred = (CompletableDeferred)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
                            }
                            catch (CancellationException ce) {
                                deferred.cancel(ce);
                                return Unit.INSTANCE;
                            }
lbl65:
                            // 2 sources

                            deferred.complete((Object)Unit.INSTANCE);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent event = anActionEvent;
            FrontendAsyncActionHost.Companion.getInstance(session2).execute(this.frontendId, event);
        }
    }

    private static final ActionCallStrategyKind getCallStrategy$lambda$0(FrontendAsyncEditorActionHandler this$0, Editor $editor, Caret $caret, DataContext $dataContext, FrontendEditorActionHandlerStrategyCustomizer customizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$dataContext, (String)"$dataContext");
        Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
        return customizer.getCustomStrategy(this$0.frontendId, $editor, $caret, $dataContext);
    }

    private static final void doExecute$executeFrontend(FrontendAsyncEditorActionHandler this$0, Editor $editor, Caret $caret, DataContext $dataContext) {
        if (this$0.baseHandler.isEnabled($editor, $caret, $dataContext)) {
            this$0.baseHandler.execute($editor, $caret, $dataContext);
        }
    }

    public static final /* synthetic */ Set access$getTRAVERSAL_ACTIONS_IDS$cp() {
        return TRAVERSAL_ACTIONS_IDS;
    }

    public static final /* synthetic */ String access$getFrontendId$p(FrontendAsyncEditorActionHandler $this) {
        return $this.frontendId;
    }

    public static final /* synthetic */ EditorActionHandler access$getBaseHandler$p(FrontendAsyncEditorActionHandler $this) {
        return $this.baseHandler;
    }

    static {
        Object[] objectArray = new String[]{"$Paste", "EditorPaste", "EditorPasteSimple", "PasteMultiple", "CompareClipboardWithSelection", "ChangesView.ApplyPatchFromClipboard", "Unscramble", "XDebugger.CompareValueWithClipboard"};
        PASTE_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"$Copy", "EditorCopy"};
        COPY_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"EditorTab", "BraceOrQuoteOut", "EditorUnindentSelection", "EditorIndentSelection"};
        TRAVERSAL_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JB\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u00a6@\u00a2\u0006\u0002\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    public static interface CallEditorActionRequestFactory {
        @Nullable
        public Object createRequest(@NotNull Editor var1, @NotNull TextControlId var2, @NotNull String var3, @Nullable Caret var4, @NotNull EditorActionHandler var5, @NotNull DataContext var6, @NotNull Continuation<? super FrontendAsyncRequest> var7);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$Companion;", "", "()V", "COPY_ACTIONS_IDS", "", "", "getCOPY_ACTIONS_IDS", "()Ljava/util/Set;", "PASTE_ACTIONS_IDS", "getPASTE_ACTIONS_IDS", "TRAVERSAL_ACTIONS_IDS", "<set-?>", "", "isExecuting", "()Z", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getPASTE_ACTIONS_IDS() {
            return PASTE_ACTIONS_IDS;
        }

        @NotNull
        public final Set<String> getCOPY_ACTIONS_IDS() {
            return COPY_ACTIONS_IDS;
        }

        public final boolean isExecuting() {
            return isExecuting;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,290:1\n42#2,3:291\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n*L\n247#1:291,3\n*E\n"})
    public static final class LocalCallEditorActionRequestFactory
    implements CallEditorActionRequestFactory {
        @NotNull
        private final ClientAppSession session;

        public LocalCallEditorActionRequestFactory(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Object createRequest(@NotNull Editor editor2, @NotNull TextControlId editorId, @NotNull String frontendActionId2, @Nullable Caret caret, @NotNull EditorActionHandler baseHandler, @NotNull DataContext dataContext2, @NotNull Continuation<? super FrontendAsyncRequest> $completion) {
            FrontendAsyncRequestExecutor frontendAsyncRequestExecutor = FrontendAsyncRequestExecutor.Companion.getInstance(this.session);
            if (frontendAsyncRequestExecutor.getSpeculativeExecutionEnabled()) {
                RdPatch rdPatch;
                void $this$recordChanges$iv;
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor2);
                PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(this.session);
                String description$iv = "Call editor action " + frontendActionId2;
                boolean $i$f$recordChanges = false;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
                Throwable throwable = null;
                try {
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl = false;
                    ChangeScope $this$createRequest_u24lambda_u240 = it$iv.getSession().getChangeScope();
                    boolean bl2 = false;
                    baseHandler.execute(editor2, caret, dataContext2);
                    RdPatch rdPatch2 = it$iv.getSession().getPatch();
                    rdPatch = rdPatch2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                if (rdPatch == null) {
                    return null;
                }
                RdPatch patch = rdPatch;
                return new FrontendCallEditorActionRequest(patch, editorId, frontendActionId2, this.session, resetUndoHistoryToken);
            }
            return new PhantomCallEditorActionRequest(frontendActionId2, editorId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$RemoteCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    public static final class RemoteCallEditorActionRequestFactory
    implements CallEditorActionRequestFactory {
        @NotNull
        private final ClientAppSession session;

        public RemoteCallEditorActionRequestFactory(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public Object createRequest(@NotNull Editor editor2, @NotNull TextControlId editorId, @NotNull String frontendActionId2, @Nullable Caret caret, @NotNull EditorActionHandler baseHandler, @NotNull DataContext dataContext2, @NotNull Continuation<? super FrontendAsyncRequest> $completion) {
            return new PhantomCallEditorActionRequest(frontendActionId2, editorId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionCallStrategyKind.values().length];
            try {
                nArray[ActionCallStrategyKind.FrontendOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.FrontendFirst.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.Backend.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWhenAvailableByHint.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

