/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlineInlayRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.InlayInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "frontendInlayModelAdapter", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;)V", "attach", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getInlayInfo", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/InlayInfo;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.rd.client"})
public final class FrontendInlayDocumentWatcher
implements DocumentListener {
    @Nullable
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final FrontendInlayModelAdapter frontendInlayModelAdapter;

    public FrontendInlayDocumentWatcher(@Nullable Project project2, @NotNull Editor editor2, @NotNull FrontendInlayModelAdapter frontendInlayModelAdapter) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frontendInlayModelAdapter, (String)"frontendInlayModelAdapter");
        this.project = project2;
        this.editor = editor2;
        this.frontendInlayModelAdapter = frontendInlayModelAdapter;
    }

    public final void attach(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        this.editor.getDocument().addDocumentListener((DocumentListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime2, null, (int)1, null));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getDocument().isInBulkUpdate()) {
                    return;
                }
                CharSequence charSequence = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                if (charSequence.length() == 0) break block10;
                CharSequence charSequence2 = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
                if (StringsKt.isBlank((CharSequence)charSequence2)) break block11;
            }
            return;
        }
        int oldOffset = event.getOffset();
        int newOffset = event.getOffset() + event.getNewFragment().length();
        VisualPosition visualPosition = this.editor.offsetToVisualPosition(event.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition visualPositionBefore = visualPosition;
        Inlay inlayBeforeInsertedText = this.editor.getInlayModel().getInlineElementAt(visualPositionBefore);
        if (inlayBeforeInsertedText != null) {
            InlayInfo inlayInfo = this.getInlayInfo(inlayBeforeInsertedText);
            if (inlayInfo == null) {
                return;
            }
            InlayInfo inlayInfo2 = inlayInfo;
            if (!inlayInfo2.getRelatesToPrecedingText()) {
                this.frontendInlayModelAdapter.moveInlay(inlayBeforeInsertedText, inlayInfo2, newOffset);
            }
        }
        VisualPosition visualPosition2 = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)this.editor, (int)newOffset);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"inlayAwareOffsetToVisualPosition(...)");
        VisualPosition visualPositionAfter = visualPosition2;
        Inlay inlayAfterInsertedText = this.editor.getInlayModel().getInlineElementAt(visualPositionAfter);
        if (inlayAfterInsertedText != null) {
            InlayInfo inlayInfo = this.getInlayInfo(inlayAfterInsertedText);
            if (inlayInfo == null) {
                return;
            }
            InlayInfo inlayInfo3 = inlayInfo;
            if (inlayInfo3.getRelatesToPrecedingText()) {
                this.frontendInlayModelAdapter.moveInlay(inlayAfterInsertedText, inlayInfo3, oldOffset);
            }
        }
    }

    private final InlayInfo getInlayInfo(Inlay<?> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        FrontendInlineInlayRenderer frontendInlineInlayRenderer = editorCustomElementRenderer instanceof FrontendInlineInlayRenderer ? (FrontendInlineInlayRenderer)editorCustomElementRenderer : null;
        if (frontendInlineInlayRenderer == null) {
            return null;
        }
        FrontendInlineInlayRenderer renderer = frontendInlineInlayRenderer;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, document);
        if (frontendMarkupContributor == null) {
            return null;
        }
        FrontendMarkupContributor markupContributor = frontendMarkupContributor;
        RangeHighlighterEx rangeHighlighterEx = markupContributor.getStorage().getAll().get(renderer.getId());
        return rangeHighlighterEx != null ? FrontendHintInlayModelSupportKt.getInlayInfo((RangeHighlighter)rangeHighlighterEx) : null;
    }
}

