/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope.FrontendCurrentScopeHighlightingManager;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope.FrontendCurrentScopeHighlightingManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl;", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManager;", "()V", "myCodeInsightSettings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "tryCalculateCurrentScopeRange", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "updateCurrentScopeHighlighting", "", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rd.client"})
public final class FrontendCurrentScopeHighlightingManagerImpl
implements FrontendCurrentScopeHighlightingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeInsightSettings myCodeInsightSettings;
    @NotNull
    private static final Key<RangeHighlighter> SCOPE_MARKER_IN_EDITOR_KEY;

    public FrontendCurrentScopeHighlightingManagerImpl() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance(...)");
        this.myCodeInsightSettings = codeInsightSettings;
    }

    @Override
    public void updateCurrentScopeHighlighting(@NotNull Editor editor2) {
        RangeHighlighter existingHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(editor2 instanceof EditorEx)) {
            return;
        }
        TextRange calculatedRange = this.tryCalculateCurrentScopeRange((EditorEx)editor2);
        RangeHighlighter rangeHighlighter = existingHighlighter = (RangeHighlighter)editor2.getUserData(SCOPE_MARKER_IN_EDITOR_KEY);
        if (Intrinsics.areEqual((Object)calculatedRange, (Object)(rangeHighlighter != null ? RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)rangeHighlighter)) : null))) {
            return;
        }
        RangeHighlighter rangeHighlighter2 = existingHighlighter;
        if (rangeHighlighter2 != null) {
            rangeHighlighter2.dispose();
        }
        editor2.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, null);
        if (calculatedRange == null) {
            return;
        }
        RangeHighlighterEx rangeHighlighterEx = ((EditorEx)editor2).getMarkupModel().addRangeHighlighterAndChangeAttributes(null, calculatedRange.getStartOffset(), calculatedRange.getEndOffset(), 0, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.updateCurrentScopeHighlighting$lambda$0(updateCurrentScopeHighlighting.highlighter.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighter highlighter2 = (RangeHighlighter)rangeHighlighterEx;
        editor2.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, (Object)highlighter2);
    }

    private final TextRange tryCalculateCurrentScopeRange(EditorEx editor2) {
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            return null;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)editor2.getDocument()), (Project)editor2.getProject(), (boolean)false);
        MarkupModelEx markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        if (markupModelEx == null) {
            return null;
        }
        MarkupModelEx model = markupModelEx;
        int caretOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        Ref.ObjectRef currentMaxIndentLevel = new Ref.ObjectRef();
        Ref.ObjectRef rangeOfCurrentMaxIndentLevel = new Ref.ObjectRef();
        model.processRangeHighlightersOverlappingWith(caretOffset, caretOffset, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.tryCalculateCurrentScopeRange$lambda$1((Function1)new Function1<RangeHighlighterEx, Boolean>((Ref.ObjectRef<Integer>)currentMaxIndentLevel, (Ref.ObjectRef<TextRange>)rangeOfCurrentMaxIndentLevel){
            final /* synthetic */ Ref.ObjectRef<Integer> $currentMaxIndentLevel;
            final /* synthetic */ Ref.ObjectRef<TextRange> $rangeOfCurrentMaxIndentLevel;
            {
                this.$currentMaxIndentLevel = $currentMaxIndentLevel;
                this.$rangeOfCurrentMaxIndentLevel = $rangeOfCurrentMaxIndentLevel;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx highlighter2) {
                Intrinsics.checkNotNull((Object)highlighter2);
                Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)highlighter2);
                if (n == null) {
                    return true;
                }
                int indentLevel2 = n;
                Integer cachedMaxIndentLevel = (Integer)this.$currentMaxIndentLevel.element;
                if (cachedMaxIndentLevel == null || cachedMaxIndentLevel < indentLevel2) {
                    this.$currentMaxIndentLevel.element = indentLevel2;
                    this.$rangeOfCurrentMaxIndentLevel.element = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)highlighter2));
                }
                return true;
            }
        }, arg_0));
        return (TextRange)rangeOfCurrentMaxIndentLevel.element;
    }

    private static final void updateCurrentScopeHighlighting$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean tryCalculateCurrentScopeRange$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"FrontendCurrentScopeHighlightingManagerImpl.SCOPE_MARKER_IN_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCOPE_MARKER_IN_EDITOR_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl$Companion;", "", "()V", "SCOPE_MARKER_IN_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

