/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"allCharactersAreWhiteSpace", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "", "endOffset", "shouldRenderIndentGuideOnLine", "docLine", "indentLevel", "isWhiteSpaceToken", "Lcom/intellij/psi/tree/IElementType;", "translateToColumn", "Lcom/intellij/openapi/editor/LogicalPosition;", "column", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIndentGuideRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIndentGuideRenderer.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRendererKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1549#2:135\n1620#2,3:136\n1726#2,3:139\n*S KotlinDebug\n*F\n+ 1 FrontendIndentGuideRenderer.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRendererKt\n*L\n61#1:135\n61#1:136,3\n61#1:139,3\n*E\n"})
public final class FrontendIndentGuideRendererKt {
    private static final LogicalPosition translateToColumn(LogicalPosition $this$translateToColumn, int column) {
        return new LogicalPosition($this$translateToColumn.line, column);
    }

    private static final boolean shouldRenderIndentGuideOnLine(Editor editor2, int docLine, int indentLevel2) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel fm = foldingModel;
        EditorHighlighter editorHighlighter = editor2.getHighlighter();
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
        EditorHighlighter eh = editorHighlighter;
        int currentLineStartOffset = document2.getLineStartOffset(docLine);
        int currentLineEndOffset = document2.getLineEndOffset(docLine);
        int lineLength = currentLineEndOffset - currentLineStartOffset;
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(currentLineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalLineEndPosition = logicalPosition;
        if (logicalLineEndPosition.column < indentLevel2) {
            return true;
        }
        int indentGuideOffset = editor2.logicalPositionToOffset(FrontendIndentGuideRendererKt.translateToColumn(logicalLineEndPosition, indentLevel2));
        if (fm.isOffsetCollapsed(indentGuideOffset)) {
            return true;
        }
        IElementType tokenType = eh.createIterator(indentGuideOffset).getTokenType();
        Intrinsics.checkNotNull((Object)tokenType);
        if (FrontendIndentGuideRendererKt.isWhiteSpaceToken(tokenType)) {
            return true;
        }
        return FrontendIndentGuideRendererKt.allCharactersAreWhiteSpace(editor2, currentLineStartOffset, indentGuideOffset) || FrontendIndentGuideRendererKt.allCharactersAreWhiteSpace(editor2, indentGuideOffset, currentLineEndOffset);
    }

    private static final boolean isWhiteSpaceToken(IElementType $this$isWhiteSpaceToken) {
        return Intrinsics.areEqual((Object)$this$isWhiteSpaceToken, (Object)TokenType.WHITE_SPACE) || Intrinsics.areEqual((Object)$this$isWhiteSpaceToken.getDebugName(), (Object)"NEW_LINE");
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean allCharactersAreWhiteSpace(Editor editor2, int startOffset, int endOffset) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)new IntRange(startOffset, endOffset);
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(DocumentExKt.getCharAt(document2, (int)p0));
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Character it = (Character)element$iv;
                    boolean bl3 = false;
                    Character c = it;
                    if (c != null ? CharsKt.isWhitespace((char)c.charValue()) : true) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$shouldRenderIndentGuideOnLine(Editor editor2, int docLine, int indentLevel2) {
        return FrontendIndentGuideRendererKt.shouldRenderIndentGuideOnLine(editor2, docLine, indentLevel2);
    }
}

