/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.IndentsModelCaretListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.InvisibleBraceHintModel;
import com.jetbrains.rd.ide.model.InvisibleBraceHintProviderModel;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideProtocolMarkupExtension;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener;", "Lcom/intellij/openapi/editor/impl/IndentsModelCaretListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "version", "", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "findIndentGuideHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "adapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getCaretIndentGuide", "Lcom/intellij/openapi/editor/IndentGuideDescriptor;", "showHint", "newGuide", "toIndentGuideDescriptor", "Lcom/intellij/openapi/editor/Editor;", "withCodeConstructStartLine", "codeConstructStartLine", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIndentGuideCaretListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIndentGuideCaretListener.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n288#2,2:114\n13#3:116\n*S KotlinDebug\n*F\n+ 1 FrontendIndentGuideCaretListener.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener\n*L\n97#1:114,2\n111#1:116\n*E\n"})
public final class FrontendIndentGuideCaretListener
extends IndentsModelCaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorImpl editor;
    private int version;
    @NotNull
    private static final Logger logger;

    public FrontendIndentGuideCaretListener(@NotNull Project project2, @NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(editor2);
        this.project = project2;
        this.editor = editor2;
    }

    @Nullable
    protected IndentGuideDescriptor getCaretIndentGuide(@NotNull CaretEvent event) {
        RangeHighlighterEx indentGuideHighlighter;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        FrontendMarkupContributor markupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, (Document)documentEx);
        Object object = markupContributor;
        if (object == null || (object = ((FrontendMarkupContributor)object).getMarkupAdapter()) == null) {
            return null;
        }
        Object adapter2 = object;
        RangeHighlighterEx rangeHighlighterEx = indentGuideHighlighter = this.findIndentGuideHighlighter((FrontendMarkupAdapter)adapter2);
        return rangeHighlighterEx != null ? this.toIndentGuideDescriptor(rangeHighlighterEx, (Editor)this.editor) : null;
    }

    protected void showHint(@NotNull IndentGuideDescriptor newGuide) {
        block3: {
            IOptPropertyView iOptPropertyView;
            IRdTask iRdTask;
            RdCall rdCall;
            Intrinsics.checkNotNullParameter((Object)newGuide, (String)"newGuide");
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            FrontendMarkupContributor markupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, (Document)documentEx);
            Object object = markupContributor;
            if (object == null || (object = ((FrontendMarkupContributor)object).getMarkupAdapter()) == null) {
                return;
            }
            Object adapter2 = object;
            RangeHighlighterEx rangeHighlighterEx = this.findIndentGuideHighlighter((FrontendMarkupAdapter)adapter2);
            if (rangeHighlighterEx == null) {
                return;
            }
            RangeHighlighterEx indentGuideHighlighter = rangeHighlighterEx;
            Long l = markupContributor.getStorage().get(indentGuideHighlighter);
            if (l == null) {
                return;
            }
            long highlighterId = l;
            LifetimeDefinition callLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
            int currentVersion = this.version;
            InvisibleBraceHintProviderModel invisibleBraceHintProviderModel = FrontendIndentGuideProtocolMarkupExtension.Companion.getInvisibleBraceHintProviderModel((FrontendMarkupAdapter)adapter2);
            if (invisibleBraceHintProviderModel == null || (rdCall = invisibleBraceHintProviderModel.getGetInvisibleBraceHint()) == null || (iRdTask = rdCall.start((Lifetime)callLifetime, (Object)highlighterId)) == null || (iOptPropertyView = iRdTask.getResult()) == null) break block3;
            SourceExKt.adviseOnce((ISource)((ISource)iOptPropertyView), (Lifetime)((Lifetime)callLifetime), (Function1)((Function1)new Function1<RdTaskResult<? extends InvisibleBraceHintModel>, Unit>(this, currentVersion, newGuide){
                final /* synthetic */ FrontendIndentGuideCaretListener this$0;
                final /* synthetic */ int $currentVersion;
                final /* synthetic */ IndentGuideDescriptor $newGuide;
                {
                    this.this$0 = $receiver;
                    this.$currentVersion = $currentVersion;
                    this.$newGuide = $newGuide;
                    super(1);
                }

                public final void invoke(@NotNull RdTaskResult<InvisibleBraceHintModel> callResult) {
                    Intrinsics.checkNotNullParameter(callResult, (String)"callResult");
                    if (!(callResult instanceof RdTaskResult.Success)) {
                        FrontendIndentGuideCaretListener.access$getLogger$cp().warn("Invisible brace hint range calculation failed");
                        return;
                    }
                    if (FrontendIndentGuideCaretListener.access$getVersion$p(this.this$0) != this.$currentVersion) {
                        return;
                    }
                    InvisibleBraceHintModel invisibleBraceHintModel = (InvisibleBraceHintModel)((RdTaskResult.Success)callResult).getValue();
                    if (invisibleBraceHintModel == null || (invisibleBraceHintModel = invisibleBraceHintModel.getHintRange()) == null) {
                        return;
                    }
                    int codeConstructStartOffset = invisibleBraceHintModel.getStartOffset();
                    int codeConstructStartLine = FrontendIndentGuideCaretListener.access$getEditor$p((FrontendIndentGuideCaretListener)this.this$0).offsetToLogicalPosition((int)codeConstructStartOffset).line;
                    FrontendIndentGuideCaretListener.access$showHint$s1196841525(this.this$0, FrontendIndentGuideCaretListener.access$withCodeConstructStartLine(this.this$0, this.$newGuide, codeConstructStartLine));
                }
            }));
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ++this.version;
        super.caretPositionChanged(event);
    }

    private final RangeHighlighterEx findIndentGuideHighlighter(FrontendMarkupAdapter adapter2) {
        Object v1;
        block1: {
            LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition caretLogicalPosition = logicalPosition;
            int caretLineStartOffset = this.editor.logicalPositionToOffset(new LogicalPosition(caretLogicalPosition.line, 0));
            int caretVisualColumn = caretLogicalPosition.column;
            int caretOffset = this.editor.getCaretModel().getOffset();
            int caretColumn = caretOffset - caretLineStartOffset;
            Iterable $this$firstOrNull$iv = adapter2.getHighlighters(caretOffset);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RangeHighlighterEx p0 = (RangeHighlighterEx)element$iv;
                boolean bl = false;
                if (!FrontendIndentGuideCaretListener.findIndentGuideHighlighter$hasRightVisualIndentLevel(p0, caretOffset, this, caretColumn, caretVisualColumn)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final IndentGuideDescriptor toIndentGuideDescriptor(RangeHighlighterEx $this$toIndentGuideDescriptor, Editor editor2) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)$this$toIndentGuideDescriptor);
        if (n == null) {
            return null;
        }
        int indentLevel2 = n;
        int startLine = editor2.offsetToLogicalPosition((int)$this$toIndentGuideDescriptor.getStartOffset()).line;
        int endLine = editor2.offsetToLogicalPosition((int)$this$toIndentGuideDescriptor.getEndOffset()).line;
        return new IndentGuideDescriptor(indentLevel2, startLine, endLine);
    }

    private final IndentGuideDescriptor withCodeConstructStartLine(IndentGuideDescriptor $this$withCodeConstructStartLine, int codeConstructStartLine) {
        return new IndentGuideDescriptor($this$withCodeConstructStartLine.indentLevel, codeConstructStartLine, $this$withCodeConstructStartLine.startLine, $this$withCodeConstructStartLine.endLine);
    }

    private static final int findIndentGuideHighlighter$getStartVisualIndentLevel(RangeHighlighterEx $this$findIndentGuideHighlighter_u24getStartVisualIndentLevel, FrontendIndentGuideCaretListener this$0) {
        int n;
        int startLine = this$0.editor.offsetToLogicalPosition((int)$this$findIndentGuideHighlighter_u24getStartVisualIndentLevel.getStartOffset()).line;
        int lineLength = this$0.editor.getDocument().getLineEndOffset(startLine) - this$0.editor.getDocument().getLineStartOffset(startLine);
        Integer n2 = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)$this$findIndentGuideHighlighter_u24getStartVisualIndentLevel);
        Intrinsics.checkNotNull((Object)n2);
        if (n2 <= lineLength) {
            int n3 = this$0.editor.logicalPositionToOffset(new LogicalPosition(startLine, 0));
            Integer n4 = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)$this$findIndentGuideHighlighter_u24getStartVisualIndentLevel);
            Intrinsics.checkNotNull((Object)n4);
            n = n3 + n4;
        } else {
            n = $this$findIndentGuideHighlighter_u24getStartVisualIndentLevel.getStartOffset();
        }
        int effectiveIndentGuideStartOffset = n;
        return this$0.editor.offsetToVisualPosition((int)effectiveIndentGuideStartOffset).column;
    }

    private static final boolean findIndentGuideHighlighter$hasRightVisualIndentLevel(RangeHighlighterEx $this$findIndentGuideHighlighter_u24hasRightVisualIndentLevel, int caretOffset, FrontendIndentGuideCaretListener this$0, int caretColumn, int caretVisualColumn) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)$this$findIndentGuideHighlighter_u24hasRightVisualIndentLevel);
        if (n == null) {
            return false;
        }
        int indentLevel2 = n;
        if ($this$findIndentGuideHighlighter_u24hasRightVisualIndentLevel.getEndOffset() == caretOffset) {
            return true;
        }
        if (this$0.editor.getFoldingModel().isOffsetCollapsed($this$findIndentGuideHighlighter_u24hasRightVisualIndentLevel.getStartOffset())) {
            return indentLevel2 == caretColumn;
        }
        return FrontendIndentGuideCaretListener.findIndentGuideHighlighter$getStartVisualIndentLevel($this$findIndentGuideHighlighter_u24hasRightVisualIndentLevel, this$0) == caretVisualColumn;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ int access$getVersion$p(FrontendIndentGuideCaretListener $this) {
        return $this.version;
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(FrontendIndentGuideCaretListener $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$showHint$s1196841525(FrontendIndentGuideCaretListener $this, IndentGuideDescriptor p0) {
        super.showHint(p0);
    }

    public static final /* synthetic */ IndentGuideDescriptor access$withCodeConstructStartLine(FrontendIndentGuideCaretListener $this, IndentGuideDescriptor $receiver, int codeConstructStartLine) {
        return $this.withCodeConstructStartLine($receiver, codeConstructStartLine);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendIndentGuideCaretListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendIndentGuideCaretListener.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideCaretListener$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

