/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingRestoreRecord;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 `2\u00020\u0001:\u0001`B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0014J\u0014\u0010.\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002000/J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u000200J\u0016\u00103\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0018\u00104\u001a\u00020\b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0007H\u0014J\b\u00108\u001a\u00020*H\u0002J\u0018\u00109\u001a\u00020*2\u0006\u00107\u001a\u00020\u00072\u0006\u0010:\u001a\u000206H\u0002J\"\u0010;\u001a\u0004\u0018\u0001062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020\u0007H\u0014J*\u0010@\u001a\u0004\u0018\u0001062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u00107\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\bH\u0014J\u0016\u0010B\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0010\u0010C\u001a\u00020*2\u0006\u00102\u001a\u000200H\u0002J&\u0010D\u001a\b\u0012\u0004\u0012\u0002060/2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u00107\u001a\u00020\u0007H\u0014J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u0002060FH\u0014J,\u0010G\u001a\u001e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0Hj\u0002`I2\u0006\u0010J\u001a\u00020\bH\u0002J\u0016\u0010K\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0/H\u0014J\u0018\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020-2\u0006\u00107\u001a\u00020\u0007H\u0014J\u0018\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020=2\u0006\u0010P\u001a\u00020=H\u0002J\b\u0010Q\u001a\u00020\bH\u0002J\b\u0010R\u001a\u00020\bH\u0014J8\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u0002062\u0006\u00107\u001a\u00020\u00072\u001e\u0010U\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0W0VH\u0002J>\u0010X\u001a\u00020*2\u0006\u0010O\u001a\u00020=2\u0006\u0010P\u001a\u00020=2\u0006\u00107\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\b2\u0006\u0010Z\u001a\u00020\b2\f\u0010[\u001a\b\u0012\u0004\u0012\u0002060/H\u0002J \u0010\\\u001a\u00020*2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010]\u001a\u00020^H\u0002J\u0014\u0010_\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0/R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R+\u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010$R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000fR\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isExpandedCallbackFactory", "Lkotlin/Function0;", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingInfo;", "", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallback;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallbackFactory;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "_initialized", "applyIsExpandedUpdatesFromBackend", "getApplyIsExpandedUpdatesFromBackend", "()Z", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "foldingManager", "Lkotlin/Lazy;", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl;", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "getFoldingModel", "()Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "foldingRestoreRecords", "", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingRestoreRecord;", "frontendEditorFoldingInfo", "Lcom/intellij/codeInsight/folding/impl/EditorFoldingInfo;", "Lorg/jetbrains/annotations/NotNull;", "groups", "", "Lcom/intellij/openapi/editor/FoldingGroup;", "getGroups", "()Ljava/util/Map;", "()Lkotlin/jvm/functions/Function0;", "isInitialized", "lock", "", "uiRegionDebugging", "addFoldings", "", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "afterBulkAdd", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterUpdated", "highlighter", "beforeBulkRemove", "canBeReused", "oldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "foldingInfo", "clearReloadingState", "copyMarkersToRegion", "existingRegion", "createFoldRegion", "start", "", "end", "info", "createNewRegionOrIgnore", "isExpanded", "doAfterBulkAdd", "doAfterUpdated", "getExistingFoldRegionsAtRange", "getExistingFoldRegionsForMerge", "", "getIsExpandedCallback", "Lkotlin/Function3;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/RestoreFoldingExpandedCallback;", "foldingInitializationForOpenedEditor", "initFoldings", "isCustomFoldRegion", "rangeHighlighter", "isMandatoryExpanded", "startOffset", "endOffset", "isReloadingState", "isUserFoldRegionsSupported", "mergeExistingFoldingRegion", "existingFoldRegion", "mergeResult", "Lcom/intellij/openapi/util/Ref;", "Lkotlin/Triple;", "mergeRangeHighlighterWithExistingFoldRegions", "defaultExpansion", "mandatoryExpansion", "existingFoldRegionsAtRange", "traceRange", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "updateCollapsedStates", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorFoldingModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,424:1\n2624#2,3:425\n2624#2,3:428\n766#2:448\n857#2,2:449\n766#2:452\n857#2,2:453\n223#2,2:455\n766#2:459\n857#2,2:460\n288#2,2:463\n1#3:431\n372#4,7:432\n372#4,7:439\n65#5,2:446\n68#5:451\n65#5,2:457\n68#5:462\n65#5,4:465\n13#5:469\n*S KotlinDebug\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n*L\n103#1:425,3\n321#1:428,3\n105#1:448\n105#1:449,2\n111#1:452\n111#1:453,2\n132#1:455,2\n323#1:459\n323#1:460,2\n328#1:463,2\n387#1:432,7\n406#1:439,7\n105#1:446,2\n105#1:451\n323#1:457,2\n323#1:462\n367#1:465,4\n44#1:469\n*E\n"})
public class FrontendEditorFoldingModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory;
    private final boolean applyIsExpandedUpdatesFromBackend;
    private final boolean uiRegionDebugging;
    @NotNull
    private final Map<Long, FoldingGroup> groups;
    @NotNull
    private final FoldingModelImpl foldingModel;
    @NotNull
    private final Lazy<CodeFoldingManagerImpl> foldingManager;
    @NotNull
    private final EditorFoldingInfo frontendEditorFoldingInfo;
    @NotNull
    private final Map<FoldingRestoreRecord, Boolean> foldingRestoreRecords;
    private boolean _initialized;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Key<Boolean> RESTORE_FOLDING_STATE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final TextAttributes redFromBackend;
    @NotNull
    private static final TextAttributes greenMergedWithExisting;
    @NotNull
    private static final TextAttributes blueMergedWithCreatedByFrontend;
    @NotNull
    private static final TextAttributes cyanExoticStateFromFrontend;

    public FrontendEditorFoldingModelAdapter(@NotNull Editor editor2, @NotNull Function0<? extends Function1<? super FoldingInfo, Boolean>> isExpandedCallbackFactory) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(isExpandedCallbackFactory, (String)"isExpandedCallbackFactory");
        this.editor = editor2;
        this.isExpandedCallbackFactory = isExpandedCallbackFactory;
        this.applyIsExpandedUpdatesFromBackend = true;
        this.uiRegionDebugging = Registry.is((String)"rdclient.fold.debug.ui.enabled", (boolean)false);
        this.groups = new LinkedHashMap();
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
        this.foldingManager = LazyKt.lazy((Function0)((Function0)new Function0<CodeFoldingManagerImpl>(this){
            final /* synthetic */ FrontendEditorFoldingModelAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CodeFoldingManagerImpl invoke() {
                CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance((Project)this.this$0.getEditor().getProject());
                Intrinsics.checkNotNull((Object)codeFoldingManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl");
                return (CodeFoldingManagerImpl)codeFoldingManager;
            }
        }));
        EditorFoldingInfo editorFoldingInfo = EditorFoldingInfo.get((Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)editorFoldingInfo, (String)"get(...)");
        this.frontendEditorFoldingInfo = editorFoldingInfo;
        this.foldingRestoreRecords = new LinkedHashMap();
        this.lock = new Object();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory() {
        return this.isExpandedCallbackFactory;
    }

    protected boolean getApplyIsExpandedUpdatesFromBackend() {
        return this.applyIsExpandedUpdatesFromBackend;
    }

    @NotNull
    protected final Map<Long, FoldingGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    protected final FoldingModelImpl getFoldingModel() {
        return this.foldingModel;
    }

    private final boolean isReloadingState() {
        return Intrinsics.areEqual((Object)RESTORE_FOLDING_STATE.get((UserDataHolder)this.editor), (Object)true);
    }

    private final void clearReloadingState() {
        RESTORE_FOLDING_STATE.set((UserDataHolder)this.editor, null);
        this.foldingRestoreRecords.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInitialized() {
        if (this._initialized) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this._initialized;
            return bl2;
        }
    }

    @Override
    public final void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0)((Function0)new Function0<Unit>(this, highlighters){
            final /* synthetic */ FrontendEditorFoldingModelAdapter this$0;
            final /* synthetic */ List<RangeHighlighterEx> $highlighters;
            {
                this.this$0 = $receiver;
                this.$highlighters = $highlighters;
                super(0);
            }

            public final void invoke() {
                FrontendEditorFoldingModelAdapter.access$doAfterBulkAdd(this.this$0, this.$highlighters);
            }
        }));
    }

    private final void traceRange(int start2, int end, TextAttributes attr) {
        if (this.uiRegionDebugging) {
            this.editor.getMarkupModel().addRangeHighlighter(start2, end, 6000, attr, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private final void doAfterBulkAdd(List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Iterable $this$none$iv = highlighters;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
                    boolean bl2 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.doAfterBulkAdd$lambda$6(this, highlighters));
    }

    public final void updateCollapsedStates(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> isExpandedCallback = this.getIsExpandedCallback(true);
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.updateCollapsedStates$lambda$8(highlighters, isExpandedCallback, this));
    }

    protected boolean isUserFoldRegionsSupported() {
        return false;
    }

    @NotNull
    protected List<FoldRegion> getExistingFoldRegionsForMerge() {
        FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        return ArraysKt.toMutableList((Object[])foldRegionArray);
    }

    @NotNull
    protected List<FoldRegion> getExistingFoldRegionsAtRange(int start2, int end, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion foldRegion = this.foldingModel.getFoldRegion(start2, end);
        return foldRegion == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)foldRegion);
    }

    private final void mergeExistingFoldingRegion(FoldRegion existingFoldRegion, FoldingInfo foldingInfo, Ref<Triple<FoldRegion, Boolean, Boolean>> mergeResult) {
        boolean canReuseExistingFoldRegionAsIs = true;
        boolean isExpanded = existingFoldRegion.isExpanded();
        if (this.frontendEditorFoldingInfo.getPsiElement(existingFoldRegion) != null) {
            this.frontendEditorFoldingInfo.removeRegion(existingFoldRegion);
            canReuseExistingFoldRegionAsIs = false;
        }
        if (mergeResult.isNull() && this.canBeReused(existingFoldRegion, foldingInfo)) {
            if (canReuseExistingFoldRegionAsIs) {
                this.copyMarkersToRegion(foldingInfo, existingFoldRegion);
                ((CodeFoldingManagerImpl)this.foldingManager.getValue()).markUpdated(existingFoldRegion);
                mergeResult.set((Object)new Triple((Object)existingFoldRegion, (Object)isExpanded, (Object)true));
                return;
            }
            mergeResult.set((Object)new Triple((Object)existingFoldRegion, (Object)isExpanded, (Object)false));
        }
        this.foldingModel.removeFoldRegion(existingFoldRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFoldings(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        try {
            Map map = CodeFoldingManagerImpl.getAsyncExpandStatusMap((Editor)this.editor);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map expandedCacheMap = map;
            Function3<Integer, Integer, FoldingInfo, Boolean> isExpandedCallback = this.getIsExpandedCallback(false);
            for (RangeHighlighter rangeHighlighter : highlighters) {
                FoldingInfo foldingInfo;
                if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null || this.isCustomFoldRegion(rangeHighlighter, foldingInfo)) continue;
                Boolean bl = (Boolean)expandedCacheMap.get(TextRange.create((Segment)((Segment)rangeHighlighter)));
                boolean isExpanded = bl != null ? bl.booleanValue() : ((Boolean)isExpandedCallback.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo)).booleanValue();
                this.mergeRangeHighlighterWithExistingFoldRegions(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo, isExpanded, false, this.getExistingFoldRegionsAtRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo));
                if (!this.uiRegionDebugging || !expandedCacheMap.containsKey(TextRange.create((Segment)((Segment)rangeHighlighter)))) continue;
                this.traceRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), cyanExoticStateFromFrontend);
            }
        }
        finally {
            this.clearReloadingState();
            CodeFoldingManagerImpl.setAsyncExpandStatusMap((Editor)this.editor, null);
        }
    }

    protected boolean isCustomFoldRegion(@NotNull RangeHighlighter rangeHighlighter, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        return false;
    }

    protected void initFoldings(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> isExpandedCallback = this.getIsExpandedCallback(true);
        List<FoldRegion> allExistingFoldRegions = this.getExistingFoldRegionsForMerge();
        if (Registry.is((String)"cache.folding.model.on.disk")) {
            logger.warn("Key `cache.folding.model.on.disk` is active. \n            The successfully raised zombies broke the order of editor/document folding initialization.\n            That leads to RIDER-5877. \n            See `com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl.buildInitialFoldings(com.intellij.openapi.editor.Document)`");
        }
        for (RangeHighlighter rangeHighlighter : highlighters) {
            FoldingInfo foldingInfo;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null) continue;
            List<FoldRegion> existingFoldRegionsAtRange = this.getExistingFoldRegionsAtRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo);
            allExistingFoldRegions.removeAll((Collection)existingFoldRegionsAtRange);
            this.mergeRangeHighlighterWithExistingFoldRegions(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo, (Boolean)isExpandedCallback.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo), this.isMandatoryExpanded(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset()), existingFoldRegionsAtRange);
        }
        boolean cleanUserFoldRegion = !this.isUserFoldRegionsSupported();
        for (FoldRegion foldRegionNotMergedWithHighlighters : allExistingFoldRegions) {
            if (this.frontendEditorFoldingInfo.getPsiElement(foldRegionNotMergedWithHighlighters) != null || !cleanUserFoldRegion) continue;
            this.foldingModel.removeFoldRegion(foldRegionNotMergedWithHighlighters);
        }
    }

    private final Function3<Integer, Integer, FoldingInfo, Boolean> getIsExpandedCallback(boolean foldingInitializationForOpenedEditor) {
        if (foldingInitializationForOpenedEditor) {
            Function1 isExpandStateFromSettingsCallback = (Function1)this.isExpandedCallbackFactory.invoke();
            return (Function3)new Function3<Integer, Integer, FoldingInfo, Boolean>((Function1<? super FoldingInfo, Boolean>)isExpandStateFromSettingsCallback){
                final /* synthetic */ Function1<FoldingInfo, Boolean> $isExpandStateFromSettingsCallback;
                {
                    this.$isExpandStateFromSettingsCallback = $isExpandStateFromSettingsCallback;
                    super(3);
                }

                @NotNull
                public final Boolean invoke(int n, int n2, @NotNull FoldingInfo foldingInfo) {
                    Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
                    return (Boolean)this.$isExpandStateFromSettingsCallback.invoke((Object)foldingInfo);
                }
            };
        }
        if (this.isReloadingState()) {
            Function1 isExpandStateFromSettingsCallback = (Function1)this.isExpandedCallbackFactory.invoke();
            return (Function3)new Function3<Integer, Integer, FoldingInfo, Boolean>(this, (Function1<? super FoldingInfo, Boolean>)isExpandStateFromSettingsCallback){
                final /* synthetic */ FrontendEditorFoldingModelAdapter this$0;
                final /* synthetic */ Function1<FoldingInfo, Boolean> $isExpandStateFromSettingsCallback;
                {
                    this.this$0 = $receiver;
                    this.$isExpandStateFromSettingsCallback = $isExpandStateFromSettingsCallback;
                    super(3);
                }

                @NotNull
                public final Boolean invoke(int start2, int end, @NotNull FoldingInfo foldingInfo) {
                    Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
                    FrontendEditorFoldingModelAdapter.access$traceRange(this.this$0, start2, end, FrontendEditorFoldingModelAdapter.Companion.getCyanExoticStateFromFrontend());
                    Boolean bl = (Boolean)FrontendEditorFoldingModelAdapter.access$getFoldingRestoreRecords$p(this.this$0).get(new FoldingRestoreRecord(start2, end, foldingInfo.getAttributeId(), foldingInfo.getPlaceholderText()));
                    return bl != null ? bl.booleanValue() : ((Boolean)this.$isExpandStateFromSettingsCallback.invoke((Object)foldingInfo)).booleanValue();
                }
            };
        }
        return getIsExpandedCallback.3.INSTANCE;
    }

    private final void mergeRangeHighlighterWithExistingFoldRegions(int startOffset, int endOffset, FoldingInfo foldingInfo, boolean defaultExpansion, boolean mandatoryExpansion, List<? extends FoldRegion> existingFoldRegionsAtRange) {
        Ref mergeFoldRegionResult = new Ref();
        for (FoldRegion triple : existingFoldRegionsAtRange) {
            this.mergeExistingFoldingRegion(triple, foldingInfo, (Ref<Triple<FoldRegion, Boolean, Boolean>>)mergeFoldRegionResult);
        }
        FoldRegion foldRegion = null;
        if (mergeFoldRegionResult.isNull()) {
            this.traceRange(startOffset, endOffset, redFromBackend);
            foldRegion = this.createNewRegionOrIgnore(startOffset, endOffset, foldingInfo, defaultExpansion || mandatoryExpansion);
        } else {
            Triple triple = (Triple)mergeFoldRegionResult.get();
            FoldRegion existingFoldRegion = (FoldRegion)triple.component1();
            boolean isExpanded = (Boolean)triple.component2();
            boolean canReuseExistingFoldRegionAsIs = (Boolean)triple.component3();
            if (canReuseExistingFoldRegionAsIs) {
                this.traceRange(existingFoldRegion.getStartOffset(), existingFoldRegion.getEndOffset(), greenMergedWithExisting);
                foldRegion = existingFoldRegion;
            } else {
                this.traceRange(existingFoldRegion.getStartOffset(), existingFoldRegion.getEndOffset(), blueMergedWithCreatedByFrontend);
                foldRegion = this.createNewRegionOrIgnore(existingFoldRegion.getStartOffset(), existingFoldRegion.getEndOffset(), foldingInfo, isExpanded || mandatoryExpansion);
            }
        }
        if (foldRegion != null) {
            if (mandatoryExpansion && !foldRegion.isExpanded()) {
                this.traceRange(startOffset, endOffset, cyanExoticStateFromFrontend);
                foldRegion.setExpanded(true);
            }
            foldingInfo.getRegions().add((Object)foldRegion);
        }
    }

    private final boolean isMandatoryExpanded(int startOffset, int endOffset) {
        for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
            int offset = caret.getOffset();
            if (offset == 0) continue;
            boolean bl = startOffset + 1 <= offset ? offset < endOffset : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            Iterable $this$none$iv = highlighters;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
                    boolean bl2 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.beforeBulkRemove$lambda$13(this, highlighters));
    }

    @Override
    public final void afterUpdated(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0)((Function0)new Function0<Unit>(this, highlighter2){
            final /* synthetic */ FrontendEditorFoldingModelAdapter this$0;
            final /* synthetic */ RangeHighlighterEx $highlighter;
            {
                this.this$0 = $receiver;
                this.$highlighter = $highlighter;
                super(0);
            }

            public final void invoke() {
                FrontendEditorFoldingModelAdapter.access$doAfterUpdated(this.this$0, this.$highlighter);
            }
        }));
    }

    private final void doAfterUpdated(RangeHighlighterEx highlighter2) {
        Object v1;
        SmartList<FoldRegion> foldRegions;
        FoldingInfo foldingInfo;
        block5: {
            FoldingInfo foldingInfo2 = FoldingInfoKt.getFoldingInfo((RangeHighlighter)highlighter2);
            if (foldingInfo2 == null) {
                return;
            }
            foldingInfo = foldingInfo2;
            foldRegions = foldingInfo.getRegions();
            Iterable iterable = (Iterable)foldRegions;
            for (Object t : iterable) {
                FoldRegion it = (FoldRegion)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this.editor)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        FoldRegion foldRegion = v1;
        if (foldRegion == null) {
            return;
        }
        FoldRegion oldRegion = foldRegion;
        if (this.canBeReused(oldRegion, foldingInfo)) {
            if (this.getApplyIsExpandedUpdatesFromBackend() && oldRegion.isExpanded() == foldingInfo.getCollapsedByDefault()) {
                this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.doAfterUpdated$lambda$15(oldRegion, foldingInfo));
            }
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.doAfterUpdated$lambda$18(oldRegion, foldRegions, this, highlighter2, foldingInfo));
    }

    protected boolean canBeReused(@NotNull FoldRegion oldRegion, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        if (!Intrinsics.areEqual((Object)oldRegion.getPlaceholderText(), (Object)foldingInfo.getPlaceholderText())) {
            return false;
        }
        FoldingGroup group = oldRegion.getGroup();
        Long groupId = foldingInfo.getGroupId();
        if (group != null && groupId != null) {
            FoldingGroup foldingGroup;
            FoldingGroup foldingGroup2 = group;
            Map<Long, FoldingGroup> $this$getOrPut$iv = this.groups;
            boolean $i$f$getOrPut = false;
            FoldingGroup value$iv = $this$getOrPut$iv.get(groupId);
            if (value$iv == null) {
                FoldingGroup foldingGroup3 = foldingGroup2;
                boolean bl = false;
                foldingGroup2 = foldingGroup3;
                FoldingGroup answer$iv = group;
                $this$getOrPut$iv.put(groupId, answer$iv);
                foldingGroup = answer$iv;
            } else {
                foldingGroup = value$iv;
            }
            return Intrinsics.areEqual((Object)foldingGroup2, (Object)foldingGroup);
        }
        if (oldRegion.shouldNeverExpand() != foldingInfo.getNeverExpands()) {
            return false;
        }
        return group == null && groupId == null;
    }

    @Nullable
    protected FoldRegion createNewRegionOrIgnore(int start2, int end, @NotNull FoldingInfo foldingInfo, boolean isExpanded) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion newRegion = this.createFoldRegion(start2, end, foldingInfo);
        if (newRegion == null) {
            logger.warn("Unable to insert (" + start2 + ", " + end + ") in the folding tree. Maybe the duplicate range already/still exist.");
            return null;
        }
        newRegion.setExpanded(isExpanded && !foldingInfo.getNeverExpands());
        return newRegion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected FoldRegion createFoldRegion(int start2, int end, @NotNull FoldingInfo info2) {
        FoldRegion region;
        block4: {
            FoldingGroup foldingGroup;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Long l = info2.getGroupId();
            if (l != null) {
                Object object;
                void $this$getOrPut$iv;
                long it = ((Number)l).longValue();
                boolean bl = false;
                Map<Long, FoldingGroup> map = this.groups;
                Long key$iv = it;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    FoldingGroup foldingGroup2 = FoldingGroup.newGroup((String)String.valueOf(it));
                    Intrinsics.checkNotNullExpressionValue((Object)foldingGroup2, (String)"newGroup(...)");
                    FoldingGroup answer$iv = foldingGroup2;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                foldingGroup = (FoldingGroup)object;
            } else {
                foldingGroup = null;
            }
            FoldingGroup group = foldingGroup;
            FoldRegion foldRegion = region = this.foldingModel.createFoldRegion(start2, end, info2.getPlaceholderText(), group, info2.getNeverExpands());
            if (foldRegion == null) break block4;
            FoldRegion it = foldRegion;
            boolean bl = false;
            this.copyMarkersToRegion(info2, region);
        }
        return region;
    }

    private final void copyMarkersToRegion(FoldingInfo foldingInfo, FoldRegion existingRegion) {
        if (FoldingInfoKt.isDocComment(foldingInfo)) {
            FoldingInfoKt.markAsDocComment(existingRegion);
        }
        if (FoldingInfoKt.isDefinition(foldingInfo)) {
            FoldingInfoKt.markAsDefinition(existingRegion);
        }
        if (FoldingInfoKt.isCodeBlock(foldingInfo)) {
            FoldingInfoKt.markAsCodeBlock(existingRegion);
        }
        ((CodeFoldingManagerImpl)this.foldingManager.getValue()).setCollapsedByDefault(existingRegion, foldingInfo.getCollapsedByDefault());
        CodeFoldingManagerImpl.markAsAutoCreated((FoldRegion)existingRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void doAfterBulkAdd$lambda$6(FrontendEditorFoldingModelAdapter this$0, List $highlighters) {
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            void $this$filterTo$iv$iv;
            Logger logger = $this$trace$iv;
            boolean bl = false;
            Iterable iterable = $highlighters;
            int n = $highlighters.size();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
                boolean bl2 = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            logger.trace("doAfterBulkAdd (runBatchFoldingOperation): allHighlighters=" + n + ", foldings=" + list.size());
        }
        if (this$0._initialized) {
            this$0.addFoldings($highlighters);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv2 = $highlighters;
            boolean $i$f$filter = false;
            $this$filter$iv = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
                boolean bl = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newHighlighters = (List)destination$iv$iv;
            if (!((Collection)newHighlighters).isEmpty()) {
                Object object = this$0.lock;
                synchronized (object) {
                    boolean bl = false;
                    try {
                        CodeFoldingManagerImpl.markAsAsyncFoldingUpdater((Editor)this$0.editor);
                        this$0.initFoldings(newHighlighters);
                    }
                    finally {
                        this$0._initialized = true;
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private static final void updateCollapsedStates$lambda$8(List $highlighters, Function3 $isExpandedCallback, FrontendEditorFoldingModelAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Intrinsics.checkNotNullParameter((Object)$isExpandedCallback, (String)"$isExpandedCallback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (RangeHighlighter h : $highlighters) {
            Object element$iv2;
            FoldingInfo info2;
            block2: {
                Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(h));
                Iterable $this$first$iv = (Iterable)info2.getRegions();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FoldRegion it = (FoldRegion)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this$0.editor)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FoldRegion region = (FoldRegion)element$iv2;
            region.setExpanded(((Boolean)$isExpandedCallback.invoke((Object)h.getStartOffset(), (Object)h.getEndOffset(), (Object)info2)).booleanValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void beforeBulkRemove$lambda$13(FrontendEditorFoldingModelAdapter this$0, List $highlighters) {
        RangeHighlighterEx it;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Logger logger = $this$trace$iv;
            boolean bl = false;
            Iterable iterable = $highlighters;
            int n = $highlighters.size();
            boolean $i$f$filter = false;
            void var8_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RangeHighlighterEx)element$iv$iv;
                boolean bl2 = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            logger.trace("beforeBulkRemove (runBatchFoldingOperation): allHighlighters=" + n + ", foldings=" + list.size());
        }
        boolean collectRecordsForRestore = this$0.isReloadingState();
        for (RangeHighlighterEx h : $highlighters) {
            FoldingGroup group;
            FoldRegion region;
            Object v0;
            SmartList<FoldRegion> foldRegions;
            FoldingInfo foldingInfo;
            block6: {
                if (FoldingInfoKt.getFoldingInfo((RangeHighlighter)h) == null) continue;
                foldRegions = foldingInfo.getRegions();
                Iterable $this$firstOrNull$iv = (Iterable)foldRegions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (FoldRegion)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this$0.editor)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            if ((FoldRegion)v0 == null) continue;
            foldRegions.remove((Object)region);
            if (!region.isValid()) continue;
            if (collectRecordsForRestore && region.isExpanded() == foldingInfo.getCollapsedByDefault()) {
                this$0.foldingRestoreRecords.put(new FoldingRestoreRecord(h.getStartOffset(), h.getEndOffset(), foldingInfo.getAttributeId(), foldingInfo.getPlaceholderText()), region.isExpanded());
            }
            if ((group = region.getGroup()) != null && this$0.foldingModel.getGroupedRegions(group).size() == 1) {
                Map<Long, FoldingGroup> map = this$0.groups;
                Long l = foldingInfo.getGroupId();
                TypeIntrinsics.asMutableMap(map).remove(l);
            }
            this$0.foldingModel.removeFoldRegion(region);
        }
    }

    private static final void doAfterUpdated$lambda$15(FoldRegion $oldRegion, FoldingInfo $foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)$oldRegion, (String)"$oldRegion");
        Intrinsics.checkNotNullParameter((Object)$foldingInfo, (String)"$foldingInfo");
        $oldRegion.setExpanded(!$foldingInfo.getCollapsedByDefault());
    }

    private static final void doAfterUpdated$lambda$18(FoldRegion $oldRegion, SmartList $foldRegions, FrontendEditorFoldingModelAdapter this$0, RangeHighlighterEx $highlighter, FoldingInfo $foldingInfo) {
        block1: {
            FoldRegion newRegion;
            Intrinsics.checkNotNullParameter((Object)$oldRegion, (String)"$oldRegion");
            Intrinsics.checkNotNullParameter((Object)$foldRegions, (String)"$foldRegions");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$highlighter, (String)"$highlighter");
            Intrinsics.checkNotNullParameter((Object)$foldingInfo, (String)"$foldingInfo");
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("doAfterUpdated (runBatchFoldingOperation): a single folding");
            }
            boolean oldIsExpanded = $oldRegion.isExpanded();
            $foldRegions.remove((Object)$oldRegion);
            this$0.foldingModel.removeFoldRegion($oldRegion);
            FoldRegion foldRegion = newRegion = this$0.createNewRegionOrIgnore($highlighter.getStartOffset(), $highlighter.getEndOffset(), $foldingInfo, this$0.getApplyIsExpandedUpdatesFromBackend() ? !$foldingInfo.getCollapsedByDefault() : oldIsExpanded);
            if (foldRegion == null) break block1;
            FoldRegion it = foldRegion;
            boolean bl = false;
            $foldRegions.add((Object)newRegion);
        }
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final /* synthetic */ void access$doAfterBulkAdd(FrontendEditorFoldingModelAdapter $this, List highlighters) {
        $this.doAfterBulkAdd(highlighters);
    }

    public static final /* synthetic */ void access$traceRange(FrontendEditorFoldingModelAdapter $this, int start2, int end, TextAttributes attr) {
        $this.traceRange(start2, end, attr);
    }

    public static final /* synthetic */ Map access$getFoldingRestoreRecords$p(FrontendEditorFoldingModelAdapter $this) {
        return $this.foldingRestoreRecords;
    }

    public static final /* synthetic */ void access$doAfterUpdated(FrontendEditorFoldingModelAdapter $this, RangeHighlighterEx highlighter2) {
        $this.doAfterUpdated(highlighter2);
    }

    static {
        Key key = Key.create((String)"RESTORE_FOLDING_STATE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RESTORE_FOLDING_STATE = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendEditorFoldingModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorFoldingModelAdapter.logger = logger;
        redFromBackend = new TextAttributes();
        greenMergedWithExisting = new TextAttributes();
        blueMergedWithCreatedByFrontend = new TextAttributes();
        cyanExoticStateFromFrontend = new TextAttributes();
        redFromBackend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.RED);
        greenMergedWithExisting.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.GREEN);
        blueMergedWithCreatedByFrontend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.BLUE);
        cyanExoticStateFromFrontend.withAdditionalEffect(EffectType.WAVE_UNDERSCORE, JBColor.CYAN);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001c\u0010\u000e\u001a\u00020\u000f8\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter$Companion;", "", "()V", "RESTORE_FOLDING_STATE", "Lcom/intellij/openapi/util/Key;", "", "blueMergedWithCreatedByFrontend", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getBlueMergedWithCreatedByFrontend", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "cyanExoticStateFromFrontend", "getCyanExoticStateFromFrontend", "greenMergedWithExisting", "getGreenMergedWithExisting", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "redFromBackend", "getRedFromBackend", "setReloadingState", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void setReloadingState(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            RESTORE_FOLDING_STATE.set((UserDataHolder)editor2, (Object)true);
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final TextAttributes getRedFromBackend() {
            return redFromBackend;
        }

        @NotNull
        public final TextAttributes getGreenMergedWithExisting() {
            return greenMergedWithExisting;
        }

        @NotNull
        public final TextAttributes getBlueMergedWithCreatedByFrontend() {
            return blueMergedWithCreatedByFrontend;
        }

        @NotNull
        public final TextAttributes getCyanExoticStateFromFrontend() {
            return cyanExoticStateFromFrontend;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

