/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.runfile;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTarget;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTargetsService;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/CppFileWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope$intellij_clion_runFile", "()Lkotlinx/coroutines/CoroutineScope;", "collectRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "contentRoot", "Ljava/io/File;", "intellij.clion.runFile"})
@SourceDebugExtension(value={"SMAP\nCppFileWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppFileWorkspace.kt\ncom/jetbrains/cidr/cpp/runfile/CppFileWorkspace\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,42:1\n31#2,2:43\n*S KotlinDebug\n*F\n+ 1 CppFileWorkspace.kt\ncom/jetbrains/cidr/cpp/runfile/CppFileWorkspace\n*L\n21#1:43,2\n*E\n"})
public final class CppFileWorkspace
extends CidrWorkspace
implements Disposable.Default {
    @NotNull
    private final CoroutineScope coroutineScope;

    public CppFileWorkspace(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project);
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope$intellij_clion_runFile() {
        return this.coroutineScope;
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        OCRootsSynchronizer.RootsInfo info;
        block3: {
            info = new OCRootsSynchronizer.RootsInfo();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CppFileBuildTargetsService> serviceClass$iv = CppFileBuildTargetsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            for (CppFileBuildTarget target : ((CppFileBuildTargetsService)object).getTargets()) {
                VirtualFile vFile = VirtualFileManager.getInstance().findFileByNioPath(target.getBuildConfiguration().getSourceFile().toPath());
                if (ScratchUtil.isScratch((VirtualFile)vFile)) continue;
                ((Collection)info.sourceFiles).add(target.getBuildConfiguration().getSourceFile());
            }
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile == null) break block3;
            VirtualFile it = virtualFile;
            boolean bl = false;
            VirtualFile root = Intrinsics.areEqual((Object)it.getName(), (Object)".idea") ? it.getParent() : it;
            Path nioPath = root.toNioPath().toRealPath(new LinkOption[0]);
            String string = FileUtilRt.getTempDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
            String tmpRoot = string;
            if (!nioPath.startsWith(tmpRoot)) {
                ((Collection)info.contentRoots).add(nioPath.toFile());
            }
        }
        return info;
    }
}

