/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.debugger.util.XDebugSessionUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/cpp/debugger/PauseContextLifetimeHolder;", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;)V", "<set-?>", "currentLifetime", "getCurrentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "intellij.rider.plugins.cpp.debugger"})
public final class PauseContextLifetimeHolder {
    @NotNull
    private final SequentialLifetimes lifetimes;
    @NotNull
    private volatile Lifetime currentLifetime;

    public PauseContextLifetimeHolder(@NotNull Lifetime sessionLifetime, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.lifetimes = new SequentialLifetimes(sessionLifetime);
        this.currentLifetime = Lifetime.Companion.getTerminated();
        XDebugSessionUtilKt.advise((XDebugSession)session, (Lifetime)sessionLifetime, (XDebugSessionListener)new XDebugSessionListener(){

            public void sessionPaused() {
                currentLifetime = (Lifetime)lifetimes.next();
            }

            public void beforeSessionResume() {
                lifetimes.terminateCurrent();
            }

            public void sessionStopped() {
                lifetimes.terminateCurrent();
            }
        });
    }

    @NotNull
    public final Lifetime getCurrentLifetime() {
        return this.currentLifetime;
    }
}

