/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JListCellBoundsQuery;
import org.assertj.swing.driver.JListCellCenterQuery;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

final class JListMatchingItemQuery {
    @Nonnull
    @RunsInEDT
    static Point centerOfMatchingItemCell(@Nonnull JList<?> list, @Nullable String value, @Nonnull JListCellReader cellReader) {
        Point result2 = GuiActionRunner.execute(() -> {
            int itemIndex = JListMatchingItemQuery.matchingItemIndex(list, new StringTextMatcher(value), cellReader);
            Rectangle cellBounds = (Rectangle)Preconditions.checkNotNull((Object)JListCellBoundsQuery.cellBounds(list, itemIndex));
            return JListCellCenterQuery.cellCenter(list, cellBounds);
        });
        return (Point)Preconditions.checkNotNull((Object)result2);
    }

    @RunsInCurrentThread
    static int matchingItemIndex(@Nonnull JList<?> list, @Nonnull TextMatcher matcher, @Nonnull JListCellReader cellReader) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    @RunsInEDT
    static List<Integer> matchingItemIndices(final @Nonnull JList<?> list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        List<Integer> result2 = GuiActionRunner.execute(new GuiQuery<List<Integer>>(){

            @Override
            protected List<Integer> executeInEDT() {
                HashSet indices = Sets.newHashSet();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
                    indices.add(i);
                }
                ArrayList indexList = Lists.newArrayList((Iterable)indices);
                Collections.sort(indexList);
                return indexList;
            }
        });
        return (List)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    static List<String> matchingItemValues(final @Nonnull JList<?> list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        List<String> result2 = GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                ArrayList values = Lists.newArrayList();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    String value = cellReader.valueAt(list, i);
                    if (!matcher.isMatching(value)) continue;
                    values.add(value);
                }
                return values;
            }
        });
        return (List)Preconditions.checkNotNull(result2);
    }

    private JListMatchingItemQuery() {
    }
}

