/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.expression.editor;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.vcs.github.ultimate.expression.editor.GithubExpressionLanguageInjector;
import com.intellij.vcs.github.ultimate.expression.editor.GithubExpressionLanguageInjectorKt;
import com.intellij.vcs.github.ultimate.expression.lang.GithubExpressionLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00050\u0004H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/github/ultimate/expression/editor/GithubExpressionLanguageInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "findMultipleRangesInLiteral", "Lcom/intellij/openapi/util/TextRange;", "elementText", "", "findRangesToInjectTo", "psiElement", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "getOrComputeRangesForElement", "injectIntoRange", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "textRange", "shouldInjectIntoEntireElementRange", "", "shouldInjectIntoSubRanges", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nGithubExpressionLanguageInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubExpressionLanguageInjector.kt\ncom/intellij/vcs/github/ultimate/expression/editor/GithubExpressionLanguageInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,70:1\n1855#2,2:71\n14#3:73\n*S KotlinDebug\n*F\n+ 1 GithubExpressionLanguageInjector.kt\ncom/intellij/vcs/github/ultimate/expression/editor/GithubExpressionLanguageInjector\n*L\n27#1:71,2\n38#1:73\n*E\n"})
public final class GithubExpressionLanguageInjector
implements MultiHostInjector {
    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return CollectionsKt.listOf(YAMLScalar.class);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof PsiLanguageInjectionHost) || !GithubYamlFileDetectionKt.isGithubActionsFile(((PsiLanguageInjectionHost)context).getContainingFile().getOriginalFile())) {
            return;
        }
        Iterable $this$forEach$iv = this.getOrComputeRangesForElement(context);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range = (TextRange)element$iv;
            boolean bl = false;
            this.injectIntoRange(registrar, (PsiLanguageInjectionHost)context, range);
        }
    }

    private final void injectIntoRange(MultiHostRegistrar registrar, PsiLanguageInjectionHost host, TextRange textRange) {
        registrar.startInjecting(GithubExpressionLanguage.INSTANCE).addPlace("", "", host, textRange).doneInjecting();
    }

    private final boolean shouldInjectIntoEntireElementRange(PsiElement psiElement) {
        if (!(psiElement instanceof YAMLScalar)) {
            return false;
        }
        PsiElement $this$asSafely$iv = ((YAMLScalar)psiElement).getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof YAMLKeyValue)) {
            psiElement2 = null;
        }
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)psiElement2;
        return Intrinsics.areEqual((Object)(yAMLKeyValue != null ? yAMLKeyValue.getKeyText() : null), (Object)"if");
    }

    private final boolean shouldInjectIntoSubRanges(PsiElement psiElement) {
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"${{", (boolean)false, (int)2, null);
    }

    private final List<TextRange> getOrComputeRangesForElement(PsiElement psiElement) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> GithubExpressionLanguageInjector.getOrComputeRangesForElement$lambda$1(this, psiElement));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private final List<TextRange> findRangesToInjectTo(PsiElement psiElement) {
        List<TextRange> list;
        if (this.shouldInjectIntoEntireElementRange(psiElement)) {
            list = CollectionsKt.listOf((Object)TextRange.create((int)0, (int)psiElement.getTextLength()));
        } else if (this.shouldInjectIntoSubRanges(psiElement)) {
            String string = psiElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            list = this.findMultipleRangesInLiteral(string);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<TextRange> findMultipleRangesInLiteral(String elementText) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)GithubExpressionLanguageInjectorKt.access$getInjectedLanguageSegmentPattern$p(), (CharSequence)elementText, (int)0, (int)2, null), (Function1)((Function1)findMultipleRangesInLiteral.1.INSTANCE)), (Function1)findMultipleRangesInLiteral.2.INSTANCE));
    }

    private static final CachedValueProvider.Result getOrComputeRangesForElement$lambda$1(GithubExpressionLanguageInjector this$0, PsiElement $psiElement) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiElement, (String)"$psiElement");
        Object[] objectArray = new Object[]{$psiElement.getManager().getModificationTracker().forLanguage((Language)YAMLLanguage.INSTANCE)};
        return CachedValueProvider.Result.create(this$0.findRangesToInjectTo($psiElement), (Object[])objectArray);
    }
}

