/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.cache;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.vcs.github.ultimate.cache.GitHubActionCacheCommonsKt;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.cache.GitHubActionsCatalog$refreshCache$1$1$1$invokeSuspend$;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.cache.metadata.GitHubActionMetadataFactory;
import com.intellij.vcs.github.ultimate.cache.providers.ActionsProvider;
import com.intellij.vcs.github.ultimate.cache.providers.LocalActionsProvider;
import com.intellij.vcs.github.ultimate.cache.providers.RemoteActionsProvider;
import com.intellij.vcs.github.ultimate.cache.state.CacheInternalState;
import com.intellij.vcs.github.ultimate.ide.PluginSettingsUtilKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="GitHubActionsCache", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DEFAULT, exportable=true)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0015\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010$J&\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010*J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,J\b\u0010-\u001a\u00020\u0002H\u0016J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\u0006\u0010/\u001a\u00020\u001cJ\b\u00100\u001a\u00020\u001aH\u0016J\u0018\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0016022\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u001cH\u0002J\r\u00106\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b7J$\u00108\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0018\u0001022\b\u00105\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u00109\u001a\u00020:J\u0015\u0010;\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b<J\u0014\u0010=\u001a\u0004\u0018\u00010\u00162\b\u00105\u001a\u0004\u0018\u00010\u001cH\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/vcs/github/ultimate/cache/state/CacheInternalState;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "cachedValuesManager", "Lcom/intellij/psi/util/CachedValuesManager;", "kotlin.jvm.PlatformType", "downloadingLocks", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lkotlinx/coroutines/sync/Mutex;", "filesCacheDir", "metadataFactory", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadataFactory;", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "calculateAndCacheMetadata", "Lcom/intellij/vcs/github/ultimate/cache/metadata/GitHubActionMetadata;", "actionFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearCache", "", "createLocalFileName", "", "Lorg/jetbrains/annotations/NotNull;", "actionReference", "deleteActionFile", "virtualFile", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteActionMetadata", "deleteFileFromCache", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchActionFileAndGetUrl", "fetchAndSaveActionFile", "actionRef", "version", "filePath", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllActions", "Lkotlin/sequences/Sequence;", "getState", "getVersions", "actionName", "initializeComponent", "loadFileAndMetadataAsync", "Lkotlinx/coroutines/Deferred;", "loadState", "normalizeReferenceString", "referenceString", "refreshCache", "refreshCache$intellij_vcs_github_ultimate", "reloadActionDataAsync", "deleteCachedFile", "", "reloadLocalActionEntry", "reloadLocalActionEntry$intellij_vcs_github_ultimate", "resolveActionMetadata", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nGitHubActionsCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionsCatalog.kt\ncom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,247:1\n55#2:248\n34#2,2:249\n55#2:251\n34#2,2:252\n55#2:254\n34#2,2:255\n55#2:258\n34#2,2:259\n55#2:261\n34#2,2:262\n55#2:268\n34#2,2:269\n55#2:285\n34#2,2:286\n1#3:257\n31#4,2:264\n31#4,2:266\n31#4,2:273\n1855#5,2:271\n116#6,10:275\n*S KotlinDebug\n*F\n+ 1 GitHubActionsCatalog.kt\ncom/intellij/vcs/github/ultimate/cache/GitHubActionsCatalog\n*L\n58#1:248\n58#1:249,2\n65#1:251\n65#1:252,2\n91#1:254\n91#1:255,2\n101#1:258\n101#1:259,2\n119#1:261\n119#1:262,2\n139#1:268\n139#1:269,2\n217#1:285\n217#1:286,2\n137#1:264,2\n138#1:266,2\n201#1:273,2\n140#1:271,2\n208#1:275,10\n*E\n"})
public final class GitHubActionsCatalog
implements PersistentStateComponent<CacheInternalState> {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private CacheInternalState state;
    @NotNull
    private final Path filesCacheDir;
    @NotNull
    private final GitHubActionMetadataFactory metadataFactory;
    @NotNull
    private final ConcurrentHashMap<Path, Mutex> downloadingLocks;
    private final CachedValuesManager cachedValuesManager;

    public GitHubActionsCatalog(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.state = new CacheInternalState();
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("github-actions").resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.filesCacheDir = path;
        this.metadataFactory = new GitHubActionMetadataFactory(this.project);
        this.downloadingLocks = new ConcurrentHashMap();
        this.cachedValuesManager = CachedValuesManager.getManager((Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void loadState(@NotNull CacheInternalState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        try {
            XmlSerializerUtil.copyBean((Object)state2, (Object)this.state);
        }
        catch (Exception ignore) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warnWithDebug("Cannot load state", (Throwable)ignore);
        }
    }

    @NotNull
    public CacheInternalState getState() {
        return this.state;
    }

    public void initializeComponent() {
        if (!PluginSettingsUtilKt.githubActionsSupportEnabled()) {
            return;
        }
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("GitHub Actions cache is enabled, need to initialize catalog");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        processor = new CommonProcessors.FindFirstProcessor<VirtualFile>(){

                            protected boolean accept(@Nullable VirtualFile t) {
                                return t != null && t.isDirectory();
                            }
                        };
                        this.L$0 = processor;
                        this.label = 1;
                        v0 = CoroutinesKt.smartReadAction((Project)this.this$0.getProject(), (Function0)((Function0)new Function0<Boolean>(this.this$0, processor){
                            final /* synthetic */ GitHubActionsCatalog this$0;
                            final /* synthetic */ initializeComponent.processor.1 $processor;
                            {
                                this.this$0 = $receiver;
                                this.$processor = $processor;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return FilenameIndex.processFilesByName((String)".github", (boolean)true, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.this$0.getProject()), (Processor)((Processor)this.$processor));
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        processor = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (processor.isFound()) {
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v1 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                            v1.debug("Found .github folder. Initializing GitHub Actions catalog");
                            this.this$0.refreshCache$intellij_vcs_github_ultimate();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Sequence<String> getAllActions() {
        return this.state.getAllActions();
    }

    @NotNull
    public final Sequence<String> getVersions(@NotNull String actionName) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        return this.state.getVersions(actionName);
    }

    public final void clearCache() {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Clearing GitHub Actions cache");
        this.state.reset$intellij_vcs_github_ultimate();
        NioFiles.deleteRecursively((Path)this.filesCacheDir);
    }

    @RequiresReadLock
    @Nullable
    public final GitHubActionMetadata resolveActionMetadata(@Nullable String referenceString) {
        VirtualFile virtualFile;
        CharSequence charSequence = referenceString;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String actionReference2 = this.normalizeReferenceString(referenceString);
        String string = this.state.getActionFileUrl(actionReference2);
        if (string != null) {
            String fileUrl = string;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        } else {
            virtualFile = null;
        }
        VirtualFile actionFile = virtualFile;
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VirtualFile virtualFile2 = actionFile;
        logger.debug("Calculating metadata for " + actionReference2 + ". File: " + (virtualFile2 != null ? virtualFile2.getUrl() : null));
        Deferred<GitHubActionMetadata> metadata = this.calculateAndCacheMetadata(actionFile);
        Deferred<GitHubActionMetadata> deferred = metadata;
        if (deferred == null) {
            deferred = this.reloadActionDataAsync(actionReference2, false);
        }
        return metadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    private final GitHubActionMetadata calculateAndCacheMetadata(VirtualFile actionFile) {
        PsiFile psiFile;
        if (actionFile == null) return null;
        if (!actionFile.isValid()) {
            return null;
        }
        PsiFile psiFile3 = VirtualFileUtil.findPsiFile((VirtualFile)actionFile, (Project)this.project);
        psiFile3 = psiFile3;
        if (psiFile2 == null) return null;
        PsiFile it = psiFile = psiFile3;
        boolean bl = false;
        if (!it.isValid()) return null;
        PsiFile psiFile3 = psiFile;
        psiFile3 = psiFile3;
        if (psiFile4 == null) return null;
        PsiFile psiFile5 = psiFile3;
        boolean bl2 = false;
        GitHubActionMetadata gitHubActionMetadata = (GitHubActionMetadata)this.cachedValuesManager.getCachedValue((UserDataHolder)psiFile5, () -> GitHubActionsCatalog.calculateAndCacheMetadata$lambda$3$lambda$2(this, psiFile5));
        return gitHubActionMetadata;
    }

    private final void deleteActionMetadata(String actionReference2) {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Deleting GitHub Actions metadata: " + actionReference2);
        this.state.deleteEntry(actionReference2);
    }

    private final Deferred<GitHubActionMetadata> loadFileAndMetadataAsync(String actionReference2) {
        return BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitHubActionMetadata>, Object>(actionReference2, this, null){
            int label;
            final /* synthetic */ String $actionReference;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.$actionReference = $actionReference;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $i$f$fileLogger = false;
                        $i$f$currentClassLogger = false;
                        clazz$iv$iv = MethodHandles.lookup().lookupClass();
                        v0 = Logger.getInstance(clazz$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                        v0.debug("Resolving action metadata for " + this.$actionReference);
                        this.label = 1;
                        v1 = GitHubActionsCatalog.access$fetchActionFileAndGetUrl(this.this$0, this.$actionReference, (Continuation)this);
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        v2 = (String)v1;
                        if (v2 == null) {
                            return null;
                        }
                        fileUrl = v2;
                        v3 /* !! */  = VirtualFileManager.getInstance().refreshAndFindFileByUrl(fileUrl);
                        if (v3 /* !! */  == null) ** GOTO lbl30
                        it = var7_8 = v3 /* !! */ ;
                        $i$a$-takeIf-GitHubActionsCatalog$loadFileAndMetadataAsync$1$virtualFile$1 = false;
                        v3 /* !! */  = it.isValid() != false ? var7_8 : null;
                        if (v3 /* !! */  != null) ** GOTO lbl31
lbl30:
                        // 2 sources

                        return null;
lbl31:
                        // 1 sources

                        virtualFile = v3 /* !! */ ;
                        v4 = GitHubActionsCatalog.access$getState$p(this.this$0);
                        v5 = virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getUrl(...)");
                        v4.registerActionFile(this.$actionReference, v5);
                        var4_7 = GitHubActionCacheCommonsKt.splitActionReference(this.$actionReference);
                        actionRef = (String)var4_7.component1();
                        version = (String)var4_7.component2();
                        GitHubActionsCatalog.access$getState$p(this.this$0).addVersion(actionRef, version);
                        this.label = 2;
                        v6 = CoroutinesKt.readAction((Function0)((Function0)new Function0<GitHubActionMetadata>(this.this$0, virtualFile){
                            final /* synthetic */ GitHubActionsCatalog this$0;
                            final /* synthetic */ VirtualFile $virtualFile;
                            {
                                this.this$0 = $receiver;
                                this.$virtualFile = $virtualFile;
                                super(0);
                            }

                            @Nullable
                            public final GitHubActionMetadata invoke() {
                                return GitHubActionsCatalog.access$calculateAndCacheMetadata(this.this$0, this.$virtualFile);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v6 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl50
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl50:
                        // 2 sources

                        return v6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitHubActionMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void refreshCache$intellij_vcs_github_ultimate() {
        Object[] objectArray = new ActionsProvider[2];
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = LocalActionsProvider.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_0 = objectArray[0];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = RemoteActionsProvider.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_1 = objectArray[1];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        List providers = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Refreshing catalog");
        Iterable $this$forEach$iv = providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActionsProvider provider = (ActionsProvider)element$iv;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider, this, null){
                int label;
                final /* synthetic */ ActionsProvider $provider;
                final /* synthetic */ GitHubActionsCatalog this$0;
                {
                    this.$provider = $provider;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = this.$provider.fetchActionNames((Continuation<? super Flow<String>>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = FlowKt.collect((Flow)FlowKt.onEach((Flow)FlowKt.flatMapMerge$default((Flow)FlowKt.filterNotNull((Flow)((Flow)v0)), (int)0, (Function2)((Function2)new Function2<String, Continuation<? super Flow<? extends Pair<? extends String, ? extends String>>>, Object>(this.$provider, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ ActionsProvider $provider;
                                {
                                    this.$provider = $provider;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            actionRef = (String)this.L$0;
                                            this.L$0 = actionRef;
                                            this.label = 1;
                                            v0 = ActionsProvider.fetchActionVersions$default(this.$provider, actionRef, null, (Continuation)this, 2, null);
                                            if (v0 == var8_2) {
                                                return var8_2;
                                            }
                                            ** GOTO lbl16
                                        }
                                        case 1: {
                                            actionRef = (String)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl16:
                                            // 2 sources

                                            $this$mapNotNull$iv = (Flow)v0;
                                            $i$f$mapNotNull = false;
                                            $this$unsafeTransform$iv$iv = $this$mapNotNull$iv;
                                            $i$f$unsafeTransform = false;
                                            $i$f$unsafeFlow = false;
                                            return (Flow)new Flow<Pair<? extends String, ? extends String>>($this$unsafeTransform$iv$iv, actionRef){
                                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                                final /* synthetic */ String $actionRef$inlined;
                                                {
                                                    this.$this_unsafeTransform$inlined = flow;
                                                    this.$actionRef$inlined = string;
                                                }

                                                @Nullable
                                                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                                    Continuation continuation = $completion;
                                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                                    boolean bl = false;
                                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$actionRef$inlined){
                                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                                        final /* synthetic */ String $actionRef$inlined;
                                                        {
                                                            this.$this_unsafeFlow = $receiver;
                                                            this.$actionRef$inlined = string;
                                                        }

                                                        /*
                                                         * Unable to fully structure code
                                                         */
                                                        @Nullable
                                                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                                            if (!(var2_2 instanceof refreshCache$1$1$1$invokeSuspend$$inlined$mapNotNull$1$2$1)) ** GOTO lbl-1000
                                                            var3_3 = var2_2;
                                                            if ((var3_3.label & -2147483648) != 0) {
                                                                var3_3.label -= -2147483648;
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                $continuation = new ContinuationImpl(this, var2_2){
                                                                    /* synthetic */ Object result;
                                                                    int label;
                                                                    Object L$0;
                                                                    final /* synthetic */ refreshCache$1$1$1$invokeSuspend$$inlined$mapNotNull$1$2 this$0;
                                                                    {
                                                                        this.this$0 = this$0;
                                                                        super($completion);
                                                                    }

                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                                        this.result = $result;
                                                                        this.label |= Integer.MIN_VALUE;
                                                                        return this.this$0.emit(null, (Continuation)this);
                                                                    }
                                                                };
                                                            }
                                                            $result = $continuation.result;
                                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch ($continuation.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    var6_6 = value;
                                                                    $this$mapNotNull_u24lambda_u246 = this.$this_unsafeFlow;
                                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                                    (Continuation)$continuation;
                                                                    tag = (String)value;
                                                                    $i$a$-mapNotNull-GitHubActionsCatalog$refreshCache$1$1$1$1 = false;
                                                                    transformed = new Pair((Object)this.$actionRef$inlined, (Object)tag);
                                                                    $continuation.label = 1;
                                                                    v0 = $this$mapNotNull_u24lambda_u246.emit((Object)transformed, (Continuation)$continuation);
                                                                    if (v0 == var5_5) {
                                                                        return var5_5;
                                                                    }
                                                                    ** GOTO lbl29
                                                                }
                                                                case 1: {
                                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl29:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }
                                                    }, $completion);
                                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                        return object;
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            };
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Flow<Pair<String, String>>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null), (Function2)((Function2)new Function2<Pair<? extends String, ? extends String>, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ GitHubActionsCatalog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Pair pair = (Pair)this.L$0;
                                            String actionRef = (String)pair.component1();
                                            String version = (String)pair.component2();
                                            boolean $i$f$fileLogger = false;
                                            boolean $i$f$currentClassLogger = false;
                                            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                                            Logger logger = Logger.getInstance(clazz$iv$iv);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                            logger.debug("Processing action: " + actionRef + " version " + version);
                                            GitHubActionsCatalog.access$getState$p(this.this$0).addVersion(actionRef, version);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull Pair<String, String> p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Nullable
    public final Deferred<GitHubActionMetadata> reloadActionDataAsync(@Nullable String referenceString, boolean deleteCachedFile) throws IOException {
        CharSequence charSequence = referenceString;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String actionReference2 = this.normalizeReferenceString(referenceString);
        return BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitHubActionMetadata>, Object>(deleteCachedFile, this, actionReference2, null){
            int label;
            final /* synthetic */ boolean $deleteCachedFile;
            final /* synthetic */ GitHubActionsCatalog this$0;
            final /* synthetic */ String $actionReference;
            {
                this.$deleteCachedFile = $deleteCachedFile;
                this.this$0 = $receiver;
                this.$actionReference = $actionReference;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (this.$deleteCachedFile) {
                            this.label = 1;
                            v0 = GitHubActionsCatalog.access$deleteFileFromCache(this.this$0, this.$actionReference, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        GitHubActionsCatalog.access$deleteActionMetadata(this.this$0, this.$actionReference);
                        this.label = 2;
                        v1 = GitHubActionsCatalog.access$loadFileAndMetadataAsync(this.this$0, this.$actionReference).await((Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitHubActionMetadata> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ Deferred reloadActionDataAsync$default(GitHubActionsCatalog gitHubActionsCatalog, String string, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gitHubActionsCatalog.reloadActionDataAsync(string, bl);
    }

    public final void reloadLocalActionEntry$intellij_vcs_github_ultimate(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
            int label;
            final /* synthetic */ GitHubActionsCatalog this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$service$iv = (ComponentManager)this.this$0.getProject();
                        $i$f$service = false;
                        serviceClass$iv = LocalActionsProvider.class;
                        v0 = $this$service$iv.getService(serviceClass$iv);
                        if (v0 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        localActionsProvider = (LocalActionsProvider)v0;
                        $i$f$service = this.$virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$service, (String)"getUrl(...)");
                        this.label = 1;
                        v1 = localActionsProvider.constructActionReference($i$f$service, (Continuation<? super String>)((Continuation)this));
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        actionReference = (String)v1;
                        $i$f$fileLogger = false;
                        $i$f$currentClassLogger = false;
                        clazz$iv$iv = MethodHandles.lookup().lookupClass();
                        v2 = Logger.getInstance(clazz$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.debug("Reloading local action file: " + this.$virtualFile + ", action reference is " + actionReference);
                        v3 = GitHubActionsCatalog.reloadActionDataAsync$default(this.this$0, actionReference, false, 2, null);
                        if (v3 == null) return Unit.INSTANCE;
                        this.label = 2;
                        v4 = v3.await((Continuation)this);
                        ** if (v4 != var8_2) goto lbl38
lbl37:
                        // 1 sources

                        return var8_2;
lbl38:
                        // 1 sources

                        ** GOTO lbl44
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl44:
                        // 2 sources

                        (GitHubActionMetadata)v4;
                        return Unit.INSTANCE;
                    }
                }
                catch (Exception e) {
                    $i$f$fileLogger = false;
                    $i$f$currentClassLogger = false;
                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    v5 = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                    v5.warnWithDebug("Failed to reload local action file: " + this.$virtualFile, (Throwable)e);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object deleteFileFromCache(String actionReference2, Continuation<? super Unit> $completion) {
        String string;
        block5: {
            block4: {
                String fileUrl = this.state.getActionFileUrl(actionReference2);
                string = fileUrl;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(it);
                string = virtualFile;
                if (virtualFile != null) break block5;
            }
            return Unit.INSTANCE;
        }
        String virtualFile = string;
        Object object = this.deleteActionFile(actionReference2, (VirtualFile)virtualFile, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object deleteActionFile(String actionReference2, VirtualFile virtualFile, Continuation<? super Unit> $completion) {
        if (GitHubActionCacheCommonsKt.isLocalAction(actionReference2)) {
            return CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(virtualFile, actionReference2, this){
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ String $actionReference;
                final /* synthetic */ GitHubActionsCatalog this$0;
                {
                    this.$virtualFile = $virtualFile;
                    this.$actionReference = $actionReference;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    VirtualFile virtualFile;
                    boolean $i$f$fileLogger = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    Logger logger = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Invalidating file " + this.$virtualFile.getUrl() + " for action " + this.$actionReference);
                    VirtualFile it = virtualFile = this.$virtualFile;
                    boolean bl = false;
                    Object object = it.isValid() ? virtualFile : null;
                    if (object != null && (object = VirtualFileUtil.findPsiFile((VirtualFile)object, (Project)this.this$0.getProject())) != null) {
                        object.clearCaches();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            }), $completion);
        }
        return CoroutinesKt.writeAction((Function0)((Function0)new Function0<Unit>(virtualFile, actionReference2, this){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ String $actionReference;
            final /* synthetic */ GitHubActionsCatalog this$0;
            {
                this.$virtualFile = $virtualFile;
                this.$actionReference = $actionReference;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                VirtualFile virtualFile;
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Deleting file " + this.$virtualFile.getUrl() + " for action " + this.$actionReference + " from filesystem cache");
                VirtualFile it = virtualFile = this.$virtualFile;
                boolean bl = false;
                Object object = it.isValid() ? virtualFile : null;
                if (object != null) {
                    object.delete((Object)this.this$0);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        }), $completion);
    }

    /*
     * Exception decompiling
     */
    private final Object fetchActionFileAndGetUrl(String var1_1, Continuation<? super String> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Object fetchAndSaveActionFile(String actionRef, String version, Path filePath, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionRef, version, this, filePath, null){
            int label;
            final /* synthetic */ String $actionRef;
            final /* synthetic */ String $version;
            final /* synthetic */ GitHubActionsCatalog this$0;
            final /* synthetic */ Path $filePath;
            {
                this.$actionRef = $actionRef;
                this.$version = $version;
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block18: {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v0 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                            v0.debug("Fetching file for " + this.$actionRef + "@" + this.$version);
                            $this$service$iv = (ComponentManager)this.this$0.getProject();
                            $i$f$service = false;
                            serviceClass$iv = RemoteActionsProvider.class;
                            v1 = $this$service$iv.getService(serviceClass$iv);
                            if (v1 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            v2 = RemoteActionsProvider.resolveActionFile$default((RemoteActionsProvider)v1, this.$actionRef, this.$version, null, 0L, 12, null);
                            if (v2 == null) break;
                            this.label = 1;
                            v3 = v2.await((Continuation)this);
                            if (v3 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl28
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl28:
                            // 2 sources

                            v4 = (VirtualFile)v3;
                            break block18;
                        }
                    }
                    v4 = null;
                }
                virtualFile = v4;
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v5 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                v5.debug("Saving file " + virtualFile + " to " + this.$filePath);
                v6 /* !! */  = virtualFile;
                if (v6 /* !! */  != null && (v6 /* !! */  = v6 /* !! */ .getInputStream()) != null) {
                    $i$f$currentClassLogger = (Closeable)v6 /* !! */ ;
                    clazz$iv$iv = this.$filePath;
                    var6_12 = null;
                    try {
                        inputStream = (InputStream)$i$f$currentClassLogger;
                        $i$a$-use-GitHubActionsCatalog$fetchAndSaveActionFile$2$1 = false;
                        PathsKt.createParentDirectories(clazz$iv$iv, (FileAttribute[])new FileAttribute[0]);
                        v7 = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(clazz$iv$iv, Arrays.copyOf(v7, v7.length)), (String)"createFile(...)");
                        var9_17 = clazz$iv$iv;
                        var10_18 /* !! */  = new OpenOption[]{StandardOpenOption.WRITE};
                        v8 = Files.newOutputStream(var9_17, Arrays.copyOf(var10_18 /* !! */ , var10_18 /* !! */ .length));
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"newOutputStream(...)");
                        var9_17 = v8;
                        var10_18 /* !! */  = null;
                        try {
                            outputStream = (OutputStream)var9_17;
                            $i$a$-use-GitHubActionsCatalog$fetchAndSaveActionFile$2$1$1 = false;
                            var11_20 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable var11_21) {
                            var10_18 /* !! */  = var11_21;
                            throw var11_21;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var9_17, (Throwable)var10_18 /* !! */ );
                        }
                        var7_13 = Boxing.boxLong((long)var11_20);
                    }
                    catch (Throwable var7_14) {
                        var6_12 = var7_14;
                        throw var7_14;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$f$currentClassLogger, (Throwable)var6_12);
                    }
                }
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v9 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getInstance(...)");
                v9.debug("Finished saving " + virtualFile + " to local filesystem cache " + this.$filePath);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String createLocalFileName(String actionReference2) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string2 = PathUtil.makeFileName((String)(StringsKt.replace$default((String)actionReference2, (String)"@", (String)string, (boolean)false, (int)4, null) + File.separator + "action"), (String)"yml");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"makeFileName(...)");
        return string2;
    }

    private final String normalizeReferenceString(String referenceString) {
        Pair<String, String> pair = GitHubActionCacheCommonsKt.splitActionReference(referenceString);
        String refString = (String)pair.component1();
        String version = (String)pair.component2();
        String actionReference2 = refString + "@" + version;
        return actionReference2;
    }

    private static final CachedValueProvider.Result calculateAndCacheMetadata$lambda$3$lambda$2(GitHubActionsCatalog this$0, PsiFile $psiFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        GitHubActionMetadata metadata = this$0.metadataFactory.createMetadata($psiFile);
        Object[] objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create((Object)metadata, (Object[])objectArray);
    }

    private static final Mutex fetchActionFileAndGetUrl$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mutex)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$fetchActionFileAndGetUrl(GitHubActionsCatalog $this, String actionReference2, Continuation $completion) {
        return $this.fetchActionFileAndGetUrl(actionReference2, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ CacheInternalState access$getState$p(GitHubActionsCatalog $this) {
        return $this.state;
    }

    public static final /* synthetic */ GitHubActionMetadata access$calculateAndCacheMetadata(GitHubActionsCatalog $this, VirtualFile actionFile) {
        return $this.calculateAndCacheMetadata(actionFile);
    }

    public static final /* synthetic */ Object access$deleteFileFromCache(GitHubActionsCatalog $this, String actionReference2, Continuation $completion) {
        return $this.deleteFileFromCache(actionReference2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$deleteActionMetadata(GitHubActionsCatalog $this, String actionReference2) {
        $this.deleteActionMetadata(actionReference2);
    }

    public static final /* synthetic */ Deferred access$loadFileAndMetadataAsync(GitHubActionsCatalog $this, String actionReference2) {
        return $this.loadFileAndMetadataAsync(actionReference2);
    }

    public static final /* synthetic */ Object access$deleteActionFile(GitHubActionsCatalog $this, String actionReference2, VirtualFile virtualFile, Continuation $completion) {
        return $this.deleteActionFile(actionReference2, virtualFile, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$fetchAndSaveActionFile(GitHubActionsCatalog $this, String actionRef, String version, Path filePath, Continuation $completion) {
        return $this.fetchAndSaveActionFile(actionRef, version, filePath, (Continuation<? super Unit>)$completion);
    }
}

